/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Ray;

public class Sphere
extends Object3d {
    Vector3d center;
    double radius;
    Vector3d normal;

    public Sphere(Vector3d center_, double radius_, Material mat) {
        super(mat);
        this.center = center_;
        this.radius = radius_;
        this.origin = this.center;
    }

    @Override
    public Vector3d getTextureCoordinates(Hit h, Ray r) {
        Vector3d ro = r.getOrigin();
        Vector3d rd = r.getDirection();
        double x_os = ro.x + rd.x * h.getT();
        double y_os = ro.y + rd.y * h.getT();
        double z_os = ro.z + rd.z * h.getT();
        Vector3d intsctPt_os = new Vector3d(x_os, y_os, z_os);
        double theta = Math.acos((z_os - this.center.z) / this.radius);
        double phi = Math.atan2(y_os - this.center.y, x_os - this.center.x);
        if (phi < 0.0) {
            phi += Math.PI * 2;
        }
        double u = phi / (Math.PI * 2);
        double v = (Math.PI - theta) / Math.PI;
        return new Vector3d(u, v, 0.0);
    }

    public boolean intersectGeometric(Ray r, Hit h, double tmin) {
        Vector3d romso = new Vector3d();
        romso.sub((Tuple3d)this.center, (Tuple3d)r.getOrigin());
        double len = romso.length();
        double distsq = Math.pow(len, 2.0);
        double rsq = Math.pow(this.radius, 2.0);
        double tp = 0.0;
        double calct = 0.0;
        if (distsq == rsq) {
            return false;
        }
        if (distsq > rsq) {
            tp = romso.dot(r.getDirection());
            if (tp < 0.0) {
                return false;
            }
            double dsq = distsq - Math.pow(tp, 2.0);
            if (dsq > rsq) {
                return false;
            }
            double tprimesq = rsq - dsq;
            double tprime = Math.sqrt(tprimesq);
            calct = tp - tprime;
        } else if (distsq < rsq) {
            tp = romso.dot(r.getDirection());
            double dsq1 = Math.pow(tp, 2.0) - distsq;
            double tprimesq1 = rsq - dsq1;
            double tprime1 = Math.sqrt(tprimesq1);
            calct = tp + tprime1;
        }
        if (calct < tmin) {
            return false;
        }
        double t_prev = h.getT();
        if (calct < t_prev) {
            h.set(calct, this.getMaterial());
        }
        return true;
    }

    @Override
    public boolean intersect(Ray r, Hit h, double tmin) {
        Vector3d romso = new Vector3d();
        romso.sub((Tuple3d)r.getOrigin(), (Tuple3d)this.center);
        double a = r.getDirection().dot(r.getDirection());
        double b = 2.0 * r.getDirection().dot(romso);
        double c = romso.dot(romso) - Math.pow(this.radius, 2.0);
        double dsquared = b * b - 4.0 * a * c;
        double calct = 0.0;
        if (dsquared < 0.0) {
            return false;
        }
        if (dsquared == 0.0) {
            calct = -b / 2.0 * a;
        } else if (dsquared > 0.0 && (calct = (-b - Math.sqrt(dsquared)) / (2.0 * a)) < 0.0 && (calct = (-b + Math.sqrt(dsquared)) / (2.0 * a)) < tmin) {
            return false;
        }
        if (calct < tmin) {
            return false;
        }
        double t_prev = h.getT();
        if (calct < t_prev) {
            h.set(calct, this.getMaterial(), this.calcNormal(calct, r));
        }
        return true;
    }

    public Vector3d calcNormal(double t, Ray r) {
        Vector3d point = new Vector3d();
        Vector3d scale = new Vector3d(r.getDirection());
        scale.scale(t);
        point.add((Tuple3d)r.getOrigin(), (Tuple3d)scale);
        this.normal = new Vector3d();
        this.normal.sub((Tuple3d)point, (Tuple3d)this.center);
        this.normal.scale(2.0);
        return this.normal;
    }
}

