/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.LightSource;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PhongMaterial;
import oracle.sdovis.raytracing.RTRenderer;
import oracle.sdovis.raytracing.Ray;
import oracle.sdovis.raytracing.Render3DException;

public class DEMTracer {
    static double EPSILON = 5.0E-4;
    LightSource[] light;
    Camera cam;
    double reflection_coefficient;
    double transmission_coefficient;
    double[] r0;
    double[] rd;
    Vector3d ambient_light;
    Vector3d background_color;
    Material[] mat;
    Material cur_mat;
    Group grp;
    int bounces;
    double minweight;

    public DEMTracer(RTRenderer rtp, int max_bounces, int min_weight) {
        this.grp = rtp.getGroup();
        this.cam = rtp.getCamera();
        this.light = rtp.getLights();
        this.ambient_light = rtp.getAmbientLight();
        this.background_color = rtp.getBackgroundColor();
        this.mat = rtp.getMaterials();
        this.bounces = max_bounces;
        this.minweight = min_weight;
    }

    public static Vector3d mirrorDirection(Vector3d normal, Vector3d incoming) {
        Vector3d newInc = incoming;
        Vector3d mirr = new Vector3d();
        Vector3d aux1 = normal;
        aux1.scale(incoming.dot(normal) * 2.0);
        mirr.sub((Tuple3d)newInc, (Tuple3d)aux1);
        return mirr;
    }

    public static boolean transmittedDirection(Vector3d normal, Vector3d incoming, double index_i, double index_t, Vector3d transmitted) {
        Vector3d newInc = incoming;
        newInc.negate();
        newInc.normalize();
        Vector3d newNorm = normal;
        newNorm.normalize();
        double nr = index_i / index_t;
        double sqrtTest = 1.0 - Math.pow(nr, 2.0) * (1.0 - Math.pow(newNorm.dot(newInc), 2.0));
        if (sqrtTest < 0.0) {
            return false;
        }
        transmitted = newNorm;
        transmitted.scale(nr * newNorm.dot(newInc) - Math.sqrt(sqrtTest));
        newInc.scale(nr);
        transmitted.sub((Tuple3d)newInc);
        transmitted.normalize();
        return true;
    }

    public Vector3d traceRay(Ray r, double tmin, int bounces, double weight, double refrIdx, Hit h) {
        Vector3d bkg = this.background_color;
        Vector3d zero = new Vector3d();
        PhongMaterial background = new PhongMaterial(bkg, zero, 1.0, zero, zero, 1.0);
        boolean success = this.grp.intersect(r, h, tmin);
        Vector3d color = new Vector3d();
        if (success) {
            if (h.getMaterial() == null) {
                color = background.getDiffuseColor();
            } else {
                color = DEMTracer.mulVectors(h.getMaterial().getDiffuseColor(), this.ambient_light);
                for (int li = 0; li < this.light.length; ++li) {
                    Vector3d itsctPt = new Vector3d();
                    itsctPt.scale(h.getT(), (Tuple3d)r.getDirection());
                    itsctPt.add((Tuple3d)r.getOrigin());
                    Vector3d liDir = new Vector3d();
                    Vector3d liCol = new Vector3d();
                    Vector3d dummy = new Vector3d();
                    LightSource nextLight = this.light[li];
                    Vector results = nextLight.getIllumination(itsctPt);
                    liDir = (Vector3d)results.elementAt(0);
                    liCol = (Vector3d)results.elementAt(1);
                    double distToLight = (Double)results.elementAt(2);
                    liDir.normalize();
                    Ray shadowRay = new Ray(liDir, itsctPt);
                    Hit shadowHit = new Hit(Double.POSITIVE_INFINITY, null);
                    boolean shadowSucc = this.grp.intersect(shadowRay, shadowHit, EPSILON);
                    if (shadowSucc) {
                        if (shadowHit.getT() < distToLight) {
                            color.add((Tuple3d)zero);
                        } else {
                            color.add((Tuple3d)h.getMaterial().shade(r, h, liDir, liCol));
                        }
                    } else {
                        color.add((Tuple3d)h.getMaterial().shade(r, h, liDir, liCol));
                    }
                    Vector3d reflcol = h.getMaterial().getReflectiveColor();
                    if ((reflcol.x > 0.0 || reflcol.y > 0.0 || reflcol.z > 0.0) && bounces > 0) {
                        Vector3d mirrDir = DEMTracer.mirrorDirection(h.getNormal(), r.getDirection());
                        Ray mirrorRay = new Ray(mirrDir, itsctPt);
                        Hit mirrorHit = new Hit(Double.POSITIVE_INFINITY, null);
                        Vector3d reflCol = h.getMaterial().getReflectiveColor();
                        Vector3d tracedCol = this.traceRay(mirrorRay, EPSILON, bounces - 1, weight * (reflCol.x + reflCol.y + reflCol.z) / 3.0, refrIdx, mirrorHit);
                        color.add((Tuple3d)DEMTracer.mulVectors(reflCol, tracedCol));
                    }
                    Vector3d transcol = h.getMaterial().getTransparencyColor();
                    if (!(transcol.x > 0.0) && !(transcol.y > 0.0) && !(transcol.z > 0.0)) continue;
                    Vector3d transm = new Vector3d();
                    Hit refrHit = new Hit(Double.POSITIVE_INFINITY, null);
                    if (r.getDirection().dot(h.getNormal()) < 0.0) {
                        if (!DEMTracer.transmittedDirection(h.getNormal(), r.getDirection(), refrIdx, h.getMaterial().getIndexOfRefraction(), transm) || bounces <= 0) continue;
                        Ray transmRay = new Ray(transm, itsctPt);
                        Vector3d transCol = h.getMaterial().getTransparencyColor();
                        Vector3d tracedRefr = this.traceRay(transmRay, EPSILON, bounces - 1, weight * (transCol.x + transCol.y + transCol.z) / 3.0, refrIdx, refrHit);
                        color.add((Tuple3d)DEMTracer.mulVectors(transCol, tracedRefr));
                        continue;
                    }
                    Vector3d newNorm = h.getNormal();
                    Vector3d transm2 = new Vector3d();
                    newNorm.negate();
                    if (!DEMTracer.transmittedDirection(newNorm, r.getDirection(), h.getMaterial().getIndexOfRefraction(), refrIdx, transm2) || bounces <= 0) continue;
                    Ray transmRay1 = new Ray(transm2, itsctPt);
                    Vector3d transCol1 = h.getMaterial().getTransparencyColor();
                    Vector3d tracedRefr1 = this.traceRay(transmRay1, EPSILON, bounces - 1, weight * (transCol1.x + transCol1.y + transCol1.z) / 3.0, h.getMaterial().getIndexOfRefraction(), refrHit);
                    color.add((Tuple3d)DEMTracer.mulVectors(transCol1, tracedRefr1));
                }
            }
        } else {
            color = background.getDiffuseColor();
        }
        color = new Vector3d(Math.min(color.x, 1.0), Math.min(color.y, 1.0), Math.min(color.z, 1.0));
        return color;
    }

    public static Vector3d mulVectors(Vector3d v1, Vector3d v2) {
        Vector3d newVec = new Vector3d(v1.x * v2.x, v1.y * v2.y, v1.z * v2.z);
        return newVec;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Vector3d getBackgroundColor() {
        return this.background_color;
    }

    public void setBackgroundColor(Vector3d bkg) {
        this.background_color = bkg;
    }

    public Vector3d getAmbientLight() {
        return this.ambient_light;
    }

    public int getNumLights() {
        return this.light.length;
    }

    public LightSource getLight(int i) throws Render3DException {
        if (i < 0 || i >= this.light.length) {
            throw new Render3DException("Error parsing light sources.");
        }
        return this.light[i];
    }

    public int getNumMaterials() {
        return this.mat.length;
    }

    public Material getMaterial(int i) throws Render3DException {
        if (i < 0 || i >= this.mat.length) {
            throw new Render3DException("Error parsing materials.");
        }
        return this.mat[i];
    }
}

