/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.awt.geom.Rectangle2D;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.MapMaker;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class SDOBoxFilter
implements SpatialOp {
    public static String TRUE4EVER = "'s'='s'";
    protected String dataSource;
    protected String targetGeometryColumn;
    protected int srid = -9999;
    protected double minx = Double.NaN;
    protected double miny = Double.NaN;
    protected double maxx = Double.NaN;
    protected double maxy = Double.NaN;
    protected double minResolution = Double.NaN;
    protected double maxResolution = Double.NaN;

    public SDOBoxFilter(String dsrc, String targetGeomColumn) {
        this.dataSource = dsrc;
        this.targetGeometryColumn = targetGeomColumn;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public static String getGenericFilterPredicate(String geomCol, int srid, boolean is9i, String param) {
        StringBuffer sb = new StringBuffer(256);
        boolean geodetic = Util.isGeodetic(srid);
        if (param == null) {
            param = "'querytype=WINDOW'";
        }
        if (is9i && geodetic) {
            sb.append("MDSYS.SDO_FILTER(" + geomCol + ", ");
            sb.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            sb.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(:mvqboxxl, :mvqboxyl, :mvqboxxh, :mvqboxyh)), " + srid + " ), " + param + ") = 'TRUE'");
            return sb.toString();
        }
        sb.append("MDSYS.SDO_FILTER(" + geomCol + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (srid == 0) {
            sb.append("NULL");
        } else {
            sb.append(srid);
        }
        sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(:mvqboxxl, :mvqboxyl, :mvqboxxh, :mvqboxyh)), " + param + ") = 'TRUE'");
        return sb.toString();
    }

    public String getFilterPredicate(String geomCol, int srid, boolean is9i) {
        StringBuffer sb = new StringBuffer(256);
        boolean geodetic = Util.isGeodetic(srid);
        String param = "'querytype=WINDOW";
        if (is9i && geodetic) {
            param = param + "'";
        } else if (Double.isNaN(this.minResolution) && Double.isNaN(this.maxResolution)) {
            param = param + "'";
        } else {
            if (!Double.isNaN(this.minResolution)) {
                param = param + " min_resolution=" + this.minResolution;
            }
            if (!Double.isNaN(this.maxResolution)) {
                param = param + " max_resolution=" + this.maxResolution;
            }
            param = param + "'";
        }
        return SDOBoxFilter.getGenericFilterPredicate(geomCol, srid, is9i, param);
    }

    @Override
    public String getSpatialPredicate() {
        if (this.srid == -9999) {
            throw new IllegalArgumentException("Box srid must be set before calling getSpatialPredicate.");
        }
        if (MapMaker.isSpecial(this.minx, this.miny, this.maxx, this.maxy)) {
            return TRUE4EVER;
        }
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (ads == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        boolean is9i = ads.is9i();
        return this.getFilterPredicate(this.targetGeometryColumn, this.srid, is9i);
    }

    @Override
    public void prepare(PreparedStatement ps) throws SQLException {
        if (MapMaker.isSpecial(this.minx, this.miny, this.maxx, this.maxy)) {
            return;
        }
        OraclePreparedStatement ops = (OraclePreparedStatement)ps;
        ops.setDoubleAtName("mvqboxxl", this.minx);
        ops.setDoubleAtName("mvqboxyl", this.miny);
        ops.setDoubleAtName("mvqboxxh", this.maxx);
        ops.setDoubleAtName("mvqboxyh", this.maxy);
    }

    @Override
    public void setDataSource(String dsrc) {
        this.dataSource = dsrc;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    public void setTargetGeometryColumn(String geomCol) {
        this.targetGeometryColumn = geomCol;
    }

    public String getTargetGeometryColumn() {
        return this.targetGeometryColumn;
    }

    public void setMinResoultion(double min) {
        this.minResolution = min;
    }

    public double getMinResoultion() {
        return this.minResolution;
    }

    public void setMaxResoultion(double max) {
        this.maxResolution = max;
    }

    public double getMaxResoultion() {
        return this.maxResolution;
    }

    public void setFilterBox(double minx, double miny, double maxx, double maxy, int srid) {
        this.minx = minx;
        this.miny = miny;
        this.maxx = maxx;
        this.maxy = maxy;
        this.srid = srid;
        if (MapMaker.isSpecial(minx, miny, maxx, maxy)) {
            return;
        }
        if (this.dataSource != null) {
            SRS srs = null;
            boolean isGeodetic = false;
            String unit = null;
            SRSCache sc = DSManager.getSRSCache(this.dataSource);
            if (sc != null && (srs = sc.get(srid)) != null) {
                isGeodetic = srs.isGeodetic();
                unit = srs.getUnit();
                if (isGeodetic) {
                    Rectangle2D out = Util.getOptimalFilterQueryWindow(minx, miny, maxx, maxy, isGeodetic, unit);
                    this.minx = out.getMinX();
                    this.miny = out.getMinY();
                    this.maxx = out.getMaxX();
                    this.maxy = out.getMaxY();
                }
            }
        }
    }

    @Override
    public int getNumBindingVariables() {
        if (MapMaker.isSpecial(this.minx, this.miny, this.maxx, this.maxy)) {
            return 0;
        }
        return 4;
    }

    @Override
    public void setOperationGeometry(JGeometry geom) {
        if (geom == null) {
            throw new IllegalArgumentException("null geometry argument.");
        }
        if (geom.isRectangle()) {
            double[] ords = geom.getOrdinatesArray();
            int dim = geom.getDimensions();
            this.minx = ords[0];
            this.miny = ords[1];
            this.maxx = ords[dim];
            this.maxy = ords[dim + 1];
            this.srid = geom.getSRID();
        } else {
            double[] mbr = geom.getMBR();
            this.minx = mbr[0];
            this.miny = mbr[1];
            this.maxx = mbr[2];
            this.maxy = mbr[3];
            this.srid = geom.getSRID();
        }
    }

    @Override
    public JGeometry getOperationGeometry() {
        return new JGeometry(2003, this.srid, new int[]{1, 1003, 3}, new double[]{this.minx, this.miny, this.maxx, this.maxy});
    }

    @Override
    public int getSrid() {
        return this.srid;
    }
}

