/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ppp;

import java.util.HashMap;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.utils.CSTransformUtils;
import oracle.mapviewer.utils.MapCSBean;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ppp.PPPInterface;
import oracle.sdovis.theme.CustomGeomThemeProducer;
import oracle.sdovis.theme.DynGeomThemeProducer;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.PredGeomThemeProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.WFSThemeProducer;

public class CSTransformP3
implements PPPInterface {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    HashMap initParams = null;

    public CSTransformP3(HashMap params) {
        this.init(params);
    }

    @Override
    public void init(HashMap params) {
        this.initParams = params;
    }

    @Override
    public int process(Theme t, VisContext vc, HashMap parameters) {
        boolean vectorTheme;
        ThemeDataProducer tp = t.getProducer();
        boolean bl = vectorTheme = tp instanceof PredGeomThemeProducer || tp instanceof DynGeomThemeProducer || tp instanceof LocalThemeDataProducer || tp instanceof WFSThemeProducer || tp instanceof CustomGeomThemeProducer;
        if (!vectorTheme) {
            throw new IllegalArgumentException("Only geometry themes are supported.");
        }
        StyledFeatureI[] features = tp.getStyledFeatures();
        if (features == null || features.length == 0) {
            return 0;
        }
        String fromSrid = null;
        String toSrid = null;
        if (parameters != null) {
            fromSrid = (String)parameters.get("from_srid");
            toSrid = (String)parameters.get("to_srid");
        } else {
            fromSrid = (String)this.initParams.get("from_srid");
            toSrid = (String)this.initParams.get("to_srid");
        }
        if (fromSrid == null || toSrid == null) {
            log.severe("Invalid from/to SRID: " + fromSrid + " --> " + toSrid + ".");
            return 0;
        }
        if (!MapCSBean.supported(Integer.parseInt(fromSrid), Integer.parseInt(toSrid))) {
            log.severe("Mid-tier does no support CS transform: " + fromSrid + " --> " + toSrid + ".");
            return 0;
        }
        for (int i = 0; i < features.length; ++i) {
            StyledFeatureI f = features[i];
            JSDOGeometry geom = f.getGeometry();
            geom = CSTransformUtils.doTransform(geom, fromSrid, toSrid);
            f.setGeometry(geom);
        }
        return 0;
    }

    @Override
    public Object getPPPResult() {
        return null;
    }
}

