/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.metastore.util;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.metastore.style.jaxb.StyleInstance;
import oracle.sdovis.metastore.style.jaxb.StyleType;
import oracle.sdovis.metastore.style.jaxb.Styles;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Base64OutputStream;

public class StyleExporter {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static JAXBContext jc = null;
    private String styleTableName = "user_sdo_styles";
    static String DS_NAME = "StyleExporter_temp_ds";

    public StyleExporter() {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)"oracle.sdovis.metastore.style.jaxb", (ClassLoader)this.getClass().getClassLoader());
            }
        }
        catch (JAXBException je) {
            throw new IllegalArgumentException("Cannot initialize StyleExporter.", je);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportToXmlFile(String file) {
        Styles styleList = new Styles();
        StyleTable st = null;
        st = new StyleTable(DS_NAME, this.styleTableName);
        try {
            st.query("select * from " + this.styleTableName);
            int n = 0;
            while (st.next()) {
                StyleInstance s = new StyleInstance();
                s.setName(st.getName());
                String type = StyleUtils.getTypeNameFromCode(st.getType());
                if (type == null) continue;
                s.setType(StyleType.fromValue(type));
                s.setDescription(st.getDescription());
                s.setDefinition(st.getDefinition().toString());
                byte[] img = st.getImageData();
                if (img != null) {
                    try {
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        Base64OutputStream bo = new Base64OutputStream(bytes, false);
                        bo.write(img);
                        bo.flush();
                        s.setImage(bytes.toString());
                        bo.close();
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                }
                ++n;
                styleList.getStyleInstance().add(s);
            }
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            marshaller.marshal((Object)styleList, (OutputStream)new FileOutputStream(file));
            int type = n;
            return type;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            int n = 0;
            return n;
        }
        finally {
            try {
                st.closeQuery();
            }
            catch (SQLException se) {}
        }
    }

    public static void main(String[] args) {
        StyleExporter se = new StyleExporter();
        if (args.length != 6 && args.length != 7) {
            System.out.println("Usage: java oracle.sdovis.metastore.util.StyleExporter <host> <sid> <port> <user> <password> <output-file>\n Or \n       java oracle.sdovis.metastore.util.StyleExporter <host> <sid> <port> <user> <password> <output-file> <style_table> ");
            System.exit(1);
        }
        if (args.length == 7) {
            se.styleTableName = args[6];
        }
        log.fine("metadata table: " + se.styleTableName);
        try {
            System.out.println("connecting to " + args[0] + "...");
            DSManager.registerOracleJdbcDS(DS_NAME, args[0], args[2], args[1], args[3], args[4], "thin", 3);
            System.out.println("connected.");
            int n = se.exportToXmlFile(args[5]);
            log.info(n + " styles exported.");
            DSManager.remove(DS_NAME);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

