/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.DBSRSStore;
import oracle.sdovis.JavaDBStyleStore;
import oracle.sdovis.MapTable;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyleStore;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.ThemeTable;
import oracle.sdovis.TileLayerCache;
import oracle.sdovis.TileLayerTable;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.ContainerDataSource;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.ds.JavaDBDataSource;
import oracle.sdovis.ds.NativeOracleDataSource;
import oracle.sdovis.ds.TemplateDataSource;
import oracle.sdovis.edit.session.EditSessionCache;
import oracle.sdovis.edit.session.store.EditSessionTable;
import oracle.sdovis.style.AllStyleTable;
import oracle.sdovis.util.DBTable;

public class DSManager {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static int connectionWaitTimeout = 120;
    static Hashtable visList = new Hashtable(13);

    public static void registerContainerDS(String name, String jndiLocation) throws Exception {
        DSManager.ensureUnique(name);
        ContainerDataSource ods = new ContainerDataSource(name, jndiLocation);
        DSManager.enlist_(ods);
    }

    public static void registerOracleJdbcDS(String name, String jdbcHost, String jdbcPort, String jdbcSid, String jdbcUser, String jdbcPasswd, String jdbcMode, int maxConn) throws Exception {
        DSManager.ensureUnique(name);
        NativeOracleDataSource nds = new NativeOracleDataSource(name, null, jdbcHost, jdbcPort, jdbcSid, jdbcUser, jdbcPasswd, jdbcMode, maxConn);
        DSManager.enlist_(nds);
    }

    public static void registerOracleJdbcDS(String name, String tnsName, String jdbcUser, String jdbcPasswd, String jdbcMode, int maxConn) throws Exception {
        DSManager.ensureUnique(name);
        NativeOracleDataSource nds = new NativeOracleDataSource(name, tnsName, null, null, null, jdbcUser, jdbcPasswd, jdbcMode, maxConn);
        DSManager.enlist_(nds);
    }

    public static void registerOracleJdbcDS(String name, String customString, String jdbcUser, String jdbcPasswd, int maxConn) throws Exception {
        DSManager.ensureUnique(name);
        NativeOracleDataSource nds = new NativeOracleDataSource(name, customString, jdbcUser, jdbcPasswd, maxConn);
        DSManager.enlist_(nds);
    }

    public static void registerJavaDBDS(String name, String dbName, String user, String passwd, String javaDBMode) throws Exception {
        DSManager.ensureUnique(name);
        JavaDBDataSource jds = new JavaDBDataSource(name, dbName, user, passwd, javaDBMode);
        DSManager.enlist_(jds);
    }

    public static void registerTemplateDS(String name, String folder, String configFile) throws Exception {
        DSManager.ensureUnique(name);
        TemplateDataSource tds = new TemplateDataSource(name, folder, configFile);
        DSManager.enlist_(tds);
    }

    public static void enlist(DataSourceI ds) throws Exception {
        DSManager.ensureUnique(ds.getName());
        DSManager.enlist_(ds);
    }

    private static void enlist_(DataSourceI ds) {
        if (ds == null) {
            return;
        }
        String key = ds.getName().toUpperCase();
        Object old = visList.get(key);
        if (old != null) {
            ((DataSourceI)old).close();
            visList.remove(key);
        }
        visList.put(key, ds);
        if (ds instanceof AbstractDBDataSource) {
            DSManager.postRegistration((AbstractDBDataSource)ds);
        }
    }

    public static void delist(DataSourceI ds) {
        if (ds == null) {
            return;
        }
        String key = ds.getName().toUpperCase();
        visList.remove(key);
    }

    public static void delist(String ds) {
        visList.remove(ds.toUpperCase());
    }

    public static void remove(String name) {
        DataSourceI ds = (DataSourceI)visList.get(name = name.toUpperCase());
        if (ds != null) {
            ds.close();
            visList.remove(name);
        }
    }

    public static DataSourceI get(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        return (DataSourceI)visList.get(name.toUpperCase());
    }

    public static String getDataSourceType(String dsrc) {
        if (dsrc == null) {
            return "ORACLE";
        }
        DataSourceI dsi = (DataSourceI)visList.get(dsrc.toUpperCase());
        if (dsi == null) {
            return "ORACLE";
        }
        if (dsi instanceof JavaDBDataSource) {
            return "JAVADB";
        }
        return "ORACLE";
    }

    public static String[] getAllNames() {
        if (visList == null || visList.size() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        Enumeration enumer = visList.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            v.add(key);
        }
        return v.toArray(new String[v.size()]);
    }

    public static void closeAll() {
        DataSourceI ds = null;
        Enumeration enumer = visList.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            ds = (DataSourceI)visList.get(key);
            if (ds.isClosed()) continue;
            ds.close();
        }
        visList.clear();
    }

    public static String findOracleJdbcDS(String jdbcHost, String jdbcPort, String jdbcSid, String jdbcUser, String jdbcPasswd, String jdbcMode) {
        Enumeration enumer = visList.elements();
        while (enumer.hasMoreElements()) {
            NativeOracleDataSource ods;
            DataSourceI ds = (DataSourceI)enumer.nextElement();
            if (!(ds instanceof NativeOracleDataSource) || !(ods = (NativeOracleDataSource)ds).matches(jdbcHost, jdbcPort, jdbcSid, jdbcUser, jdbcPasswd, jdbcMode)) continue;
            return ods.getName();
        }
        return null;
    }

    public static boolean isRegistered(String dataSrc) {
        Enumeration enumer = visList.keys();
        while (enumer.hasMoreElements()) {
            String dsname = (String)enumer.nextElement();
            if (!dsname.equalsIgnoreCase(dataSrc)) continue;
            return true;
        }
        return false;
    }

    private static void postRegistration(AbstractDBDataSource ds) {
        StyleCache styleCache = new StyleCache(ds.getName(), 200);
        try {
            DBTable styleTable = null;
            styleTable = !(ds instanceof JavaDBDataSource) ? new AllStyleTable(ds.getName(), "ALL_SDO_STYLES") : new JavaDBStyleStore(ds.getName());
            styleCache.setStyleStore((StyleStore)((Object)styleTable));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException("cannot create a style table.");
        }
        ThemeTable themeStore = new ThemeTable(ds.getName(), "USER_SDO_THEMES");
        ThemeCache themeCache = new ThemeCache(ds.getName(), 9999, themeStore);
        BasemapCache basemapCache = null;
        try {
            MapTable mapTable = new MapTable(ds.getName(), "USER_SDO_MAPS");
            basemapCache = new BasemapCache(ds.getName(), mapTable);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException("cannot create a basemap table.");
        }
        TileLayerCache tilelayerCache = null;
        try {
            TileLayerTable tlTable = new TileLayerTable(ds.getName(), "USER_SDO_CACHED_MAPS");
            tilelayerCache = new TileLayerCache(ds.getName(), tlTable);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException("cannot create a tile layer table.");
        }
        EditSessionCache editsessionCache = null;
        try {
            EditSessionTable esTable = new EditSessionTable(ds.getName(), "USER_SDO_EDIT_SESSIONS");
            editsessionCache = new EditSessionCache(ds.getName(), esTable);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException("cannot create a tile layer table.");
        }
        DBSRSStore store = new DBSRSStore(ds.getName());
        SRSCache srsCache = new SRSCache(ds.getName(), store);
        ds.setStyleCache(styleCache);
        ds.setThemeCache(themeCache);
        ds.setBasemapCache(basemapCache);
        ds.setSRSCache(srsCache);
        ds.setTileLayerCache(tilelayerCache);
        ds.setEditSessionCache(editsessionCache);
    }

    private static void ensureUnique(String name) throws Exception {
        Enumeration enumer = visList.keys();
        while (enumer.hasMoreElements()) {
            String dsname = (String)enumer.nextElement();
            if (!dsname.equalsIgnoreCase(name)) continue;
            throw new Exception("Data source with the same name already exists.");
        }
    }

    public static StyleCache getStyleCache(String dataSrc) {
        DataSourceI dsi = DSManager.get(dataSrc);
        return dsi == null ? null : dsi.getStyleCache();
    }

    public static SRSCache getSRSCache(String dataSrc) {
        DataSourceI dsi = DSManager.get(dataSrc);
        return dsi == null ? null : dsi.getSRSCache();
    }

    public static void setConnectionWaitTimeout(int timeout) {
        connectionWaitTimeout = timeout;
    }

    public static int getConnectionWaitTimeout() {
        return connectionWaitTimeout;
    }

    public static String[] getTemplateDSNames() {
        if (visList.size() == 0) {
            return null;
        }
        Iterator it = visList.entrySet().iterator();
        ArrayList res = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getValue() instanceof TemplateDataSource)) continue;
            if (res == null) {
                res = new ArrayList(10);
            }
            res.add(entry.getKey());
        }
        return res == null ? null : res.toArray(new String[res.size()]);
    }
}

