/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.internal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.text.AttributedString;
import oracle.sdovis.charts.internal.LabelUtil2;
import oracle.sdovis.charts.types.ButtonDesc;
import oracle.sdovis.charts.types.LabelDesc;

public final class Button {
    static final int OffsetMinHilight = 1;
    static final int OffsetMin = 2;

    public static Dimension drawButton(Graphics2D g2, int originX, int originY, ButtonDesc bDesc) {
        LabelDesc lab = bDesc.getLabelDesc();
        Color buttonColor = bDesc.getBackgroundColor();
        Dimension labelDim = Button.getLabelDimensions(g2, bDesc);
        Dimension e = Button.computeEllipseDimensions(g2, bDesc);
        int offsetHilight = Button.getOffsetHilight((int)e.getHeight());
        int offset = Button.getOffset((int)e.getHeight());
        Ellipse2D.Double shapeOriginal = new Ellipse2D.Double(originX, originY, e.getWidth(), e.getHeight());
        Ellipse2D.Double shapeCrescent = new Ellipse2D.Double(originX + offset, originY + offset, e.getWidth(), e.getHeight());
        Ellipse2D.Double shapeCrescentHilight = new Ellipse2D.Double(originX + offsetHilight, originY + offsetHilight, e.getWidth(), e.getHeight());
        Color buttonDark = buttonColor.darker();
        Color buttonBright = buttonColor.brighter();
        Area areaOriginal = new Area(shapeOriginal);
        Area areaCrescentHilight = new Area(shapeCrescentHilight);
        Area areaCrescent = new Area(shapeCrescent);
        areaCrescentHilight.exclusiveOr(areaOriginal);
        areaCrescentHilight.intersect(areaOriginal);
        g2.setColor(buttonDark);
        g2.fill(areaCrescent);
        RenderingHints RHOriginal = g2.getRenderingHints();
        g2.setColor(buttonColor);
        g2.fill(areaOriginal);
        g2.setColor(buttonBright);
        g2.fill(areaCrescentHilight);
        int x = (int)Math.round((double)originX + e.getWidth() / 2.0 - labelDim.getWidth() / 2.0 + 2.0);
        int y = (int)Math.round((double)originY + e.getHeight() / 2.0 + labelDim.getHeight() / 3.0);
        if (lab != null) {
            g2.setColor(lab.getColor());
            int labelPad = 0;
            if (lab.getTextAttributes() != null) {
                AttributedString attrStr = new AttributedString(lab.getText(), lab.getTextAttributes());
                TextLayout layout = new TextLayout(attrStr.getIterator(), g2.getFontRenderContext());
                layout.draw(g2, x + labelPad, y);
            } else {
                g2.setColor(lab.getColor());
                g2.drawString(lab.getText(), x + labelPad, y);
            }
        }
        return new Dimension((int)e.getWidth() + offsetHilight, (int)e.getHeight() + offsetHilight);
    }

    public static Dimension getButtonDimensions(Graphics2D g2, ButtonDesc bDesc) {
        Dimension e = Button.computeEllipseDimensions(g2, bDesc);
        int offsetHilight = Button.getOffsetHilight((int)e.getHeight());
        return new Dimension((int)e.getWidth() + offsetHilight, (int)e.getHeight() + offsetHilight);
    }

    private static Dimension computeEllipseDimensions(Graphics2D g2, ButtonDesc bDesc) {
        LabelDesc lab = bDesc.getLabelDesc();
        int ellipseWidth = bDesc.getWidth();
        int ellipseHeight = bDesc.getHeight();
        Dimension labelDim = Button.getLabelDimensions(g2, bDesc);
        double factor = 1.2;
        if (ellipseWidth < 0) {
            ellipseWidth = (int)Math.round(factor * labelDim.getWidth());
        }
        if (ellipseHeight < 0) {
            ellipseHeight = (int)Math.round(factor * labelDim.getHeight());
        }
        return new Dimension(ellipseWidth, ellipseHeight);
    }

    private static int getOffsetHilight(int ellipseHeight) {
        int offsetHilight = (int)Math.round((double)ellipseHeight * 0.015);
        if (offsetHilight <= 1) {
            offsetHilight = 1;
        }
        return offsetHilight;
    }

    private static int getOffset(int ellipseHeight) {
        int offset = (int)Math.round((double)ellipseHeight * 0.03);
        if (offset <= 2) {
            offset = 2;
        }
        return offset;
    }

    private static Dimension getLabelDimensions(Graphics2D g2, ButtonDesc bDesc) {
        LabelDesc lab = bDesc.getLabelDesc();
        int labelHeight = 0;
        int labelWidth = 0;
        if (lab != null) {
            lab.fontmet = g2.getFontMetrics(lab.getFont());
            labelHeight = LabelUtil2.getLabelHeight(lab, g2.getFontRenderContext());
            labelWidth = LabelUtil2.getLabelWidth(lab, g2.getFontRenderContext());
        }
        return new Dimension(labelWidth, labelHeight);
    }
}

