/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.Serializable;
import oracle.sdovis.util.Util;

public class TileLayerRowData
implements Serializable {
    public String name = "";
    public String description = "";
    public String tilesTable = null;
    public String isOnline = "YES";
    public String isInternal = "YES";
    public String definition = "";
    public String baseMap = null;
    public byte[] mapAdapter = null;

    public String toXmlFileFormat() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("    <tile_layer>\n");
        sb.append("        <name>" + this.name.toUpperCase() + "</name>\n");
        sb.append("        <description>" + this.description + "</description>\n");
        if (this.tilesTable != null) {
            sb.append("        <tilestable>" + this.tilesTable + "</tilestable>\n");
        } else {
            sb.append("        <tilestable></tilestable>\n");
        }
        sb.append("        <isonline>" + this.isOnline + "</isonline>\n");
        sb.append("        <isinternal>" + this.isOnline + "</isinternal>\n");
        sb.append("        <definition><!CDATA[" + this.definition + "]]</definition>\n");
        if (this.baseMap != null) {
            sb.append("        <basemap>" + this.tilesTable + "</basemap>\n");
        } else {
            sb.append("        <basemap></basemap>\n");
        }
        sb.append("        <mapadapter>" + Util.base64Encode(this.mapAdapter) + "</mapadapter>\n");
        sb.append("    </tile_layer>\n");
        return sb.toString();
    }
}

