/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.style.Style;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.util.DoubleGeneralPath;
import oracle.sdovis.util.ShapeUtil;

public class StyledFeature
implements Cloneable,
Serializable,
StyledFeatureI {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    int gType = 0;
    Shape shape = null;
    Point2D point = null;
    String label = null;
    String translatedLabel = null;
    String id = null;
    String dataSource = null;
    Object appData = null;
    Style featureStyle = null;
    String featureStyleName = null;
    String labelStyleName = null;
    Style labelStyle = null;
    boolean forceLabel = false;
    boolean fixedSVGLabel = false;
    int markerStyleSize = 0;
    double markerStyleOrientation = 0.0;
    double[] radius = null;
    double[] originalRadii = null;
    double customField1 = 0.0;
    Field[] renderableValues = null;
    Field[] identifiableValues = null;
    Point2D lblPoint = null;
    transient Rectangle2D shpMBR = null;
    String themeName = null;
    Rectangle2D[] mtptShpMBRs = null;
    String infoStr = null;
    String svgId = null;
    JSDOGeometry geom = null;
    boolean selectableInSVG = false;
    String onClick = null;
    String onMouseMove = null;
    String onMouseOver = null;
    String onMouseOut = null;
    boolean shapeSimplified = true;
    RenderingRule[] renderRules = null;
    String nsdpMetaInfo = null;
    boolean allowNakedPoints = true;
    int elementPosition = 0;
    boolean labelAsOPoint = false;
    boolean isCluster = false;
    AnnotationText atextLabel = null;
    String atextLeaderLineStyleName = null;
    Style atextLeaderLineStyle = null;

    @Override
    public Rectangle2D getShpMBR() {
        return this.shpMBR;
    }

    @Override
    public void setShpMBR(Rectangle2D shpMBR) {
        this.shpMBR = shpMBR;
    }

    public Object clone() {
        try {
            int i;
            StyledFeature sf = (StyledFeature)super.clone();
            if (this.geom != null) {
                sf.geom = (JSDOGeometry)this.geom.clone();
            }
            if (this.shpMBR != null) {
                sf.shpMBR = (Rectangle2D)this.shpMBR.clone();
            }
            if (this.lblPoint != null) {
                sf.lblPoint = (Point2D)this.lblPoint.clone();
            }
            if (this.radius != null) {
                sf.radius = new double[this.radius.length];
                for (i = 0; i < this.radius.length; ++i) {
                    sf.radius[i] = this.radius[i];
                }
            }
            if (this.originalRadii != null) {
                sf.originalRadii = new double[this.originalRadii.length];
                for (i = 0; i < this.originalRadii.length; ++i) {
                    sf.originalRadii[i] = this.originalRadii[i];
                }
            }
            if (this.renderableValues != null) {
                sf.renderableValues = new Field[this.renderableValues.length];
                for (i = 0; i < this.renderableValues.length; ++i) {
                    sf.renderableValues[i] = (Field)this.renderableValues[i].clone();
                }
            }
            if (this.identifiableValues != null) {
                sf.identifiableValues = new Field[this.identifiableValues.length];
                for (i = 0; i < this.identifiableValues.length; ++i) {
                    sf.identifiableValues[i] = (Field)this.identifiableValues[i].clone();
                }
            }
            if (this.renderRules != null) {
                sf.renderRules = new RenderingRule[this.renderRules.length];
                for (i = 0; i < this.renderRules.length; ++i) {
                    sf.renderRules[i] = new RenderingRule();
                    sf.renderRules[i].setStyleColumns(this.renderRules[i].getStyleColumns());
                    sf.renderRules[i].setStyleName(this.renderRules[i].getStyleName());
                    sf.renderRules[i].setSubStyleChangeProperty(this.renderRules[i].getSubStyleChangeProperty());
                    sf.renderRules[i].setSubStyleColumns(this.renderRules[i].getSubStyleColumns());
                    sf.renderRules[i].setSubStyleName(this.renderRules[i].getSubStyleName());
                }
            }
            return sf;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(Shape s) {
        this.shape = s;
    }

    @Override
    public Point2D getPoint() {
        return this.point;
    }

    @Override
    public void setPoint(Point2D p) {
        this.point = p;
        this.shape = null;
        this.gType = 1;
    }

    @Override
    public Point2D getLabelPoint() {
        return this.lblPoint;
    }

    @Override
    public void setLabelPoint(Point2D pt) {
        this.lblPoint = pt;
    }

    @Override
    public double getCenterX() {
        if (this.point != null) {
            return this.point.getX();
        }
        return this.shape.getBounds().getCenterX();
    }

    @Override
    public double getX() {
        return this.getCenterX();
    }

    @Override
    public double getCenterY() {
        if (this.point != null) {
            return this.point.getY();
        }
        return this.shape.getBounds().getCenterY();
    }

    @Override
    public double getY() {
        return this.getCenterY();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.gType);
        out.writeObject(this.label);
        out.writeObject(this.id);
        out.writeObject(this.appData);
        out.writeObject(this.featureStyleName);
        out.writeObject(this.labelStyleName);
        out.writeBoolean(this.forceLabel);
        out.writeBoolean(this.fixedSVGLabel);
        out.writeInt(this.markerStyleSize);
        out.writeDouble(this.customField1);
        out.writeObject(this.radius);
        out.writeObject(this.originalRadii);
        out.writeObject(this.renderableValues);
        out.writeObject(this.identifiableValues);
        out.writeObject(this.renderRules);
        out.writeObject(this.geom);
        this.writeShapeOrPoint(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj = null;
        this.gType = in.readInt();
        obj = in.readObject();
        if (obj != null) {
            this.label = (String)obj;
        }
        this.id = (String)in.readObject();
        this.appData = in.readObject();
        obj = in.readObject();
        if (obj != null) {
            this.featureStyleName = (String)obj;
        }
        if ((obj = in.readObject()) != null) {
            this.labelStyleName = (String)obj;
        }
        this.forceLabel = in.readBoolean();
        this.fixedSVGLabel = in.readBoolean();
        this.markerStyleSize = in.readInt();
        this.customField1 = in.readDouble();
        obj = in.readObject();
        if (obj != null) {
            this.radius = (double[])obj;
        }
        if ((obj = in.readObject()) != null) {
            this.originalRadii = (double[])obj;
        }
        if ((obj = in.readObject()) != null) {
            this.renderableValues = (Field[])obj;
        }
        if ((obj = in.readObject()) != null) {
            this.identifiableValues = (Field[])obj;
        }
        if ((obj = in.readObject()) != null) {
            this.renderRules = (RenderingRule[])obj;
        }
        this.geom = (JSDOGeometry)in.readObject();
        this.readShapeOrPoint(in);
    }

    private void writeShapeOrPoint(ObjectOutputStream out) throws IOException {
        boolean isPoint = this.point != null;
        out.writeBoolean(isPoint);
        if (isPoint) {
            out.writeDouble(this.point.getX());
            out.writeDouble(this.point.getY());
        } else {
            boolean hasTransformedShape = this.shape != null;
            out.writeBoolean(hasTransformedShape);
            if (this.shape != null) {
                ShapeUtil.store(this.shape, out);
            }
        }
    }

    private void readShapeOrPoint(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isPoint = in.readBoolean();
        if (isPoint) {
            double x = in.readDouble();
            double y = in.readDouble();
            this.point = new Point2D.Double(x, y);
        } else {
            boolean hasTransformedShape = in.readBoolean();
            this.shape = hasTransformedShape ? ShapeUtil.load(in) : null;
        }
    }

    @Override
    public JSDOGeometry getGeometry() {
        return this.geom;
    }

    @Override
    public boolean hasRenderableShape() {
        return this.point != null || this.shape != null;
    }

    @Override
    public void resetRenderableShape() {
        this.point = null;
        this.shape = null;
    }

    @Override
    public void setGeometry(JSDOGeometry geom) {
        this.geom = geom;
        if (geom == null) {
            return;
        }
        int gt = geom.getType();
        this.setGeomType(gt);
        if (geom.isOrientedPoint() || geom.isOrientedMultiPoint()) {
            double[] coords = geom.getOrdinatesArray();
            int dim = geom.getDimensions();
            if (coords != null) {
                this.setMarkerStyleOrientation(coords[dim], coords[dim + 1], 0.0);
            }
        }
    }

    @Override
    public void buildDoubleShapeFromGeometry(AffineTransform xfm) {
        if (this.geom == null) {
            return;
        }
        int gt = this.geom.getType();
        if (gt == 1) {
            Point2D p2 = this.geom.getJavaPoint();
            Point2D p2new = null;
            if (xfm != null) {
                p2new = (Point2D)p2.clone();
                xfm.transform(p2, p2new);
                this.setPoint(p2new);
            } else {
                this.setPoint(p2);
            }
        } else if (gt == 5) {
            Point2D[] pts = this.geom.getJavaPoints();
            if (pts != null) {
                if (xfm != null) {
                    xfm.transform(pts, 0, pts, 0, pts.length);
                }
                DoubleGeneralPath gp = new DoubleGeneralPath();
                if (pts.length > 0) {
                    gp.moveTo(pts[0].getX(), pts[0].getY());
                    for (int i = 1; i < pts.length; ++i) {
                        gp.lineTo(pts[i].getX(), pts[i].getY());
                    }
                }
                this.setShape(gp);
                if (this.geom.getLabelPoint() != null) {
                    this.lblPoint = this.geom.getLabelPoint();
                }
            } else {
                log.severe("empty multipoint encountered.");
            }
        } else {
            Shape shp = this.geom.createDoubleShape(xfm);
            this.setShape(shp);
            if (this.geom.getLabelPoint() != null) {
                this.lblPoint = this.geom.getLabelPoint();
            }
        }
    }

    @Override
    public void buildShapeFromGeometry(AffineTransform xfm) {
        if (this.geom == null) {
            return;
        }
        int gt = this.geom.getType();
        if (gt == 1) {
            Point2D p2 = this.geom.getJavaPoint();
            Point2D p2new = null;
            if (xfm != null) {
                p2new = (Point2D)p2.clone();
                xfm.transform(p2, p2new);
                this.setPoint(p2new);
            } else {
                this.setPoint(p2);
            }
        } else if (gt == 5) {
            Point2D[] pts = this.geom.getJavaPoints();
            if (pts != null) {
                if (xfm != null) {
                    xfm.transform(pts, 0, pts, 0, pts.length);
                }
                GeneralPath gp = new GeneralPath();
                if (pts.length > 0) {
                    gp.moveTo((float)pts[0].getX(), (float)pts[0].getY());
                    for (int i = 1; i < pts.length; ++i) {
                        gp.lineTo((float)pts[i].getX(), (float)pts[i].getY());
                    }
                }
                this.setShape(gp);
                if (this.geom.getLabelPoint() != null) {
                    this.lblPoint = this.geom.getLabelPoint();
                }
            } else {
                log.severe("empty multipoint encountered.");
            }
        } else {
            Shape shp = this.geom.createShape(xfm, this.shapeSimplified);
            this.setShape(shp);
            if (this.geom.getLabelPoint() != null) {
                this.lblPoint = this.geom.getLabelPoint();
            }
        }
    }

    @Override
    public int getGeomType() {
        return this.gType;
    }

    @Override
    public void setGeomType(int gtype) {
        this.gType = gtype;
    }

    @Override
    public void setForceLabel(boolean force) {
        this.forceLabel = force;
    }

    @Override
    public boolean getForceLabel() {
        return this.forceLabel;
    }

    @Override
    public void setFixedSVGLabel(boolean fixed) {
        this.fixedSVGLabel = fixed;
    }

    @Override
    public boolean getFixedSVGLabel() {
        return this.fixedSVGLabel;
    }

    @Override
    public String getLabel() {
        return this.translatedLabel != null && this.translatedLabel.length() > 0 ? this.translatedLabel : this.label;
    }

    @Override
    public void setLabel(String l) {
        this.label = l;
    }

    @Override
    public Style getFeatureStyle() {
        return this.featureStyle;
    }

    @Override
    public String getFeatureStyleName() {
        return this.featureStyleName;
    }

    @Override
    public void setFeatureStyle(Style s) {
        this.featureStyle = s;
    }

    @Override
    public void setFeatureStyleName(String name) {
        this.featureStyleName = name != null ? ((name = name.trim()).length() == 0 || name.equalsIgnoreCase("null") ? null : name) : null;
    }

    @Override
    public Style getLabelStyle() {
        return this.labelStyle;
    }

    @Override
    public String getLabelStyleName() {
        return this.labelStyleName;
    }

    @Override
    public void setLabelStyle(Style s) {
        this.labelStyle = s;
    }

    @Override
    public void setLabelStyleName(String name) {
        this.labelStyleName = name != null ? ((name = name.trim()).length() == 0 || name.equalsIgnoreCase("null") ? null : name) : null;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getThemeName() {
        return this.themeName;
    }

    @Override
    public void setDataSource(String ds) {
        this.dataSource = ds;
    }

    @Override
    public void setThemeName(String theme) {
        this.themeName = theme;
    }

    @Override
    public Object getCustomData() {
        return this.appData;
    }

    @Override
    public void setCustomData(Object v) {
        this.appData = v;
    }

    @Override
    public void setMarkerStyleSize(int sz) {
        this.markerStyleSize = sz > 0 ? sz : 0;
    }

    @Override
    public int getMarkerStyleSize() {
        return this.markerStyleSize;
    }

    @Override
    public double getMarkerStyleOrientation() {
        return this.markerStyleOrientation;
    }

    @Override
    public void setMarkerStyleOrientation(double mo) {
        this.markerStyleOrientation = mo;
    }

    @Override
    public void setMarkerStyleOrientation(double x, double y, double z) {
        this.markerStyleOrientation = Math.atan2(-y, x);
    }

    @Override
    public double[] getGeomMBR() {
        if (this.geom != null) {
            int gt = this.geom.getType();
            if (gt == 5) {
                Point2D[] pts = this.geom.getJavaPoints();
                if (pts != null && pts.length > 0) {
                    double xmin = pts[0].getX();
                    double ymin = pts[0].getY();
                    double xmax = pts[0].getX();
                    double ymax = pts[0].getY();
                    for (int i = 1; i < pts.length; ++i) {
                        xmin = Math.min(xmin, pts[i].getX());
                        ymin = Math.min(ymin, pts[i].getY());
                        xmax = Math.max(xmax, pts[i].getX());
                        ymax = Math.max(ymax, pts[i].getY());
                    }
                    return new double[]{xmin, ymin, xmax, ymax};
                }
                return null;
            }
            return this.geom.getMBR();
        }
        if (this.point != null) {
            return new double[]{this.point.getX(), this.point.getY(), this.point.getX(), this.point.getY()};
        }
        return null;
    }

    @Override
    public void getShapeMBR(double[] mbr) {
        if (this.shape != null) {
            Rectangle2D r2 = this.shape.getBounds2D();
            mbr[0] = r2.getMinX();
            mbr[1] = r2.getMinY();
            mbr[2] = r2.getMaxX();
            mbr[3] = r2.getMaxY();
        } else if (this.point != null) {
            mbr[0] = this.point.getX();
            mbr[1] = this.point.getY();
            mbr[2] = this.point.getX();
            mbr[3] = this.point.getY();
        } else {
            return;
        }
    }

    @Override
    public void setRadius(double[] r) {
        this.radius = r;
    }

    @Override
    public double[] getRadius() {
        return this.radius;
    }

    @Override
    public void setOriginalRadius(double[] r) {
        this.originalRadii = r;
    }

    @Override
    public double[] getOriginalRadius() {
        return this.originalRadii;
    }

    @Override
    public void setCustomField1(double v) {
        this.customField1 = v;
    }

    @Override
    public double getCustomField1() {
        return this.customField1;
    }

    @Override
    public int getNumAttributes() {
        return (this.identifiableValues != null ? this.identifiableValues.length : 0) + (this.renderableValues != null ? this.renderableValues.length : 0);
    }

    @Override
    public int getNumIdentifiableAttributes() {
        return this.identifiableValues != null ? this.identifiableValues.length : 0;
    }

    @Override
    public int getNumRenderableAttributes() {
        return this.renderableValues != null ? this.renderableValues.length : 0;
    }

    @Override
    public Field getIdentifiableAttribute(int idx) {
        return this.identifiableValues != null ? this.identifiableValues[idx] : null;
    }

    @Override
    public Field getRenderableAttribute(int idx) {
        return this.renderableValues != null ? this.renderableValues[idx] : null;
    }

    @Override
    public Field[] getRenderableAttributes() {
        return this.renderableValues;
    }

    @Override
    public void setIdentifiableAttributes(Field[] attrs) {
        this.identifiableValues = attrs;
    }

    @Override
    public Field[] getIdentifiableAttributes() {
        return this.identifiableValues;
    }

    @Override
    public void setRenderableAttributes(Field[] attrs) {
        this.renderableValues = attrs;
    }

    @Override
    public Object[] getRenderableValues() {
        if (this.renderableValues == null || this.renderableValues.length == 0) {
            return null;
        }
        Object[] vals = new Object[this.renderableValues.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = this.renderableValues[i].getValue();
        }
        return vals;
    }

    @Override
    public void setInfoStr(String info) {
        this.infoStr = info;
    }

    @Override
    public String getInfoStr() {
        if (this.infoStr != null) {
            return this.infoStr;
        }
        if (this.identifiableValues == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(100);
        for (int i = 0; i < this.identifiableValues.length; ++i) {
            Float fvalue;
            Field ac = this.identifiableValues[i];
            if (ac == null) continue;
            Object value = ac.getValue();
            if (value instanceof Double) {
                Double dvalue = (Double)value;
                if (dvalue == (double)((int)dvalue.doubleValue())) {
                    value = new Integer((int)dvalue.doubleValue());
                }
            } else if (value instanceof Float && (fvalue = (Float)value).floatValue() == (float)((int)fvalue.floatValue())) {
                value = new Integer((int)fvalue.floatValue());
            }
            sb.append(ac.getDisplayName() + ": " + value + "\\n");
        }
        return sb.toString();
    }

    @Override
    public Field[] getAttributes() {
        int k;
        int tc = (this.identifiableValues == null ? 0 : this.identifiableValues.length) + (this.renderableValues == null ? 0 : this.renderableValues.length);
        if (tc == 0) {
            return null;
        }
        Field[] attrs = new Field[tc];
        int i = 0;
        if (this.identifiableValues != null) {
            for (k = 0; k < this.identifiableValues.length; ++k) {
                attrs[i++] = this.identifiableValues[k];
            }
        }
        if (this.renderableValues != null) {
            for (k = 0; k < this.renderableValues.length; ++k) {
                attrs[i++] = this.renderableValues[k];
            }
        }
        return attrs;
    }

    @Override
    public String getAttributeListStr() {
        Field[] attrs = null;
        if (this.identifiableValues != null) {
            attrs = this.identifiableValues;
        } else if (this.renderableValues != null) {
            attrs = this.renderableValues;
        } else {
            return "";
        }
        StringBuffer sb = new StringBuffer(100);
        for (int i = 0; i < attrs.length; ++i) {
            Field ac = attrs[i];
            if (ac == null) continue;
            Object value = ac.getValue();
            if (value instanceof Double) {
                Double dvalue = (Double)value;
                if (dvalue == (double)((int)dvalue.doubleValue())) {
                    value = new Integer((int)dvalue.doubleValue());
                }
            } else if (value instanceof Float) {
                Float fvalue = (Float)value;
                if (fvalue.floatValue() == (float)((int)fvalue.floatValue())) {
                    value = new Integer((int)fvalue.floatValue());
                }
            } else if (value instanceof String) {
                value = this.escapeQuote((String)value);
            }
            if (i > 0) {
                sb.append(" ");
            }
            sb.append((ac.getDisplayName() != null ? ac.getDisplayName() : ac.getName()) + "=\"" + value + "\"");
        }
        return sb.toString();
    }

    private String escapeQuote(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length() * 1 + 5);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"' && (i == 0 || str.charAt(i - 1) != '\\')) {
                sb.append('\\');
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public String getSVGId() {
        return this.svgId;
    }

    @Override
    public void setSVGId(String id) {
        this.svgId = id;
    }

    @Override
    public Rectangle2D getMBR() {
        return this.shpMBR;
    }

    @Override
    public void setMBR(Rectangle2D mbr) {
        this.shpMBR = mbr;
    }

    @Override
    public void setShapeToNull() {
        this.shape = null;
        this.point = null;
    }

    @Override
    public void setSelectableInSVG(boolean selectable) {
        this.selectableInSVG = selectable;
    }

    @Override
    public boolean selectableInSVG() {
        return this.selectableInSVG;
    }

    @Override
    public void setOnClick(String oc) {
        this.onClick = oc;
    }

    @Override
    public String getOnClick() {
        return this.onClick;
    }

    @Override
    public void setOnMouseMove(String oc) {
        this.onMouseMove = oc;
    }

    @Override
    public String getOnMouseMove() {
        return this.onMouseMove;
    }

    @Override
    public void setOnMouseOver(String oc) {
        this.onMouseOver = oc;
    }

    @Override
    public String getOnMouseOver() {
        return this.onMouseOver;
    }

    @Override
    public void setOnMouseOut(String oc) {
        this.onMouseOut = oc;
    }

    @Override
    public String getOnMouseOut() {
        return this.onMouseOut;
    }

    @Override
    public void setShapeSimplified(boolean shapeSimplified) {
        this.shapeSimplified = shapeSimplified;
    }

    @Override
    public boolean isShapeSimplified() {
        return this.shapeSimplified;
    }

    @Override
    public void setRenderingRules(RenderingRule[] rules) {
        this.renderRules = rules;
    }

    @Override
    public RenderingRule[] getRenderingRules() {
        return this.renderRules;
    }

    @Override
    public void setNsdpMetaInfo(String nsdpMetaInfo) {
        this.nsdpMetaInfo = nsdpMetaInfo;
    }

    @Override
    public String getNsdpMetaInfo() {
        return this.nsdpMetaInfo;
    }

    @Override
    public void setAllowNakedPoints(boolean param) {
        this.allowNakedPoints = param;
    }

    @Override
    public boolean isAllowNakedPoints() {
        return this.allowNakedPoints;
    }

    @Override
    public int getElementPosition() {
        return this.elementPosition;
    }

    @Override
    public void setElementPosition(int index) {
        this.elementPosition = index;
    }

    @Override
    public boolean labelAsOrientedPoint() {
        return this.labelAsOPoint;
    }

    @Override
    public void setLabelAsOrientedPoint(boolean lopt) {
        this.labelAsOPoint = lopt;
    }

    @Override
    public void setTranslatedLabel(String translatedLabel) {
        this.translatedLabel = translatedLabel;
    }

    @Override
    public String getTranslatedLabel() {
        return this.translatedLabel;
    }

    @Override
    public boolean isCluster() {
        return this.isCluster;
    }

    @Override
    public void setIsCluster(boolean isCluster) {
        this.isCluster = isCluster;
    }

    @Override
    public void setMultiPointShapeMBRs(Rectangle2D[] shpMbrs) {
        this.mtptShpMBRs = shpMbrs;
    }

    @Override
    public Rectangle2D[] getMultiPointShapeMBRs() {
        return this.mtptShpMBRs;
    }

    @Override
    public AnnotationText getAnnotationTextLabel() {
        return this.atextLabel;
    }

    @Override
    public void setAnnotationTextLabel(AnnotationText label) {
        this.atextLabel = label;
    }

    @Override
    public void setLabelLeaderLineStyleName(String style) {
        this.atextLeaderLineStyleName = style;
    }

    @Override
    public String getLabelLeaderLineStyleName() {
        return this.atextLeaderLineStyleName;
    }

    @Override
    public void setLabelLeaderLineStyle(Style style) {
        this.atextLeaderLineStyle = style;
    }

    @Override
    public Style getLabelLeaderLineStyle() {
        return this.atextLeaderLineStyle;
    }
}

