/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BuiltinStyles;
import oracle.sdovis.DataException;
import oracle.sdovis.StyleStore;
import oracle.sdovis.VisConstants;
import oracle.sdovis.style.Style;
import oracle.sdovis.stylex.VariableMarkerStyle;

public class StyleCache
implements VisConstants,
Serializable {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String dsName;
    protected Hashtable styles;
    protected int maxSize;
    protected Hashtable ttFonts;
    protected StyleStore styleStore;
    protected Hashtable editedStyles = new Hashtable();

    public StyleCache(String dataSrc, int maxNumStyles) {
        this.dsName = dataSrc == null ? null : dataSrc.toUpperCase();
        this.styles = new Hashtable();
        this.addBuiltInStyles();
        this.maxSize = maxNumStyles <= 0 ? 200 : maxNumStyles;
        this.ttFonts = new Hashtable();
    }

    protected void addBuiltInStyles() {
        if (this.styles == null) {
            this.styles = new Hashtable();
        }
        this.put(BuiltinStyles.highlightColorStyleName, BuiltinStyles.highlightColorStyle);
        this.put(BuiltinStyles.invisibleColorStyleName, BuiltinStyles.invisibleColorStyle);
        this.put(BuiltinStyles.blackLineStyleName, BuiltinStyles.blackLineStyle);
        this.put(BuiltinStyles.circleMarkerStyleName, BuiltinStyles.circleMarkerStyle);
        try {
            VariableMarkerStyle clusterStyle = BuiltinStyles.getPointClusterStyle();
            clusterStyle.resolveStyles(this, null);
            this.put(BuiltinStyles.pointClusterStyleName, clusterStyle);
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setStyleStore(StyleStore param) {
        this.styleStore = param;
    }

    public StyleStore getStyleStore() {
        return this.styleStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style get(String styName) {
        Style edsty;
        if (styName == null) {
            return null;
        }
        styName = styName.toUpperCase();
        if (this.editedStyles.size() > 0 && (edsty = (Style)this.editedStyles.get(styName)) != null) {
            return edsty;
        }
        CacheEntry ce = (CacheEntry)this.styles.get(styName);
        if (ce != null) {
            ce.mark();
            return ce.sty;
        }
        Style sty = null;
        try {
            StyleCache styleCache = this;
            synchronized (styleCache) {
                sty = this.styleStore.getStyleObject(styName);
            }
            if (sty != null) {
                this.put(styName, sty);
                return sty;
            }
            return null;
        }
        catch (DataException e) {
            log.severe("[datasource:" + this.dsName + "] cannot load style " + styName);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TruetypeFont getFont(String fntName) {
        if (fntName == null) {
            return null;
        }
        TruetypeFont ttf = (TruetypeFont)this.ttFonts.get(fntName = fntName.toUpperCase());
        if (ttf != null) {
            return ttf;
        }
        try {
            StyleCache styleCache = this;
            synchronized (styleCache) {
                ttf = this.styleStore.getTTFont(fntName);
            }
            if (ttf != null) {
                this.putFont(fntName, ttf);
                return ttf;
            }
            return null;
        }
        catch (DataException e) {
            log.severe("[datasource:" + this.dsName + "] cannot load tt-font " + fntName);
            return null;
        }
    }

    public void put(String styName, Style sty) {
        if (this.styles.size() > this.maxSize) {
            this.purge();
        }
        CacheEntry ce = new CacheEntry(sty);
        this.styles.put(styName.toUpperCase(), ce);
    }

    public void putFont(String fntName, TruetypeFont font) {
        this.ttFonts.put(fntName.toUpperCase(), font);
    }

    public Hashtable getAllStyles() {
        return this.styles;
    }

    public Hashtable getAllFonts() {
        return this.ttFonts;
    }

    public void remove(String styName) {
        if (styName != null) {
            styName = styName.toUpperCase();
        }
        this.styles.remove(styName);
    }

    public void removeFont(String fntName) {
        this.ttFonts.remove(fntName);
    }

    public void removeAll() {
        this.styles.clear();
        this.ttFonts.clear();
        this.addBuiltInStyles();
    }

    public void removeAllFonts() {
        this.ttFonts.clear();
    }

    private void purge() {
    }

    public boolean addStyleToEditedList(String name, Style sty) {
        if (name == null || sty == null) {
            return false;
        }
        this.editedStyles.put(name.toUpperCase(), sty);
        return true;
    }

    public boolean removeStyleFromEditedList(String name) {
        if (name == null) {
            return false;
        }
        this.editedStyles.remove(name.toUpperCase());
        return true;
    }

    public void clearStyleEditedList() {
        this.editedStyles.clear();
    }

    static class CacheEntry {
        Style sty;
        long lastUsed;

        public CacheEntry(Style _sty) {
            this.sty = _sty;
            this.lastUsed = System.currentTimeMillis();
        }

        public void mark() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

