/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;

public class SRSConstants {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static Hashtable distUnitList = new Hashtable(79);
    public static Hashtable angularUnitList = new Hashtable(17);
    private static double dpi = -1.0;

    public static double getDPI() {
        if (dpi < 0.0) {
            try {
                dpi = Toolkit.getDefaultToolkit().getScreenResolution();
                log.info("Using system default dpi: " + dpi);
            }
            catch (Throwable ex) {
                dpi = 96.0;
                log.info("Using 96.0 as default dpi.");
            }
        }
        return dpi;
    }

    public static void setDPI(double newDefaultDPI) {
        if (newDefaultDPI <= 0.0) {
            throw new IllegalArgumentException("Invalid dpi number.");
        }
        dpi = newDefaultDPI;
    }

    public static Double getDistanceConversionFactor(String unitStr) {
        if (unitStr == null) {
            return null;
        }
        unitStr = unitStr.toUpperCase();
        return (Double)distUnitList.get(unitStr);
    }

    public static Hashtable getDistanceUnitList() {
        return distUnitList;
    }

    public static Hashtable getAngularUnitList() {
        return angularUnitList;
    }

    static {
        distUnitList.put("CENTIMETER", new Double(0.01));
        distUnitList.put("CHAIN", new Double(20.1168));
        distUnitList.put("CHN_BEN", new Double(20.1167825));
        distUnitList.put("CHN_SRS", new Double(20.1167651));
        distUnitList.put("CL_FT", new Double(0.304797265));
        distUnitList.put("CM", new Double(0.01));
        distUnitList.put("FATHOM", new Double(1.8288));
        distUnitList.put("FOOT", new Double(0.3048));
        distUnitList.put("INCH", new Double(0.0254));
        distUnitList.put("IND_FT", new Double(0.304799518));
        distUnitList.put("IND_YARD", new Double(0.914398554));
        distUnitList.put("KILOMETER", new Double(1000.0));
        distUnitList.put("KM", new Double(1000.0));
        distUnitList.put("LINK", new Double(0.201166195));
        distUnitList.put("LINK_BEN", new Double(0.201167651));
        distUnitList.put("LINK_SRS", new Double(0.201167651));
        distUnitList.put("M", new Double(1.0));
        distUnitList.put("METER", new Double(1.0));
        distUnitList.put("MILE", new Double(1609.344));
        distUnitList.put("MILLIMETER", new Double(0.001));
        distUnitList.put("MM", new Double(0.001));
        distUnitList.put("MOD_USFT", new Double(0.304812253));
        distUnitList.put("NAUT_MILE", new Double(1852.0));
        distUnitList.put("ROD", new Double(5.0292));
        distUnitList.put("SRS_YARD", new Double(0.914398415));
        distUnitList.put("SURVEY_FOOT", new Double(0.3048006));
        distUnitList.put("YARD", new Double(0.9144));
        angularUnitList.put("DECIMAL DEGREE", new Double(Math.PI / 180));
        angularUnitList.put("RADIAN", new Double(1.0));
        angularUnitList.put("DECIMAL MINUTE", new Double(2.908882086657216E-4));
        angularUnitList.put("DECIMAL SECOND", new Double(4.84813681109536E-6));
        angularUnitList.put("GON", new Double(0.015707963267948967));
        angularUnitList.put("GRAD", new Double(0.015707963267948967));
    }
}

