/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.SRSConstants;
import oracle.sdovis.Spheroid;

public class SRSCommons {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static HashMap<Integer, SRS> cache = new HashMap();

    public static synchronized void addCommons() {
        String wkt = "PROJCS[\"WGS 84 / Pseudo-Mercator\",GEOGCS[\"Popular Visualisation CRS\",DATUM[\"Popular_Visualisation_Datum\",SPHEROID[\"Popular Visualisation Sphere\",6378137,0,AUTHORITY[\"EPSG\",\"7059\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6055\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4055\"]],UNIT[\"metre\",1.0],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],AUTHORITY[\"EPSG\",\"3785\"],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]]";
        SRSCommons.put(3857, wkt);
    }

    public static synchronized void put(int srid, String wkt) {
        if (cache.get(new Integer(srid)) != null) {
            return;
        }
        if (wkt == null || wkt.length() == 0) {
            if (srid == 999999) {
                SRS sr = new SRS();
                sr.set(srid, null, 1.0, 0, null);
                if (cache.get(new Integer(srid)) == null) {
                    log.finer("Registering srs " + srid + " to SRSCommons.");
                    cache.put(new Integer(srid), sr);
                }
            }
            return;
        }
        SRS sr = new SRS(null);
        int csType = 0;
        String wkt_ = wkt.toUpperCase();
        if (wkt_.indexOf("PROJCS") >= 0) {
            csType = 2;
        } else if (wkt_.indexOf("GEOGCS") >= 0) {
            csType = 1;
        } else if (wkt_.indexOf("LOCAL_CS") >= 0) {
            csType = 3;
        }
        Spheroid spheroid = SRSCache.extractSpheroidInfo(wkt_);
        int idx = wkt_.lastIndexOf("UNIT");
        int idx2 = 0;
        if (idx < 0) {
            log.severe("cannot find UNIT parameter in wkt.");
            return;
        }
        double cf = 0.0;
        String unit = null;
        try {
            while (wkt_.charAt(idx) != '[') {
                ++idx;
            }
            while (wkt_.charAt(idx) != '\"') {
                ++idx;
            }
            idx2 = ++idx;
            while (wkt_.charAt(idx2) != '\"') {
                ++idx2;
            }
            unit = wkt_.substring(idx, idx2);
            if (unit == null || unit.length() == 0) {
                log.severe("no unit name.");
                return;
            }
            idx = idx2;
            while (wkt_.charAt(idx) != ',') {
                ++idx;
            }
            idx2 = ++idx;
            while (wkt_.charAt(idx2) != ']') {
                ++idx2;
            }
            try {
                cf = Double.valueOf(wkt_.substring(idx, idx2));
            }
            catch (Exception ex) {
                log.severe("cannot parse unit conversion factor.");
                return;
            }
        }
        catch (Exception e) {
            log.severe("error parsing UNIT parameter in wkt.");
            return;
        }
        if (csType == 1) {
            Hashtable angularUnitList = SRSConstants.getAngularUnitList();
            if (angularUnitList.get(unit) == null) {
                angularUnitList.put(unit, new Double(cf));
            }
        } else {
            Hashtable distUnitList = SRSConstants.getDistanceUnitList();
            if (distUnitList.get(unit) == null) {
                distUnitList.put(unit, new Double(cf));
            }
        }
        sr.set(srid, unit, cf, csType, spheroid);
        cache.put(new Integer(srid), sr);
    }

    public static synchronized void put(int srid, SRS srs) {
        cache.put(new Integer(srid), srs);
    }

    public static synchronized SRS get(int srid) {
        if (cache.size() == 0) {
            SRSCommons.addCommons();
        }
        Integer i = new Integer(srid);
        return cache.get(i);
    }

    public static synchronized int size() {
        return cache.size();
    }

    public static void main(String[] args) {
        SRS srs = SRSCommons.get(3857);
        System.out.println("srs 3857:" + srs);
        System.out.println("SRS.isGeod:" + srs.isGeodetic());
        System.out.println("SRS.unit: " + srs.getUnit());
    }
}

