/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import java.util.Properties;
import oracle.lbs.mapcache.MCSServlet;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.sdovis.Theme;
import oracle.sdovis.theme.MapCacheThemeDefinition;
import oracle.sdovis.theme.MapCacheThemeProducer;

public class MapCacheTheme
extends Theme {
    String mapSourceName = null;
    String dataSource = null;
    private MapCache cache = null;
    int srid = 0;
    private Rectangle2D mapWindow = null;
    private boolean snapToCachedScale = false;
    private String externalMapviewerURL;
    private Properties parameters = null;

    public MapCacheTheme(String themeName, String dataSource, String mapSource, boolean snapToCachedScale, String tileServerURL, Properties parameters) {
        int dotIdx = mapSource.indexOf(".");
        if (dotIdx > 0) {
            this.mapSourceName = mapSource.substring(dotIdx + 1);
            this.dataSource = mapSource.substring(0, dotIdx);
        } else {
            this.mapSourceName = mapSource;
            this.dataSource = dataSource;
        }
        if (tileServerURL != null && !(tileServerURL = tileServerURL.trim()).endsWith("/")) {
            tileServerURL = tileServerURL + "/";
        }
        this.externalMapviewerURL = tileServerURL;
        if (tileServerURL == null) {
            this.cache = MCSServlet.server.getMapCacheByName(dataSource, this.mapSourceName);
            if (this.cache == null) {
                return;
            }
        }
        MapCacheThemeDefinition def = new MapCacheThemeDefinition(themeName, mapSource, tileServerURL);
        this.setDefinition(def);
        this.setProducer(new MapCacheThemeProducer(this));
        this.snapToCachedScale = snapToCachedScale;
        if (this.cache != null) {
            this.srid = this.cache.config.coordinateSystem.srid;
        }
        this.parameters = parameters;
    }

    @Override
    public boolean isTextLabelPresent() {
        return false;
    }

    public boolean cacheInstanceExists() {
        return this.cache != null;
    }

    @Override
    public int getSRID() {
        if (this.cache != null) {
            return this.srid;
        }
        if (this.definition != null) {
            return this.definition.getSrid();
        }
        return 0;
    }

    public MapCache getCacheInstance() {
        return this.cache;
    }

    public void setMapWindow(Rectangle2D window) {
        this.mapWindow = window;
    }

    public Rectangle2D getMapWindow() {
        return this.mapWindow;
    }

    public boolean snapToCachedScale() {
        return this.snapToCachedScale;
    }

    public String getExternalMapViewerURL() {
        return this.externalMapviewerURL;
    }

    public void setExternalMapViewerURL(String mvServer) {
        this.externalMapviewerURL = mvServer;
    }

    public String getTileResizingOption() {
        return this.decorator.tileResizingOption;
    }

    public void setTileResizingOption(String tileResizingOption_) {
        this.decorator.tileResizingOption = tileResizingOption_;
    }

    public String getTileLayerName() {
        return this.mapSourceName;
    }

    public void setTileLayerName(String name) {
        this.mapSourceName = name;
    }

    @Override
    public String getDataSourceName() {
        if (this.dataSource == null) {
            return super.getDataSourceName();
        }
        return this.dataSource;
    }

    public void setDataSource(String dsrc) {
        this.dataSource = dsrc;
    }

    public String getParameter(String name) {
        if (this.parameters != null) {
            return this.parameters.getProperty(name);
        }
        return null;
    }

    @Override
    public void destroy() {
        this.decorator = null;
        this.producer.destroy();
        this.definition = null;
    }
}

