/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Font;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyleRowData;
import oracle.sdovis.StyleStore;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;

public class JavaDBStyleStore
extends DBTable
implements StyleStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String mName = null;
    int mType = 0;
    String mDescription = null;
    StringBuffer mSVGData = null;
    byte[] mImageData = null;
    byte[] mGeometry = null;
    private Clob mCLOBSVG;
    private Blob mBLOBImage;

    public JavaDBStyleStore(String dataSrc) {
        super(dataSrc, "USER_SDO_STYLES");
    }

    public int getType() {
        return this.mType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getName() {
        return this.mName;
    }

    public StringBuffer getDefinition() {
        return this.mSVGData;
    }

    public byte[] getImageData() {
        return this.mImageData;
    }

    public byte[] getGeometry() {
        return this.mGeometry;
    }

    @Override
    public int update() throws SQLException {
        String name = this.mName;
        int type = this.mType;
        String desc = this.mDescription;
        StringBuffer svgData = this.mSVGData;
        byte[] img = this.mImageData;
        byte[] geom = this.mGeometry;
        this.delete();
        this.mName = name;
        this.mType = type;
        this.mDescription = desc;
        this.mSVGData = svgData;
        this.mImageData = img;
        this.mGeometry = geom;
        int res = this.insert();
        return res;
    }

    @Override
    public int insert() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initInsertStatement();
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, StyleUtils.getTypeNameFromCode(this.mType));
        this.mInsertStatement.setString(3, this.mDescription);
        String definition = null;
        if (this.mSVGData != null) {
            definition = this.mSVGData.toString();
        }
        if (definition == null) {
            this.mInsertStatement.setClob(4, (Clob)null);
        } else {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            try {
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)b, "UTF8"));
                w.write(definition);
                w.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            byte[] ba = b.toByteArray();
            ByteArrayInputStream barray = new ByteArrayInputStream(ba);
            this.mInsertStatement.setAsciiStream(4, (InputStream)barray, ba.length);
        }
        if (this.mImageData == null) {
            this.mInsertStatement.setBlob(5, (Blob)null);
        } else {
            ByteArrayInputStream barray = new ByteArrayInputStream(this.mImageData);
            this.mInsertStatement.setBinaryStream(5, (InputStream)barray, this.mImageData.length);
        }
        int res = this.mInsertStatement.executeUpdate();
        this.mConnection.commit();
        this.mConnection.setAutoCommit(autoCommit);
        this.close();
        return res;
    }

    @Override
    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int res = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.close();
        this.mSVGData = null;
        this.mImageData = null;
        this.mName = null;
        this.mType = 0;
        this.mDescription = null;
        this.mCLOBSVG = null;
        this.mBLOBImage = null;
        this.mGeometry = null;
        if (this.mConnection != null) {
            this.mConnection.close();
        }
        return res;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public void setType(String s) {
        this.mType = StyleUtils.getTypeCodeFromName(s);
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public void setDefinition(StringBuffer data) {
        this.mSVGData = data;
    }

    public void setImage(String imgFile) {
        if (imgFile == null || imgFile.length() < 2) {
            return;
        }
        try {
            this.mImageData = Util.readFile(imgFile);
        }
        catch (IOException e) {
            this.mImageData = null;
        }
    }

    public void setImage(byte[] data) {
        this.mImageData = data;
    }

    public void setGeometry(byte[] data) {
        this.mGeometry = data;
    }

    @Override
    public Style getStyleObject(String name) throws DataException {
        if (name == null) {
            return null;
        }
        if (name.indexOf(58) > 0 || name.indexOf(47) > 0) {
            int idx = name.indexOf(58);
            if (idx < 0) {
                idx = name.indexOf(47);
            }
            String owner = name.substring(0, idx);
            String sname = name.substring(idx + 1, name.length());
            return this.getStyleObject(sname, owner);
        }
        try {
            this.query("select *from " + this.mTableName + " where name='" + name.toUpperCase() + "'");
            if (!this.next()) {
                Style idx = null;
                return idx;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        String description = this.mDescription;
        Style style = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (style != null) {
            style.getModel().setDescription(description);
        }
        return style;
    }

    @Override
    public TruetypeFont getTTFont(String name) throws DataException {
        if (name == null) {
            return null;
        }
        Font font = null;
        if (name.indexOf(58) > 0) {
            int idx = name.indexOf(58);
            String owner = name.substring(0, idx);
            String sname = name.substring(idx + 1, name.length());
            return this.getTTFont(sname, owner);
        }
        try {
            this.query("select * from " + this.mUser + "." + this.mTableName + " where name='" + name.toUpperCase() + "' and type='TTF'");
            if (!this.next()) {
                TruetypeFont idx = null;
                return idx;
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        TruetypeFont ttf = new TruetypeFont();
        ttf.setName(this.mName);
        ttf.setDescription(this.mDescription);
        ttf.setFontData(this.mImageData);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, bais);
            ttf.setFont(font);
            return ttf;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DataException(e.getCause());
        }
    }

    public Style getStyleObject(String name, String owner) throws DataException {
        if (name == null) {
            return null;
        }
        try {
            this.query("select * from " + owner + "." + this.mTableName + " where name='" + name.toUpperCase() + "'");
            if (!this.next()) {
                Style style = null;
                return style;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {
                e2.printStackTrace(System.err);
            }
        }
        String description = this.mDescription;
        Style style = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (style != null) {
            style.getModel().setDescription(description);
        }
        return style;
    }

    public TruetypeFont getTTFont(String name, String owner) throws DataException {
        if (name == null) {
            return null;
        }
        try {
            this.query("select * from " + owner + "." + this.mTableName + " where name='" + name.toUpperCase() + "' and type='TTF'");
            if (!this.next()) {
                TruetypeFont truetypeFont = null;
                return truetypeFont;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        TruetypeFont ttf = new TruetypeFont();
        ttf.setName(this.mName);
        ttf.setDescription(this.mDescription);
        ttf.setFontData(this.mImageData);
        Font font = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, bais);
            ttf.setFont(font);
            return ttf;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DataException(e.getCause());
        }
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    @Override
    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + "(name,type,description,definition,image)" + " VALUES(?, ?, ?, ?, ?)");
        }
    }

    @Override
    protected void initUpdateStatement() throws SQLException {
    }

    @Override
    protected void updateLocalData() throws SQLException {
        String typeName = null;
        Object owner = null;
        this.mName = this.mResultSet.getString("NAME");
        typeName = this.mResultSet.getString("TYPE");
        this.mType = StyleUtils.getTypeCodeFromName(typeName);
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        this.mCLOBSVG = (Clob)this.mResultSet.getObject("DEFINITION");
        this.mBLOBImage = (Blob)this.mResultSet.getObject("IMAGE");
        try {
            this.mSVGData = new StringBuffer(this.mCLOBSVG.getSubString(1L, (int)this.mCLOBSVG.length()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mSVGData = null;
        }
        if (this.mBLOBImage == null) {
            this.mImageData = null;
            return;
        }
        try {
            if (this.mBLOBImage.length() < 5L) {
                this.mImageData = null;
                return;
            }
            this.mImageData = this.mBLOBImage.getBytes(1L, (int)this.mBLOBImage.length());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mImageData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStyleNames(String type) {
        ArrayList<String> arrayList;
        ArrayList<String> res = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            if (conn == null) {
                ArrayList<String> arrayList2 = res;
                return arrayList2;
            }
            res = new ArrayList<String>();
            String owner = this.mUser;
            String q1 = "select name from " + owner + ".user_sdo_styles order by name";
            String q2 = "select name from " + owner + ".user_sdo_styles where type=? order by name";
            String query = type == null ? q1 : q2;
            stmt = conn.prepareStatement(query);
            if (type != null) {
                stmt.setString(1, type);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                res.add(rs.getString(1));
            }
            arrayList = res;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            ArrayList<String> arrayList3 = res;
            return arrayList3;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStyleNamesAndTypes(String[] types) {
        ArrayList<String> arrayList;
        ArrayList<String> res = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            if (conn == null) {
                ArrayList<String> arrayList2 = res;
                return arrayList2;
            }
            res = new ArrayList<String>();
            String owner = this.mUser;
            String q1 = "select name, type from " + owner + ".user_sdo_styles";
            if (types != null && types.length > 0) {
                q1 = q1 + " where ";
                for (int i = 0; i < types.length; ++i) {
                    q1 = i == 0 ? q1 + "type=?" : q1 + " or type=?";
                }
            }
            String query = q1 = q1 + " order by name";
            stmt = conn.prepareStatement(query);
            if (types != null && types.length > 0) {
                for (int i = 0; i < types.length; ++i) {
                    stmt.setString(1 + i, types[i]);
                }
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                res.add(rs.getString(1) + ":" + rs.getString(2));
            }
            arrayList = res;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            ArrayList<String> arrayList3 = res;
            return arrayList3;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return arrayList;
    }

    @Override
    public StyleRowData getStyleData(String name) throws DataException {
        if (name == null) {
            return null;
        }
        String owner = this.mUser;
        if (name.indexOf(58) > 0) {
            int idx = name.indexOf(58);
            owner = name.substring(0, idx);
            name = name.substring(idx + 1, name.length());
            return this.getStyleData(name, owner, false);
        }
        return this.getStyleData(name, owner, true);
    }

    public StyleRowData getStyleData(String name, String owner, boolean checkCurrentSchema) throws DataException {
        StyleRowData styleRowData;
        if (name == null) {
            return null;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            String currentSchema = owner;
            if (checkCurrentSchema && (currentSchema = Util.getCurrentSchema(conn, null)) == null) {
                currentSchema = owner;
            }
            String sql = "select * from " + currentSchema + ".user_sdo_styles where name=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, name.toUpperCase());
            rs = ps.executeQuery();
            if (!rs.next()) {
                log.warning("Cannot find style named " + name + " of " + currentSchema + " in user_sdo_styles");
                StyleRowData styleRowData2 = null;
                return styleRowData2;
            }
            this.updateLocalData(rs);
            StyleRowData row = new StyleRowData();
            row.name = this.mName;
            row.description = this.mDescription;
            row.definition = this.mSVGData.toString();
            row.geometry = this.mGeometry;
            row.image = this.mImageData;
            styleRowData = row;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {}
        }
        return styleRowData;
    }

    protected void updateLocalData(ResultSet rs) throws SQLException {
        this.mName = rs.getString("NAME");
        String typeName = rs.getString("TYPE");
        this.mType = StyleUtils.getTypeCodeFromName(typeName);
        this.mDescription = rs.getString("DESCRIPTION");
        this.mCLOBSVG = rs.getClob("DEFINITION");
        this.mBLOBImage = rs.getBlob("IMAGE");
        try {
            this.mSVGData = new StringBuffer(this.mCLOBSVG.getSubString(1L, (int)this.mCLOBSVG.length()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mSVGData = null;
        }
        if (this.mBLOBImage == null) {
            this.mImageData = null;
            return;
        }
        try {
            if (this.mBLOBImage.length() < 5L) {
                this.mImageData = null;
                return;
            }
            this.mImageData = this.mBLOBImage.getBytes(1L, (int)this.mBLOBImage.length());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mImageData = null;
        }
    }
}

