/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CoordArray;
import oracle.sdovis.DataException;
import oracle.sdovis.Unpickle81;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class JSDOGeometry
extends JGeometry
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4792272186565640701L;
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    boolean reoriented = false;

    protected JSDOGeometry(int gtype, int srid) {
        super(gtype, srid);
    }

    public JSDOGeometry(int gtype, int srid, double x, double y, double z, int[] elemInfo, double[] ordinates) {
        super(gtype, srid, x, y, z, elemInfo, ordinates);
    }

    public JSDOGeometry(int gtype, int srid, int[] elemInfo, double[] ordinates) {
        super(gtype, srid, elemInfo, ordinates);
    }

    public JSDOGeometry(double x, double y, int srid) {
        super(x, y, srid);
    }

    public JSDOGeometry(double x, double y, double z, int srid) {
        super(x, y, z, srid);
    }

    public JSDOGeometry(double minX, double minY, double maxX, double maxY, int srid) {
        super(minX, minY, maxX, maxY, srid);
    }

    public Object clone() {
        JSDOGeometry geom = (JSDOGeometry)super.clone();
        return geom;
    }

    public static JSDOGeometry recast(JGeometry geom) {
        if (geom == null) {
            return null;
        }
        double[] lp = geom.getLabelPointXYZ();
        int gt = geom.getType();
        int dim = geom.getDimensions();
        int lrm = geom.getLRMDimension();
        int gtype = dim * 1000 + lrm * 100 + gt;
        JSDOGeometry ng = new JSDOGeometry(gtype, geom.getSRID(), lp[0], lp[1], lp[2], geom.getElemInfo(), geom.getOrdinatesArray());
        return ng;
    }

    public static JSDOGeometry setOrientation(JSDOGeometry geom, double orientX, double orientY) {
        if (geom == null) {
            return null;
        }
        int gt = geom.getType();
        if (gt != 1) {
            return geom;
        }
        int dim = geom.getDimensions();
        int lrm = geom.getLRMDimension();
        int gtype = dim * 1000 + lrm * 100 + gt;
        double[] lp = geom.getLabelPointXYZ();
        int[] etype = new int[]{1, 1, 1, 3, 1, 0};
        double[] ords = new double[4];
        if (lp != null) {
            ords[0] = lp[0];
            ords[1] = lp[1];
        } else {
            double[] coords = geom.getOrdinatesArray();
            ords[0] = coords[0];
            ords[1] = coords[1];
        }
        ords[2] = orientX;
        ords[3] = orientY;
        return new JSDOGeometry(gtype, geom.getSRID(), etype, ords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSDOGeometry(double minX, double minY, double maxX, double maxY, int innerouter, int srid, Connection conn) throws DataException, SQLException {
        super(3, srid);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(" SELECT count(*) from mdsys.geodetic_srids where srid = ?");
            ps.setInt(1, srid);
            rs = ps.executeQuery();
            rs.next();
            int cnt = rs.getInt(1);
            if (cnt == 0) {
                throw new DataException("an srid exists in geodetic_srids view is required.");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        if (innerouter != 1003 && innerouter != 2003) {
            throw new DataException("an SDO_ETYPE value of 1003 or 2003 is required.");
        }
        if (minY > maxY) {
            throw new DataException("minY must be less than maxY.");
        }
        this.elemInfo = new int[3];
        this.elemInfo[0] = 1;
        this.elemInfo[1] = innerouter;
        this.elemInfo[2] = 5;
        this.ordinates = new double[4];
        this.ordinates[0] = minX;
        this.ordinates[1] = minY;
        this.ordinates[2] = maxX;
        this.ordinates[3] = maxY;
    }

    public boolean LoadedAndReoriented() {
        return this.reoriented;
    }

    private void transformCoords(AffineTransform xfm) {
    }

    public static final JSDOGeometry loadFromDB(STRUCT st) throws SQLException {
        double[] coords;
        if (st == null) {
            return null;
        }
        Datum[] attrs = st.getOracleAttributes();
        int gtype = attrs[0] != null ? attrs[0].intValue() : 0;
        int srid = attrs[1] != null ? attrs[1].intValue() : 0;
        STRUCT dbpoint = (STRUCT)attrs[2];
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        if (dbpoint != null) {
            Datum[] xyz = dbpoint.getOracleAttributes();
            if (xyz[0] != null && xyz[1] != null) {
                x = xyz[0].doubleValue();
                y = xyz[1].doubleValue();
            }
            if (xyz[2] != null) {
                z = xyz[2].doubleValue();
            }
        }
        int[] einfo = attrs[3] != null ? ((ARRAY)attrs[3]).getIntArray() : null;
        double[] dArray = coords = attrs[4] != null ? ((ARRAY)attrs[4]).getDoubleArray() : null;
        if (coords != null && einfo != null) {
            boolean flag = JSDOGeometry.nonOracleETypeExists(einfo);
            if (!flag) {
                return new JSDOGeometry(gtype, srid, x, y, z, einfo, coords);
            }
            return JSDOGeometry.removeEType0(gtype, srid, x, y, z, einfo, coords);
        }
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            if (!Double.isNaN(z)) {
                return new JSDOGeometry(x, y, z, srid);
            }
            return new JSDOGeometry(x, y, srid);
        }
        return null;
    }

    public static boolean nonOracleETypeExists(int[] ea) throws SQLException {
        if (ea == null || ea.length == 0) {
            return false;
        }
        for (int i = 0; i < ea.length / 3; ++i) {
            if (ea[3 * i] < 1) {
                throw new SQLException("Ordinate Starting Offset could not be less than 1");
            }
            if (ea[3 * i + 1] != 0) continue;
            return true;
        }
        return false;
    }

    public static JSDOGeometry removeEType0(int gtype, int srid, double x, double y, double z, int[] einfo, double[] coords) throws SQLException {
        int[] new_einfo_tmp = new int[einfo.length];
        double[] new_coords_tmp = new double[coords.length];
        int i = 0;
        int j = 0;
        int counter_ei = 0;
        int counter_ords = 0;
        int ignored_coords = 0;
        int start_ords = 0;
        int end_ords = 0;
        for (i = 0; i < einfo.length / 3; ++i) {
            if (einfo[3 * i] < 1) {
                throw new SQLException("Ordinate Starting Offset could not be less than 1");
            }
            if (einfo[3 * i + 1] == 0) {
                start_ords = einfo[3 * i] - 1;
                end_ords = 3 * (i + 1) <= einfo.length - 1 ? einfo[3 * (i + 1)] - 2 : coords.length - 1;
                ignored_coords += end_ords - start_ords + 1;
                continue;
            }
            start_ords = einfo[3 * i] - 1;
            end_ords = 3 * (i + 1) <= einfo.length - 1 ? einfo[3 * (i + 1)] - 2 : coords.length - 1;
            for (j = start_ords; j <= end_ords; ++j) {
                new_coords_tmp[counter_ords] = coords[j];
                ++counter_ords;
            }
            new_einfo_tmp[counter_ei] = einfo[3 * i] - ignored_coords;
            ++counter_ei;
            for (j = 1; j < 3; ++j) {
                new_einfo_tmp[counter_ei] = einfo[3 * i + j];
                ++counter_ei;
            }
        }
        int[] new_einfo = new int[counter_ei];
        double[] new_coords = new double[counter_ords];
        System.arraycopy(new_einfo_tmp, 0, new_einfo, 0, counter_ei);
        System.arraycopy(new_coords_tmp, 0, new_coords, 0, counter_ords);
        return new JSDOGeometry(gtype, srid, x, y, z, new_einfo, new_coords);
    }

    static final JGeometry loadAndReorient(STRUCT st) throws SQLException {
        JSDOGeometry geom = JSDOGeometry.loadFromDB(st);
        return geom;
    }

    public static final JSDOGeometry loadFromDB(byte[] image) throws Exception {
        if (image == null || image.length < 8) {
            return null;
        }
        return Unpickle81.unpickle(image);
    }

    public static final JSDOGeometry loadAndReorient(byte[] image) throws Exception {
        JSDOGeometry geom = JSDOGeometry.loadFromDB(image);
        if (geom == null) {
            return null;
        }
        if (!(geom.gtype != 2 && geom.gtype != 6 && geom.gtype != 4 || geom.hasCircularArcs())) {
            geom.reOrientCurves();
        }
        return geom;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.gtype);
        out.writeInt(this.linfo);
        out.writeInt(this.srid);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeObject(this.elemInfo);
        out.writeObject(this.ordinates);
        out.writeInt(this.dim);
        out.writeObject(this.mbr);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.gtype = in.readInt();
        this.linfo = in.readInt();
        this.srid = in.readInt();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.elemInfo = (int[])in.readObject();
        this.ordinates = (double[])in.readObject();
        this.dim = in.readInt();
        this.mbr = (double[])in.readObject();
    }

    public long getSize() {
        return 40 + (this.elemInfo == null ? 0 : 4 * this.elemInfo.length) + (this.ordinates == null ? 0 : 8 * this.ordinates.length);
    }

    public boolean pointInPolygon(double x, double y) {
        if (this.gtype != 3 && this.gtype != 7) {
            return false;
        }
        this.getMBR();
        if (x < this.mbr[0] || x > this.mbr[2] || y < this.mbr[1] || y > this.mbr[3]) {
            return false;
        }
        int i = 0;
        int j = 0;
        boolean c = false;
        double xi = 0.0;
        double yi = 0.0;
        double xj = 0.0;
        double yj = 0.0;
        JGeometry.ElementIterator eit = new JGeometry.ElementIterator((JGeometry)this);
        while (eit.next()) {
            int offset = eit.ord_offset;
            int npol = eit.nCoord;
            int etype = eit.original_etype;
            try {
                i = 0;
                j = npol - 1;
                while (i < npol) {
                    xi = this.ordinates[offset + i * this.dim];
                    yi = this.ordinates[offset + i * this.dim + 1];
                    xj = this.ordinates[offset + j * this.dim];
                    yj = this.ordinates[offset + j * this.dim + 1];
                    if ((yi <= y && y < yj || yj <= y && y < yi) && x < (xj - xi) * (y - yi) / (yj - yi) + xi) {
                        c = !c;
                    }
                    j = i++;
                }
            }
            catch (Error e) {
                return false;
            }
            if (c && (etype == 1003 || etype == 3)) {
                return true;
            }
            c = false;
        }
        return c;
    }

    public String toString() {
        String s = "JSDOGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        return s;
    }

    boolean crossing180() {
        if (this.gtype != 2 && this.gtype != 3 && this.gtype != 6 && this.gtype != 7) {
            return false;
        }
        this.getMBR();
        return this.mbr[0] < 0.0 && this.mbr[2] > 0.0 && this.mbr[2] - this.mbr[0] > 180.0 && this.mbr[3] > -60.0;
    }

    void elemMBR(int offset, int nCoord, double[] mbr) {
        int orient_offset = 0;
        if (this.isOrientedMultiPoint()) {
            orient_offset = this.getOrientMultiPointOffset();
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < nCoord; ++i) {
            double x = this.ordinates[offset + i * (this.dim + orient_offset)];
            double y = this.ordinates[offset + i * (this.dim + orient_offset) + 1];
            if (minX > x) {
                minX = x;
            }
            if (maxX < x) {
                maxX = x;
            }
            if (minY > y) {
                minY = y;
            }
            if (!(maxY < y)) continue;
            maxY = y;
        }
        mbr[0] = minX;
        mbr[1] = minY;
        mbr[2] = maxX;
        mbr[3] = maxY;
    }

    boolean elemCrossing180(int offset, int nCoord, double[] embr) {
        this.elemMBR(offset, nCoord, embr);
        return embr[0] < 0.0 && embr[2] > 0.0 && embr[2] - embr[0] > 180.0 && embr[3] > -60.0;
    }

    public boolean unwrapAt180() {
        double[] _mbr = new double[4];
        boolean flag = false;
        int orient_offset = 0;
        if (this.isOrientedMultiPoint()) {
            orient_offset = this.getOrientMultiPointOffset();
        }
        JGeometry.ElementIterator eit = new JGeometry.ElementIterator((JGeometry)this);
        while (eit.next()) {
            int offset;
            if (eit.eitpr == 2 || eit.eitpr == 4 || !this.elemCrossing180(offset = eit.ord_offset, eit.nCoord, _mbr)) continue;
            for (int i = 0; i < eit.nCoord; ++i) {
                flag = true;
                if (!(this.ordinates[offset + i * (this.dim + orient_offset)] < 0.0)) continue;
                int n = offset + i * (this.dim + orient_offset);
                this.ordinates[n] = this.ordinates[n] + 360.0;
            }
        }
        if (flag) {
            this.mbr = null;
            this.getMBR();
        }
        return flag;
    }

    boolean _elemCrossing180(int offset, int nCoord, double[] embr) {
        this.elemMBR(offset, nCoord, embr);
        return embr[2] > 180.0;
    }

    private void splitAt180() {
        double[] _mbr = new double[4];
        JGeometry.ElementIterator eit = new JGeometry.ElementIterator((JGeometry)this);
        while (eit.next()) {
            int nCoord;
            int offset;
            if (eit.eitpr != 2 && eit.eitpr != 4 && this._elemCrossing180(offset = eit.ord_offset, nCoord = eit.nCoord, _mbr)) continue;
        }
    }

    private void elemSplitAt180(double[] in, int offset, int nCoord, int etype) {
        double X = 180.0;
        double x1 = in[offset];
        double y1 = in[offset + 1];
        double x2 = in[offset + this.dim];
        double y2 = in[offset + this.dim + 1];
        double x3 = in[offset + this.dim + this.dim];
        double y3 = in[offset + this.dim + this.dim + 1];
        boolean clockwise = JSDOGeometry.orientation((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3) < 0.0;
        CoordArray left = new CoordArray(nCoord / 2);
        CoordArray right = new CoordArray(nCoord / 2);
        for (int i = 1; i < nCoord - 1; ++i) {
            double yi;
            if (i > 1) {
                x1 = x2;
                y1 = y2;
                x2 = in[offset + this.dim * i];
                y2 = in[offset + this.dim * i + 1];
            }
            if (x1 == X) {
                left.add(x1, y1);
                right.add(x1, y1);
                continue;
            }
            if (x1 < X && x2 <= X) {
                left.add(x1, y1);
                continue;
            }
            if (x1 > X && x2 >= X) {
                right.add(x1, y1);
                continue;
            }
            double sx = x1 < 0.0 ? x1 + 360.0 : x1;
            double ex = x2 < 0.0 ? x2 + 360.0 : x2;
            double m = (y1 - y2) / (sx - ex);
            double xi = X;
            double d = yi = y1 == y2 ? y1 : y2 + (X - ex) * m;
            if (x1 < X && x2 > X) {
                left.add(x1, y1);
                left.add(xi, yi);
                right.add(xi, yi);
                left.add(Double.NaN, Double.NaN);
                continue;
            }
            if (!(x1 > X) || !(x2 < X)) continue;
            right.add(x1, y1);
            left.add(xi, yi);
            right.add(xi, yi);
            right.add(Double.NaN, Double.NaN);
        }
        if (etype % 10 == 3) {
            this.closeLeftClips(left, clockwise, X);
            this.closeRightClips(right, clockwise, X);
        }
    }

    private void closeLeftClips(CoordArray a, boolean clockwise, double X) {
        int i = 0;
        while (i < a.getNumCoords()) {
            double x = a.getX(i);
            if (Double.isNaN(x)) {
                a.remove(i);
                continue;
            }
            ++i;
        }
        if (a.getX(0) != a.getLastX() || a.getY(0) != a.getLastY()) {
            a.add(a.getX(0), a.getY(0));
        }
    }

    private void closeRightClips(CoordArray a, boolean clockwise, double X) {
        this.closeLeftClips(a, clockwise, X);
    }
}

