/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.util;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLogger;

public class LogFactory {
    public static String WS_LOGGER = "oracle.mapviewer.ws";
    public static String ACCESS_LOGGER = "oracle.mapviewer.access";
    public static String BUILDER_LOGGER = "oracle.mapviewer.builder";
    public static String SDOVIS_LOGGER = "oracle.mapviewer.sdovis";
    public static String CONSOLE_LOGGER = "oracle.mapviewer.webconsole";
    private static Vector<String> outputLocation = new Vector();
    public static Properties properties = new Properties();

    public static Logger getLogger(LoggerEnum loggerEnum) {
        if (loggerEnum == LoggerEnum.ACCESS) {
            return LogFactory.getLogerUsingName(ACCESS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOVIS) {
            return LogFactory.getLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.INTERNAL) {
            return LogFactory.getLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMS) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMTS) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPVIEWER) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPCACHE_SERVER) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.FOI_SERVER) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPBUILDER) {
            return LogFactory.getLogerUsingName(BUILDER_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SHARE) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WEBCONSOLE) {
            return LogFactory.getLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPEDITOR) {
            return LogFactory.getLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOEDIT) {
            return LogFactory.getLogerUsingName(SDOVIS_LOGGER, null);
        }
        return null;
    }

    public static ODLLogger getODLLogger(LoggerEnum loggerEnum) {
        if (loggerEnum == LoggerEnum.ACCESS) {
            return LogFactory.getODLLogerUsingName(ACCESS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOVIS) {
            return LogFactory.getODLLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.INTERNAL) {
            return LogFactory.getODLLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMS) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMTS) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPVIEWER) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPCACHE_SERVER) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.FOI_SERVER) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPBUILDER) {
            return LogFactory.getODLLogerUsingName(BUILDER_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SHARE) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WEBCONSOLE) {
            return LogFactory.getODLLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPEDITOR) {
            return LogFactory.getODLLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOEDIT) {
            return LogFactory.getODLLogerUsingName(SDOVIS_LOGGER, null);
        }
        return null;
    }

    private static Logger getRealLogger(RealODLLoggersEnum loggerEnum) {
        if (loggerEnum == RealODLLoggersEnum.WS) {
            return Logger.getLogger(WS_LOGGER);
        }
        if (loggerEnum == RealODLLoggersEnum.ACCESS) {
            return Logger.getLogger(ACCESS_LOGGER);
        }
        if (loggerEnum == RealODLLoggersEnum.BUILDER) {
            return Logger.getLogger(BUILDER_LOGGER);
        }
        if (loggerEnum == RealODLLoggersEnum.SDOVIS) {
            return Logger.getLogger(SDOVIS_LOGGER);
        }
        if (loggerEnum == RealODLLoggersEnum.CONSOLE) {
            return Logger.getLogger(CONSOLE_LOGGER);
        }
        return null;
    }

    private static Logger getLogerUsingName(String name, String resource) {
        Logger log = null;
        log = resource == null ? Logger.getLogger(name) : Logger.getLogger(name, resource);
        if (log != null) {
            return log;
        }
        return Logger.getLogger(name);
    }

    private static ODLLogger getODLLogerUsingName(String name, String resource) {
        ODLLogger log = null;
        log = resource == null ? ODLLogger.getODLLogger((String)name) : ODLLogger.getODLLogger((String)name, (String)resource);
        if (log != null) {
            return log;
        }
        return ODLLogger.getODLLogger((String)name);
    }

    public static void setMapViewerGlobalConfigs(Properties p, String[] outputs, Properties pLevels) {
        String fileCount;
        properties = p;
        outputLocation = new Vector();
        for (RealODLLoggersEnum e : RealODLLoggersEnum.values()) {
            Handler[] handlers;
            Logger log = LogFactory.getRealLogger(e);
            for (Handler h : handlers = log.getHandlers()) {
                log.removeHandler(h);
            }
        }
        String s = (String)p.get("console_log_level");
        Level level = Level.INFO;
        if ("finest".equalsIgnoreCase(s)) {
            level = Level.FINEST;
        } else if ("debug".equalsIgnoreCase(s)) {
            level = Level.FINER;
        }
        if ("fine".equalsIgnoreCase(s)) {
            level = Level.FINE;
        }
        if ("config".equalsIgnoreCase(s)) {
            level = Level.CONFIG;
        } else if ("info".equalsIgnoreCase(s)) {
            level = Level.INFO;
        } else if ("warn".equalsIgnoreCase(s)) {
            level = Level.WARNING;
        } else if ("error".equalsIgnoreCase(s)) {
            level = Level.SEVERE;
        } else if ("fatal".equalsIgnoreCase(s)) {
            level = Level.SEVERE;
        }
        double limit = 50.0;
        int count = 10;
        String fileLimit = (String)p.get("file_limit");
        if (fileLimit != null && fileLimit.length() > 0) {
            try {
                limit = Double.parseDouble(fileLimit);
            }
            catch (Exception ex) {
                System.err.println("invalid log file size limit specified: " + fileLimit);
            }
        }
        if ((fileCount = (String)p.get("file_count")) != null && fileCount.length() > 0) {
            try {
                count = Integer.parseInt(fileCount);
            }
            catch (Exception ex) {
                System.err.println("invalid rotating log file count specified: " + fileCount);
            }
        }
        if (outputs == null || outputs.length == 0) {
            return;
        }
        boolean console = false;
        Vector<Handler> handlers = new Vector<Handler>();
        for (int i = 0; i < outputs.length; ++i) {
            Handler h;
            String o = outputs[i];
            if ("System.err".equalsIgnoreCase(o) || "System.out".equalsIgnoreCase(o)) {
                if (!console) {
                    h = new ConsoleHandler();
                    h.setLevel(level);
                    try {
                        h.setEncoding("UTF-8");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    handlers.add(h);
                    console = true;
                }
            } else {
                try {
                    long limitBytes = (long)(1048576.0 * limit);
                    System.err.println("Log file size limit set to: " + limitBytes + " bytes.");
                    System.err.println("Log file rotation count set to: " + count + ".");
                    for (RealODLLoggersEnum e : RealODLLoggersEnum.values()) {
                        ODLHandler h2 = new ODLHandler(o, limitBytes, limitBytes * (long)count);
                        h2.setFormatter((Formatter)new ODLFormatter());
                        h2.setEncoding("UTF-8");
                        handlers.add((Handler)h2);
                        Logger log = LogFactory.getRealLogger(e);
                        if (log == null) {
                            System.err.println("cannot obtain logger for " + (Object)((Object)e));
                            continue;
                        }
                        String currentLevel = pLevels.getProperty(log.getName());
                        if (currentLevel == null) {
                            h2.setLevel(level);
                            log.setLevel(level);
                        } else if (currentLevel.equalsIgnoreCase("fatal")) {
                            h2.setLevel(Level.SEVERE);
                            log.setLevel(Level.SEVERE);
                        } else if (currentLevel.equalsIgnoreCase("error")) {
                            h2.setLevel(Level.SEVERE);
                            log.setLevel(Level.SEVERE);
                        } else if (currentLevel.equalsIgnoreCase("warn")) {
                            h2.setLevel(Level.WARNING);
                            log.setLevel(Level.WARNING);
                        } else if (currentLevel.equalsIgnoreCase("info")) {
                            h2.setLevel(Level.INFO);
                            log.setLevel(Level.INFO);
                        } else if (currentLevel.equalsIgnoreCase("config")) {
                            h2.setLevel(Level.CONFIG);
                            log.setLevel(Level.CONFIG);
                        } else if (currentLevel.equalsIgnoreCase("fine")) {
                            h2.setLevel(Level.FINE);
                            log.setLevel(Level.FINE);
                        } else if (currentLevel.equalsIgnoreCase("debug")) {
                            h2.setLevel(Level.FINER);
                            log.setLevel(Level.FINER);
                        } else if (currentLevel.equalsIgnoreCase("finest")) {
                            h2.setLevel(Level.FINEST);
                            log.setLevel(Level.FINEST);
                        } else {
                            h2.setLevel(level);
                            log.setLevel(level);
                        }
                        log.setUseParentHandlers(false);
                        log.addHandler((Handler)h2);
                    }
                }
                catch (Exception e) {
                    System.err.println("error creating file based log handler:" + o);
                }
            }
            if ((h = (Handler)handlers.get(handlers.size() - 1)) instanceof ConsoleHandler) continue;
            outputLocation.add(((ODLHandler)h).getPath());
        }
        for (int j = 0; j < handlers.size(); ++j) {
            Handler h = (Handler)handlers.get(j);
            if (!(h instanceof ConsoleHandler)) continue;
            for (RealODLLoggersEnum e : RealODLLoggersEnum.values()) {
                Logger log = LogFactory.getRealLogger(e);
                log.addHandler(h);
            }
        }
    }

    static boolean hasConsoleHandler(Logger log) {
        Handler[] hs = log.getHandlers();
        for (int i = 0; i < hs.length; ++i) {
            Handler h = hs[i];
            if (!(h instanceof ConsoleHandler)) continue;
            return true;
        }
        return false;
    }

    public static String getLogFileContents(String type, int lines) {
        Logger log = null;
        if ("WS_LOGGER".equalsIgnoreCase(type)) {
            log = LogFactory.getRealLogger(RealODLLoggersEnum.WS);
        } else if ("ACCESS_LOGGER".equalsIgnoreCase(type)) {
            log = LogFactory.getRealLogger(RealODLLoggersEnum.ACCESS);
        } else if ("BUILDER_LOGGER".equalsIgnoreCase(type)) {
            log = LogFactory.getRealLogger(RealODLLoggersEnum.BUILDER);
        } else if ("SDOVIS_LOGGER".equalsIgnoreCase(type)) {
            log = LogFactory.getRealLogger(RealODLLoggersEnum.SDOVIS);
        } else if ("CONSOLE_LOGGER".equalsIgnoreCase(type)) {
            log = LogFactory.getRealLogger(RealODLLoggersEnum.CONSOLE);
        }
        return "";
    }

    public static void setGlobalLevel(String slevel) {
        Properties p = new Properties();
        p.put("console_log_level", slevel);
        Level level = Level.INFO;
        if ("finest".equalsIgnoreCase(slevel)) {
            level = Level.FINEST;
        } else if ("debug".equalsIgnoreCase(slevel)) {
            level = Level.FINER;
        } else if ("fine".equalsIgnoreCase(slevel)) {
            level = Level.FINE;
        } else if ("config".equalsIgnoreCase(slevel)) {
            level = Level.CONFIG;
        } else if ("info".equalsIgnoreCase(slevel)) {
            level = Level.INFO;
        } else if ("warn".equalsIgnoreCase(slevel)) {
            level = Level.WARNING;
        } else if ("error".equalsIgnoreCase(slevel)) {
            level = Level.SEVERE;
        } else if ("fatal".equalsIgnoreCase(slevel)) {
            level = Level.SEVERE;
        }
        for (RealODLLoggersEnum e : RealODLLoggersEnum.values()) {
            Logger log = LogFactory.getRealLogger(e);
            log.setLevel(level);
            for (Handler h : log.getHandlers()) {
                h.setLevel(level);
            }
        }
    }

    public static Properties getGlobalProperties() {
        return properties;
    }

    public static String[] getLogFileLocations() {
        return outputLocation.toArray(new String[outputLocation.size()]);
    }

    private static enum RealODLLoggersEnum {
        WS,
        ACCESS,
        BUILDER,
        SDOVIS,
        CONSOLE;

    }

    public static enum LoggerEnum {
        ACCESS,
        INTERNAL,
        MAPBUILDER,
        SDOVIS,
        WMS,
        WMTS,
        MAPVIEWER,
        MAPCACHE_SERVER,
        FOI_SERVER,
        SHARE,
        WEBCONSOLE,
        MAPEDITOR,
        SDOEDIT;

    }
}

