/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.stylex.Bucket;

public class RangedBucket
extends Bucket {
    static final long serialVersionUID = -5125025974937295048L;
    Field low = null;
    Field high = null;

    public RangedBucket(String id) {
        super(id);
    }

    public RangedBucket(String id, Field low, Field high) {
        super(id);
        this.setRange(low, high);
    }

    @Override
    public Object clone() {
        RangedBucket bkt = (RangedBucket)super.clone();
        return bkt;
    }

    public Field getLowerBoundValue() {
        return this.low;
    }

    public void setLowerBoundValue(Field f) {
        this.low = f;
    }

    public Field getUpperBoundValue() {
        return this.high;
    }

    public void setUpperBoundValue(Field f) {
        this.high = f;
    }

    public void setRange(Field low, Field high) {
        this.low = low;
        this.high = high;
        this.bucketLabel = "" + low + " - " + high;
    }

    @Override
    public boolean contains(Field v) {
        block10: {
            if (v == null || this.low == null && this.high == null) {
                return false;
            }
            try {
                if (this.low == null && this.high.compareTo(v) > 0) {
                    return true;
                }
                if (this.high == null && this.low.compareTo(v) <= 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(v) <= 0 && this.high.compareTo(v) > 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(v) <= 0 && this.high.compareTo(v) == 0 && this.isLastBucket()) {
                    return true;
                }
            }
            catch (ClassCastException e) {
                v = this.low != null ? Field.createField(v.getString(), this.low.getShortJavaTypeName()) : Field.createField(v.getString(), this.high.getShortJavaTypeName());
                if (this.low == null && this.high.compareTo(v) > 0) {
                    return true;
                }
                if (this.high == null && this.low.compareTo(v) <= 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(v) <= 0 && this.high.compareTo(v) > 0) {
                    return true;
                }
                if (this.low == null || this.high == null || this.low.compareTo(v) > 0 || this.high.compareTo(v) != 0 || !this.isLastBucket()) break block10;
                return true;
            }
        }
        return false;
    }

    public double getLowerBound() {
        if (this.low == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.low.getDouble();
    }

    public void setLowerBound(double value) {
        if (this.low == null) {
            this.low = new Field().setDouble(value);
        } else {
            this.low.setDouble(value);
        }
    }

    public double getUpperBound() {
        if (this.high == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.high.getDouble();
    }

    public void setUpperBound(double value) {
        if (this.high == null) {
            this.high = new Field().setDouble(value);
        } else {
            this.high.setDouble(value);
        }
    }
}

