/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class ColorStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = -6980461813241800978L;
    protected Color fillColor = null;
    protected Color strokeColor = null;
    protected float strokeWidth = 1.0f;

    public ColorStyleModel() {
        this.type = 1;
    }

    @Override
    public Object clone() {
        ColorStyleModel obj = (ColorStyleModel)super.clone();
        return obj;
    }

    @Override
    public String getTypeName() {
        return "COLOR";
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public String toXMLString() {
        int alpha;
        String stroke = "";
        String fill = "";
        if (this.strokeColor != null) {
            stroke = stroke + "stroke:" + StyleUtils.getHexidecimalString(this.strokeColor);
            alpha = this.strokeColor.getAlpha();
            if (alpha < 255) {
                stroke = stroke + ";stroke-opacity:" + alpha;
            }
            if (this.strokeWidth != 1.0f) {
                stroke = stroke + ";stroke-width:" + this.strokeWidth;
            }
            if (this.fillColor != null) {
                stroke = stroke + ";";
            }
        }
        if (this.fillColor != null) {
            fill = fill + "fill:" + StyleUtils.getHexidecimalString(this.fillColor);
            alpha = this.fillColor.getAlpha();
            if (alpha < 255) {
                fill = fill + ";fill-opacity:" + alpha;
            }
        }
        String style = stroke + fill;
        String res = "<?xml version=\"1.0\" standalone=\"yes\"?>\n";
        res = res + "<svg width=\"1in\" height=\"1in\">\n";
        res = res + "  <desc/>\n";
        res = res + "  <g class=\"color\" style=\"" + style + "\">\n";
        res = res + "    <rect width=\"50\" height=\"50\"/>\n";
        res = res + "  </g>\n";
        res = res + "</svg>";
        return res;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }
}

