/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.lbs.mapserver.core.MSBundle;
import oracle.mapviewer.share.util.LogFactory;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IPMonitor {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);
    public static boolean enabled = false;
    public static Hashtable ipAllow = new Hashtable();
    public static Hashtable ipExclude = new Hashtable();
    static Integer dummy = new Integer(0);
    static int maxLength = 15;
    static int minLength = 1;

    public static boolean allow(String ip) {
        if (!enabled) {
            return true;
        }
        if (IPMonitor.foundIP(ipExclude, ip)) {
            return false;
        }
        return IPMonitor.foundIP(ipAllow, ip);
    }

    public static void clearAll() {
        enabled = false;
        ipAllow.clear();
        ipExclude.clear();
    }

    private static boolean foundIP(Hashtable ht, String ip) {
        if (ip == null || ip.length() == 0) {
            return false;
        }
        if (ht.isEmpty()) {
            return false;
        }
        if (ht.get("*") != null) {
            return true;
        }
        if (ht.get(ip) != null) {
            return true;
        }
        try {
            int dot = ip.lastIndexOf(".");
            while (dot > 0) {
                String wildcard = ip.substring(0, ip.lastIndexOf(".")) + ".*";
                if (ht.get(wildcard) != null) {
                    return true;
                }
                ip = ip.substring(0, dot);
                dot = ip.lastIndexOf(".");
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.getMessage(), e);
        }
        return false;
    }

    private static void putIP(String ip, Hashtable ht) {
        ht.put(ip, dummy);
    }

    private static void putIPs(String ips, Hashtable ht) {
        StringTokenizer st = new StringTokenizer(ips, ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            String ip = st.nextToken();
            if (!IPMonitor.validateIP(ip)) continue;
            ht.put(ip, dummy);
        }
    }

    private static void putIPRange(String ipr, Hashtable ht) {
        int end;
        int start;
        StringTokenizer st = new StringTokenizer(ipr, " -\t\n\r\f");
        int count = 0;
        String ip1 = null;
        String ip2 = null;
        while (st.hasMoreTokens()) {
            if (count == 0) {
                ip1 = st.nextToken();
            } else if (count == 1) {
                ip2 = st.nextToken();
            }
            ++count;
        }
        System.out.println("ip1=" + ip1 + ", ip2=" + ip2);
        if (!IPMonitor.validateIP(ip1) || !IPMonitor.validateIP(ip2)) {
            log.severe(MSBundle.getMsg((String)"MAPVIEWER-00068"));
            return;
        }
        try {
            start = Integer.parseInt(ip1.substring(ip1.lastIndexOf(".") + 1, ip1.length()));
            end = Integer.parseInt(ip2.substring(ip2.lastIndexOf(".") + 1, ip2.length()));
        }
        catch (Exception e) {
            log.severe(MSBundle.getMsg((String)"MAPVIEWER-00069"));
            return;
        }
        if (start > end) {
            log.severe(MSBundle.getMsg((String)"MAPVIEWER-00070"));
            return;
        }
        String prefix = ip1.substring(0, ip1.lastIndexOf(".") + 1);
        for (int i = start; i <= end; ++i) {
            String ip = prefix + i;
            ht.put(ip, dummy);
        }
    }

    public static void loadFromConfig(XMLDocument doc) throws XSLException {
        enabled = false;
        IPMonitor.clearAll();
        NodeList nl = doc.getElementsByTagName("ip_monitor");
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        XMLElement e = (XMLElement)nl.item(0);
        if (e == null) {
            return;
        }
        String value = null;
        nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            String name = n.getNodeName().toLowerCase();
            value = n.getFirstChild().getNodeValue();
            System.out.println("value=" + value);
            if (name.equals("ips")) {
                IPMonitor.putIPs(value, ipAllow);
                continue;
            }
            if (name.equals("ip_range")) {
                IPMonitor.putIPRange(value, ipAllow);
                continue;
            }
            if (name.equals("ips_exclude")) {
                IPMonitor.putIPs(value, ipExclude);
                continue;
            }
            if (!name.equals("ip_range_exclude")) continue;
            IPMonitor.putIPRange(value, ipExclude);
        }
        if (!ipAllow.isEmpty() || !ipExclude.isEmpty()) {
            enabled = true;
        }
    }

    private static boolean validateIP(String ip) {
        if (ip == null || ip.length() < minLength || ip.length() > maxLength) {
            return false;
        }
        int si = ip.lastIndexOf("*");
        if (si > 0 && si != ip.length() - 1) {
            return false;
        }
        for (int i = 0; i < ip.length(); ++i) {
            char c = ip.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '*') continue;
            return false;
        }
        return true;
    }

    public static String print() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("\nAllowed IPs:\n");
        Enumeration e = ipAllow.keys();
        while (e.hasMoreElements()) {
            sb.append("+ " + e.nextElement() + "\n");
        }
        sb.append("Excluded IPs:\n");
        e = ipExclude.keys();
        while (e.hasMoreElements()) {
            sb.append("- " + e.nextElement() + "\n");
        }
        return sb.toString();
    }
}

