/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapcommon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.mapviewer.share.MapFormats;
import oracle.sdovis.LiveFeature;

public class MapResponse
implements Serializable,
MapFormats {
    static final long serialVersionUID = -3854084457594740563L;
    protected Object imageData = null;
    protected String utfGridPack = null;
    protected Throwable exception = null;
    protected AffineTransform transform = null;
    protected double rotation = 0.0;
    protected double[] mbr = null;
    protected String status = "SUCCESS";
    protected Dimension deviceSize = null;
    protected double currentScale = 0.0;
    protected String[] themeNames = null;
    protected int imageFormat = 9;
    protected int imageSize = 0;
    protected LiveFeature[] liveFeatures = new LiveFeature[0];
    protected double[] proj;
    protected int srid = 0;
    private static Component sComponent = null;
    private static MediaTracker sTracker = null;
    private static int sID = 0;

    public void setStatus(String msg) {
        this.status = msg;
    }

    public String getStatus() {
        return this.status;
    }

    public void setAffineTransform(AffineTransform at) {
        this.transform = at;
    }

    public AffineTransform getAffineTransform() {
        return this.transform;
    }

    public void setMapProjectionParams(double[] ps) {
        this.proj = ps;
    }

    public double[] getMapProjectionParams() {
        return this.proj;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable ex) {
        this.exception = ex;
    }

    public double[] getMBR() {
        return this.mbr;
    }

    public Dimension getDeviceSize() {
        return this.deviceSize;
    }

    public void setDeviceSize(Dimension d) {
        this.deviceSize = d;
    }

    public double getCurrentScale() {
        return this.currentScale;
    }

    public void setCurrentScale(double cs) {
        this.currentScale = cs;
    }

    public String[] getThemeNames() {
        return this.themeNames;
    }

    public void setThemeNames(String[] tns) {
        this.themeNames = tns;
    }

    public double[] getMbr() {
        return this.mbr;
    }

    public void setMbr(double[] m) {
        this.mbr = m;
    }

    public LiveFeature[] getLiveFeatures() {
        return this.liveFeatures;
    }

    public void setLiveFeatures(LiveFeature[] lf) {
        this.liveFeatures = lf;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(int t) {
        this.imageFormat = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image) {
        int id;
        if (sTracker == null) {
            sComponent = new Component(){};
            sTracker = new MediaTracker(sComponent);
        }
        Component component = sComponent;
        synchronized (component) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.err);
            return false;
        }
        return !sTracker.isErrorID(id);
    }

    public static void removeImageFromTracker(Image img) {
        if (img != null && sTracker != null) {
            sTracker.removeImage(img);
        }
    }

    public Image getImage() {
        if (this.imageData == null) {
            return null;
        }
        long t2 = System.currentTimeMillis();
        Image img = null;
        int w = (int)this.deviceSize.getWidth();
        int h = (int)this.deviceSize.getHeight();
        switch (this.imageFormat) {
            case 1: {
                img = Toolkit.getDefaultToolkit().createImage((byte[])this.imageData);
                MapResponse.waitForImage(img);
                break;
            }
            case 9: {
                try {
                    if (this.imageData != null && this.imageData instanceof byte[]) {
                        this.imageData = this.unzipIntArray((byte[])this.imageData, this.imageSize);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    return null;
                }
            }
            case 0: {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ColorModel cm = ColorModel.getRGBdefault();
                img = tk.createImage(new MemoryImageSource(w, h, cm, (int[])this.imageData, 0, w));
                break;
            }
            case 29: {
                return (Image)this.imageData;
            }
            default: {
                return null;
            }
        }
        long t3 = System.currentTimeMillis();
        return img;
    }

    public byte[] getGIFImage() {
        if (this.imageFormat != 1 && this.imageFormat != 7) {
            return null;
        }
        return (byte[])this.imageData;
    }

    public String getImageURL() {
        if (this.imageFormat != 3) {
            return null;
        }
        return (String)this.imageData;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.imageData);
        out.writeObject(this.exception);
        out.writeObject(this.transform);
        out.writeObject(this.mbr);
        out.writeObject(this.status);
        out.writeObject(this.deviceSize);
        out.writeDouble(this.currentScale);
        out.writeObject(this.themeNames);
        out.writeInt(this.imageFormat);
        out.writeInt(this.imageSize);
        out.writeInt(this.srid);
        out.writeObject(this.proj);
        out.writeObject(this.liveFeatures);
        out.writeDouble(this.rotation);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.imageData = in.readObject();
        this.exception = (Throwable)in.readObject();
        this.transform = (AffineTransform)in.readObject();
        this.mbr = (double[])in.readObject();
        this.status = (String)in.readObject();
        this.deviceSize = (Dimension)in.readObject();
        this.currentScale = in.readDouble();
        this.themeNames = (String[])in.readObject();
        this.imageFormat = in.readInt();
        this.imageSize = in.readInt();
        this.srid = in.readInt();
        this.proj = (double[])in.readObject();
        this.liveFeatures = (LiveFeature[])in.readObject();
        this.rotation = in.readDouble();
    }

    public static byte[] zipIntArray(int[] data) throws IOException {
        byte[] input = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            int n = i * 4;
            int d = data[i];
            input[n] = (byte)d;
            input[n + 1] = (byte)(d >>= 8);
            input[n + 2] = (byte)(d >>= 8);
            input[n + 3] = (byte)(d >>= 8);
        }
        long t2 = System.currentTimeMillis();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length / 2);
        ZipOutputStream zos = new ZipOutputStream(bos);
        zos.putNextEntry(new ZipEntry("image"));
        zos.write(input);
        zos.closeEntry();
        zos.close();
        byte[] res = bos.toByteArray();
        bos.close();
        long t3 = System.currentTimeMillis();
        return res;
    }

    private final int[] unzipIntArray(byte[] raw, int origSize) throws IOException {
        long t1 = System.currentTimeMillis();
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(raw));
        int read = 0;
        int count = 0;
        byte[] in = new byte[origSize];
        byte[] buf = new byte[4096];
        while (zis.getNextEntry() != null) {
            while ((read = zis.read(buf)) > 0) {
                System.arraycopy(buf, 0, in, count, read);
                count += read;
            }
        }
        zis.close();
        if (count != origSize) {
            System.err.println("**** unzip error ****");
            return null;
        }
        int[] data = new int[origSize / 4];
        long t2 = System.currentTimeMillis();
        for (int i = 0; i < origSize / 4; ++i) {
            int n = i * 4;
            int firstByte = 0xFF & in[n];
            int secondByte = 0xFF & in[n + 1];
            int thirdByte = 0xFF & in[n + 2];
            int fourthByte = 0xFF & in[n + 3];
            data[i] = (firstByte | secondByte << 8 | thirdByte << 16 | fourthByte << 24) & 0xFFFFFFFF;
        }
        return data;
    }

    public void clearImage() {
        this.imageData = null;
    }

    public void setImageData(Object img) {
        this.imageData = img;
    }

    public Object getImageData() {
        return this.imageData;
    }

    public void setImageSize(int bs) {
        this.imageSize = bs;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public void setSRID(int id) {
        this.srid = id;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setRotation(double angle) {
        this.rotation = angle;
    }

    public void setUTFGridPack(String str) {
        this.utfGridPack = str;
    }

    public String getUTFGridPack() {
        return this.utfGridPack;
    }

    public double getRotation() {
        return this.rotation;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(" MapResponse=");
        sb.append("\n  status=" + this.status);
        sb.append("\n  imageFormat=" + this.imageFormat);
        if (this.imageFormat == 3) {
            sb.append("\n  image url=" + (String)this.imageData);
        }
        sb.append("\n  transform=" + this.transform);
        sb.append("\n  rotation=" + this.rotation);
        sb.append("\n  mbr=" + this.mbr);
        sb.append("\n  currentScale=" + this.currentScale);
        sb.append("\n  deviceSize=" + this.deviceSize);
        sb.append("\n  imageSize=" + this.imageSize);
        sb.append("\n  srid=" + this.srid);
        sb.append("\n  themeNames=" + this.themeNames);
        if (this.themeNames != null) {
            for (int i = 0; i < this.themeNames.length; ++i) {
                sb.append("\n    " + this.themeNames[i]);
            }
        }
        return sb.toString();
    }

    public static String getImageFormatString(int imageFormat) {
        switch (imageFormat) {
            case 25: {
                return "PNG8_URL";
            }
            case 26: {
                return "PNG8_STREAM";
            }
            case 17: {
                return "SVGTINY_URL";
            }
            case 18: {
                return "SVGTINY_STREAM";
            }
            case 15: {
                return "SVG_URL";
            }
            case 27: {
                return "SVGZ_URL";
            }
            case 16: {
                return "SVG_STREAM";
            }
            case 13: {
                return "PNG_URL";
            }
            case 14: {
                return "PNG_STREAM";
            }
            case 1: {
                return "GIF";
            }
            case 0: {
                return "JAVA_IMAGE";
            }
            case 2: {
                return "BMP";
            }
            case 3: {
                return "GIF_URL";
            }
            case 7: {
                return "GIF_STREAM";
            }
            case 4: {
                return "BMP_URL";
            }
            case 9: {
                return "JAVA_IMAGE_COMPRESSED";
            }
            case 22: {
                return "JPEG_STREAM";
            }
            case 21: {
                return "JPEG_URL";
            }
            case 51: {
                return "PDF_URL";
            }
            case 53: {
                return "PDF_STREAM";
            }
            case 29: {
                return "BUFFERED_IMAGE";
            }
        }
        return "GIF_URL";
    }
}

