/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.DrawerWindowConfig;
import oracle.ide.editor.Editor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.palette2.res.Bundle;
import oracle.ide.view.View;
import oracle.ide.view.ViewAdapter;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewProxy;
import oracle.ideimpl.palette2.AllPages;
import oracle.ideimpl.palette2.CompositePalettePage;
import oracle.ideimpl.palette2.DeclaredPages;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteDockable;
import oracle.ideimpl.palette2.PaletteDockable2;
import oracle.ideimpl.palette2.PaletteDockableFactory;
import oracle.ideimpl.palette2.PalettePageSelectionStrategy;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.ideimpl.palette2.PreferredPage;
import oracle.ideimpl.palette2.SearchDockable;
import oracle.ideimpl.palette2.SearchThread;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.Disposable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.ProxyFactory;

public class PaletteWindowUI
extends PaletteWindow
implements SearchListener,
PalettePagesListener,
Disposable {
    private boolean useLargeIcons;
    private SearchDockable searchDockable;
    private static AtomicInteger instanceCount = new AtomicInteger();
    private JPanel windowContainer;
    private Map<String, String> pageKeysByPageName = new HashMap<String, String>();
    private JPanel _topSearchComponent;
    private SearchField _searchField;
    private SearchThread _searchThread;
    private SearchEvent _searchEvent;
    private Map<View, Collection<PaletteAugmentedItem>> _searchResultsByView;
    private final PaletteComboBoxModel pageModel = new PaletteComboBoxModel();
    private final PaletteComboBox pageComboBox = new PaletteComboBox(this.pageModel);
    private String currentPageSelection;
    private Editor _currentEditor;
    private DrawerWindow activeDrawerWindow;
    private Map<String, DrawerWindow> drawerWindowsByName = new HashMap<String, DrawerWindow>();
    private Component ui;
    private final Map<PalettePages, PalettePagesListener> pageSets = new LinkedHashMap<PalettePages, PalettePagesListener>();
    private final List<PreferredPage> preferredPages = new ArrayList<PreferredPage>();
    private boolean needsRefresh = true;
    private PalettePageSelectionStrategy pageSelectionStrategy = new PalettePageSelectionStrategy(this);
    private String savedPageName = null;

    private static ViewId newViewId() {
        String viewName = MessageFormat.format("{0}-{1}", "PALETTE", instanceCount.incrementAndGet());
        return new ViewId(PaletteWindowUI.class.getSimpleName(), viewName);
    }

    public PaletteWindowUI() {
        super(PaletteWindowUI.newViewId().toString());
        this.pageComboBox.addActionListener(PaletteControllerUI.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getGUI() {
        PaletteWindowUI paletteWindowUI = this;
        synchronized (paletteWindowUI) {
            if (null == this.ui) {
                this.ui = this.initUI();
            }
        }
        return this.ui;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idecomponentpalette_html");
    }

    public String getTabName() {
        return Bundle.get("COMPONENT_PALETTE");
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"component.png");
    }

    public String getTitleName() {
        return Bundle.get("COMPONENT_PALETTE");
    }

    @Override
    public void addPaletteListener(PaletteListener paletteListener) {
    }

    @Override
    public void removePaletteListener(PaletteListener paletteListener) {
    }

    @Override
    public void unSelectSelectedItem() {
    }

    @Override
    public PaletteItem getFocusedItem() {
        return null;
    }

    @Override
    public void setUseLargeIcons(boolean useLargeIcons) {
        if (useLargeIcons == this.useLargeIcons) {
            return;
        }
        this.useLargeIcons = useLargeIcons;
        for (PalettePages pages : this.getProviderPages()) {
            this.setUseLargeIcons(useLargeIcons, pages);
        }
        this.setUseLargeIcons(useLargeIcons, this.getPalette1ProviderPages());
    }

    private void setUseLargeIcons(boolean useLargeIcons, PalettePages pages) {
        if (null == pages) {
            return;
        }
        for (PalettePage page : pages.getPages()) {
            List<PaletteDockable2> dockables = this.getDockables(page);
            for (PaletteDockable2 dockable : dockables) {
                dockable.setUseLargeIcons(useLargeIcons);
            }
        }
    }

    private List<PaletteDockable2> getDockables(PalettePage page) {
        ArrayList<PaletteDockable2> dockables = new ArrayList<PaletteDockable2>();
        if (null == this.activeDrawerWindow) {
            return dockables;
        }
        for (PaletteGroup group : page.getGroups()) {
            Dockable dockable = DockStation.getDockStation().getDockable(this.getViewId(page, group));
            if (!(dockable instanceof PaletteDockable2)) continue;
            dockables.add((PaletteDockable2)dockable);
        }
        return dockables;
    }

    private ViewId getViewId(PalettePage page, PaletteGroup group) {
        return this.getViewId(page.getName(), group.getName());
    }

    ViewId getViewId(String pageName, String groupName) {
        StringBuilder viewName = new StringBuilder(pageName);
        if (ModelUtil.hasLength((String)groupName)) {
            viewName.append("-").append(groupName).append("-").append(this.activeDrawerWindow.getId());
        }
        return new ViewId(this.getId(), viewName.toString());
    }

    @Override
    public boolean getUseLargeIcons() {
        return this.useLargeIcons;
    }

    private Component initUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel topComp = this.createTopComponent();
        panel.add((Component)topComp, "North");
        this.windowContainer = new JPanel();
        this.windowContainer.setLayout(new CardLayout());
        panel.add((Component)this.windowContainer, "Center");
        return panel;
    }

    private DrawerWindow newDrawerWindow(String pageName) {
        DrawerWindowConfig config = new DrawerWindowConfig();
        config.icon(this.getTabIcon());
        config.tabName(PaletteArb.getString(0));
        config.titleName(Bundle.get("COMPONENT_PALETTE"));
        config.type(this.getType());
        PaletteDrawerWindow drawerWindow = new PaletteDrawerWindow(pageName, (View)this, config);
        drawerWindow.hideHandleIfOnlyOneDrawerShown();
        return drawerWindow;
    }

    private JPanel createTopComponent() {
        if (this._topSearchComponent == null) {
            VerticalFlowLayout layout = new VerticalFlowLayout(3, 0, 0, true, true);
            this._topSearchComponent = new JPanel((LayoutManager)layout);
            this._topSearchComponent.add((Component)this.searchToolbar());
            this._topSearchComponent.add((Component)this.pagePickerToolbar());
        }
        this.setSearchThread(null);
        return this._topSearchComponent;
    }

    private Toolbar searchToolbar() {
        Toolbar toolbar = new Toolbar();
        JPanel panelSearch = new JPanel(new BorderLayout());
        this._searchField = new SearchField();
        this._searchField.setStyle(SearchField.Style.SEARCH);
        this._searchField.setAllowEmptySearch(true);
        this._searchField.addSearchListener((SearchListener)ProxyFactory.newWeakProxy(SearchListener.class, (Object)this));
        panelSearch.add((Component)this._searchField, "Center");
        toolbar.add((Component)panelSearch);
        return toolbar;
    }

    private Toolbar pagePickerToolbar() {
        Toolbar toolbar = new Toolbar();
        toolbar.forcePrimaryViewToolbar(true);
        toolbar.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 4));
        toolbar.add((Component)this.pageComboBox);
        return toolbar;
    }

    void setSearchThread(SearchThread searchThread) {
        boolean isSearching = searchThread != null;
        this._searchField.setEnabled(!isSearching);
        this._searchThread = searchThread;
        if (!isSearching) {
            if (this._searchEvent != null) {
                this._searchEvent.getSearchProgress().finish();
                this._searchEvent = null;
            }
            this._searchField.requestFocus();
        }
    }

    public void doSearch() {
        if (this._searchEvent == null) {
            return;
        }
        String searchPredicate = this._searchEvent.getSearchText();
        this._searchField.getTextField().selectAll();
        SearchThread searchThread = new SearchThread(this, searchPredicate);
        this.runSearch(searchThread);
    }

    private void runSearch(SearchThread searchThread) {
        this.setSearchThread(searchThread);
        try {
            searchThread.setPriority(Thread.currentThread().getPriority() - 1);
            searchThread.start();
        }
        catch (RuntimeException e) {
            this.setSearchThread(null);
            throw e;
        }
    }

    public void searchPerformed(SearchEvent se) {
        if (se.isFromClear() && this._searchThread != null && this._searchThread.isAlive()) {
            this.stopSearch();
            this._searchEvent = null;
        } else {
            this._searchEvent = se;
            this.doSearch();
        }
    }

    public void searchCategoryChanged(SearchEvent se) {
    }

    public void stopSearch() {
        this._searchThread.abortSearch();
    }

    public boolean isSearchCancelled() {
        if (this._searchEvent == null) {
            return true;
        }
        return this._searchEvent.getSearchProgress().isStopped();
    }

    public void setSearchProgress(int progress, int total) {
    }

    void showSearchResults(final Collection<PaletteAugmentedItem> results) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteWindowUI.this.showSearchResults(results);
                }
            });
            return;
        }
        this.cacheSearchResults(results, (View)this._currentEditor);
        this.removeSearchResults();
        if (results != null) {
            SearchDockable searchDockable = this.getSearchDockable();
            searchDockable.showSearchResults(results);
        }
    }

    void removeSearchResults() {
        SearchDockable searchDockable = this.getSearchDockable();
        if (searchDockable == null) {
            return;
        }
        this.collapse((View)searchDockable);
        this.removeDrawer((Dockable)searchDockable);
    }

    private SearchDockable getSearchDockable() {
        if (null == this.searchDockable) {
            this.searchDockable = new SearchDockable(this);
        }
        return this.searchDockable;
    }

    private void cacheSearchResults(Collection<PaletteAugmentedItem> results, View view) {
        if (view == null) {
            return;
        }
        if (this._searchResultsByView == null) {
            this._searchResultsByView = new HashMap<View, Collection<PaletteAugmentedItem>>();
        }
        if (results == null) {
            this._searchResultsByView.remove(view);
            return;
        }
        boolean needListener = !this._searchResultsByView.containsKey(view);
        this._searchResultsByView.put(view, results);
        if (needListener) {
            view.addViewListener((ViewListener)new ViewAdapter(){

                public void viewClosed(ViewEvent e) {
                    View view = e.getView();
                    PaletteWindowUI.this._searchResultsByView.remove(view);
                    e.getView().removeViewListener((ViewListener)this);
                }
            });
        }
    }

    void expand(View view) {
        if (null != this.activeDrawerWindow) {
            this.activeDrawerWindow.togglePanelsWithAnimation(Collections.singletonList(view), null);
        }
    }

    void collapse(View view) {
        if (null != this.activeDrawerWindow) {
            this.activeDrawerWindow.togglePanelsWithAnimation(null, Collections.singletonList(view));
        }
    }

    void removeDrawer(Dockable w) {
        if (w != null && null != this.activeDrawerWindow) {
            this.activeDrawerWindow.removeIfPresent((View)w);
        }
    }

    public String getSelectedPageName() {
        return this.pageComboBox.getSelectedString();
    }

    public PalettePage getSelectedPage() {
        return this.getPageFromProviderList(this.getSelectedPageName());
    }

    private PalettePage getPageFromProviderList(String name) {
        ArrayList<PalettePage> list = new ArrayList<PalettePage>();
        if (name != null) {
            if (name.equals(PaletteArb.getString(57))) {
                Collection<PalettePage> palettePages = AllPages.getInstance().getPages();
                Iterator<PalettePage> i = palettePages.iterator();
                if (i.hasNext()) {
                    list.add(i.next());
                }
            } else {
                for (PalettePages pageSet : this.getProviderPages()) {
                    for (PalettePage page : pageSet.getPages()) {
                        if (!page.getName().equals(name)) continue;
                        list.add(page);
                    }
                }
            }
        }
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (PalettePage)list.get(0);
            }
        }
        return new CompositePalettePage(list.toArray(new PalettePage[list.size()]));
    }

    String firstPage() {
        String page = this.pageComboBox.getItemAt(0).toString();
        if (page.equals(PaletteArb.getString(57))) {
            return this.pageComboBox.getItemAt(1).toString();
        }
        return page;
    }

    @Override
    public ContextMenu getContextMenu() {
        return PaletteControllerUI.getInstance().getContextMenu();
    }

    void showPage(String pageName) {
        String pageKey;
        DrawerWindow namedWindow;
        this.getGUI();
        if (ModelUtil.areDifferent((Object)this.currentPageSelection, (Object)pageName)) {
            this.currentPageSelection = pageName;
        }
        View editor = ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).getEditor();
        PalettePage page = this.getPageFromProviderList(pageName);
        if (null == page || null == editor) {
            this.pageModel.removeElement(pageName);
            this.drawerWindowsByName.remove(pageName);
            return;
        }
        if (this._topSearchComponent != null) {
            this._topSearchComponent.setVisible(true);
        }
        if (null == (namedWindow = this.drawerWindowsByName.get(pageKey = this.getPageKey(page)))) {
            namedWindow = this.newDrawerWindow(UUID.randomUUID().toString());
            this.drawerWindowsByName.put(pageKey, namedWindow);
            this.activeDrawerWindow = namedWindow;
            this.showGroups(page, editor);
            this.windowContainer.add(namedWindow.getGUI(), pageKey);
        }
        ((CardLayout)this.windowContainer.getLayout()).show(this.windowContainer, pageKey);
    }

    private String getPageKey(PalettePage page) {
        String pageKey = this.pageKeysByPageName.get(page.getName());
        if (null == pageKey) {
            pageKey = this.generatePageKey(page);
            this.pageKeysByPageName.put(page.getName(), pageKey);
        }
        return pageKey;
    }

    private void showGroups(PalettePage page, View editor) {
        editor = ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).getEditor();
        if (null == editor || null == this.activeDrawerWindow) {
            return;
        }
        Context context = editor.getContext();
        String pageName = page.getName();
        Collection<PaletteGroup> groups = page.getGroups();
        for (PaletteGroup group : groups) {
            String viewName = pageName;
            ViewId viewId = this.getViewId(page, group);
            Dockable dockable = DockStation.getDockStation().getDockable(viewId);
            if (dockable == null) {
                dockable = PaletteDockableFactory.getInstance().getDockable(viewId);
                if (dockable instanceof PaletteDockable) {
                    ((PaletteDockable)dockable).setData(group);
                    if (groups.size() == 1) {
                        this.addDrawerThatCanHideHandle(dockable);
                    } else if (!group.isVisible(context)) {
                        DrawerConfig config = new DrawerConfig(group.getName(), DrawerConfig.State.HIDDEN);
                        this.addDrawer(dockable, config);
                    } else {
                        this.addDrawer(dockable);
                        if (null != this.activeDrawerWindow) {
                            if (this.isShowForGroupType(group, editor)) {
                                this.activeDrawerWindow.expand((View)((DockableWindow)dockable));
                            } else {
                                List<View> collapseList = Collections.singletonList((View)dockable);
                                this.activeDrawerWindow.togglePanelsWithoutAnimation(null, collapseList);
                            }
                        }
                    }
                } else {
                    viewName = viewName != null && viewName.length() > 0 ? viewName : "null";
                    FeedbackManager.addFeedback((String)("WARNING: Could not determine palette page named: " + viewName));
                }
                if (!(dockable instanceof PaletteDockable2)) continue;
                ((PaletteDockable2)dockable).setUseLargeIcons(this.getUseLargeIcons());
                continue;
            }
            if (dockable instanceof PaletteDockable) {
                ((PaletteDockable)dockable).setData(group);
            }
            if (!(dockable instanceof DockableWindow)) continue;
            View view = this.undecorateIfNecessary((DockableWindow)dockable);
            if (null == this.activeDrawerWindow) continue;
            if (group.isVisible(context)) {
                this.activeDrawerWindow.show(view);
                continue;
            }
            this.activeDrawerWindow.hide(view);
        }
        this.repaintGUI();
        this.updateDrawerHandlesVisibility();
    }

    private void repaintGUI() {
        if (this.getGUI() != null) {
            this.getGUI().repaint();
        }
    }

    private boolean isShowForGroupType(PaletteGroup paletteGroup, View editor) {
        List showForTypes;
        if (null == editor) {
            if (null == this._currentEditor) {
                return false;
            }
            editor = this._currentEditor;
        }
        if (null == (showForTypes = (List)paletteGroup.getData("showForTypes"))) {
            return false;
        }
        Context context = editor.getContext();
        if (null == context) {
            return false;
        }
        Node node = context.getNode();
        if (null == node) {
            return false;
        }
        String fileType = DeclaredPages.getSuffix(node.getURL());
        if (null == fileType) {
            return false;
        }
        for (String type : showForTypes) {
            if (!DeclaredPages.isCorrectNode(fileType, type)) continue;
            return true;
        }
        return false;
    }

    View undecorateIfNecessary(DockableWindow dockable) {
        View undecorated = null != this.activeDrawerWindow ? this.activeDrawerWindow.undecorateIfNecessary(dockable) : null;
        return null != undecorated ? undecorated : dockable;
    }

    private void addDrawer(Dockable w) {
        this.addDrawer(w, null);
    }

    private void addDrawer(Dockable w, DrawerConfig config) {
        if (null == this.activeDrawerWindow || !(w instanceof DockableWindow)) {
            return;
        }
        if (null == config) {
            this.activeDrawerWindow.addDrawer((DockableWindow)w);
        } else {
            this.activeDrawerWindow.addDrawer((View)((DockableWindow)w), config);
        }
    }

    private void addDrawerThatCanHideHandle(Dockable w) {
        DockableWindow dw = (DockableWindow)w;
        if (null != this.activeDrawerWindow) {
            this.activeDrawerWindow.addDrawerThatCanHideHandle(dw);
            this.activeDrawerWindow.expand((View)dw);
        }
    }

    void updateDrawerHandlesVisibility() {
        if (null != this.activeDrawerWindow) {
            this.activeDrawerWindow.updateDrawerHandlesVisibility();
        }
    }

    void addCloseableDrawer(DockableWindow view, int index) {
        if (null != this.activeDrawerWindow) {
            this.activeDrawerWindow.addCloseableDrawer(view, index);
        }
    }

    boolean setPageSets(List<PalettePages> pageSets) {
        String pageToShow;
        for (PalettePages pageSet : pageSets) {
            for (String pageName : this.addPageSet(pageSet)) {
                this.pageModel.addElement(pageName);
            }
        }
        if (this.pageModel.getSize() > 0 && null != (pageToShow = this.pageSelectionStrategy.getPage())) {
            this.pageComboBox.setSelectedItem(pageToShow);
        }
        return true;
    }

    private synchronized List<String> addPageSet(PalettePages pageSet) {
        PalettePagesListener listener = (PalettePagesListener)ProxyFactory.newWeakProxy(PalettePagesListener.class, (Object)this);
        pageSet.addPalettePagesListener(listener);
        this.pageSets.put(pageSet, listener);
        Collection<PalettePage> pages = pageSet.getPages();
        if (null == pages) {
            return Collections.emptyList();
        }
        PalettePage preferredPage = pageSet.getPreferredPage();
        if (preferredPage != null) {
            this.preferredPages.add(new PreferredPage(preferredPage, pageSet.getPreferredPageRank()));
        }
        ArrayList<String> pageNames = new ArrayList<String>();
        for (PalettePage page : pages) {
            String name = page.getName();
            if (pageNames.contains(name)) continue;
            pageNames.add(name);
        }
        return pageNames;
    }

    String getSavedPageName() {
        return this.savedPageName;
    }

    String getAndClearSavedPageName() {
        try {
            String string = this.savedPageName;
            return string;
        }
        finally {
            this.savedPageName = null;
        }
    }

    public PalettePages getPalette1ProviderPages() {
        for (PalettePages provPages : this.getProviderPages()) {
            if (!(provPages instanceof Palette1Provider)) continue;
            return provPages;
        }
        return null;
    }

    public synchronized List<PalettePages> getProviderPages() {
        return new ArrayList<PalettePages>(this.pageSets.keySet());
    }

    @Override
    public void palettePagesChanged(final Set<PalettePage> addedPages, final Set<PalettePage> removedPages, final Set<PalettePage> updatedPages) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteWindowUI.this.palettePagesChanged(addedPages, removedPages, updatedPages);
                }
            });
            return;
        }
        this.updatePageList(addedPages, removedPages);
        if (null != updatedPages) {
            this.pageKeysByPageName.clear();
            String currentPage = this.currentPageSelection;
            for (PalettePage palettePage : updatedPages) {
                if (!palettePage.getName().equals(currentPage)) continue;
                this.showPage(currentPage);
                break;
            }
        }
    }

    private void updatePageList(Set<PalettePage> addedPages, Set<PalettePage> removedPages) {
        if (null != addedPages && !addedPages.isEmpty()) {
            for (PalettePage page : addedPages) {
                this.pageModel.addElement(page.getName());
            }
        }
        if (null != removedPages && !removedPages.isEmpty()) {
            for (PalettePage page : removedPages) {
                this.pageModel.removeElement(page.getName());
            }
        }
    }

    List<String> getPageList() {
        return Collections.unmodifiableList(this.pageModel.elements);
    }

    List<PreferredPage> getPreferredPages() {
        return Collections.unmodifiableList(this.preferredPages);
    }

    void needsToBeRefreshed(boolean b) {
        this.needsRefresh = b;
    }

    boolean needsToBeRefreshed() {
        return this.needsRefresh;
    }

    PalettePageSelectionStrategy getPageSelectionStrategy() {
        return this.pageSelectionStrategy;
    }

    void hide(View view) {
        if (null != this.activeDrawerWindow) {
            this.activeDrawerWindow.hide(view);
        }
    }

    public Controller getController() {
        if (null != this.activeDrawerWindow) {
            return this.activeDrawerWindow.getController();
        }
        return PaletteControllerUI.getInstance();
    }

    static boolean palettePageIsEmpty(PalettePage palettePage) {
        if (null == palettePage) {
            return true;
        }
        Collection<PaletteGroup> groups = palettePage.getGroups();
        if (null == groups || groups.isEmpty()) {
            return true;
        }
        for (PaletteGroup group : groups) {
            Collection<PaletteSection> sections = group.getSections();
            if (null == sections || sections.isEmpty()) {
                return true;
            }
            for (PaletteSection section : sections) {
                Collection<PaletteItem> items = section.getItems();
                if (null != items && !items.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    PaletteItem getItem(String providerId, String itemId) {
        PalettePages provPages;
        PaletteItem pItem = null;
        Iterator<PalettePages> iterator = this.getProviderPages().iterator();
        while (iterator.hasNext() && (pItem = (provPages = iterator.next()).getItem(providerId, itemId)) == null) {
        }
        return pItem;
    }

    void setSavedPageName(String pageName) {
        this.savedPageName = pageName;
    }

    public void dispose() {
        this.stopListeningForPalettePagesChanges();
        this.disposeUI();
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        switch (newState) {
            case 1: {
                this.listenForPalettePagesChanges();
                break;
            }
            case 2: 
            case 3: {
                this.stopListeningForPalettePagesChanges();
            }
        }
    }

    private void listenForPalettePagesChanges() {
        for (Map.Entry<PalettePages, PalettePagesListener> entry : this.pageSets.entrySet()) {
            entry.getKey().addPalettePagesListener(entry.getValue());
        }
    }

    private void stopListeningForPalettePagesChanges() {
        for (Map.Entry<PalettePages, PalettePagesListener> entry : this.pageSets.entrySet()) {
            PalettePages pageSet = entry.getKey();
            PalettePagesListener listener = entry.getValue();
            pageSet.removePalettePagesListener(listener);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    private void disposeUI() {
        for (DrawerWindow window : this.drawerWindowsByName.values()) {
            for (View view : window.drawerViews()) {
                window.removeIfPresent(view);
                Component gui = view.getGUI();
                if (!(gui instanceof Disposable)) continue;
                ((Disposable)gui).dispose();
            }
        }
        this.activeDrawerWindow = null;
        this.drawerWindowsByName.clear();
    }

    private String generatePageKey(PalettePage page) {
        StringBuilder key = new StringBuilder(page.getClass().getSimpleName()).append(" - ").append(page.getName()).append(":\n");
        boolean nextGroup = false;
        for (PaletteGroup group : page.getGroups()) {
            if (nextGroup) {
                key.append(",\n");
            }
            key.append("\t").append(group.getClass().getSimpleName()).append(" - ").append(group.getName()).append(":\n");
            nextGroup = true;
            boolean nextSection = false;
            for (PaletteSection section : group.getSections()) {
                if (nextSection) {
                    key.append(",\n");
                }
                key.append("\t\t").append(section.getClass().getSimpleName()).append(" - ").append(section.getName()).append(":\n");
                nextSection = true;
                boolean nextItem = false;
                for (PaletteItem item : section.getItems()) {
                    if (nextItem) {
                        key.append(",\n");
                    }
                    key.append("\t\t\t").append(item.getClass().getSimpleName()).append(" - ").append(item.getName());
                    nextItem = true;
                }
            }
        }
        return key.toString();
    }

    private static class PaletteDrawerWindow
    extends DrawerWindow
    implements ActionListener {
        public PaletteDrawerWindow(String viewId, View view, DrawerWindowConfig config) {
            super(viewId, (View)ViewProxy.newSoftProxy((View)view), config);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != this.getGUI()) {
                this.getGUI().repaint();
            }
        }
    }

    private static class PaletteComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel,
    Comparator<String> {
        private static final String ALL_PAGES = PaletteArb.getString(57);
        private static final String MY_COMPONENTS = PaletteArb.getString(5);
        private static final long serialVersionUID = 1L;
        private List<String> elements = new ArrayList<String>();
        private String selected;

        private PaletteComboBoxModel() {
        }

        public void addElement(final Object obj) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.addElement(obj);
                    }
                });
                return;
            }
            if (null == obj) {
                return;
            }
            String val = String.valueOf(obj);
            if (!this.elements.contains(val)) {
                this.elements.add(val);
            }
            if (this.elements.size() > 1 && !this.elements.contains(ALL_PAGES)) {
                this.elements.add(0, ALL_PAGES);
            }
            Collections.sort(this.elements, this);
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public void removeElement(final Object obj) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.removeElement(obj);
                    }
                });
                return;
            }
            if (null == obj || !this.elements.contains(obj)) {
                return;
            }
            this.elements.remove(obj);
            if (this.elements.contains(ALL_PAGES) && this.elements.size() - 1 <= 1) {
                this.elements.remove(ALL_PAGES);
            }
            if (obj == this.selected) {
                this.setSelectedItem(this.getFirst());
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public void insertElementAt(Object obj, int index) {
        }

        @Override
        public synchronized void removeElementAt(int index) {
            if (0 <= index && index < this.elements.size()) {
                this.removeElement(this.elements.get(index));
            }
        }

        @Override
        public synchronized void setSelectedItem(Object anItem) {
            if (null != anItem && !this.elements.contains(anItem)) {
                return;
            }
            if (ModelUtil.areDifferent((Object)this.selected, (Object)anItem)) {
                this.selected = null != anItem ? String.valueOf(anItem) : null;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public synchronized Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public synchronized int getSize() {
            return this.elements.size();
        }

        @Override
        public synchronized Object getElementAt(int index) {
            return this.elements.get(index);
        }

        @Override
        public int compare(String o1, String o2) {
            if (ALL_PAGES.equals(o1)) {
                return -1;
            }
            if (ALL_PAGES.equals(o2)) {
                return 1;
            }
            if (MY_COMPONENTS.equals(o1)) {
                return 1;
            }
            if (MY_COMPONENTS.equals(o2)) {
                return -1;
            }
            return o1.compareTo(o2);
        }

        private synchronized Object getFirst() {
            for (String str : this.elements) {
                if (ALL_PAGES.equals(str)) continue;
                return str;
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        }

        @Override
        protected void fireContentsChanged(final Object source, final int index0, final int index1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteComboBoxModel.super.fireContentsChanged(source, index0, index1);
                }
            });
        }
    }

    private static class PaletteComboBox
    extends JComboBox {
        private static final String DFT_NAME = "ComponentPaletteComboBox";
        private static final long serialVersionUID = 1L;
        String lastSelection;

        public PaletteComboBox(PaletteComboBoxModel model) {
            super(model);
            this.setName(DFT_NAME);
            this.setMaximumRowCount(30);
            AdapterManager.Factory.getAdapterManager().adapt((Object)this, JComboBox.class);
        }

        public String getSelectedString() {
            return (String)this.getSelectedItem();
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        }
    }
}

