/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ide.editor.Editor;
import oracle.ide.view.View;
import oracle.ideimpl.palette2.PalettePageKey;
import oracle.ideimpl.palette2.PaletteWindowUI;
import oracle.ideimpl.palette2.PreferredPage;

class PalettePageSelectionStrategy {
    private PaletteWindowUI palette;
    private ConcurrentHashMap<PalettePageKey, String> pagesByKey = new ConcurrentHashMap();

    public PalettePageSelectionStrategy(PaletteWindowUI palette) {
        this.palette = palette;
    }

    public String getPage(View view) {
        PalettePageKey key = new PalettePageKey(view);
        String pageToShow = this.pagesByKey.get(key);
        if (!this.palette.getPageList().contains(pageToShow)) {
            pageToShow = this.getPage();
        }
        return pageToShow;
    }

    public String getPage() {
        List<String> pageList = this.palette.getPageList();
        String pageToShow = this.palette.getAndClearSavedPageName();
        if (null != pageToShow && pageList.contains(pageToShow)) {
            return pageToShow;
        }
        List<PreferredPage> preferredPages = this.palette.getPreferredPages();
        if (!preferredPages.isEmpty()) {
            String preferredPageName = null;
            float preferredPageRank = -1.0f;
            for (PreferredPage preferredPage : preferredPages) {
                String name;
                if (preferredPage.rank <= preferredPageRank || !pageList.contains(name = preferredPage.page.getName())) continue;
                preferredPageRank = preferredPage.rank;
                preferredPageName = name;
            }
            return preferredPageName;
        }
        pageToShow = this.palette.getSelectedPageName();
        if (null != pageToShow && pageList.contains(pageToShow)) {
            return pageToShow;
        }
        return this.palette.firstPage();
    }

    public void setLRUPage(View view, String page) {
        if (null == view) {
            return;
        }
        PalettePageKey key = new PalettePageKey(view);
        if (null != page) {
            this.pagesByKey.put(key, page);
        } else {
            this.remove(view);
        }
    }

    private void remove(View view) {
        if (view instanceof Editor) {
            this.removeById(((Editor)view).getTitleLabel());
        } else {
            this.removeById(view.getId());
        }
    }

    private void removeById(String id) {
        Iterator iter = ((ConcurrentHashMap.KeySetView)this.pagesByKey.keySet()).iterator();
        while (iter.hasNext()) {
            PalettePageKey key = (PalettePageKey)iter.next();
            if (!key.getTitle().equals(id)) continue;
            iter.remove();
        }
    }
}

