/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.LayerUI;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.ColorProvider;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.palette2.layouts.PaletteLayout;
import oracle.ide.palette2.layouts.PaletteLayoutDescriptor;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.util.Disposable;
import oracle.javatools.util.ModelUtil;

public class PaletteGroupUI
extends JPanel
implements MouseListener,
KeyListener,
Disposable {
    private transient PaletteGroup paletteGroup = null;
    private CenterPanel contentPanel = new CenterPanel();
    private JScrollPane scrollPane = null;
    private String showState = null;
    private TextLayer<JScrollPane> textLayer;
    private transient List<PaletteSectionUI> sectionUIs = new ArrayList<PaletteSectionUI>();
    private boolean _tryPopupInMousePressed = false;
    private transient PaletteControllerUI paletteController = PaletteControllerUI.getInstance();
    int cellHeight = 0;

    public PaletteGroupUI(String showState) {
        this.setContentPanelLayout(showState);
        this.contentPanel.addMouseListener(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.contentPanel, 20, 30);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        InputMap map = this.scrollPane.getInputMap(1);
        map.put(KeyStroke.getKeyStroke(38, 0), "none");
        map.put(KeyStroke.getKeyStroke(40, 0), "none");
        map.put(KeyStroke.getKeyStroke(37, 0), "none");
        map.put(KeyStroke.getKeyStroke(39, 0), "none");
        this.scrollPane.getViewport().addChangeListener(new ChangeListener(){
            private Dimension lastSize = new Dimension(0, 0);

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = (JViewport)e.getSource();
                Dimension size = viewport.getExtentSize();
                if (!size.equals(this.lastSize)) {
                    return;
                }
                this.lastSize = size;
                PaletteGroupUI.this.contentPanel.validate();
                PaletteGroupUI.this.contentPanel.repaint();
            }
        });
        this.textLayer = new TextLayer(PaletteArb.getString(52));
        this.textLayer.setTextVisible(false);
        JLayer<JScrollPane> scrollLayer = new JLayer<JScrollPane>(this.scrollPane, (LayerUI<JScrollPane>)this.textLayer);
        this.add(scrollLayer, "Center");
        this.addKeyListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int singleItemHeight = PaletteGroupUI.this.getSingleItemHeight();
                int itemsDisplayed = (int)Math.ceil(1.0 * (double)PaletteGroupUI.this.scrollPane.getHeight() / (double)singleItemHeight);
                int blockIncrement = (itemsDisplayed - 1) * singleItemHeight;
                PaletteGroupUI.this.scrollPane.getVerticalScrollBar().setBlockIncrement(blockIncrement);
            }
        });
    }

    public Component getGUI() {
        return this.scrollPane;
    }

    protected void initialize() {
        PaletteGroup group = this.getPaletteGroup();
        if (null == group) {
            return;
        }
        this.textLayer.setText(this.getMessageText(group));
        this.sectionUIs.clear();
        if (!ModelUtil.hasLength((String)this.showState)) {
            String groupLayout = group.getLayout();
            this.setContentPanelLayout(groupLayout);
        }
        if (this.isGroupEmpty(group)) {
            this.textLayer.setTextVisible(true);
        } else {
            this.textLayer.setTextVisible(false);
            PaletteWindow window = PaletteManager.getPaletteManager().getPaletteWindow();
            boolean useLargeIcons = null != window ? window.getUseLargeIcons() : true;
            Collection<PaletteSection> sections = group.getSections();
            for (PaletteSection section : sections) {
                PaletteSectionUI sectionUI = this.newSectionUi(section, this.contentPanel, this.showState);
                sectionUI.setUseLargeIcons(useLargeIcons);
                this.sectionUIs.add(sectionUI);
            }
        }
    }

    protected CenterPanel getContentPanel() {
        return this.contentPanel;
    }

    protected PaletteSectionUI newSectionUi(PaletteSection section, CenterPanel parent, String showState) {
        return new PaletteSectionUI(parent, showState, section, this);
    }

    public void setData(PaletteGroup paletteGroup) {
        this.contentPanel.removeAll();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        this.paletteGroup = paletteGroup;
        this.initialize();
    }

    public PaletteGroup getPaletteGroup() {
        return this.paletteGroup;
    }

    public void toggleView(String newViewState) {
        if (newViewState.equals(this.showState)) {
            return;
        }
        this.setContentPanelLayout(newViewState);
        for (PaletteSectionUI sectUI : this.sectionUIs) {
            sectUI.setShowState(newViewState);
        }
    }

    public List<PaletteItemUI> getAllPaletteItemUIs() {
        ArrayList<PaletteItemUI> paletteItems = new ArrayList<PaletteItemUI>();
        for (PaletteSectionUI nextSectionUI : this.sectionUIs) {
            paletteItems.addAll(nextSectionUI.getPaletteItems());
        }
        return paletteItems;
    }

    public List<PaletteSectionUI> getAllPaletteSectionUIs() {
        return Collections.unmodifiableList(this.sectionUIs);
    }

    private int getSingleItemHeight() {
        List<PaletteItemUI> allItems = this.getAllPaletteItemUIs();
        if (allItems.size() == 0) {
            return 20;
        }
        if (this.cellHeight == 0) {
            this.cellHeight = allItems.get(0).getHeight();
        }
        return this.cellHeight;
    }

    private void setContentPanelLayout(String layout) {
        if (!ModelUtil.hasLength((String)layout)) {
            return;
        }
        this.showState = layout;
        this.contentPanel.setView(layout);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (PaletteSectionUI section : this.sectionUIs) {
            section.showAsUnselected();
        }
        this.requestFocusInWindow();
        this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
        this.paletteController.setSelectedWindowUI(this);
        boolean bl = this._tryPopupInMousePressed = e.isPopupTrigger();
        if (this._tryPopupInMousePressed) {
            this.paletteController.unSelectSelectedItem(true);
            this.tryPopup(e);
        }
    }

    private void tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.paletteController.tryPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._tryPopupInMousePressed && !e.isPopupTrigger() && e.getButton() != 2) {
            this.paletteController.setSelectedWindowUI(this);
        }
        this.tryPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 27: {
                this.handleEscapeKey();
                e.consume();
                break;
            }
            case 10: {
                this.handleEnterKey();
                e.consume();
            }
        }
    }

    private void handleEscapeKey() {
        PalettePages palette1Pages;
        PaletteItem paletteItem;
        if (this.paletteController.getStickyMode()) {
            this.paletteController.setStickyMode(false);
        }
        if ((paletteItem = this.paletteController.getSelectedItem()) != null && paletteItem.getProviderId().equalsIgnoreCase(PaletteArb.getString(2)) && (palette1Pages = ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).getPalette1ProviderPages()) != null) {
            Palette1Provider prov = (Palette1Provider)((Object)palette1Pages);
            prov.escapeKeyPressed(paletteItem);
        }
        this.paletteController.unSelectSelectedItem(true);
        this.contentPanel.removeAll();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        this.initialize();
    }

    private void handleEnterKey() {
        PaletteSectionUI section;
        PaletteItemUI item = null;
        Iterator<PaletteSectionUI> iterator = this.sectionUIs.iterator();
        while (iterator.hasNext() && (item = (section = iterator.next()).getItemWithFocus()) == null) {
        }
        if (item != null) {
            item.showAsSelected();
            this.paletteController.setSelectedWindowUI(item, "PALETTE2_ITEM_DEFAULTCREATE");
        } else {
            item = this.paletteController.getSelectedItemUI();
            if (item != null) {
                this.paletteController.fireItemSelected("PALETTE2_ITEM_DEFAULTCREATE");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void setUseLargeIcons(boolean useLargeIcons) {
        for (PaletteSectionUI section : this.sectionUIs) {
            section.setUseLargeIcons(useLargeIcons);
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
    }

    protected String getMessageText(PaletteGroup group) {
        return PaletteArb.getString(52);
    }

    protected boolean isGroupEmpty(PaletteGroup group) {
        if (null == group) {
            return true;
        }
        Collection<PaletteSection> sections = group.getSections();
        if (sections.isEmpty()) {
            return true;
        }
        for (PaletteSection section : sections) {
            if (this.isSectionEmpty(section)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSectionEmpty(PaletteSection section) {
        if (null == section) {
            return true;
        }
        Collection<PaletteItem> items = section.getItems();
        return null == items || true == items.isEmpty();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + (null != this.paletteGroup ? this.paletteGroup.getName() : "<null>");
    }

    public void dispose() {
        this.contentPanel.dispose();
        for (PaletteSectionUI sectionUI : this.sectionUIs) {
            sectionUI.dispose();
        }
        this.sectionUIs.clear();
    }

    protected class CenterPanel
    extends JPanel
    implements Disposable {
        private final transient Set<FocusListener> focusListeners = new HashSet<FocusListener>();
        private transient CopyOnWriteArrayList<KeyListener> keyListeners = new CopyOnWriteArrayList();
        private transient PaletteLayout paletteLayout = null;

        public CenterPanel() {
            this.initColors();
            this.putClientProperty(PaletteLayout.PALETTE_GROUP_UI_KEY, PaletteGroupUI.this);
        }

        @Override
        public synchronized void addFocusListener(FocusListener l) {
            this.focusListeners.add(l);
            super.addFocusListener(l);
            this.addFocusListenerToComponents(l, null);
        }

        private void initColors() {
            ColorProvider colorProvider = (ColorProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)PaletteGroupUI.this, ColorProvider.class);
            if (null == colorProvider) {
                return;
            }
            Color bg = colorProvider.backgroundFor((Object)PaletteGroupUI.this, "enabled");
            if (null != bg) {
                this.setBackground(bg);
            }
        }

        void addFocusListener(FocusListener l, Component source) {
            this.addFocusListener(l);
            this.addFocusListenerToComponents(l, source);
        }

        private void addFocusListenerToComponents(FocusListener l, Component source) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof PaletteItemUI) || c == source) continue;
                PaletteItemUI paletteItemUI = (PaletteItemUI)c;
                paletteItemUI.addFocusListenerWithoutPropagationToParent(l);
            }
        }

        @Override
        public Component add(Component comp) {
            this.addFocusListenersToActivateAccordionHeader(comp);
            this.addKeyListeners(comp);
            return super.add(comp);
        }

        private void addFocusListenersToActivateAccordionHeader(Component addedComponent) {
            for (FocusListener l : this.focusListeners) {
                addedComponent.addFocusListener(l);
            }
        }

        private void setView(String viewType) {
            if (!ModelUtil.hasLength((String)viewType)) {
                throw new IllegalArgumentException("View type must neither be null nor empty");
            }
            PaletteLayoutDescriptor descriptor = PaletteLayoutDescriptor.Manager.getLayoutDescriptor(viewType);
            if (null == descriptor) {
                throw new IllegalArgumentException("Unknown view type: " + viewType);
            }
            PaletteLayout layout = descriptor.getLayoutInstance();
            if (null == layout) {
                throw new IllegalStateException("Could not get layout from descriptor: " + viewType);
            }
            if (null != this.paletteLayout) {
                this.removeKeyListener(this.paletteLayout);
            }
            this.paletteLayout = layout;
            this.addKeyListener(this.paletteLayout);
            this.setLayout(this.paletteLayout);
            this.paletteLayout.invalidateLayout(this);
            this.repaint();
        }

        @Override
        public synchronized void addKeyListener(KeyListener l) {
            this.keyListeners.addIfAbsent(l);
            super.addKeyListener(l);
            this.addKeyListenerToComponents(l, null);
        }

        @Override
        public synchronized void removeKeyListener(KeyListener l) {
            if (this.keyListeners.remove(l)) {
                super.removeKeyListener(l);
                this.removeKeyListenerFromComponents(l, null);
            }
        }

        private void addKeyListenerToComponents(KeyListener l, Component source) {
            int count = this.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof PaletteItemUI) || source == c) continue;
                c.addKeyListener(l);
            }
        }

        private void addKeyListeners(Component comp) {
            for (KeyListener l : this.keyListeners) {
                comp.addKeyListener(l);
            }
        }

        private void removeKeyListenerFromComponents(KeyListener l, Component source) {
            int count = this.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof PaletteItemUI) || source == c) continue;
                c.removeKeyListener(l);
            }
        }

        public void dispose() {
            this.removeAll();
            this.keyListeners.clear();
            this.focusListeners.clear();
        }
    }
}

