/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.ExtensionRegistry;
import oracle.javatools.patterns.Builder;

public abstract class AbstractPaletteObjectBuilder<T>
implements Builder<T> {
    final Map<String, Object> data = new HashMap<String, Object>();
    private String extensionId;
    private String iconUrl;
    private Icon icon;
    private String largeIconUrl;
    private Icon largeIcon;

    public AbstractPaletteObjectBuilder<T> extensionId(String extensionId) {
        this.extensionId = extensionId;
        return this;
    }

    public AbstractPaletteObjectBuilder<T> iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public Icon icon() {
        return this.icon;
    }

    public AbstractPaletteObjectBuilder<T> icon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public AbstractPaletteObjectBuilder<T> largeIconUrl(String largeIconUrl) {
        this.largeIconUrl = largeIconUrl;
        return this;
    }

    public String largeIconUrl() {
        return this.largeIconUrl;
    }

    public Icon largeIcon() {
        return this.largeIcon;
    }

    public T build() {
        if (null == this.icon) {
            this.icon = this.initIcon(this.iconUrl);
        }
        this.largeIcon = this.initIcon(this.largeIconUrl);
        return this.doBuild();
    }

    protected abstract T doBuild();

    private Icon initIcon(String iconUrl) {
        if (iconUrl == null) {
            return null;
        }
        try {
            Toolkit toolkit;
            Image image;
            File file;
            URL url = null;
            try {
                url = new URL(iconUrl);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url == null && iconUrl.indexOf("!") != -1) {
                String jarUrl = iconUrl.replace('\\', '/');
                url = new URL("jar:" + (jarUrl.indexOf("file:") == -1 ? "file:" : "") + jarUrl);
            }
            if (url == null && this.extensionId != null) {
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                ClassLoader loader = registry.getClassLoader(this.extensionId);
                url = loader.getResource(iconUrl);
            }
            if (url == null) {
                url = this.getClass().getResource(iconUrl);
            }
            if (url == null && (file = new File(iconUrl)).exists()) {
                url = file.toURI().toURL();
            }
            if (url != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(url)) != null) {
                return new ImageIcon(image);
            }
        }
        catch (Exception ex) {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.WARNING, "Unable to load icon from " + iconUrl, ex);
        }
        return null;
    }

    public AbstractPaletteObjectBuilder<T> data(String key, Object value) {
        if (key != null && value != null) {
            this.data.put(key, value);
        }
        return this;
    }
}

