/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer.maps;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.NamedPropertyEvent;
import ilog.views.event.NamedPropertyListener;
import ilog.views.io.IlvReadFileException;
import ilog.views.maps.IlvCoordinate;
import ilog.views.maps.IlvCoordinateSystemProperty;
import ilog.views.maps.IlvMapInputStream;
import ilog.views.maps.IlvMapLayerTreeProperty;
import ilog.views.maps.IlvMapOutputStream;
import ilog.views.maps.IlvMapUtil;
import ilog.views.maps.beans.IlvMapLayer;
import ilog.views.maps.beans.IlvMapLayerTreeModel;
import ilog.views.maps.datasource.IlvMapDataSource;
import ilog.views.maps.datasource.IlvMapDataSourceProperty;
import ilog.views.maps.format.IlvDefaultDataPathResolver;
import ilog.views.maps.format.IlvMapDataPathManager;
import ilog.views.maps.format.IlvMapDataPathResolver;
import ilog.views.maps.label.IlvMapDefaultLabeler;
import ilog.views.maps.label.IlvMapLabelerProperty;
import ilog.views.maps.projection.IlvProjectionUtil;
import ilog.views.maps.srs.coordsys.IlvCoordinateSystem;
import ilog.views.maps.srs.coordsys.IlvGeographicCoordinateSystem;
import ilog.views.maps.srs.coordtrans.IlvCoordinateTransformation;
import ilog.views.maps.srs.coordtrans.IlvMathTransform;
import ilog.views.prototypes.IlvValueConverter;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.internal.renderer.Latitude;
import ilog.views.sdm.internal.renderer.LatitudeOrLongitude;
import ilog.views.sdm.internal.renderer.Longitude;
import ilog.views.sdm.renderer.IlvFilterSDMRenderer;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.sdm.renderer.IlvSDMRenderer;
import ilog.views.tiling.IlvThreadedTileLoader;
import ilog.views.tiling.IlvTileController;
import ilog.views.tiling.IlvTileLoader;
import ilog.views.tiling.IlvTiledLayer;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.internal.IlvURLUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IlvMapRenderer
extends IlvFilterSDMRenderer {
    private static final String a = "ilog.views.maps";
    private static final String b = "ilog.views.maps.messages";
    public static String LONGITUDE_PROPERTY = "longitude";
    public static String LATITUDE_PROPERTY = "latitude";
    public static String X_PROPERTY = "x";
    public static String Y_PROPERTY = "y";
    private IlvRect c;
    private boolean d;
    private float e = 5.0f;
    private transient IlvCoordinate f = new IlvCoordinate();
    private transient IlvCoordinate g = new IlvCoordinate();
    private transient Object h;
    private transient IlvGrapher i;
    private transient URL j;
    private transient IlvCoordinateTransformation k;
    private boolean l;
    private boolean m = true;
    private String n;
    private float o = 0.0f;
    private float p = 0.0f;
    private boolean q = true;
    private static final String r = "jlm";
    private NamedPropertyListener s = new NamedPropertyListener(){

        public void propertyChanged(NamedPropertyEvent namedPropertyEvent) {
            if (namedPropertyEvent.getNewValue() instanceof IlvCoordinateSystemProperty) {
                IlvMapRenderer.this.k = null;
            }
        }
    };
    IlvPoint t = new IlvPoint();
    IlvRect u = new IlvRect();
    private static final Collection<String> v = Arrays.asList(LONGITUDE_PROPERTY, LATITUDE_PROPERTY);
    private boolean w = true;

    public IlvMapRenderer(IlvSDMRenderer ilvSDMRenderer) {
        super(ilvSDMRenderer);
    }

    public IlvMapRenderer() {
        this(null);
    }

    @Override
    public void prepareRendering(IlvSDMEngine ilvSDMEngine) {
        Object object;
        IlvGrapher ilvGrapher;
        if (this._renderer != null) {
            this._renderer.prepareRendering(ilvSDMEngine);
        }
        if (this.a((IlvManager)(ilvGrapher = ilvSDMEngine.getGrapher()))) {
            return;
        }
        this.a(ilvGrapher);
        if (this.n != null && this.n.trim().length() > 0) {
            try {
                object = new URL(this.n);
                if (this.l || !((URL)object).equals(this.j)) {
                    IlvManagerView ilvManagerView;
                    this.a((URL)object, (IlvManager)ilvGrapher);
                    if (this.d) {
                        this.b(ilvSDMEngine);
                    }
                    if ((ilvManagerView = ilvSDMEngine.getReferenceView()) != null) {
                        ilvManagerView.fitTransformerToContent(true);
                    }
                    this.j = object;
                    if (ilvSDMEngine.getReferenceView() != null) {
                        double d;
                        IlvTransformer ilvTransformer = ilvSDMEngine.getReferenceView().getTransformer();
                        if (this.isFitToContentsAllowed()) {
                            ilvSDMEngine.getReferenceView().fitTransformerToContent();
                        }
                        if (!Double.isNaN(d = ilvSDMEngine.getReferenceView().getTransformer().zoomFactor()) && !Double.isInfinite(d)) {
                            ilvSDMEngine.setReferenceZoom(d);
                        } else {
                            ilvSDMEngine.setReferenceZoom(1.0);
                        }
                        IlvTransformer ilvTransformer2 = ilvSDMEngine.getReferenceView().getTransformer();
                        if (ilvTransformer2.equals((Object)ilvTransformer)) {
                            IlvTileController ilvTileController = null;
                            for (int i = 0; i < ilvGrapher.getLayersCount(); ++i) {
                                IlvTileController ilvTileController2;
                                IlvManagerLayer ilvManagerLayer = ilvGrapher.getManagerLayer(i);
                                if (!(ilvManagerLayer instanceof IlvTiledLayer) || (ilvTileController2 = ((IlvTiledLayer)ilvManagerLayer).getTileController()) == ilvTileController) continue;
                                ilvTileController2.updateView(ilvManagerView);
                                ilvTileController = ilvTileController2;
                            }
                        }
                    }
                    return;
                }
            }
            catch (Exception exception) {
                Logger.getLogger("ilog.views.sdm", "ilog.views.sdm.messages").log(Level.SEVERE, "MapRenderer.ExceptionWhileReadingMapFile", new Object[]{this.n, exception});
                exception.printStackTrace();
            }
        }
        try {
            object = IlvMapDataSourceProperty.GetMapDataSourceModel((IlvManager)ilvGrapher);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object.getRoot();
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                IlvMapDataSource ilvMapDataSource = (IlvMapDataSource)defaultMutableTreeNode2.getUserObject();
                IlvMapLayer ilvMapLayer = ilvMapDataSource.getInsertionLayer();
                if (ilvMapLayer.getManager() != ilvGrapher) continue;
                ilvMapDataSource.reset();
                if (ilvMapLayer.getDataSource() == null) {
                    ilvMapLayer.setDataSource(ilvMapDataSource);
                }
                ilvMapDataSource.start();
                IlvManagerLayer[] ilvManagerLayerArray = ilvMapLayer.getManagerLayers();
                for (int j = 0; j < ilvManagerLayerArray.length; ++j) {
                    if (!(ilvManagerLayerArray[j] instanceof IlvTiledLayer)) continue;
                    ((IlvTiledLayer)ilvManagerLayerArray[j]).getTileController().updateView(ilvSDMEngine.getReferenceView());
                }
            }
            if (this.d) {
                this.b(ilvSDMEngine);
            }
            if (ilvSDMEngine.getReferenceView() != null) {
                ilvSDMEngine.getReferenceView().fitTransformerToContent();
                ilvSDMEngine.setReferenceZoom(ilvSDMEngine.getReferenceView().getTransformer().zoomFactor());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private boolean a(IlvManager ilvManager) {
        if (ilvManager.getProperty("makeBeanFromRuleEngine") != null) {
            return true;
        }
        return ilvManager.getProperty("customizerPreviewing") != null;
    }

    private void a(URL uRL, IlvManager ilvManager) throws IOException, IlvReadFileException {
        File file;
        InputStream inputStream;
        URL uRL2;
        Object object;
        Object object2;
        IlvMapLabelerProperty ilvMapLabelerProperty = (IlvMapLabelerProperty)ilvManager.getNamedProperty("__IlvMapLabelerProperty");
        if (ilvMapLabelerProperty != null && (object2 = ilvMapLabelerProperty.getMapLabeler()) instanceof IlvMapDefaultLabeler) {
            object = (IlvMapDefaultLabeler)object2;
            object.getLabelManager().dispose();
        }
        ilvManager.removeNamedProperty("__IlvMapLayerTreeProperty");
        ilvManager.removeNamedProperty("__IlvMapDataSourceProperty");
        ilvManager.removeNamedProperty("__IlvAreasOfInterest");
        ilvManager.removeNamedProperty("__IlvMapStyleControllerProperty");
        ilvManager.removeNamedProperty("__IlvMapLabelerProperty");
        ilvManager.removeNamedProperty("__IlvMapAnnotationProperty");
        object2 = "file".equals(uRL.getProtocol()) ? IlvURLUtil.convertFileURLToFilename((URL)uRL) : uRL.toExternalForm();
        object = ((String)object2).substring(0, ((String)object2).length() - 4) + IlvMapOutputStream.getImageFileSuffix();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile((String)object, "r");
        }
        catch (Exception exception) {
            try {
                int n;
                uRL2 = new URL((String)object);
                inputStream = uRL2.openStream();
                file = File.createTempFile(r + ((String)object2).hashCode(), IlvMapOutputStream.getImageFileSuffix());
                this.a(file.getParentFile());
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)bufferedOutputStream).flush();
                ((OutputStream)bufferedOutputStream).close();
                inputStream.close();
                randomAccessFile = new RandomAccessFile(file, "r");
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        InputStream inputStream2 = uRL.openConnection().getInputStream();
        uRL2 = new IlvMapInputStream(inputStream2, randomAccessFile);
        uRL2.setDocumentBase(uRL);
        inputStream = new IlvDefaultDataPathResolver(new File(uRL.getFile()).getParent());
        IlvMapDataPathManager.AddDataPathResolver((IlvMapDataPathResolver)inputStream);
        uRL2.setGeneratingImage(!this.isUsingThreads());
        uRL2.read((IlvGraphicBag)ilvManager);
        IlvMapDataPathManager.RemoveDataPathResolver((IlvMapDataPathResolver)inputStream);
        file = ilvManager.getNamedProperty("VersionPropertyName");
        this.l = file == null;
    }

    private void a(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(IlvMapRenderer.r) && file.getName().endsWith(IlvMapOutputStream.getImageFileSuffix());
            }
        });
        file = null;
        IlvMapUtil.freeMemoryNow(null);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                fileArray[i].delete();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void removeAll(IlvSDMEngine ilvSDMEngine) {
        super.removeAll(ilvSDMEngine);
        this.a((IlvGrapher)null);
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        if (this.a((IlvManager)ilvGrapher)) {
            return;
        }
        if (this.l) {
            for (int i = 0; i < ilvGrapher.getLayersCount(); ++i) {
                IlvManagerLayer ilvManagerLayer = ilvGrapher.getManagerLayer(i);
                if (!(ilvManagerLayer instanceof IlvTiledLayer)) continue;
                ilvGrapher.removeLayer(i, false);
                ilvGrapher.addLayer(i);
            }
            return;
        }
        IlvMapLayerTreeModel ilvMapLayerTreeModel = IlvMapLayerTreeProperty.GetMapLayerTreeModel((IlvManager)ilvGrapher);
        Enumeration enumeration = ilvMapLayerTreeModel.getEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof IlvMapLayer)) continue;
            IlvMapLayer ilvMapLayer = (IlvMapLayer)object;
            IlvManagerLayer ilvManagerLayer = ilvMapLayer.getManagerLayer();
            if (ilvManagerLayer instanceof IlvTiledLayer) {
                IlvTileLoader ilvTileLoader = ((IlvTiledLayer)ilvManagerLayer).getTileLoader();
                if (ilvTileLoader instanceof IlvThreadedTileLoader) {
                    ((IlvThreadedTileLoader)ilvTileLoader).dispose();
                }
                ((IlvTiledLayer)ilvManagerLayer).getTileController().removeAllFreeTiles();
            }
            ilvMapLayer.setDataSource(null);
        }
    }

    private void a(IlvGrapher ilvGrapher) {
        if (this.i != ilvGrapher) {
            if (this.i != null) {
                this.i.removeNamedPropertyListener(this.s);
            }
            this.k = null;
            this.i = ilvGrapher;
            if (this.i != null) {
                this.i.addNamedPropertyListener(this.s);
            }
        }
    }

    private IlvCoordinateTransformation a(IlvSDMEngine ilvSDMEngine) {
        if (this.k == null) {
            IlvCoordinateSystem ilvCoordinateSystem = IlvCoordinateSystemProperty.GetCoordinateSystem((IlvManager)ilvSDMEngine.getGrapher());
            this.k = IlvCoordinateTransformation.CreateTransformation((IlvCoordinateSystem)this.a(ilvCoordinateSystem), (IlvCoordinateSystem)ilvCoordinateSystem);
        }
        return this.k;
    }

    @Override
    public Object getGraphicProperty(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, Class clazz) {
        if (string.equals(X_PROPERTY)) {
            if (this.a(ilvSDMEngine, object, this.f)) {
                this.h = object;
                if (clazz != null) {
                    return this.convert((Object)String.valueOf(this.f.x), clazz, string);
                }
                return new Float(this.f.x);
            }
            this.h = null;
        } else if (string.equals(Y_PROPERTY)) {
            boolean bl = object == this.h ? true : this.a(ilvSDMEngine, object, this.f);
            this.h = null;
            if (bl) {
                if (clazz != null) {
                    return this.convert((Object)String.valueOf(this.f.y), clazz, string);
                }
                return new Float(this.f.y);
            }
            return null;
        }
        if (this._renderer == null) {
            return null;
        }
        return this._renderer.getGraphicProperty(ilvSDMEngine, object, string, stringArray, clazz);
    }

    private boolean a(IlvSDMEngine ilvSDMEngine, Object object, IlvCoordinate ilvCoordinate) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, LONGITUDE_PROPERTY, null, null);
        if (object2 == null) {
            return false;
        }
        Object object3 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, LATITUDE_PROPERTY, null, null);
        if (object3 == null) {
            return false;
        }
        try {
            ilvCoordinate.x = IlvMapRenderer.convertLatLong(object2, false);
            ilvCoordinate.y = IlvMapRenderer.convertLatLong(object3, true);
        }
        catch (Exception exception) {
            if (!this.isHideInvalidNodesAndLinks()) {
                String string = MessageFormat.format(IlvMapUtil.getString(IlvSDMEngine.class, (String)"MapRenderer.ExceptionWhileConvertingLatLong"), object2, object3, exception);
                Logger.getLogger(a, b).log(Level.WARNING, string);
            }
            return false;
        }
        if (Double.isNaN(ilvCoordinate.x) || Double.isNaN(ilvCoordinate.y)) {
            return false;
        }
        try {
            this.a(ilvSDMEngine).transform(ilvCoordinate, this.g);
            ilvCoordinate.x = this.g.x;
            ilvCoordinate.y = this.g.y;
            IlvProjectionUtil.invertY((IlvCoordinate)ilvCoordinate);
            return true;
        }
        catch (Exception exception) {
            if (!this.isHideInvalidNodesAndLinks()) {
                String string = MessageFormat.format(IlvMapUtil.getString(IlvSDMEngine.class, (String)"MapRenderer.ExceptionWhileProjecting"), ilvCoordinate, exception);
                Logger.getLogger(a, b).log(Level.WARNING, string);
            }
            return false;
        }
    }

    @Override
    public void propertiesChanged(IlvSDMEngine ilvSDMEngine, Object object, Collection<String> collection, IlvGraphic ilvGraphic) {
        if (collection != null && v.containsAll(collection)) {
            this.a(ilvSDMEngine.getGrapher(), ilvGraphic, this.getLocation(ilvSDMEngine, object, this.t));
            this.u.x = this.t.x;
            this.u.y = this.t.y;
            this.u.width = IlvRendererUtil.getGraphicPropertyAsFloat(ilvSDMEngine, object, "width", null, 0.0f);
            this.u.height = IlvRendererUtil.getGraphicPropertyAsFloat(ilvSDMEngine, object, "height", null, 0.0f);
            ilvSDMEngine.getRenderer().callMoveResizeNodeGraphic(ilvSDMEngine, object, ilvGraphic, this.u, 16);
            return;
        }
        super.propertiesChanged(ilvSDMEngine, object, collection, ilvGraphic);
    }

    @Override
    public void updateObjectProperties(IlvSDMEngine ilvSDMEngine, Object object, String string, Object object2, String[] stringArray) {
        if (string.equals(X_PROPERTY)) {
            try {
                this.f.x = IlvValueConverter.convertToDouble((Object)object2);
                if (object == this.h) {
                    if (this.a(ilvSDMEngine, object, this.f, stringArray)) {
                        this.h = null;
                        this.f.x = Double.NaN;
                        this.f.y = Double.NaN;
                    }
                } else {
                    this.h = object;
                }
            }
            catch (Exception exception) {
                this.h = null;
                Logger.getLogger(a, b).log(Level.WARNING, "MapRenderer.ExceptionWhileUpdatingLatLongs", new Object[]{string, object2, exception});
            }
            return;
        }
        if (string.equals(Y_PROPERTY)) {
            try {
                this.f.y = IlvValueConverter.convertToDouble((Object)object2);
                if (object == this.h) {
                    if (this.a(ilvSDMEngine, object, this.f, stringArray)) {
                        this.h = null;
                        this.f.x = Double.NaN;
                        this.f.y = Double.NaN;
                    }
                } else {
                    this.h = object;
                }
            }
            catch (Exception exception) {
                this.h = null;
                Logger.getLogger(a, b).log(Level.WARNING, "MapRenderer.ExceptionWhileUpdatingLatLongs", new Object[]{string, object2, exception});
            }
            return;
        }
        super.updateObjectProperties(ilvSDMEngine, object, string, object2, stringArray);
    }

    private boolean a(IlvSDMEngine ilvSDMEngine, Object object, IlvCoordinate ilvCoordinate, String[] stringArray) {
        if (Double.isNaN(ilvCoordinate.x) || Double.isNaN(ilvCoordinate.y)) {
            return false;
        }
        try {
            IlvProjectionUtil.invertY((IlvCoordinate)ilvCoordinate);
            this.a(ilvSDMEngine).getInverse().transform(ilvCoordinate, this.g);
            ilvCoordinate.x = this.g.x;
            ilvCoordinate.y = this.g.y;
            Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, LONGITUDE_PROPERTY, null, null);
            try {
                IlvValueConverter.convertToDouble((Object)object2);
                IlvRendererUtil.updateObjectProperties(ilvSDMEngine, object, LONGITUDE_PROPERTY, new Double(ilvCoordinate.x), stringArray);
                IlvRendererUtil.updateObjectProperties(ilvSDMEngine, object, LATITUDE_PROPERTY, new Double(ilvCoordinate.y), stringArray);
                return true;
            }
            catch (Exception exception) {
                String string = IlvProjectionUtil.RadianToDMS((double)ilvCoordinate.x, (boolean)false);
                String string2 = IlvProjectionUtil.RadianToDMS((double)ilvCoordinate.y, (boolean)true);
                IlvRendererUtil.updateObjectProperties(ilvSDMEngine, object, LONGITUDE_PROPERTY, string, stringArray);
                IlvRendererUtil.updateObjectProperties(ilvSDMEngine, object, LATITUDE_PROPERTY, string2, stringArray);
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(a, b).log(Level.WARNING, "MapRenderer.ExceptionWhileUpdatingLatLongs2", new Object[]{ilvCoordinate, exception});
            return false;
        }
    }

    public static double convertLatLong(Object object, boolean bl) throws IlvConvertException {
        try {
            return IlvConvert.convertToDouble((Object)object);
        }
        catch (Exception exception) {
            try {
                return IlvProjectionUtil.DMSToRadian((String)object.toString());
            }
            catch (Exception exception2) {
                return ((LatitudeOrLongitude)IlvConvert.convert((Object)object, bl ? Latitude.class : Longitude.class)).getRadians();
            }
        }
    }

    public void setMap(String string) {
        this.n = string;
    }

    public String getMap() {
        return this.n;
    }

    public void setRegionOfInterest(IlvRect ilvRect) {
        this.c = ilvRect;
    }

    public IlvRect getRegionOfInterest() {
        return this.c;
    }

    private void b(IlvSDMEngine ilvSDMEngine) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        Enumeration enumeration = ilvSDMEngine.getAllObjects();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, e, LONGITUDE_PROPERTY, null, null);
            Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, e, LATITUDE_PROPERTY, null, null);
            if (object == null || object2 == null) continue;
            try {
                this.f.x = IlvMapRenderer.convertLatLong(object, false);
                this.f.y = IlvMapRenderer.convertLatLong(object2, true);
                bl = true;
                d = Math.min(d, this.f.x);
                d2 = Math.max(d2, this.f.x);
                d3 = Math.min(d3, this.f.y);
                d4 = Math.max(d4, this.f.y);
            }
            catch (IlvConvertException ilvConvertException) {}
        }
        if (bl) {
            if (this.o == 0.0f) {
                this.o = this.c != null && this.c.width > 0.0f ? this.c.width : 0.1f;
            }
            if (this.p == 0.0f) {
                this.p = this.c != null && this.c.height > 0.0f ? this.c.height : 0.1f;
            }
            float f = (float)d;
            float f2 = (float)d3;
            float f3 = (float)(d2 - d);
            float f4 = (float)(d4 - d3);
            float f5 = f3 * this.e / 100.0f;
            if (f3 == 0.0f) {
                f3 = this.o;
                f -= f3 / 2.0f;
            }
            if (f4 == 0.0f) {
                f4 = this.p;
                f2 -= f4 / 2.0f;
            }
            this.c = new IlvRect(f -= f5, f2 -= f5, f3 += 2.0f * f5, f4 += 2.0f * f5);
        }
    }

    public void setAutoRegionOfInterest(boolean bl) {
        this.d = bl;
    }

    public boolean isAutoRegionOfInterest() {
        return this.d;
    }

    public void setRegionOfInterestMargin(float f) {
        this.e = f;
    }

    public float getRegionOfInterestMargin() {
        return this.e;
    }

    private IlvGeographicCoordinateSystem a(IlvCoordinateSystem ilvCoordinateSystem) {
        return IlvGeographicCoordinateSystem.KERNEL;
    }

    @Override
    public IlvRect computeBBox(IlvSDMEngine ilvSDMEngine, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getRegionOfInterest();
        if (ilvRect != null) {
            IlvCoordinateSystem ilvCoordinateSystem = IlvCoordinateSystemProperty.GetCoordinateSystem((IlvManager)ilvManagerView.getManager());
            IlvCoordinateTransformation ilvCoordinateTransformation = IlvCoordinateTransformation.CreateTransformation((IlvCoordinateSystem)this.a(ilvCoordinateSystem), (IlvCoordinateSystem)ilvCoordinateSystem);
            IlvRect ilvRect2 = IlvMapUtil.computeTransformedBounds((IlvMathTransform)ilvCoordinateTransformation.getTransform(), (double)ilvRect.x, (double)ilvRect.y, (double)(ilvRect.x + ilvRect.width), (double)(ilvRect.y + ilvRect.height));
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvRect2);
            }
            return ilvRect2;
        }
        return super.computeBBox(ilvSDMEngine, ilvManagerView, ilvTransformer);
    }

    public static void addLatitudeLongitudeFormat(String string, boolean bl) {
        LatitudeOrLongitude.addLatitudeLongitudeFormat(string, bl);
    }

    public boolean isFitToContentsAllowed() {
        return this.q;
    }

    public void setFitToContentsAllowed(boolean bl) {
        this.q = bl;
    }

    @Override
    public void setParameter(String string) {
        block2: {
            block3: {
                if (string == null) break block2;
                String string2 = string.toLowerCase();
                if ("true".equals(string2)) break block3;
                if (!"false".equals(string2)) break block2;
            }
            return;
        }
        this.setMap(string);
    }

    @Override
    public String getParameter() {
        return this.getMap();
    }

    public static IlvMapRenderer getInstance(IlvSDMEngine ilvSDMEngine) {
        return (IlvMapRenderer)IlvRendererUtil.getRenderer(ilvSDMEngine, "Map");
    }

    public boolean isUsingThreads() {
        return this.m;
    }

    public void setUsingThreads(boolean bl) {
        this.m = bl;
    }

    private boolean c(IlvSDMEngine ilvSDMEngine) {
        String[] stringArray = ilvSDMEngine.getPseudoClasses();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"thin-client".equals(stringArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setEngine(IlvSDMEngine ilvSDMEngine) {
        super.setEngine(ilvSDMEngine);
        this.setUsingThreads(this.c(ilvSDMEngine));
    }

    private void a(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, boolean bl) {
        ilvGraphic.setVisible(bl);
        if (ilvGraphic.getGraphicBag() != ilvGrapher) {
            ilvGraphic = (IlvGraphic)ilvGraphic.getGraphicBag();
            ilvGraphic.setVisible(bl);
        }
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvGrapher.getLinks(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvLinkImage ilvLinkImage;
            ilvLinkImage.setVisible((ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement()).getFrom().isVisible() && ilvLinkImage.getTo().isVisible());
        }
    }

    @Override
    public IlvGraphic createNodeGraphic(IlvSDMEngine ilvSDMEngine, Object object) {
        boolean bl;
        IlvGraphic ilvGraphic = super.createNodeGraphic(ilvSDMEngine, object);
        if (ilvGraphic != null && this.isHideInvalidNodesAndLinks() && !(bl = this.a(ilvSDMEngine, object, this.f))) {
            ilvGraphic.setVisible(false);
        }
        return ilvGraphic;
    }

    @Override
    public IlvGraphic createLinkGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        IlvLinkImage ilvLinkImage = (IlvLinkImage)super.createLinkGraphic(ilvSDMEngine, object, ilvGraphic, ilvGraphic2);
        if (ilvLinkImage != null && this.isHideInvalidNodesAndLinks()) {
            ilvLinkImage.setVisible(ilvLinkImage.getFrom().isVisible() && ilvLinkImage.getTo().isVisible());
        }
        return ilvLinkImage;
    }

    public boolean isHideInvalidNodesAndLinks() {
        return this.w;
    }

    public void setHideInvalidNodesAndLinks(boolean bl) {
        this.w = bl;
    }
}

