/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer.graphlayout;

import ilog.views.IlvGraphic;
import ilog.views.graphlayout.internalutil.rowcolumngrid.IlvPredefinedNodeComparator;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;

public class IlvSDMNodeComparator
implements Comparator,
IlvPersistentObject,
Serializable {
    private static final String a = "sortCriteria";
    private static final String b = "ascending";
    private static final String c = "descending";
    private SortCriteria[] d;

    public IlvSDMNodeComparator() {
    }

    public IlvSDMNodeComparator(SortCriteria[] sortCriteriaArray) {
        this.setSortCriteria(sortCriteriaArray);
    }

    public IlvSDMNodeComparator(String string) {
        this.setTextualSortCriteria(string);
    }

    public IlvSDMNodeComparator(IlvInputStream ilvInputStream) {
        try {
            String string = ilvInputStream.readString(a);
            this.setTextualSortCriteria(string);
        }
        catch (IlvReadFileException ilvReadFileException) {
            // empty catch block
        }
    }

    public void setSortCriteria(SortCriteria[] sortCriteriaArray) {
        this.d = sortCriteriaArray;
    }

    public SortCriteria[] getSortCriteria() {
        return this.d;
    }

    public void setTextualSortCriteria(String string) {
        SortCriteria[] sortCriteriaArray;
        StringTokenizer stringTokenizer = IlvSDMNodeComparator.b(string, ";");
        ArrayList<SortCriteria[]> arrayList = new ArrayList<SortCriteria[]>();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.trim().length() == 0 || (sortCriteriaArray = SortCriteria.createFromTextualDescription(string2)) == null) continue;
            arrayList.add(sortCriteriaArray);
        }
        int n = arrayList.size();
        if (n == 0) {
            this.setSortCriteria(null);
        } else {
            sortCriteriaArray = new SortCriteria[n];
            arrayList.toArray(sortCriteriaArray);
            this.setSortCriteria(sortCriteriaArray);
        }
    }

    private static StringTokenizer b(String string, String string2) {
        if (string != null && !string.endsWith(string2)) {
            string = string + string2;
        }
        return new StringTokenizer(string, string2);
    }

    public String getTextualSortCriteria() {
        int n = this.d != null ? this.d.length : 0;
        String string = "";
        if (n == 0) {
            return string;
        }
        for (int i = 0; i < n; ++i) {
            SortCriteria sortCriteria = this.d[i];
            string = string + sortCriteria.getTextualDescription() + (i != n - 1 ? ";" : "");
        }
        return string;
    }

    public int compare(Object object, Object object2) {
        if (!(object instanceof IlvGraphic) || !(object2 instanceof IlvGraphic)) {
            throw new IllegalArgumentException("Expected node type is a subclass of " + IlvGraphic.class + ". Found: " + (object != null ? object.getClass().getName() : "null") + " and " + (object2 != null ? object2.getClass().getName() : "null"));
        }
        int n = this.d != null ? this.d.length : 0;
        IlvGraphic ilvGraphic = (IlvGraphic)object;
        IlvGraphic ilvGraphic2 = (IlvGraphic)object2;
        IlvSDMEngine ilvSDMEngine = this.a(ilvGraphic);
        if (ilvSDMEngine == null) {
            throw new RuntimeException("Unexpected null engine for node: " + ilvGraphic);
        }
        IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
        if (ilvSDMModel == null) {
            throw new RuntimeException("Unexpected null SDM model for node: " + ilvGraphic);
        }
        int n2 = 0;
        Object object3 = ilvSDMEngine.getObject(ilvGraphic);
        Object object4 = ilvSDMEngine.getObject(ilvGraphic2);
        for (int i = 0; i < n; ++i) {
            SortCriteria sortCriteria = this.d[i];
            n2 = sortCriteria instanceof DataModelAttributeSortCriteria ? ((DataModelAttributeSortCriteria)sortCriteria).a(ilvSDMModel, object3, object4) : sortCriteria.compare(ilvGraphic, ilvGraphic2);
            if (n2 == 0) continue;
            return n2;
        }
        return n2;
    }

    private IlvSDMEngine a(IlvGraphic ilvGraphic) {
        return IlvSDMEngine.getSDMEngine(ilvGraphic);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        String string = this.getTextualSortCriteria();
        if (string != null && string.length() > 0) {
            ilvOutputStream.write(a, string);
        }
    }

    public static class ComparatorSortCriteria
    extends SortCriteria {
        private Comparator a;

        public ComparatorSortCriteria(Comparator comparator) {
            this.setComparator(comparator);
        }

        public ComparatorSortCriteria(String string) {
            StringTokenizer stringTokenizer;
            block3: {
                block2: {
                    stringTokenizer = IlvSDMNodeComparator.b(string, ",");
                    int n = stringTokenizer.countTokens();
                    String string2 = null;
                    if (n != 2 || (string2 = stringTokenizer.nextToken()) == null) break block2;
                    if (string2.equals("comparator")) break block3;
                }
                throw new IllegalArgumentException("Unsupported description: " + string);
            }
            String string3 = stringTokenizer.nextToken();
            Comparator comparator = ComparatorSortCriteria.a(string3);
            this.setComparator(comparator);
        }

        private static Comparator a(String string) {
            return IlvPredefinedNodeComparator.getFieldFromName(string);
        }

        public final void setComparator(Comparator comparator) {
            this.a = comparator;
        }

        public final Comparator getComparator() {
            return this.a;
        }

        public final String getTextualDescription() {
            Comparator comparator = this.getComparator();
            if (comparator == null) {
                return "comparator,NO_ORDERING";
            }
            if (comparator instanceof IlvPredefinedNodeComparator) {
                String string = ((IlvPredefinedNodeComparator)comparator).getName();
                if (string == null) {
                    return "";
                }
                return "comparator," + string;
            }
            return "comparator," + comparator.getClass().getName();
        }

        public int compare(Object object, Object object2) {
            Comparator comparator = this.getComparator();
            return comparator != null ? this.getComparator().compare(object, object2) : 1;
        }
    }

    public static class DataModelAttributeSortCriteria
    extends SortCriteria {
        private IlvSDMModel a;
        private boolean b;
        private String c;

        public DataModelAttributeSortCriteria(String string, boolean bl) {
            this.b = true;
            this.setAttributeName(string);
            this.setAscending(bl);
        }

        public DataModelAttributeSortCriteria(String string) {
            StringTokenizer stringTokenizer;
            block3: {
                block2: {
                    this.b = true;
                    stringTokenizer = IlvSDMNodeComparator.b(string, ",");
                    String string2 = stringTokenizer.nextToken();
                    if (string2 == null) break block2;
                    if (string2.equals("data")) break block3;
                }
                throw new IllegalArgumentException("Unsupported description: " + string);
            }
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            boolean bl = string4.trim().toLowerCase().equals(IlvSDMNodeComparator.b);
            this.setAttributeName(string3);
            this.setAscending(bl);
        }

        public final IlvSDMModel getSDMModel() {
            return this.a;
        }

        public final void setAscending(boolean bl) {
            this.b = bl;
        }

        public final boolean isAscending() {
            return this.b;
        }

        public final void setAttributeName(String string) {
            this.c = string;
        }

        public final String getAttributeName() {
            return this.c;
        }

        public final String getTextualDescription() {
            return "data," + this.getAttributeName() + "," + (this.isAscending() ? IlvSDMNodeComparator.b : IlvSDMNodeComparator.c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int a(IlvSDMModel ilvSDMModel, Object object, Object object2) {
            this.a = ilvSDMModel;
            try {
                int n = this.compare(object, object2);
                Object var6_5 = null;
                this.a = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.a = null;
                throw throwable;
            }
        }

        public int compare(Object object, Object object2) {
            IlvSDMModel ilvSDMModel = this.getSDMModel();
            String string = this.getAttributeName();
            Object object3 = DataModelAttributeSortCriteria.a(ilvSDMModel, object, string);
            Object object4 = DataModelAttributeSortCriteria.a(ilvSDMModel, object2, string);
            int n = DataModelAttributeSortCriteria.a(object3, object4);
            return this.isAscending() ? n : -n;
        }

        private static int a(Object object, Object object2) {
            if (object == null) {
                return object2 == null ? 0 : 1;
            }
            if (object2 == null) {
                return -1;
            }
            if (object instanceof String) {
                if (object2 instanceof String) {
                    String string = (String)object;
                    String string2 = (String)object2;
                    return string.compareTo(string2);
                }
                return -1;
            }
            if (object2 instanceof String) {
                return 1;
            }
            return 0;
        }

        private static Object a(IlvSDMModel ilvSDMModel, Object object, String string) {
            return ilvSDMModel.getObjectProperty(object, string);
        }
    }

    public static abstract class SortCriteria
    implements Comparator {
        public abstract int compare(Object var1, Object var2);

        public abstract String getTextualDescription();

        public static SortCriteria createFromTextualDescription(String string) {
            StringTokenizer stringTokenizer = IlvSDMNodeComparator.b(string, ",");
            int n = stringTokenizer.countTokens();
            if (n == 0) {
                return null;
            }
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) {
                throw new IllegalArgumentException("Unsupported format for the provided string: " + string);
            }
            if (string2.equals("data")) {
                return new DataModelAttributeSortCriteria(string);
            }
            if (string2.equals("comparator")) {
                return new ComparatorSortCriteria(string);
            }
            throw new IllegalArgumentException("Unsupported format for the provided string: " + string);
        }
    }
}

