/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.renderer.IlvBlinkingRenderer;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.sdm.renderer.IlvSDMCSSFunction;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.java2d.IlvBlinkingColor;
import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;

class SDMBlinkingColor
extends IlvSDMCSSFunction {
    public String getName() {
        return "blinkingColor";
    }

    public String getShortDescription() {
        return IlvSDMCSSFunction._bundle.getString("IlvSDMCSSFunction.function.shortDescr.blinkingColor");
    }

    public Object call(Object[] objectArray, Class clazz, IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
        if (objectArray.length < 2) {
            throw new IllegalArgumentException(this.getName() + " needs 2 parameters: on Color, offColor");
        }
        try {
            Color color = (Color)IlvConvert.convert((Object)objectArray[0], Color.class);
            Color color2 = (Color)IlvConvert.convert((Object)objectArray[1], Color.class);
            IlvBlinkingRenderer ilvBlinkingRenderer = (IlvBlinkingRenderer)IlvRendererUtil.getRenderer(ilvSDMEngine, "Blinking");
            if (ilvBlinkingRenderer == null) {
                Logger.getLogger("ilog.views.sdm", "ilog.views.sdm.messages").log(Level.WARNING, "BlinkingRenderer.NotInstalled", this.getName());
                return color;
            }
            int n = ilvBlinkingRenderer.getOnPeriod();
            int n2 = ilvBlinkingRenderer.getOffPeriod();
            if (objectArray.length == 4) {
                n = IlvConvert.convertToInt((Object)objectArray[2]);
                n2 = IlvConvert.convertToInt((Object)objectArray[3]);
            }
            IlvBlinkingColor ilvBlinkingColor = ilvBlinkingRenderer.getColor(color, color2, n, n2);
            return ilvBlinkingColor;
        }
        catch (IlvConvertException ilvConvertException) {
            ilvConvertException.printStackTrace();
            return null;
        }
    }
}

