/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.internal;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicFilter;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.IlvHyperGrapher;
import ilog.views.hypergraph.IlvSegmentedHyperEdge;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgeConnector;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgePinConnector;
import ilog.views.hypergraph.edgeconnector.IlvHyperGrapherPin;
import ilog.views.hypergraph.internal.IlvGeometryUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IlvHyperGrapherUtil {
    public static void transferHyperEdge(IlvHyperGrapher ilvHyperGrapher, IlvSegmentedHyperEdge ilvSegmentedHyperEdge, int n, IlvManagerView ilvManagerView, boolean bl) {
        if (ilvSegmentedHyperEdge == null) {
            throw new IllegalArgumentException("hyperedge cannot be null");
        }
        if (ilvHyperGrapher == null) {
            throw new IllegalArgumentException("grapher cannot be null");
        }
        if (ilvSegmentedHyperEdge.getGraphicBag() == null) {
            throw new IllegalArgumentException("hyperedge must be in a grapher");
        }
        if (ilvHyperGrapher == ilvSegmentedHyperEdge.getGraphicBag()) {
            return;
        }
        IlvHyperGrapher ilvHyperGrapher2 = (IlvHyperGrapher)ilvSegmentedHyperEdge.getGraphicBag();
        IlvHyperGrapherUtil.transferHyperEdge(ilvHyperGrapher, ilvHyperGrapher2, ilvSegmentedHyperEdge, n, ilvManagerView, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferHyperEdge(IlvHyperGrapher ilvHyperGrapher, IlvHyperGrapher ilvHyperGrapher2, IlvSegmentedHyperEdge ilvSegmentedHyperEdge, int n, IlvManagerView ilvManagerView, boolean bl) {
        IlvTransformer ilvTransformer;
        IlvTransformer ilvTransformer2;
        if (ilvSegmentedHyperEdge == null) {
            throw new IllegalArgumentException("hyperedge cannot be null");
        }
        if (ilvHyperGrapher == null) {
            throw new IllegalArgumentException("grapher cannot be null");
        }
        if (ilvHyperGrapher == ilvSegmentedHyperEdge.getGraphicBag()) {
            return;
        }
        if (ilvManagerView != null) {
            ilvTransformer2 = ilvHyperGrapher2.getDrawingTransformer(ilvManagerView);
            ilvTransformer = ilvHyperGrapher.getDrawingTransformer(ilvManagerView);
        } else {
            ilvTransformer = null;
            ilvTransformer2 = null;
        }
        ilvHyperGrapher2.setContentsAdjusting(true, true);
        ilvHyperGrapher.setContentsAdjusting(true, true);
        try {
            IlvSegmentedHyperEdge.Segment segment;
            IlvSegmentedHyperEdge.Segment segment2;
            if (ilvSegmentedHyperEdge.getGraphicBag() != null) {
                ilvHyperGrapher2.removeObject(ilvSegmentedHyperEdge, bl);
            }
            Iterator iterator = ilvSegmentedHyperEdge.getSegments();
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            while (iterator.hasNext()) {
                segment2 = (IlvSegmentedHyperEdge.Segment)iterator.next();
                int n2 = segment2.getIncidentSegmentsCount();
                for (int i = 0; i < n2; ++i) {
                    segment = segment2.getIncidentSegment(i);
                    if (segment2.hashCode() >= segment.hashCode()) continue;
                    IlvPoint ilvPoint = segment2.getIntersectionPoint(segment, ilvTransformer2);
                    arrayList.add(new Object[]{segment2, segment, ilvPoint});
                }
            }
            for (Object[] objectArray : arrayList) {
                segment2 = (IlvSegmentedHyperEdge.Segment)objectArray[0];
                segment = (IlvSegmentedHyperEdge.Segment)objectArray[1];
                IlvPoint ilvPoint = (IlvPoint)objectArray[2];
                ilvSegmentedHyperEdge.moveConnectionPoint(segment2, segment, ilvPoint.x, ilvPoint.y, ilvTransformer);
            }
            if (n >= 0) {
                ilvHyperGrapher.addHyperEdge(ilvSegmentedHyperEdge, n, bl);
            } else {
                ilvHyperGrapher.addHyperEdge(ilvSegmentedHyperEdge, bl);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            ilvHyperGrapher2.setContentsAdjusting(false, true);
            ilvHyperGrapher.setContentsAdjusting(false, true);
            throw throwable;
        }
        ilvHyperGrapher2.setContentsAdjusting(false, true);
        ilvHyperGrapher.setContentsAdjusting(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap combineTwoHyperEdges(IlvSegmentedHyperEdge ilvSegmentedHyperEdge, IlvSegmentedHyperEdge ilvSegmentedHyperEdge2, IlvManagerView ilvManagerView, boolean bl) {
        HashMap hashMap;
        IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)ilvSegmentedHyperEdge.getGraphicBag();
        IlvHyperGrapher ilvHyperGrapher2 = (IlvHyperGrapher)ilvSegmentedHyperEdge2.getGraphicBag();
        if (ilvHyperGrapher == null) {
            HashMap hashMap2 = ilvSegmentedHyperEdge.copyShapeFrom(ilvSegmentedHyperEdge2);
            if (ilvHyperGrapher2 != null) {
                ilvHyperGrapher2.removeObject(ilvSegmentedHyperEdge2, bl);
            }
            return hashMap2;
        }
        if (ilvHyperGrapher2 == ilvHyperGrapher) {
            CopyShapeApplyObject copyShapeApplyObject = new CopyShapeApplyObject();
            ilvHyperGrapher.applyToObject(ilvSegmentedHyperEdge, copyShapeApplyObject, ilvSegmentedHyperEdge2, bl);
            ilvHyperGrapher2.removeObject(ilvSegmentedHyperEdge2, bl);
            return copyShapeApplyObject.a;
        }
        HashSet<IlvGraphic> hashSet = new HashSet<IlvGraphic>();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvSegmentedHyperEdge.getFrom();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            hashSet.add(ilvGraphicEnumeration.nextElement());
        }
        ilvGraphicEnumeration = ilvSegmentedHyperEdge.getTo();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            hashSet.add(ilvGraphicEnumeration.nextElement());
        }
        ilvGraphicEnumeration = ilvSegmentedHyperEdge2.getFrom();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            hashSet.add(ilvGraphicEnumeration.nextElement());
        }
        ilvGraphicEnumeration = ilvSegmentedHyperEdge2.getTo();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            hashSet.add(ilvGraphicEnumeration.nextElement());
        }
        IlvHyperGrapher ilvHyperGrapher3 = IlvHyperGrapher.getLowestCommonHyperGrapher(hashSet.iterator());
        ilvHyperGrapher.setContentsAdjusting(true, true);
        ilvHyperGrapher2.setContentsAdjusting(true, true);
        ilvHyperGrapher3.setContentsAdjusting(true, true);
        try {
            int n;
            int n2 = ilvHyperGrapher3 == ilvHyperGrapher ? ilvHyperGrapher3.getLayer(ilvSegmentedHyperEdge) : -1;
            int n3 = n = ilvHyperGrapher3 == ilvHyperGrapher2 ? ilvHyperGrapher3.getLayer(ilvSegmentedHyperEdge2) : -1;
            if (n2 < 0 && n > 0) {
                n2 = n;
            }
            IlvHyperGrapherUtil.transferHyperEdge(ilvHyperGrapher3, ilvSegmentedHyperEdge, n2, ilvManagerView, bl);
            IlvHyperGrapherUtil.transferHyperEdge(ilvHyperGrapher3, ilvSegmentedHyperEdge2, n, ilvManagerView, bl);
            CopyShapeApplyObject copyShapeApplyObject = new CopyShapeApplyObject();
            ilvHyperGrapher3.applyToObject(ilvSegmentedHyperEdge, copyShapeApplyObject, ilvSegmentedHyperEdge2, bl);
            ilvHyperGrapher3.removeObject(ilvSegmentedHyperEdge2, bl);
            hashMap = copyShapeApplyObject.a;
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            ilvHyperGrapher3.setContentsAdjusting(false, true);
            ilvHyperGrapher2.setContentsAdjusting(false, true);
            ilvHyperGrapher.setContentsAdjusting(false, true);
            throw throwable;
        }
        ilvHyperGrapher3.setContentsAdjusting(false, true);
        ilvHyperGrapher2.setContentsAdjusting(false, true);
        ilvHyperGrapher.setContentsAdjusting(false, true);
        return hashMap;
    }

    public static IlvGraphic getNode(IlvManagerView ilvManagerView, IlvPoint ilvPoint, boolean bl) {
        return IlvHyperGrapherUtil.getNode(ilvManagerView.getManager(), ilvPoint, ilvManagerView.getTransformer(), bl);
    }

    public static IlvGraphic getNode(IlvManager ilvManager, IlvPoint ilvPoint, IlvTransformer ilvTransformer, boolean bl) {
        IlvGraphicFilter ilvGraphicFilter = new IlvGraphicFilter(){

            public boolean accept(IlvGraphic ilvGraphic) {
                if (!(ilvGraphic.getGraphicBag() instanceof IlvGrapher)) {
                    return false;
                }
                IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphic.getGraphicBag();
                return ilvGrapher.isNode(ilvGraphic);
            }
        };
        return IlvHyperGrapherUtil.getObject(ilvManager, ilvPoint, ilvTransformer, ilvGraphicFilter, bl);
    }

    public static IlvHyperGrapherPin getHyperGrapherPin(IlvManagerView ilvManagerView, IlvPoint ilvPoint, boolean bl, boolean bl2) {
        IlvHyperEdgeConnector ilvHyperEdgeConnector;
        IlvGraphic ilvGraphic;
        IlvGraphicFilter ilvGraphicFilter = new IlvGraphicFilter(){

            public boolean accept(IlvGraphic ilvGraphic) {
                return ilvGraphic instanceof IlvHyperEdgePinConnector;
            }
        };
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector = (IlvHyperEdgePinConnector)IlvHyperGrapherUtil.getObject(ilvManagerView, ilvPoint, ilvGraphicFilter, bl);
        if (ilvHyperEdgePinConnector == null && (ilvGraphic = IlvHyperGrapherUtil.getNode(ilvManagerView, ilvPoint, bl)) != null && (ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic)) instanceof IlvHyperEdgePinConnector) {
            ilvHyperEdgePinConnector = (IlvHyperEdgePinConnector)ilvHyperEdgeConnector;
        }
        if (ilvHyperEdgePinConnector != null) {
            IlvRect ilvRect;
            ilvGraphic = (IlvManager)ilvHyperEdgePinConnector.getGraphicBag();
            ilvHyperEdgeConnector = ilvGraphic.getDrawingTransformer(ilvManagerView);
            IlvHyperGrapherPin ilvHyperGrapherPin = ilvHyperEdgePinConnector.getClosestPin(ilvPoint, (IlvTransformer)ilvHyperEdgeConnector);
            if (bl2 && ilvHyperGrapherPin != null && !(ilvRect = ilvHyperGrapherPin.boundingBox((IlvTransformer)ilvHyperEdgeConnector)).contains((Point2D)ilvPoint)) {
                ilvHyperGrapherPin = null;
            }
            return ilvHyperGrapherPin;
        }
        return null;
    }

    public static IlvHyperGrapherPin getHyperGrapherPin(IlvManager ilvManager, IlvPoint ilvPoint, IlvTransformer ilvTransformer, boolean bl, boolean bl2) {
        IlvHyperEdgeConnector ilvHyperEdgeConnector;
        IlvGraphic ilvGraphic;
        IlvGraphicFilter ilvGraphicFilter = new IlvGraphicFilter(){

            public boolean accept(IlvGraphic ilvGraphic) {
                return ilvGraphic instanceof IlvHyperEdgePinConnector;
            }
        };
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector = (IlvHyperEdgePinConnector)IlvHyperGrapherUtil.getObject(ilvManager, ilvPoint, ilvTransformer, ilvGraphicFilter, bl);
        if (ilvHyperEdgePinConnector == null && (ilvGraphic = IlvHyperGrapherUtil.getNode(ilvManager, ilvPoint, ilvTransformer, bl)) != null && (ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic)) instanceof IlvHyperEdgePinConnector) {
            ilvHyperEdgePinConnector = (IlvHyperEdgePinConnector)ilvHyperEdgeConnector;
        }
        if (ilvHyperEdgePinConnector != null) {
            IlvRect ilvRect;
            ilvGraphic = (IlvManager)ilvHyperEdgePinConnector.getGraphicBag();
            ilvHyperEdgeConnector = IlvGeometryUtil.getManagerTransformerFromTo(ilvManager, ilvTransformer, (IlvManager)ilvGraphic);
            IlvHyperGrapherPin ilvHyperGrapherPin = ilvHyperEdgePinConnector.getClosestPin(ilvPoint, (IlvTransformer)ilvHyperEdgeConnector);
            if (bl2 && ilvHyperGrapherPin != null && !(ilvRect = ilvHyperGrapherPin.boundingBox((IlvTransformer)ilvHyperEdgeConnector)).contains((Point2D)ilvPoint)) {
                ilvHyperGrapherPin = null;
            }
            return ilvHyperGrapherPin;
        }
        return null;
    }

    public static IlvGraphic getObject(IlvManagerView ilvManagerView, IlvPoint ilvPoint, IlvGraphicFilter ilvGraphicFilter, boolean bl) {
        return IlvHyperGrapherUtil.getObject(ilvManagerView.getManager(), ilvPoint, ilvManagerView.getTransformer(), ilvGraphicFilter, bl);
    }

    public static IlvGraphic getObject(IlvManager ilvManager, IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvGraphicFilter ilvGraphicFilter, boolean bl) {
        SearchApplyObject searchApplyObject = new SearchApplyObject();
        searchApplyObject.e = new IlvRect(ilvPoint.x - 1.0f, ilvPoint.y - 1.0f, 2.0f, 2.0f);
        searchApplyObject.c = new IlvPoint(ilvPoint);
        searchApplyObject.b = new IlvPoint(ilvPoint);
        searchApplyObject.g = bl;
        searchApplyObject.f = ilvGraphicFilter;
        searchApplyObject.d = ilvTransformer;
        if (ilvTransformer != null) {
            ilvTransformer.inverse(searchApplyObject.b);
        }
        ilvManager.mapIntersects((IlvApplyObject)searchApplyObject, null, searchApplyObject.e, ilvTransformer);
        return searchApplyObject.a;
    }

    public static boolean needsChangeGraphicBag(IlvHyperEdge ilvHyperEdge, IlvHyperEdge ilvHyperEdge2, IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvGraphic ilvGraphic) {
        HashSet<IlvGraphic> hashSet = new HashSet<IlvGraphic>();
        if (ilvHyperEdge != null) {
            IlvHyperGrapherUtil.a(ilvHyperEdge, ilvHyperEdgeEnd, hashSet);
        }
        if (ilvHyperEdge2 != null) {
            IlvHyperGrapherUtil.a(ilvHyperEdge2, ilvHyperEdgeEnd, hashSet);
        }
        if (ilvGraphic != null) {
            hashSet.add(ilvGraphic);
        }
        return IlvHyperGrapherUtil.needsChangeGraphicBag(ilvHyperEdge, hashSet);
    }

    public static boolean needsChangeGraphicBag(IlvHyperEdge ilvHyperEdge, Set set) {
        IlvGraphicBag ilvGraphicBag = ilvHyperEdge.getGraphicBag();
        for (IlvHyperGrapher ilvHyperGrapher = IlvHyperGrapher.getLowestCommonHyperGrapher(set.iterator()); ilvHyperGrapher != null; ilvHyperGrapher = ilvHyperGrapher.getParent()) {
            if (ilvHyperGrapher != ilvGraphicBag) continue;
            return false;
        }
        return true;
    }

    private static void a(IlvHyperEdge ilvHyperEdge, IlvHyperEdgeEnd ilvHyperEdgeEnd, HashSet hashSet) {
        IlvHyperEdgeEnd ilvHyperEdgeEnd2;
        Iterator iterator = ilvHyperEdge.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
            if (ilvHyperEdgeEnd2 == ilvHyperEdgeEnd) continue;
            hashSet.add(ilvHyperEdgeEnd2.getNode());
        }
        iterator = ilvHyperEdge.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
            if (ilvHyperEdgeEnd2 == ilvHyperEdgeEnd) continue;
            hashSet.add(ilvHyperEdgeEnd2.getNode());
        }
    }

    public static HashMap collectEndCoordinates(IlvHyperEdge ilvHyperEdge) {
        HashMap hashMap = new HashMap();
        IlvHyperGrapherUtil.collectEndCoordinates(ilvHyperEdge, hashMap);
        return hashMap;
    }

    public static void collectEndCoordinates(IlvHyperEdge ilvHyperEdge, Map map) {
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector;
        IlvHyperEdgeConnector ilvHyperEdgeConnector;
        IlvHyperGrapherPin ilvHyperGrapherPin;
        IlvTransformer ilvTransformer;
        IlvPoint ilvPoint;
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        Iterator iterator = ilvHyperEdge.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvPoint = ilvHyperEdgeEnd.getPosition(null, false);
            ilvTransformer = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdge, ilvHyperEdgeEnd.getNode());
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            ilvHyperGrapherPin = null;
            ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(ilvHyperEdgeEnd);
            if (ilvHyperEdgeConnector instanceof IlvHyperEdgePinConnector) {
                ilvHyperEdgePinConnector = (IlvHyperEdgePinConnector)ilvHyperEdgeConnector;
                ilvHyperGrapherPin = ilvHyperEdgePinConnector.getPin(ilvHyperEdgeEnd);
            }
            map.put(ilvHyperEdgeEnd, new Object[]{ilvPoint, ilvHyperGrapherPin});
        }
        iterator = ilvHyperEdge.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvPoint = ilvHyperEdgeEnd.getPosition(null, false);
            ilvTransformer = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdge, ilvHyperEdgeEnd.getNode());
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            ilvHyperGrapherPin = null;
            ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(ilvHyperEdgeEnd);
            if (ilvHyperEdgeConnector instanceof IlvHyperEdgePinConnector) {
                ilvHyperEdgePinConnector = (IlvHyperEdgePinConnector)ilvHyperEdgeConnector;
                ilvHyperGrapherPin = ilvHyperEdgePinConnector.getPin(ilvHyperEdgeEnd);
            }
            map.put(ilvHyperEdgeEnd, new Object[]{ilvPoint, ilvHyperGrapherPin});
        }
    }

    public static void repositionEndCoordinates(final IlvHyperEdge ilvHyperEdge, final Map map, final Map map2, boolean bl) {
        if (ilvHyperEdge.getGraphicBag() == null) {
            IlvHyperGrapherUtil.b(ilvHyperEdge, map, map2);
        } else {
            ilvHyperEdge.getGraphicBag().applyToObject((IlvGraphic)ilvHyperEdge, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvHyperGrapherUtil.b(ilvHyperEdge, map, map2);
                }
            }, null, bl);
        }
    }

    private static void b(IlvHyperEdge ilvHyperEdge, Map map, Map map2) {
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector;
        IlvTransformer ilvTransformer;
        IlvHyperGrapherPin ilvHyperGrapherPin;
        IlvPoint ilvPoint;
        Object[] objectArray;
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        IlvHyperEdgeEnd ilvHyperEdgeEnd2;
        Iterator iterator = ilvHyperEdge.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
            ilvHyperEdgeEnd = null;
            if (map2 != null) {
                ilvHyperEdgeEnd = (IlvHyperEdgeEnd)map2.get(ilvHyperEdgeEnd2);
            }
            if (ilvHyperEdgeEnd == null) continue;
            objectArray = (Object[])map.get(ilvHyperEdgeEnd);
            ilvPoint = (IlvPoint)objectArray[0];
            ilvHyperGrapherPin = (IlvHyperGrapherPin)objectArray[1];
            if (ilvPoint != null) {
                ilvTransformer = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdgeEnd2.getNode(), ilvHyperEdge);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint);
                }
                ilvHyperEdgeEnd2.setPosition(ilvPoint, null);
            }
            if (ilvHyperGrapherPin == null) continue;
            ilvHyperEdgePinConnector = ilvHyperGrapherPin.getHyperEdgeConnector();
            ilvHyperEdgePinConnector.connect(ilvHyperEdgeEnd2, ilvHyperGrapherPin);
        }
        iterator = ilvHyperEdge.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
            ilvHyperEdgeEnd = null;
            if (map2 != null) {
                ilvHyperEdgeEnd = (IlvHyperEdgeEnd)map2.get(ilvHyperEdgeEnd2);
            }
            if (ilvHyperEdgeEnd == null) continue;
            objectArray = (Object[])map.get(ilvHyperEdgeEnd);
            ilvPoint = (IlvPoint)objectArray[0];
            ilvHyperGrapherPin = (IlvHyperGrapherPin)objectArray[1];
            if (ilvPoint != null) {
                ilvTransformer = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdgeEnd2.getNode(), ilvHyperEdge);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint);
                }
                ilvHyperEdgeEnd2.setPosition(ilvPoint, null);
            }
            if (ilvHyperGrapherPin == null) continue;
            ilvHyperEdgePinConnector = ilvHyperGrapherPin.getHyperEdgeConnector();
            ilvHyperEdgePinConnector.connect(ilvHyperEdgeEnd2, ilvHyperGrapherPin);
        }
    }

    public static HashMap getInverseMapping(Map map) {
        if (map == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public static Object getKeyForValue(Map map, Object object) {
        if (map == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!entry.getValue().equals(object)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean hasColinearIncidentSegments(IlvSegmentedHyperEdge.Segment segment, IlvSegmentedHyperEdge.Segment segment2) {
        int n = segment2.getIncidentSegmentsCount();
        for (int i = 0; i < n; ++i) {
            IlvSegmentedHyperEdge.Segment segment3 = segment2.getIncidentSegment(i);
            if (segment3 == segment || !segment.isColinear(segment3)) continue;
            return true;
        }
        return false;
    }

    static class SearchApplyObject
    implements IlvApplyObject {
        IlvGraphic a;
        IlvPoint b;
        IlvPoint c;
        IlvTransformer d;
        IlvRect e;
        IlvGraphicFilter f;
        boolean g;

        SearchApplyObject() {
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            if (this.a != null) {
                return;
            }
            IlvManager ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
            if (!ilvManager.isVisible(ilvGraphic)) {
                return;
            }
            if (ilvGraphic instanceof IlvManager && ilvGraphic.contains(this.b, this.c, this.d) && this.g && !(ilvManager = (IlvManager)ilvGraphic).isCollapsed()) {
                IlvTransformer ilvTransformer = ilvManager.getTransformer();
                ilvTransformer.compose(this.d);
                IlvTransformer ilvTransformer2 = this.d;
                this.d = ilvTransformer;
                this.b.setLocation((Point2D)this.c);
                if (this.d != null) {
                    this.d.inverse(this.b);
                }
                ilvManager.mapIntersects((IlvApplyObject)this, null, this.e, this.d);
                this.d = ilvTransformer2;
                this.b.setLocation((Point2D)this.c);
                if (this.d != null) {
                    this.d.inverse(this.b);
                }
            }
            if (this.f.accept(ilvGraphic) && this.a == null && ilvGraphic.contains(this.b, this.c, this.d)) {
                this.a = ilvGraphic;
            }
        }
    }

    static class CopyShapeApplyObject
    implements IlvApplyObject {
        HashMap a;

        CopyShapeApplyObject() {
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            IlvSegmentedHyperEdge ilvSegmentedHyperEdge = (IlvSegmentedHyperEdge)ilvGraphic;
            IlvSegmentedHyperEdge ilvSegmentedHyperEdge2 = (IlvSegmentedHyperEdge)object;
            this.a = ilvSegmentedHyperEdge.copyShapeFrom(ilvSegmentedHyperEdge2);
        }
    }
}

