/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.uniformlengthedges;

import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.internalutil.FixedNodeInterface;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractGraph;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractGraphAdapter;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractNode;
import ilog.views.graphlayout.uniformlengthedges.IlvGraphCoarseningAlgo;
import ilog.views.graphlayout.uniformlengthedges.IlvMultilevelGraphPartitioningAlgo;
import ilog.views.graphlayout.uniformlengthedges.IlvMultipoleULELayout;
import ilog.views.graphlayout.uniformlengthedges.IlvRegularizationAlgo;
import ilog.views.graphlayout.uniformlengthedges.IlvSolarSystemNode;
import ilog.views.graphlayout.uniformlengthedges.IlvUniformLengthEdgesLayout;
import ilog.views.graphlayout.uniformlengthedges.IlvUniformLengthEdgesLayoutReport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;

final class IlvFMMAlgorithm
implements Serializable {
    private static final int a = 400;
    private static final int b = 700;
    private static final float c = 2.0f;
    private static final int d = 3;
    private static final double e = 0.05;
    private IlvUniformLengthEdgesLayout f;
    private IlvMultipoleULELayout g;

    public IlvFMMAlgorithm(IlvUniformLengthEdgesLayout ilvUniformLengthEdgesLayout) {
        this.f = ilvUniformLengthEdgesLayout;
    }

    public void detach() {
        if (this.g != null) {
            this.g.detach();
        }
    }

    public void doLayout(IlvGraphModel ilvGraphModel, boolean bl) throws IlvGraphLayoutException {
        int n;
        if (this.f.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this.f, false);
        }
        long l = System.currentTimeMillis();
        long l2 = this.f.getAllowedTime();
        this.g = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        IlvMultilevelGraphPartitioningAlgo ilvMultilevelGraphPartitioningAlgo = new IlvMultilevelGraphPartitioningAlgo();
        ilvMultilevelGraphPartitioningAlgo.run(ilvGraphModel, arrayList, arrayList2);
        int n2 = arrayList.size();
        if (n2 > 1) {
            IlvAbstractGraph ilvAbstractGraph = null;
            n = n2 - 1;
            int n3 = 400;
            int n4 = n2 > 1 ? 300 / n : 0;
            long l3 = 0L;
            int n5 = this.f.getAllowedNumberOfIterations();
            IlvRegularizationAlgo ilvRegularizationAlgo = new IlvRegularizationAlgo();
            for (int i = n; i >= 0; --i) {
                Object object;
                IlvAbstractGraph ilvAbstractGraph2 = (IlvAbstractGraph)arrayList.get(i);
                IlvGraphModel ilvGraphModel2 = (IlvGraphModel)arrayList2.get(i);
                if (i < n) {
                    ilvAbstractGraph = (IlvAbstractGraph)arrayList.get(i + 1);
                }
                l3 = (long)((float)l2 * (1.0f * (float)n3 / (float)n5));
                if (ilvAbstractGraph != null) {
                    this.a(ilvGraphModel2, ilvAbstractGraph, n3, l3, i, false, i == n, bl);
                }
                if (i < 1) continue;
                IlvAbstractGraph ilvAbstractGraph3 = (IlvAbstractGraph)arrayList.get(i - 1);
                IlvGraphModel ilvGraphModel3 = (IlvGraphModel)arrayList2.get(i - 1);
                n3 += n4;
                Enumeration enumeration = ilvAbstractGraph3.getNodes();
                while (enumeration.hasMoreElements()) {
                    object = (IlvSolarSystemNode)enumeration.nextElement();
                    IlvAbstractNode ilvAbstractNode = IlvGraphCoarseningAlgo.getSolarSystemNode((IlvAbstractNode)object);
                    IlvRect ilvRect = ilvAbstractGraph2.boundingBox(ilvAbstractNode);
                    ilvAbstractGraph3.move((IlvAbstractNode)object, ilvRect.x, ilvRect.y);
                }
                object = ilvGraphModel3;
                if (object instanceof TopLevelAbstractGraphAdapter) {
                    ((TopLevelAbstractGraphAdapter)object).setMoveInOriginalModel(false);
                }
                ilvRegularizationAlgo.regularize((IlvGraphModel)object, new FixedNodeInterface((IlvGraphModel)object){
                    final /* synthetic */ IlvGraphModel a;
                    {
                        this.a = ilvGraphModel;
                    }

                    public boolean isFixed(Object object) {
                        IlvSolarSystemNode ilvSolarSystemNode;
                        if (object instanceof IlvSolarSystemNode && (ilvSolarSystemNode = (IlvSolarSystemNode)object).getType() == 0) {
                            return true;
                        }
                        return this.a.getNodeDegree(object) < 2;
                    }
                });
            }
        }
        long l4 = System.currentTimeMillis() - l;
        long l5 = n2 > 1 ? (long)(2.0f * (float)l4) : l2;
        n = 100000000;
        this.a((IlvGraphModel)arrayList2.get(0), null, n, l5, -1, true, false, bl);
        IlvUniformLengthEdgesLayoutReport ilvUniformLengthEdgesLayoutReport = (IlvUniformLengthEdgesLayoutReport)this.f.getLayoutReport();
        ilvUniformLengthEdgesLayoutReport.setCode(5);
        ilvUniformLengthEdgesLayoutReport.b(this.f.getAllowedNumberOfIterations());
    }

    private void a(IlvGraphModel ilvGraphModel, IlvAbstractGraph ilvAbstractGraph, int n, long l, int n2, boolean bl, boolean bl2, boolean bl3) throws IlvGraphLayoutException {
        if (this.g == null) {
            this.g = new IlvMultipoleULELayout(this.f);
            this.g.setRespectNodeSizes(true);
            this.g.setPreserveFixedNodes(this.f.isPreserveFixedNodes());
            this.g.setAdditionalNodeRepulsionWeight(0.2f);
            this.g.setPreferredLinksLength(2.0f * this.f.getPreferredLinksLength());
            this.g.setMaxAllowedMovePerIteration(2.0f * this.f.getMaxAllowedMovePerIteration());
            this.g.setLinkStyle(0);
            this.g.setLinkLengthWeight(0.1f);
            this.g.setForceFitToLayoutRegion(this.f.isForceFitToLayoutRegion());
            this.g.setLayoutOfConnectedComponentsEnabled(this.f.isLayoutOfConnectedComponentsEnabled());
            IlvGraphLayout ilvGraphLayout = this.f.getLayoutOfConnectedComponents();
            if (ilvGraphLayout != null) {
                this.g.setLayoutOfConnectedComponents(ilvGraphLayout.copy());
            }
        }
        if (this.g.getGraphModel() != ilvGraphModel) {
            boolean bl4 = ilvGraphModel.isInternalGraphModelChecking();
            ilvGraphModel.setInternalGraphModelChecking(false);
            this.g.setGraphModel(ilvGraphModel);
            ilvGraphModel.setInternalGraphModelChecking(bl4);
        }
        if (n2 == 0) {
            this.g.setPreferredLinksLength(this.f.getPreferredLinksLength());
            this.g.setRespectNodeSizes(this.f.isRespectNodeSizes());
            this.g.setAdditionalNodeRepulsionWeight(this.f.getAdditionalNodeRepulsionWeight());
        }
        this.g.c(bl);
        this.g.setAllowedNumberOfIterations(n);
        this.g.setAllowedTime(l);
        this.g.setLayoutMode(!bl2 || bl ? 10 : 11);
        if (bl && ilvGraphModel instanceof TopLevelAbstractGraphAdapter) {
            ((TopLevelAbstractGraphAdapter)ilvGraphModel).setMoveInOriginalModel(true);
            this.g.setConvergenceThreshold(this.f.getConvergenceThreshold());
            this.g.setLinkLengthWeight(this.f.getLinkLengthWeight());
            this.g.setLinkStyle(this.f.getLinkStyle());
        }
        this.g.d().a(bl2 ? 12 : 10);
        boolean bl5 = this.g.getLayoutMode() == 10;
        IlvUniformLengthEdgesLayoutReport ilvUniformLengthEdgesLayoutReport = null;
        if (bl5) {
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            double d = (double)l * 0.05;
            for (int i = 0; i < 3 && (double)l3 < d; ++i) {
                ilvUniformLengthEdgesLayoutReport = (IlvUniformLengthEdgesLayoutReport)this.g.performLayout(ilvAbstractGraph, bl2, bl3);
                l3 = System.currentTimeMillis() - l2;
            }
        } else {
            ilvUniformLengthEdgesLayoutReport = (IlvUniformLengthEdgesLayoutReport)this.g.performLayout(ilvAbstractGraph, bl2, bl3);
        }
        this.f.callLayoutStepPerformedIfNeeded();
    }

    static class TopLevelAbstractGraphAdapter
    extends IlvAbstractGraphAdapter {
        private IlvGraphModel a;
        private boolean b = false;

        public TopLevelAbstractGraphAdapter(IlvAbstractGraph ilvAbstractGraph, IlvGraphModel ilvGraphModel) {
            super(ilvAbstractGraph);
            if (ilvGraphModel == null) {
                throw new IllegalArgumentException("graphModel cannot be null");
            }
            this.a = ilvGraphModel;
        }

        public void moveNode(Object object, float f, float f2, boolean bl) {
            if (this.b) {
                Object object2 = ((IlvAbstractNode)object).getOriginalObject();
                this.a.moveNode(object2, f, f2, bl);
            } else {
                super.moveNode(object, f, f2, bl);
            }
        }

        public void setMoveInOriginalModel(boolean bl) {
            this.b = bl;
        }

        public boolean isMoveInOriginalModel() {
            return this.b;
        }
    }
}

