/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.internalutil;

import ilog.views.IlvConstantModeManagerFrame;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.IlvLayoutProvider;
import ilog.views.graphlayout.bus.IlvBusLayout;
import ilog.views.graphlayout.internalutil.GenericLayoutUtil;
import ilog.views.graphlayout.internalutil.SubgraphData;
import ilog.views.graphlayout.multiple.IlvMultipleLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class LayoutUtil
implements Serializable {
    public static final String ONLY_FOR_GRAPHER_METHOD = "This method can be called only if the attached graph is " + LayoutUtil.getText("an IlvGrapher or IlvGrapherAdapter", "a GraphicContainer or GraphicContainerAdapter");
    public static final String NO_ATTACHED_GRAPH_MODEL_OR_NULL = "no attached graph model or graph model is null";
    public static final String NODE_NOT_IN_GRAPHER = "node must be a node in the attached " + LayoutUtil.getText("grapher", "graphic container");
    public static final String NODE_REJECTED_BY_FILTER = "node must be a node which is accepted by the filtering mechanism";
    public static final String MUST_BE_CALLED_AFTER_LAYOUT = "you must call this method after the layout is performed on the current graph";
    private static final double a = Math.PI;
    private static final double b = Math.PI * 2;
    private static final float c = Float.MAX_VALUE;
    private static final float d = Float.POSITIVE_INFINITY;
    private static final float e = Float.NEGATIVE_INFINITY;
    private static final Enumeration f = new IlvVoidEnumeration();
    private static final Iterator g = new IlvVoidIterator();
    private static final IlvGraphicEnumeration h = new IlvVoidGraphicEnumeration();
    public static final String CHECK_APPROPRIATE_LINKS_NEEDED = "__CheckAppropriateLinksNeeded";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean IsValidNumber(float f, float f2) {
        if (!(f < Float.MAX_VALUE)) return false;
        if (!(-f < Float.MAX_VALUE)) return false;
        if (!(f2 < Float.MAX_VALUE)) return false;
        if (!(-f2 < Float.MAX_VALUE)) return false;
        if (f == Float.POSITIVE_INFINITY) return false;
        if (f == Float.NEGATIVE_INFINITY) return false;
        if (f2 == Float.POSITIVE_INFINITY) return false;
        if (f2 == Float.NEGATIVE_INFINITY) return false;
        if (Float.isNaN(f)) return false;
        if (Float.isNaN(f2)) return false;
        return true;
    }

    public static void CheckAppropriateLinks(IlvGraphLayout ilvGraphLayout, Enumeration enumeration) throws IlvInappropriateLinkException {
        LayoutUtil.CheckAppropriateLinks(ilvGraphLayout, enumeration, null);
    }

    public static void CheckAppropriateLinks(IlvGraphLayout ilvGraphLayout, Enumeration enumeration, Enumeration enumeration2) throws IlvInappropriateLinkException {
        boolean bl;
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel == null) {
            throw new RuntimeException(NO_ATTACHED_GRAPH_MODEL_OR_NULL);
        }
        boolean bl2 = ilvGraphModel.isLinkCheckEnabled();
        boolean bl3 = ilvGraphModel.isConnectionPointCheckEnabled();
        boolean bl4 = bl = ilvGraphLayout.supportsPreserveFixedLinks() && ilvGraphLayout.isPreserveFixedLinks();
        if (bl2 || bl3) {
            Object e;
            int n = 0;
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                if (bl && ilvGraphLayout.isFixed(e)) continue;
                n |= ilvGraphLayout.checkAppropriateLink(e);
            }
            if (enumeration2 != null) {
                while (enumeration2.hasMoreElements()) {
                    e = enumeration2.nextElement();
                    if (bl && ilvGraphLayout.isFixed(e)) continue;
                    n |= ilvGraphLayout.checkAppropriateLink(e);
                }
            }
            if (n != 0) {
                throw new IlvInappropriateLinkException(ilvGraphModel instanceof SubgraphData ? ((SubgraphData)ilvGraphModel).getOriginalModel() : ilvGraphModel, ilvGraphLayout, n);
            }
        }
    }

    public static void CheckAppropriateLinks(IlvGraphLayout ilvGraphLayout, IlvLayoutProvider ilvLayoutProvider, IlvGraphModel ilvGraphModel, boolean bl, boolean bl2) throws IlvInappropriateLinkException {
        if (ilvGraphLayout == null) {
            return;
        }
        if (!bl && !bl2) {
            return;
        }
        IlvGraphModel ilvGraphModel2 = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel2 == null) {
            throw new RuntimeException(NO_ATTACHED_GRAPH_MODEL_OR_NULL);
        }
        Enumeration enumeration = bl ? ilvGraphModel2.getLinks() : ilvGraphModel2.getInterGraphLinks();
        Enumeration enumeration2 = bl && bl2 ? ilvGraphModel2.getInterGraphLinks() : null;
        LayoutUtil.CheckAppropriateLinks(ilvGraphLayout, enumeration, enumeration2);
        if (ilvLayoutProvider != null) {
            Enumeration enumeration3 = ilvGraphModel2.getSubgraphs();
            while (enumeration3.hasMoreElements()) {
                Object e = enumeration3.nextElement();
                IlvGraphModel ilvGraphModel3 = ilvGraphModel.getGraphModel(e);
                IlvGraphLayout ilvGraphLayout2 = ilvLayoutProvider.getGraphLayout(ilvGraphModel3);
                LayoutUtil.CheckAppropriateLinks(ilvGraphLayout2, ilvLayoutProvider, ilvGraphModel, bl, bl2);
            }
        }
    }

    public static int CheckAppropriateLinkConnection(Object object, IlvGraphModel ilvGraphModel) {
        int n = 0;
        if (ilvGraphModel.isConnectionPointCheckEnabled()) {
            if (!ilvGraphModel.hasMoveableConnectionPoint(object, true)) {
                n |= 4;
                n |= 0x20;
            }
            if (!ilvGraphModel.hasMoveableConnectionPoint(object, false)) {
                n |= 4;
                n |= 0x20;
            }
        }
        return n;
    }

    public static IlvGraphicVector getDefaultMovingNodes(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel instanceof IlvGrapherAdapter) {
            IlvGraphicVector ilvGraphicVector = new IlvGraphicVector();
            IlvGrapher ilvGrapher = ilvGraphModel.getGrapher();
            Enumeration enumeration = ilvGraphModel.getNodes();
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic;
                Object e = enumeration.nextElement();
                if (!(e instanceof IlvGraphic) || (ilvGraphic = (IlvGraphic)e).getGraphicBag() != ilvGrapher) continue;
                ilvGraphicVector.addElement(ilvGraphic);
            }
            return ilvGraphicVector.size() > 0 ? ilvGraphicVector : null;
        }
        return null;
    }

    public static IlvGraphModel getRootModel(IlvGraphModel ilvGraphModel) {
        IlvGraphModel ilvGraphModel2 = ilvGraphModel.getRootModel();
        if (ilvGraphModel2 == null) {
            return ilvGraphModel;
        }
        return ilvGraphModel2;
    }

    public static Object ElementAt(ArrayList arrayList, int n, int n2, boolean bl) {
        return bl ? arrayList.get(n2 - n - 1) : arrayList.get(n);
    }

    public static final float getValueInManagerCoordinates(float f, IlvTransformer ilvTransformer) {
        if (ilvTransformer == null || ilvTransformer.isIdentity()) {
            return f;
        }
        double d = ilvTransformer.zoomFactor();
        if (d == 0.0) {
            throw new RuntimeException("Zoom factor is not allowed to be zero. Transformer on reference view: " + ilvTransformer);
        }
        return (float)((double)f / d);
    }

    public static final boolean IsEmpty(IlvGraphModel ilvGraphModel) {
        Enumeration enumeration = ilvGraphModel.getNodes();
        return enumeration == null ? true : !enumeration.hasMoreElements();
    }

    public static final IlvRect BoundingBox(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (ilvTransformer == null || ilvTransformer.isIdentity()) {
            return ilvGraphic.boundingBox(null);
        }
        IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
        ilvTransformer.inverse(ilvRect);
        return ilvRect;
    }

    public static final IlvRect BoundingBox(IlvGraphModel ilvGraphModel, Enumeration enumeration, IlvRect ilvRect) {
        ilvRect.reshape(0.0f, 0.0f, 0.0f, 0.0f);
        if (!enumeration.hasMoreElements()) {
            return ilvRect;
        }
        Object e = enumeration.nextElement();
        IlvRect ilvRect2 = ilvGraphModel.boundingBox(e);
        ilvRect.reshape(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height);
        IlvRect ilvRect3 = null;
        while (enumeration.hasMoreElements()) {
            ilvRect3 = ilvGraphModel.boundingBox(enumeration.nextElement());
            if (ilvRect3 == null) continue;
            LayoutUtil.a(ilvRect, ilvRect3);
        }
        return ilvRect;
    }

    public static final IlvRect BoundingBox(IlvGraphModel ilvGraphModel, Iterator iterator, IlvRect ilvRect) {
        ilvRect.reshape(0.0f, 0.0f, 0.0f, 0.0f);
        if (!iterator.hasNext()) {
            return ilvRect;
        }
        Object e = iterator.next();
        IlvRect ilvRect2 = ilvGraphModel.boundingBox(e);
        ilvRect.reshape(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height);
        IlvRect ilvRect3 = null;
        while (iterator.hasNext()) {
            ilvRect3 = ilvGraphModel.boundingBox(iterator.next());
            if (ilvRect3 == null) continue;
            LayoutUtil.a(ilvRect, ilvRect3);
        }
        return ilvRect;
    }

    public static final IlvRect BoundingBox(IlvGraphModel ilvGraphModel, ArrayList arrayList, IlvRect ilvRect) {
        ilvRect.reshape(0.0f, 0.0f, 0.0f, 0.0f);
        if (arrayList.isEmpty()) {
            return ilvRect;
        }
        Object e = arrayList.get(0);
        IlvRect ilvRect2 = ilvGraphModel.boundingBox(e);
        ilvRect.reshape(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height);
        if (arrayList.size() > 1) {
            IlvRect ilvRect3 = null;
            for (Object e2 : arrayList) {
                if (e2 == e || (ilvRect3 = ilvGraphModel.boundingBox(e2)) == null) continue;
                LayoutUtil.a(ilvRect, ilvRect3);
            }
        }
        return ilvRect;
    }

    private static void a(IlvRect ilvRect, IlvRect ilvRect2) {
        double d = ilvRect.x;
        double d2 = ilvRect2.x;
        double d3 = d < d2 ? d : d2;
        double d4 = d > d2 ? (d += (double)ilvRect.width) : (d2 += (double)ilvRect2.width);
        d = ilvRect.y;
        d2 = ilvRect2.y;
        double d5 = d < d2 ? d : d2;
        double d6 = d > d2 ? (d += (double)ilvRect.height) : (d2 += (double)ilvRect2.height);
        ilvRect.x = (float)d3;
        ilvRect.y = (float)d5;
        ilvRect.width = (float)(d4 - d3);
        ilvRect.height = (float)(d6 - d5);
    }

    public static final double getDistance(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public static final float getDiagonal(Object object, IlvGraphModel ilvGraphModel) {
        IlvRect ilvRect = ilvGraphModel.boundingBox(object);
        return (float)Math.sqrt(ilvRect.width * ilvRect.width + ilvRect.height * ilvRect.height);
    }

    public static final double getEqualSidesTriangleAngle(float f, float f2) {
        return f == 0.0f ? 0.0 : (f2 <= 2.0f * f ? 2.0 * Math.asin(f2 / (2.0f * f)) : 0.0);
    }

    public static final double Angle(float f, float f2, float f3, float f4) {
        double d;
        float f5 = f3 - f;
        float f6 = f4 - f2;
        if (f5 == 0.0f && f6 == 0.0f) {
            return 0.0;
        }
        if (f5 >= 0.0f && f6 >= 0.0f) {
            d = 0.0;
        } else if (f5 < 0.0f && f6 < 0.0f) {
            d = Math.PI;
        } else if (f5 < 0.0f) {
            float f7 = f5;
            f5 = f6;
            f6 = -f7;
            d = 1.5707963267948966;
        } else {
            float f8 = f5;
            f5 = -f6;
            f6 = f8;
            d = 4.71238898038469;
        }
        d = f5 == 0.0f ? (d += 1.5707963267948966) : (f6 == 0.0f ? (d += 0.0) : (f5 < f6 ? (d += Math.atan((double)f6 / (double)f5)) : (d += 1.5707963267948966 - Math.atan((double)f5 / (double)f6))));
        LayoutUtil.CorrectAngle(d);
        return d;
    }

    public static final double CorrectAngle(double d) {
        if (d < 0.0) {
            while ((d += Math.PI * 2) < 0.0) {
            }
            return d;
        }
        if (d > Math.PI * 2) {
            while ((d -= Math.PI * 2) > Math.PI * 2) {
            }
            return d;
        }
        return d;
    }

    public static final double GetOrientedDeltaAlpha(double d, double d2) {
        if (d2 < 0.0 || d < 0.0 || d2 > Math.PI * 2 || d > Math.PI * 2) {
            throw new IllegalArgumentException("angle must be from zero to 2pi");
        }
        return d2 <= d ? d - d2 : Math.PI * 2 - d2 + d;
    }

    public static final double GetOrientedDeltaAlpha1(double d, double d2) {
        double d3;
        double d4 = d3 = d2 <= d ? d - d2 : Math.PI * 2 - d2 + d;
        if (d3 < 0.0) {
            d3 = -d3;
        }
        return d3 < Math.PI ? d3 : Math.PI;
    }

    public static final double GetDeltaAlpha(double d, double d2) {
        double d3;
        double d4 = d - d2;
        if (d4 < 0.0) {
            d4 = -d4;
        }
        double d5 = d4 < (d3 = Math.PI * 2 - d4) ? d4 : d3;
        return d5 > 0.0 ? d5 : -d5;
    }

    public static final boolean Intersects(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4) {
        return LayoutUtil.Intersects(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y, ilvPoint4.x, ilvPoint4.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean Intersects(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        int n = LayoutUtil.GetTripletOrientation(f, f2, f3, f4, f5, f6);
        int n2 = LayoutUtil.GetTripletOrientation(f, f2, f3, f4, f7, f8);
        int n3 = LayoutUtil.GetTripletOrientation(f5, f6, f7, f8, f, f2);
        int n4 = LayoutUtil.GetTripletOrientation(f5, f6, f7, f8, f3, f4);
        if (n * n2 == -1) {
            if (n3 * n4 == -1) return true;
        }
        if (n != 0) return false;
        if (n2 != 0) return false;
        if (n3 != 0) return false;
        if (n4 != 0) return false;
        if (!(f > (f5 < f7 ? f5 : f7)) || !(f < (f5 > f7 ? f5 : f7))) {
            float f9 = f < f3 ? f : f3;
            if (!(f5 > f9)) return false;
            float f10 = f > f3 ? f : f3;
            if (!(f5 < f10)) return false;
        }
        float f11 = f6 < f8 ? f6 : f8;
        if (f2 > f11) {
            if (f2 < (f6 > f8 ? f6 : f8)) return true;
        }
        float f12 = f2 < f4 ? f2 : f4;
        if (!(f6 > f12)) return false;
        float f13 = f2 > f4 ? f2 : f4;
        if (!(f6 < f13)) return false;
        return true;
    }

    public static boolean IntersectsOrthogonal(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4) {
        return LayoutUtil.IntersectsOrthogonal(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y, ilvPoint4.x, ilvPoint4.y);
    }

    public static boolean IntersectsOrthogonal(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        boolean bl;
        boolean bl2 = f2 == f4;
        boolean bl3 = bl = f6 == f8;
        if (bl2) {
            if (!bl) {
                float f9 = f6 <= f8 ? f6 : f8;
                if (f9 < f2) {
                    float f10 = f6 >= f8 ? f6 : f8;
                    if (f10 > f2) {
                        float f11 = f <= f3 ? f : f3;
                        if (f11 < f5) {
                            float f12 = f >= f3 ? f : f3;
                            if (f12 > f5) {
                                return true;
                            }
                        }
                    }
                }
            }
            if (f2 == f6) {
                return LayoutUtil.OverlappingCoords(f, f3, f5, f7, 0.0f, 0.0f);
            }
        } else {
            if (bl) {
                float f13 = f5 <= f7 ? f5 : f7;
                if (f13 < f) {
                    float f14 = f5 >= f7 ? f5 : f7;
                    if (f14 > f) {
                        float f15 = f2 <= f4 ? f2 : f4;
                        if (f15 < f6) {
                            float f16 = f2 >= f4 ? f2 : f4;
                            if (f16 > f6) {
                                return true;
                            }
                        }
                    }
                }
            }
            if (f == f5) {
                return LayoutUtil.OverlappingCoords(f2, f4, f6, f8, 0.0f, 0.0f);
            }
        }
        return false;
    }

    public static boolean OverlappingCoords(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        float f9;
        float f10;
        if (f < f2) {
            f10 = f;
            f9 = f2;
        } else {
            f10 = f2;
            f9 = f;
        }
        if (f5 != 0.0f) {
            f10 -= f5;
            f9 += f5;
        }
        if (f3 < f4) {
            f8 = f3;
            f7 = f4;
        } else {
            f8 = f4;
            f7 = f3;
        }
        if (f6 != 0.0f) {
            f8 -= f6;
            f7 += f6;
        }
        return f10 >= f8 && f10 < f7 || f9 > f8 && f9 < f7 || f8 >= f10 && f8 < f9 || f7 > f10 && f7 < f9;
    }

    public static final int GetTripletOrientation(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f * f4 - f3 * f2 + f5 * f2 - f * f6 + f3 * f6 - f5 * f4;
        if (f7 > 0.0f) {
            return -1;
        }
        if (f7 < 0.0f) {
            return 1;
        }
        return 0;
    }

    public static final String GetExceptionMessage(IlvGraphic ilvGraphic, String string) {
        return ilvGraphic != null ? "Object " + ilvGraphic + " " + string : "Object cannot be null";
    }

    public static final IlvRect GetEstimatedLayoutRegion(IlvGraphModel ilvGraphModel) {
        return LayoutUtil.GetEstimatedLayoutRegion(null, ilvGraphModel);
    }

    public static final IlvRect GetEstimatedLayoutRegion(IlvGraphLayout ilvGraphLayout, IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        Enumeration enumeration = ilvGraphModel.getNodes();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        Object var9_6 = null;
        IlvPolyPointsInterface ilvPolyPointsInterface = null;
        if (ilvGraphLayout instanceof IlvBusLayout) {
            IlvBusLayout ilvBusLayout = (IlvBusLayout)ilvGraphLayout;
            ilvPolyPointsInterface = ilvBusLayout.getBus();
        }
        while (enumeration.hasMoreElements()) {
            var9_6 = enumeration.nextElement();
            if (var9_6 == ilvPolyPointsInterface) continue;
            IlvRect ilvRect = ilvGraphModel.boundingBox(var9_6);
            d += (double)ilvRect.width;
            d2 += (double)ilvRect.height;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        double d3 = 2.0 / Math.sqrt(n);
        float f = (float)(d * d3);
        float f2 = (float)(d2 * d3);
        float f3 = 0.0f;
        float f4 = 0.0f;
        return new IlvRect(f3, f4, f, f2);
    }

    public static final void Clip(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        dArray[0] = ilvPoint.x;
        dArray[1] = ilvPoint.y;
        dArray2[0] = ilvPoint2.x;
        dArray2[1] = ilvPoint2.y;
        dArray3[0] = ilvRect.x;
        dArray3[1] = ilvRect.x + ilvRect.width;
        dArray3[2] = ilvRect.y;
        dArray3[3] = ilvRect.y + ilvRect.height;
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        ilvPoint.x = (float)dArray[0];
        ilvPoint.y = (float)dArray[1];
    }

    public static final void Clip(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = LayoutUtil.RayAtX(dArray, dArray2, dArray3[0]);
        if (d != Double.MAX_VALUE && LayoutUtil.a(dArray3[2], dArray3[3], d)) {
            dArray[0] = dArray3[0];
            dArray[1] = d;
            return;
        }
        d = LayoutUtil.RayAtX(dArray, dArray2, dArray3[1]);
        if (d != Double.MAX_VALUE && LayoutUtil.a(dArray3[2], dArray3[3], d)) {
            dArray[0] = dArray3[1];
            dArray[1] = d;
            return;
        }
        d = LayoutUtil.RayAtY(dArray, dArray2, dArray3[2]);
        if (d != Double.MAX_VALUE && LayoutUtil.a(dArray3[0], dArray3[1], d)) {
            dArray[0] = d;
            dArray[1] = dArray3[2];
            return;
        }
        d = LayoutUtil.RayAtY(dArray, dArray2, dArray3[3]);
        if (d != Double.MAX_VALUE && LayoutUtil.a(dArray3[0], dArray3[1], d)) {
            dArray[0] = d;
            dArray[1] = dArray3[3];
            return;
        }
    }

    static boolean a(double d, double d2, double d3) {
        return d <= d3 && d2 >= d3 || d >= d3 && d2 <= d3;
    }

    static boolean b(double d, double d2, double d3) {
        return d < d2 && d < d3 || d > d2 && d > d3;
    }

    public static final double RayAtX(double[] dArray, double[] dArray2, double d) {
        if (dArray[0] == d) {
            return dArray[1];
        }
        if (dArray2[0] == d) {
            return dArray2[1];
        }
        if (LayoutUtil.b(dArray[0], dArray2[0], d)) {
            double d2 = dArray[1] - dArray2[1];
            double d3 = dArray[0] - dArray2[0];
            return d2 * (d - dArray[0]) / d3 + dArray[1];
        }
        return Double.MAX_VALUE;
    }

    public static final double RayAtY(double[] dArray, double[] dArray2, double d) {
        if (dArray[1] == d) {
            return dArray[0];
        }
        if (dArray2[1] == d) {
            return dArray2[0];
        }
        if (LayoutUtil.b(dArray[1], dArray2[1], d)) {
            double d2 = dArray[0] - dArray2[0];
            double d3 = dArray[1] - dArray2[1];
            return d2 * (d - dArray[1]) / d3 + dArray[0];
        }
        return Double.MAX_VALUE;
    }

    public static final String LayoutName(Class clazz) {
        String string = clazz.getName();
        int n = -1;
        if (string.startsWith(GenericLayoutUtil.LAYOUT_BASE_PACKAGE_NAME + ".")) {
            n = string.lastIndexOf(46);
        }
        if (n >= 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static final IlvGraphLayout AllocateLayoutClass(String string) {
        String string2 = GenericLayoutUtil.LAYOUT_BASE_PACKAGE_NAME;
        if (string == null) {
            return null;
        }
        string2 = string.equals("IlvBusLayout") ? string2 + ".bus." : (string.equals("IlvCircularLayout") ? string2 + ".circular." : (string.equals("IlvGridLayout") ? string2 + ".grid." : (string.equals("IlvHierarchicalLayout") ? string2 + ".hierarchical." : (string.equals("IlvLinkLayout") ? string2 + ".link." : (string.equals("IlvLongLinkLayout") ? string2 + ".link.longlink." : (string.equals("IlvShortLinkLayout") ? string2 + ".link.shortlink." : (string.equals("IlvMultipleLayout") ? string2 + ".multiple." : (string.equals("IlvRandomLayout") ? string2 + ".random." : (string.equals("IlvRecursiveLayout") ? string2 + ".recursive." : (string.equals("IlvSpringEmbedderLayout") ? string2 + ".springembedder." : (string.equals("IlvTopologicalMeshLayout") ? string2 + ".topologicalmesh." : (string.equals("IlvTreeLayout") ? string2 + ".tree." : (string.equals("IlvUniformLengthEdgesLayout") ? string2 + ".uniformlengthedges." : "")))))))))))));
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string2 + string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage() + " [couldn't load class " + string2 + string + "]", exception);
        }
        if (!IlvGraphLayout.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("Wrong layout class: the class " + string2 + string + " is not a subclass of " + IlvGraphLayout.class);
        }
        IlvGraphLayout ilvGraphLayout = null;
        try {
            ilvGraphLayout = (IlvGraphLayout)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage() + " [couldn't instanciate class " + string2 + string + "]", exception);
        }
        return ilvGraphLayout;
    }

    public static String getText(String string, String string2) {
        return string;
    }

    public static final Enumeration GetEnumeration(Iterator iterator) {
        return iterator.hasNext() ? new IteratorWrapper(iterator) : f;
    }

    public static final Enumeration GetEnumeration(ArrayList arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return f;
        }
        return new IteratorWrapper(arrayList.iterator());
    }

    public static final Enumeration GetVoidEnumeration() {
        return f;
    }

    public static final Iterator GetVoidIterator() {
        return g;
    }

    public static final IlvGraphicEnumeration GetVoidGraphicEnumeration() {
        return h;
    }

    public static final int GetEnumerationCount(Enumeration enumeration) {
        if (enumeration == null) {
            return 0;
        }
        int n = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    public static void fixConstantModeManagerFrameAutoMargin(IlvGraphModel ilvGraphModel, Object object) {
        IlvManager ilvManager;
        IlvManagerFrame ilvManagerFrame;
        IlvGrapherAdapter ilvGrapherAdapter;
        if (ilvGraphModel instanceof IlvGrapherAdapter && (ilvGrapherAdapter = (IlvGrapherAdapter)ilvGraphModel).isConstantModeManagerFrameAutoMargin() && object instanceof IlvManager && (ilvManagerFrame = (ilvManager = (IlvManager)object).getFrame()) instanceof IlvConstantModeManagerFrame) {
            IlvConstantModeManagerFrame ilvConstantModeManagerFrame = (IlvConstantModeManagerFrame)ilvManagerFrame;
            ilvConstantModeManagerFrame.setTopMargin(0.0f);
            ilvConstantModeManagerFrame.setBottomMargin(0.0f);
            ilvConstantModeManagerFrame.setLeftMargin(0.0f);
            ilvConstantModeManagerFrame.setRightMargin(0.0f);
        }
    }

    public static String GetPositionInMultipleLayout(IlvGraphLayout ilvGraphLayout, IlvGraphLayout ilvGraphLayout2) {
        if (ilvGraphLayout == ilvGraphLayout2) {
            return "";
        }
        if (ilvGraphLayout2 instanceof IlvMultipleLayout) {
            IlvMultipleLayout ilvMultipleLayout = (IlvMultipleLayout)ilvGraphLayout2;
            String string = LayoutUtil.GetPositionInMultipleLayout(ilvGraphLayout, ilvMultipleLayout.getFirstGraphLayout());
            if (string != null) {
                return "1" + string;
            }
            string = LayoutUtil.GetPositionInMultipleLayout(ilvGraphLayout, ilvMultipleLayout.getSecondGraphLayout());
            if (string != null) {
                return "2" + string;
            }
        }
        return null;
    }

    public static IlvGraphLayout GetLayoutFromPositionInMultipleLayout(IlvGraphLayout ilvGraphLayout, String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!(ilvGraphLayout instanceof IlvMultipleLayout)) {
                return null;
            }
            IlvMultipleLayout ilvMultipleLayout = (IlvMultipleLayout)ilvGraphLayout;
            ilvGraphLayout = string.charAt(i) == '1' ? ilvMultipleLayout.getFirstGraphLayout() : ilvMultipleLayout.getSecondGraphLayout();
        }
        return ilvGraphLayout;
    }

    private static class IteratorWrapper
    implements Enumeration {
        private Iterator a;

        IteratorWrapper(Iterator iterator) {
            this.a = iterator;
        }

        public boolean hasMoreElements() {
            return this.a.hasNext();
        }

        public Object nextElement() {
            return this.a.next();
        }
    }

    private static class IlvVoidIterator
    implements Iterator {
        private IlvVoidIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("IlvVoidIterator");
        }

        public void remove() {
        }
    }

    private static class IlvVoidEnumeration
    implements Enumeration {
        private IlvVoidEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("IlvVoidEnumeration");
        }
    }

    private static class IlvVoidGraphicEnumeration
    implements IlvGraphicEnumeration {
        private IlvVoidGraphicEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public IlvGraphic nextElement() {
            throw new NoSuchElementException("IlvVoidGraphicEnumeration");
        }
    }

    public static final class IlvDoubleArrayListEnumerator
    implements Enumeration {
        private ArrayList a;
        private ArrayList b;
        private int c;

        public IlvDoubleArrayListEnumerator(ArrayList arrayList, ArrayList arrayList2) {
            this.a = arrayList;
            this.b = arrayList2;
            this.c = 0;
        }

        public boolean hasMoreElements() {
            if (this.a == null && this.b == null) {
                return false;
            }
            if (this.a == null) {
                return this.c < this.b.size();
            }
            if (this.b == null) {
                return this.c < this.a.size();
            }
            return this.c < this.a.size() + this.b.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            int n = 0;
            int n2 = 0;
            if (this.a != null) {
                n = this.a.size();
            }
            if (this.b != null) {
                n2 = this.b.size();
            }
            if (n > 0) {
                if (this.c < n) {
                    ArrayList arrayList = this.a;
                    synchronized (arrayList) {
                        return this.a.get(this.c++);
                    }
                }
                if (n2 > 0) {
                    if (this.c - n < n2) {
                        ArrayList arrayList = this.b;
                        synchronized (arrayList) {
                            return this.b.get(this.c++ - n);
                        }
                    }
                    throw new NoSuchElementException("IlvDoubleArrayListEnumerator");
                }
            } else if (n2 > 0 && this.c < n2) {
                ArrayList arrayList = this.b;
                synchronized (arrayList) {
                    return this.b.get(this.c++);
                }
            }
            throw new NoSuchElementException("IlvDoubleArrayListEnumerator");
        }
    }

    public static final class IlvDoubleVectorEnumerator
    implements Enumeration {
        private Vector a;
        private Vector b;
        private int c;

        public IlvDoubleVectorEnumerator(Vector vector, Vector vector2) {
            this.a = vector;
            this.b = vector2;
            this.c = 0;
        }

        public boolean hasMoreElements() {
            if (this.a == null && this.b == null) {
                return false;
            }
            if (this.a == null) {
                return this.c < this.b.size();
            }
            if (this.b == null) {
                return this.c < this.a.size();
            }
            return this.c < this.a.size() + this.b.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            int n = 0;
            int n2 = 0;
            if (this.a != null) {
                n = this.a.size();
            }
            if (this.b != null) {
                n2 = this.b.size();
            }
            if (n > 0) {
                if (this.c < n) {
                    Vector vector = this.a;
                    synchronized (vector) {
                        return this.a.elementAt(this.c++);
                    }
                }
                if (n2 > 0) {
                    if (this.c - n < n2) {
                        Vector vector = this.b;
                        synchronized (vector) {
                            return this.b.elementAt(this.c++ - n);
                        }
                    }
                    throw new NoSuchElementException("IlvDoubleVectorEnumerator");
                }
            } else if (n2 > 0 && this.c < n2) {
                Vector vector = this.b;
                synchronized (vector) {
                    return this.b.elementAt(this.c++);
                }
            }
            throw new NoSuchElementException("IlvDoubleVectorEnumerator");
        }
    }

    public static final class IlvDoubleEnumerator
    implements Enumeration {
        private Enumeration a;
        private Enumeration b;

        public IlvDoubleEnumerator(Enumeration enumeration, Enumeration enumeration2) {
            if (enumeration == null || enumeration2 == null) {
                throw new IllegalArgumentException("null enumeration");
            }
            this.a = enumeration;
            this.b = enumeration2;
        }

        public boolean hasMoreElements() {
            return this.a.hasMoreElements() || this.b.hasMoreElements();
        }

        public Object nextElement() {
            if (this.a.hasMoreElements()) {
                return this.a.nextElement();
            }
            return this.b.nextElement();
        }
    }

    public static final class IlvModelNeighborsEnumeration
    implements Enumeration {
        private Enumeration a;
        private IlvGraphModel b;
        private Object c;
        private Object d;

        public IlvModelNeighborsEnumeration(IlvGraphModel ilvGraphModel, Object object) {
            if (object == null) {
                throw new IllegalArgumentException("node cannot be null");
            }
            this.c = object;
            this.b = ilvGraphModel;
            this.a = ilvGraphModel.getLinks(object);
        }

        public boolean hasMoreElements() {
            if (this.d != null) {
                return true;
            }
            if (this.a != null) {
                while (this.a.hasMoreElements()) {
                    Object e = this.a.nextElement();
                    if (e == null) continue;
                    this.d = this.b.getOpposite(e, this.c);
                    if (this.d == null || this.d == this.c) continue;
                    return true;
                }
                this.d = null;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Object object = this.d;
                this.d = null;
                return object;
            }
            throw new NoSuchElementException("no next element");
        }
    }
}

