/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout;

import ilog.jlm.Jlm;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.diagrammer.IlvDiagrammerProduct;
import ilog.views.graphlayout.GraphLayoutEvent;
import ilog.views.graphlayout.GraphLayoutEventListener;
import ilog.views.graphlayout.GraphLayoutParameterEvent;
import ilog.views.graphlayout.GraphLayoutParameterEventListener;
import ilog.views.graphlayout.GraphModelEvent;
import ilog.views.graphlayout.GraphModelListener;
import ilog.views.graphlayout.IlvAutoLayoutHandler;
import ilog.views.graphlayout.IlvDefaultLayoutProvider;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutLinkProperty;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphLayoutUtil;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.IlvLayoutProvider;
import ilog.views.graphlayout.IlvLinkClipInterface;
import ilog.views.graphlayout.IlvLinkConnectionBoxInterface;
import ilog.views.graphlayout.IlvSplineLinkFilter;
import ilog.views.graphlayout.grid.IlvGridLayout;
import ilog.views.graphlayout.internalutil.GenericLayoutUtil;
import ilog.views.graphlayout.internalutil.IlvDefaultPropertyContainer;
import ilog.views.graphlayout.internalutil.IlvPropertyContainerInterface;
import ilog.views.graphlayout.internalutil.LayoutParametersUtil;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.NestedData;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import ilog.views.graphlayout.recursive.IlvRecursiveLayout;
import java.awt.Dimension;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public abstract class IlvGraphLayout
implements Serializable,
GraphModelListener {
    public static final int INVERSE_VIEW_COORDINATES = 0;
    public static final int MANAGER_COORDINATES = 1;
    public static final int VIEW_COORDINATES = 2;
    private static int a = -1;
    private int b;
    private static final String c = "__ilvGraphLayout";
    private String d;
    private static final String e = "Fixed";
    static final long f = 32000L;
    static final long g = 50L;
    static final boolean h = false;
    static final boolean i = false;
    static final boolean j = false;
    static final boolean k = false;
    static final boolean l = false;
    static final boolean m = false;
    static final int n = 0;
    static final boolean o = false;
    static final boolean p = true;
    static final IlvRect q = null;
    static final boolean r = true;
    static final IlvLinkClipInterface s = null;
    static final IlvLinkConnectionBoxInterface t = null;
    static final int u = 0;
    static final IlvAutoLayoutHandler v = null;
    static final boolean w = false;
    static final float x = 5.0f;
    static final float y = 30.0f;
    static final float z = 10.0f;
    static final IlvSplineLinkFilter aa = new IlvSplineLinkFilter();
    private long ab;
    private long ac;
    private boolean ad;
    private boolean ae;
    private boolean af;
    private boolean ag;
    private boolean ah;
    private boolean ai;
    private long aj;
    private boolean ak;
    private boolean al;
    private boolean am;
    private int an;
    private int ao;
    private IlvLinkClipInterface ap;
    private IlvLinkConnectionBoxInterface aq;
    private IlvAutoLayoutHandler ar;
    private boolean as;
    private float at;
    private float au;
    private float av;
    private IlvSplineLinkFilter aw;
    private IlvRect ax;
    private IlvRect ay;
    private IlvManagerView az;
    private boolean a0;
    private IlvRect a1;
    private IlvRect a2;
    private IlvRecursiveLayout a3;
    private Object a4;
    boolean a5;
    IlvGraphLayout a6;
    private IlvGraphModel a7;
    private boolean a8;
    private boolean a9;
    private boolean ba;
    private boolean bb;
    private boolean bc;
    private boolean bd;
    private boolean be;
    private boolean bf;
    private int bg = 0;
    private boolean bh;
    private IlvRect bi;
    private long bj;
    private static boolean bk;
    private static final Runnable bl;
    private IlvGraphModel bm;
    boolean bn;
    private IlvGraphLayout bo;
    private IlvGraphLayoutReport bp;
    private IlvGraphLayoutReport bq;
    private IlvPropertyContainerInterface br;
    private EventListenerList bs;
    private EventListenerList bt;
    private GraphLayoutEvent bu;
    private int bv;
    private int bw;
    private int bx;
    private int by;
    private int[] bz;

    public IlvGraphLayout() {
        if (!bk) {
            Jlm.fireDoublePropertyChanged((String)"Module-GraphLayout", IlvDiagrammerProduct.class, (int)IlvDiagrammerProduct.getReleaseDate(), (Runnable)bl);
            bk = true;
        }
        this.init();
    }

    public IlvGraphLayout(IlvGraphLayout ilvGraphLayout) {
        this.init();
        boolean bl = ilvGraphLayout.isUseDefaultParameters();
        boolean bl2 = ilvGraphLayout.isParametersUpToDate();
        if (bl) {
            ilvGraphLayout.setUseDefaultParameters(false);
        }
        this.copyParameters(ilvGraphLayout);
        this.setUseDefaultParameters(bl);
        ilvGraphLayout.setUseDefaultParameters(bl);
        if (bl && bl2) {
            ilvGraphLayout.setParametersUpToDate(true);
        }
        this.setParametersUpToDate(false);
    }

    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        this.setUseDefaultParameters(false);
        if (this.supportsMemorySavings()) {
            this.setMemorySavings(ilvGraphLayout.isMemorySavings());
        }
        if (this.supportsAllowedTime()) {
            this.setAllowedTime(ilvGraphLayout.getAllowedTime());
        }
        this.setMinBusyTime(ilvGraphLayout.getMinBusyTime());
        if (this.supportsPreserveFixedNodes()) {
            this.setPreserveFixedNodes(ilvGraphLayout.isPreserveFixedNodes());
        }
        if (this.supportsPreserveFixedLinks()) {
            this.setPreserveFixedLinks(ilvGraphLayout.isPreserveFixedLinks());
        }
        if (this.supportsAnimation()) {
            this.setAnimate(ilvGraphLayout.isAnimate());
        }
        this.setAutoLayout(ilvGraphLayout.isAutoLayout());
        this.setAutoLayoutHandler(ilvGraphLayout.getAutoLayoutHandler());
        if (this.supportsRandomGenerator()) {
            this.setSeedValueForRandomGenerator(ilvGraphLayout.getSeedValueForRandomGenerator());
            this.setUseSeedValueForRandomGenerator(ilvGraphLayout.isUseSeedValueForRandomGenerator());
        }
        this.setInputCheckEnabled(ilvGraphLayout.isInputCheckEnabled());
        if (this.supportsLayoutOfConnectedComponents()) {
            this.setLayoutOfConnectedComponentsEnabled(ilvGraphLayout.isLayoutOfConnectedComponentsEnabled());
        }
        this.setCoordinatesMode(ilvGraphLayout.getCoordinatesMode());
        if (this.supportsLinkClipping()) {
            this.setLinkClipInterface(ilvGraphLayout.getLinkClipInterface());
        }
        if (this.supportsLinkConnectionBox()) {
            this.setLinkConnectionBoxInterface(ilvGraphLayout.getLinkConnectionBoxInterface());
        }
        if (this.supportsLayoutRegion()) {
            IlvRect ilvRect = ilvGraphLayout.ax;
            this.ax = ilvRect != null ? new IlvRect(ilvGraphLayout.ax) : null;
            ilvRect = ilvGraphLayout.ay;
            this.ay = ilvRect != null ? new IlvRect(ilvGraphLayout.ay) : null;
            this.az = ilvGraphLayout.az;
            this.a0 = ilvGraphLayout.a0;
        }
        if (this.supportsSplineRouting()) {
            this.setSplineRoutingEnabled(ilvGraphLayout.isSplineRoutingEnabled());
            this.setMinSplineCurveSize(ilvGraphLayout.getMinSplineCurveSize());
            this.setMaxSplineCurveSize(ilvGraphLayout.getMaxSplineCurveSize());
            this.setBalanceSplineCurveThreshold(ilvGraphLayout.getBalanceSplineCurveThreshold());
            this.setSplineLinkFilter(ilvGraphLayout.getSplineLinkFilter());
        }
        if (this.supportsLayoutOfConnectedComponents()) {
            this.a(ilvGraphLayout);
        }
    }

    protected void init() {
        this.c();
        this.ah = false;
        this.ab = 32000L;
        this.ac = 50L;
        this.ad = false;
        this.ae = false;
        this.ag = false;
        this.ai = false;
        this.ar = v;
        this.aj = 0L;
        this.ak = false;
        this.al = true;
        this.am = this.isLayoutOfConnectedComponentsEnabledByDefault();
        this.an = 0;
        this.ap = s;
        this.aq = t;
        this.as = false;
        this.at = 5.0f;
        this.au = 30.0f;
        this.av = 10.0f;
        this.aw = aa;
        this.ax = q;
        this.ay = q;
        this.a0 = true;
        this.a5 = false;
        this.a9 = true;
        this.bi = new IlvRect();
        this.bv = 1;
        this.by = 1;
        this.bz = new int[1];
        this.bz[0] = 1;
        this.bu = new GraphLayoutEvent(this);
    }

    public abstract IlvGraphLayout copy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        Class<IlvGraphLayout> clazz = IlvGraphLayout.class;
        synchronized (IlvGraphLayout.class) {
            this.b = ++a;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.d = (c + this.getInstanceId()).intern();
            return;
        }
    }

    public final int getInstanceId() {
        return this.b;
    }

    public synchronized void attach(IlvGrapher ilvGrapher) {
        if (ilvGrapher == null) {
            throw new IllegalArgumentException("graph cannot be null");
        }
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel != null && ilvGraphModel.getOriginatingLayout() == this && ilvGraphModel.getGrapher() == ilvGrapher) {
            return;
        }
        IlvGrapherAdapter ilvGrapherAdapter = new IlvGrapherAdapter(ilvGrapher);
        this.attach(ilvGrapherAdapter);
        ilvGrapherAdapter.a(this);
    }

    public synchronized void attach(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        if (ilvGraphModel == this.bm) {
            return;
        }
        if (ilvGraphModel.isInternalGraphModelChecking() && ilvGraphModel.getOriginatingLayout() != null) {
            throw new RuntimeException("Cannot attach an internally created model: " + ilvGraphModel);
        }
        if (this.bm != null) {
            this.detach();
        }
        this.bm = ilvGraphModel;
        this.bm.addGraphModelListener(this);
        if (this.a7 != null) {
            this.a7.dispose();
            this.a7 = null;
        }
        this.bc = false;
        this.bd = false;
        this.be = false;
        this.a2 = null;
        this.bm.afterAttach(this);
    }

    public synchronized void detach() {
        if (this.bm != null) {
            this.setStructureUpToDate(false);
            this.setGeometryUpToDate(false);
            this.setParametersUpToDate(false);
            this.cleanGraphModel(this.bm);
            Enumeration enumeration = this.bm.getNodes();
            while (enumeration.hasMoreElements()) {
                this.cleanNode(this.bm, enumeration.nextElement());
            }
            enumeration = this.bm.getLinks();
            while (enumeration.hasMoreElements()) {
                this.cleanLink(this.bm, enumeration.nextElement());
            }
            enumeration = this.bm.getInterGraphLinks();
            while (enumeration.hasMoreElements()) {
                this.cleanLink(this.bm, enumeration.nextElement());
            }
            if (this.a7 != null) {
                this.a7.dispose();
                this.a7 = null;
            }
            this.a8 = false;
            if (this.a6 != null) {
                this.a6.detach();
            }
            IlvGraphModel ilvGraphModel = this.bm;
            this.bm = null;
            if (this.a3 != null) {
                IlvRecursiveLayout ilvRecursiveLayout = this.a3;
                this.a3 = null;
                ((IlvGraphLayout)ilvRecursiveLayout).detach();
            }
            this.a(ilvGraphModel);
            ilvGraphModel.afterDetach(this);
            if (ilvGraphModel.getOriginatingLayout() == this) {
                ilvGraphModel.dispose();
            }
        }
    }

    final void a(IlvDefaultLayoutProvider ilvDefaultLayoutProvider) {
        if (this.a4 == null) {
            this.a4 = ilvDefaultLayoutProvider;
        } else if (this.a4 instanceof IlvDefaultLayoutProvider) {
            if (this.a4 != ilvDefaultLayoutProvider) {
                Vector<Object> vector = new Vector<Object>(2, 2);
                vector.addElement(this.a4);
                vector.addElement(ilvDefaultLayoutProvider);
                this.a4 = vector;
            }
        } else if (this.a4 instanceof Vector) {
            Vector vector = (Vector)this.a4;
            if (!vector.contains(ilvDefaultLayoutProvider)) {
                vector.addElement(ilvDefaultLayoutProvider);
            }
        } else {
            throw new RuntimeException("Illegal situation");
        }
    }

    final void b(IlvDefaultLayoutProvider ilvDefaultLayoutProvider) {
        if (this.a4 == null) {
            return;
        }
        if (this.a4 == ilvDefaultLayoutProvider) {
            this.a4 = null;
            return;
        }
        if (this.a4 instanceof Vector) {
            Vector vector = (Vector)this.a4;
            vector.removeElement(ilvDefaultLayoutProvider);
            if (vector.size() == 1) {
                this.a4 = vector.firstElement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphModel ilvGraphModel) {
        if (this.a4 == null) {
            return;
        }
        Object object = this.a4;
        this.a4 = null;
        boolean bl = ilvGraphModel.isInternalGraphModelChecking();
        try {
            ilvGraphModel.setInternalGraphModelChecking(false);
            if (object instanceof IlvDefaultLayoutProvider) {
                IlvDefaultLayoutProvider ilvDefaultLayoutProvider = (IlvDefaultLayoutProvider)object;
                ilvDefaultLayoutProvider.setPreferredLayout(ilvGraphModel, null);
            } else if (object instanceof Vector) {
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    IlvDefaultLayoutProvider ilvDefaultLayoutProvider = (IlvDefaultLayoutProvider)enumeration.nextElement();
                    ilvDefaultLayoutProvider.setPreferredLayout(ilvGraphModel, null);
                }
            }
        }
        finally {
            ilvGraphModel.setInternalGraphModelChecking(bl);
        }
    }

    public void cleanGraphModel(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graph model cannot be null");
        }
        ilvGraphModel.removeGraphModelListener(this);
        ilvGraphModel.b(this);
    }

    public void cleanNode(IlvGraphModel ilvGraphModel, Object object) {
        this.a(ilvGraphModel, object);
    }

    public void cleanLink(IlvGraphModel ilvGraphModel, Object object) {
        this.a(ilvGraphModel, object);
    }

    private void a(IlvGraphModel ilvGraphModel, Object object) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graph model cannot be null");
        }
        ilvGraphModel.setProperty(object, this.d, null);
    }

    public void setGraphModel(IlvGraphModel ilvGraphModel) {
        this.bm = ilvGraphModel;
        this.setStructureUpToDate(false);
        this.setGeometryUpToDate(false);
    }

    public IlvGraphModel getGraphModel() {
        return this.bm;
    }

    public void setGrapher(IlvGrapher ilvGrapher) {
        this.attach(ilvGrapher);
    }

    public IlvGrapher getGrapher() {
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        return ilvGraphModel == null ? null : ilvGraphModel.getGrapher();
    }

    public void setParentLayout(IlvGraphLayout ilvGraphLayout) {
        this.bo = ilvGraphLayout;
    }

    public IlvGraphLayout getParentLayout() {
        return this.bo;
    }

    public IlvGraphLayoutReport createLayoutReport() {
        return new IlvGraphLayoutReport();
    }

    protected void setLayoutReport(IlvGraphLayoutReport ilvGraphLayoutReport) {
        this.bp = ilvGraphLayoutReport;
    }

    public final IlvGraphLayoutReport getLayoutReport() {
        return this.bp;
    }

    public synchronized IlvGraphLayoutReport performLayout() throws IlvGraphLayoutException {
        return this.performLayout(false, true);
    }

    public synchronized IlvGraphLayoutReport performLayout(boolean bl, boolean bl2) throws IlvGraphLayoutException {
        return this.a(bl, bl2);
    }

    public synchronized int performLayout(boolean bl, boolean bl2, boolean bl3) throws IlvGraphLayoutException {
        if (bl3) {
            return this.b(bl, bl2);
        }
        IlvGraphLayoutReport ilvGraphLayoutReport = this.performLayout(bl, bl2);
        return ilvGraphLayoutReport.getCode();
    }

    public static int PerformLayout(IlvGraphModel ilvGraphModel, IlvLayoutProvider ilvLayoutProvider, boolean bl, boolean bl2, boolean bl3) throws IlvGraphLayoutException {
        if (ilvGraphModel == null) {
            throw new IlvGraphLayoutException("graphModel cannot be null");
        }
        return ilvGraphModel.performLayout(ilvLayoutProvider, bl, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private IlvGraphLayoutReport a(boolean bl, boolean bl2) throws IlvGraphLayoutException {
        boolean bl3;
        boolean bl4;
        IlvGraphModel ilvGraphModel;
        block26: {
            block25: {
                ilvGraphModel = this.getGraphModel();
                if (ilvGraphModel == null) {
                    throw new IlvGraphLayoutException("no attached graph model or graph model is null");
                }
                if (this.bf) {
                    throw new RuntimeException("You cannot start this layout while it is still running");
                }
                this.bq = null;
                this.setLayoutRunning(true, false);
                this.setLayoutReport(this.createLayoutReport());
                if (this.bp == null) {
                    throw new IlvGraphLayoutException("Failed to create the layout report.");
                }
                this.bp.a(System.currentTimeMillis());
                this.bp.a(0);
                this.ba = false;
                this.bb = false;
                this.bj = 0L;
                IlvGraphModel ilvGraphModel2 = ilvGraphModel;
                // MONITORENTER : ilvGraphModel2
                bl4 = false;
                bl3 = false;
                if (LayoutUtil.IsEmpty(ilvGraphModel)) {
                    this.bp.setCode(1);
                    IlvGraphLayoutReport ilvGraphLayoutReport = this.bp;
                    return ilvGraphLayoutReport;
                }
                bl4 = true;
                this.beforeLayout(bl2);
                this.a8 = false;
                this.a9 = true;
                if (!bl && !this.isLayoutNeeded()) {
                    this.bp.setCode(4);
                    IlvGraphLayoutReport ilvGraphLayoutReport = this.bp;
                    this.setLayoutRunning(false, false);
                    this.bh = false;
                    return ilvGraphLayoutReport;
                }
                if (this.getGrapher() == null || !this.getGrapher().isCrossingAwareLinksFrozen()) break block25;
                this.bp.setCode(4);
                IlvGraphLayoutReport ilvGraphLayoutReport = this.bp;
                this.setLayoutRunning(false, false);
                this.bh = false;
                return ilvGraphLayoutReport;
            }
            try {
                block28: {
                    block27: {
                        this.bp.setCode(8);
                        this.bu.a(true);
                        this.bu.b(false);
                        this.layoutStepPerformed();
                        this.bu.a(false);
                        this.bp.setCode(0);
                        if (this.bh || !this.supportsLayoutOfConnectedComponents() || !this.isLayoutOfConnectedComponentsEnabled() || this.a8 && this.a9) break block27;
                        this.a9 = IlvGraphLayoutUtil.IsConnected(ilvGraphModel);
                        if (!this.a9) break block28;
                        this.a8 = true;
                    }
                    ilvGraphModel.a(true, true);
                    this.beforeLayoutOfSubgraph(ilvGraphModel);
                    ilvGraphModel.a(this, bl2);
                    this.afterLayoutOfSubgraph(ilvGraphModel);
                    break block26;
                }
                this.a(ilvGraphModel, bl, bl2);
            }
            catch (Error error) {
                bl3 = true;
                throw error;
            }
            catch (RuntimeException runtimeException) {
                bl3 = true;
                throw runtimeException;
            }
            catch (IlvGraphLayoutException ilvGraphLayoutException) {
                bl3 = true;
                throw ilvGraphLayoutException;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.a(bl4, bl3, bl2);
                ilvGraphModel.a(false, true);
            }
        }
        this.a(bl4, bl3, bl2);
        ilvGraphModel.a(false, true);
        return this.bp;
    }

    protected int performSublayout(Object object, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2) throws IlvGraphLayoutException {
        return ilvGraphLayout.performLayout(bl, bl2, false);
    }

    public void checkAppropriateLinks() throws IlvInappropriateLinkException {
        Object object = this.getProperty("__CheckAppropriateLinksNeeded");
        if (object == Boolean.FALSE) {
            return;
        }
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel == null) {
            throw new RuntimeException("no attached graph model or graph model is null");
        }
        LayoutUtil.CheckAppropriateLinks(this, ilvGraphModel.getLinks());
    }

    public int checkAppropriateLink(Object object) {
        return 0;
    }

    public boolean setAutoCheckAppropriateLinksEnabled(boolean bl) {
        Object object = this.getProperty("__CheckAppropriateLinksNeeded");
        if (bl) {
            this.setProperty("__CheckAppropriateLinksNeeded", null);
        } else {
            this.setProperty("__CheckAppropriateLinksNeeded", Boolean.FALSE);
        }
        return object != Boolean.FALSE;
    }

    public IlvGraphicVector getMovingNodes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl, boolean bl2, boolean bl3) {
        if (!this.a5) {
            NestedData.Clean(this.getGraphModel());
        }
        if (bl) {
            this.getGraphModel().afterLayout(this, this.bp, bl3);
        }
        int n = this.bp.getCode();
        if (!(bl2 || n != 5 && n != 6)) {
            this.d();
            this.setStructureUpToDate(true);
            this.setGeometryUpToDate(true);
            this.setParametersUpToDate(true);
        }
        this.bp.b(System.currentTimeMillis());
        try {
            this.increasePercentageComplete(100);
            this.bp.setCode(9);
            this.layoutStepPerformed();
            this.bp.setCode(bl2 ? 10 : n);
            this.bu.b(true);
            this.layoutStepPerformed();
            this.bu.a(false);
            this.bu.b(false);
        }
        catch (Throwable throwable) {
            this.bp.setCode(bl2 ? 10 : n);
            this.bu.b(true);
            this.layoutStepPerformed();
            this.bu.a(false);
            this.bu.b(false);
            throw throwable;
        }
    }

    private int b(boolean bl, boolean bl2) throws IlvGraphLayoutException {
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getRecursiveLayout().performLayout(bl, bl2);
        return ilvGraphLayoutReport.getCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphModel ilvGraphModel, boolean bl, boolean bl2) throws IlvGraphLayoutException {
        int n;
        IlvGraphModel ilvGraphModel2 = ilvGraphModel;
        IlvGraphModel ilvGraphModel3 = this.a(ilvGraphModel, this.a8);
        this.increasePercentageComplete(2);
        this.callLayoutStepPerformedIfNeeded();
        this.b(ilvGraphModel3);
        Enumeration enumeration = ilvGraphModel3.getNodes();
        if (this.bv < 2) {
            throw new IlvGraphLayoutException("Unexpected (too small) number of connected components: " + this.bv);
        }
        int n2 = 0;
        try {
            this.bh = true;
            this.bw = 0;
            while (enumeration.hasMoreElements()) {
                this.setGraphModel((IlvGraphModel)enumeration.nextElement());
                ilvGraphModel = this.getGraphModel();
                this.beforeLayoutOfSubgraph(ilvGraphModel);
                ilvGraphModel.a(this, bl2);
                n = this.bp.getCode();
                if (n > n2) {
                    n2 = n;
                }
                this.afterLayoutOfSubgraph(ilvGraphModel);
                this.bx += this.bz[this.bw++];
            }
        }
        finally {
            this.setGraphModel(ilvGraphModel2);
        }
        IlvGraphLayout ilvGraphLayout = this.getLayoutOfConnectedComponents();
        if (ilvGraphModel3 != null && ilvGraphLayout.getGraphModel() != ilvGraphModel3) {
            ilvGraphLayout.attach(ilvGraphModel3);
        }
        this.bq = null;
        if (ilvGraphLayout.getGraphModel() != null) {
            this.bq = ilvGraphLayout.performLayout(bl, bl2);
        }
        this.bx += this.bz[this.bw++];
        n = this.bp.getCode();
        if (n > n2) {
            n2 = n;
        }
        this.bp.setCode(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvRecursiveLayout getRecursiveLayout() {
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel == null) {
            throw new RuntimeException("no attached graph model or graph model is null");
        }
        if (this instanceof IlvRecursiveLayout) {
            return (IlvRecursiveLayout)this;
        }
        if (this.a3 == null) {
            this.a3 = new IlvRecursiveLayout(this);
            this.a3.setLoadLayoutModeFromNamesProperties(false);
            boolean bl = ilvGraphModel.isInternalGraphModelChecking();
            try {
                ilvGraphModel.setInternalGraphModelChecking(false);
                this.a3.attach(ilvGraphModel);
            }
            finally {
                ilvGraphModel.setInternalGraphModelChecking(bl);
            }
        }
        return this.a3;
    }

    public Enumeration getLayouts(boolean bl) {
        return this.getRecursiveLayout().getLayouts(bl);
    }

    public IlvGraphLayout getLayout(Object object) {
        return this.getRecursiveLayout().getLayout(object);
    }

    private void b(IlvGraphModel ilvGraphModel) {
        this.bv = ilvGraphModel.getNodesCount() + 1;
        this.bz = new int[this.bv];
        this.by = 0;
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = ilvGraphModel.getNodes();
        while (enumeration.hasMoreElements()) {
            IlvGraphModel ilvGraphModel2 = (IlvGraphModel)enumeration.nextElement();
            int n3 = ilvGraphModel2.getNodesCount() + ilvGraphModel2.getLinksCount();
            n2 += n3;
            this.by += 3 * n3;
            this.bz[n++] = 3 * n3;
        }
        this.bz[n] = n2;
        this.by += n2;
        this.bx = 0;
    }

    private IlvGraphModel a(IlvGraphModel ilvGraphModel, boolean bl) {
        if (this.a7 == null) {
            this.a7 = IlvGraphLayoutUtil.a(ilvGraphModel, bl);
        }
        return this.a7;
    }

    protected boolean isLayoutNeeded() {
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        return ilvGraphModel != null && ilvGraphModel.isLayoutNeeded(this);
    }

    public boolean isLocalRecursiveLayoutNeeded(IlvLayoutProvider ilvLayoutProvider, IlvGraphLayout ilvGraphLayout, IlvGraphModel ilvGraphModel, boolean bl) {
        return true;
    }

    protected abstract void layout(boolean var1) throws IlvGraphLayoutException;

    protected void beforeLayout(boolean bl) {
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        ilvGraphModel.beforeLayout(this, bl);
    }

    protected void beforeLayoutOfSubgraph(IlvGraphModel ilvGraphModel) {
    }

    protected void afterLayoutOfSubgraph(IlvGraphModel ilvGraphModel) {
    }

    public final boolean isLayoutRunning() {
        return this.bf;
    }

    public final boolean isLayoutRunning(boolean bl) {
        if (this.isLayoutRunning()) {
            return true;
        }
        if (bl) {
            return this.bg > 0;
        }
        return false;
    }

    public void setLayoutRunning(boolean bl, boolean bl2) {
        if (!bl2) {
            this.bf = bl;
        }
        this.bg = bl ? ++this.bg : --this.bg;
    }

    public synchronized void addGraphLayoutEventListener(GraphLayoutEventListener graphLayoutEventListener) {
        if (this.bs == null) {
            this.bs = new EventListenerList();
        }
        this.bs.add(GraphLayoutEventListener.class, graphLayoutEventListener);
    }

    public synchronized void removeGraphLayoutEventListener(GraphLayoutEventListener graphLayoutEventListener) {
        if (this.bs == null) {
            return;
        }
        this.bs.remove(GraphLayoutEventListener.class, graphLayoutEventListener);
        if (this.bs.getListenerCount() == 0) {
            this.bs = null;
        }
    }

    public synchronized void addGraphLayoutParameterEventListener(GraphLayoutParameterEventListener graphLayoutParameterEventListener) {
        if (this.bt == null) {
            this.bt = new EventListenerList();
        }
        this.bt.add(GraphLayoutParameterEventListener.class, graphLayoutParameterEventListener);
    }

    public synchronized void removeGraphLayoutParameterEventListener(GraphLayoutParameterEventListener graphLayoutParameterEventListener) {
        if (this.bt == null) {
            return;
        }
        this.bt.remove(GraphLayoutParameterEventListener.class, graphLayoutParameterEventListener);
        if (this.bt.getListenerCount() == 0) {
            this.bt = null;
        }
    }

    public void layoutStepPerformed() {
        IlvGraphLayout ilvGraphLayout = this.getParentLayout();
        if (ilvGraphLayout != null) {
            ilvGraphLayout.layoutStepPerformed();
        } else if (this.bs != null) {
            Object[] objectArray = this.bs.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((GraphLayoutEventListener)objectArray[i]).layoutStepPerformed(this.bu);
            }
        }
    }

    public final void callLayoutStepPerformedIfNeeded() {
        if (this.bb) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l > this.bj + this.getMinBusyTime() || l < this.bj) {
            this.layoutStepPerformed();
            this.bj = System.currentTimeMillis();
            if (this.supportsAllowedTime() && this.isLayoutTimeElapsed() || this.supportsStopImmediately() && this.isStoppedImmediately()) {
                this.bb = true;
            }
        }
    }

    public synchronized void setMinBusyTime(long l) {
        if (this.ac != l) {
            this.ac = l;
            this.onParameterChanged("MinBusyTime");
        }
    }

    public long getMinBusyTime() {
        return this.isUseDefaultParameters() ? 50L : this.ac;
    }

    public void setStructureUpToDate(boolean bl) {
        this.bc = bl;
        if (!bl) {
            this.a2 = null;
        }
    }

    public boolean isStructureUpToDate() {
        return this.bc;
    }

    public void setGeometryUpToDate(boolean bl) {
        this.bd = bl;
        if (!bl) {
            this.a2 = null;
        }
    }

    public boolean isGeometryUpToDate() {
        return this.bd;
    }

    final void a(int n) {
        this.ao = n;
    }

    final int a() {
        return this.ao;
    }

    public void setCoordinatesMode(int n) {
        if (n != 1 && n != 2 && n != 0) {
            throw new IllegalArgumentException("Unsupported coordinates mode: " + n);
        }
        if (n != this.an) {
            this.an = n;
            this.setGeometryUpToDate(false);
            this.onParameterChanged("CoordinatesMode");
        }
    }

    public int getCoordinatesMode() {
        return this.an;
    }

    public void onParameterChanged(String string) {
        this.a((Object)null, string);
    }

    public void onParameterChanged(Object object, String string) {
        this.a(object, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Object object, String string) {
        boolean bl;
        EventListenerList eventListenerList = this.bt;
        try {
            this.bt = null;
            this.setParametersUpToDate(false);
        }
        finally {
            this.bt = eventListenerList;
        }
        boolean bl2 = bl = string == null || string.length() == 0 || string.charAt(0) != '_';
        if (bl) {
            this.a(false, object, string);
        }
    }

    private void a(boolean bl, Object object, String string) {
        if (this.bt != null) {
            String string2 = GenericLayoutUtil.Decapitalize(string);
            Object[] objectArray = this.bt.getListenerList();
            GraphLayoutParameterEvent graphLayoutParameterEvent = new GraphLayoutParameterEvent(this, object, string2, bl);
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((GraphLayoutParameterEventListener)objectArray[i]).parametersUpToDate(graphLayoutParameterEvent);
            }
        }
    }

    public void setParametersUpToDate(boolean bl) {
        this.be = bl;
        this.a(bl, null, null);
    }

    public boolean isParametersUpToDate() {
        IlvGraphLayout ilvGraphLayout;
        if (!this.be) {
            return false;
        }
        if (this.supportsLayoutOfConnectedComponents() && this.isLayoutOfConnectedComponentsEnabled() && (ilvGraphLayout = this.a6) != null && !ilvGraphLayout.isParametersUpToDate()) {
            this.a9 = IlvGraphLayoutUtil.IsConnected(this.getGraphModel());
            this.a8 = true;
            if (!this.a9) {
                this.be = false;
                return false;
            }
        }
        if (this.supportsLayoutRegion() && this.a(this.a1, (IlvRect)(ilvGraphLayout = this.getCalcLayoutRegion()))) {
            this.be = false;
            return false;
        }
        return true;
    }

    private boolean a(IlvRect ilvRect, IlvRect ilvRect2) {
        if (ilvRect != null) {
            if (ilvRect2 == null) {
                return true;
            }
            return Math.round(ilvRect.x) != Math.round(ilvRect2.x) || Math.round(ilvRect.y) != Math.round(ilvRect2.y) || Math.round(ilvRect.width) != Math.round(ilvRect2.width) || Math.round(ilvRect.height) != Math.round(ilvRect2.height);
        }
        return ilvRect2 != null;
    }

    public synchronized void setUseDefaultParameters(boolean bl) {
        if (bl != this.af) {
            this.af = bl;
            this.onParameterChanged("UseDefaultParameters");
        }
    }

    public boolean isUseDefaultParameters() {
        return this.af;
    }

    public void setInputCheckEnabled(boolean bl) {
        if (bl != this.al) {
            this.al = bl;
            this.onParameterChanged("InputCheckEnabled");
        }
    }

    public final boolean isInputCheckEnabled() {
        return this.isUseDefaultParameters() ? true : this.al;
    }

    public boolean supportsPreserveFixedNodes() {
        return false;
    }

    public synchronized void setPreserveFixedNodes(boolean bl) {
        if (!this.supportsPreserveFixedNodes() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the fixed nodes preservation");
        }
        if (this.ad != bl) {
            this.ad = bl;
            this.onParameterChanged("PreserveFixedNodes");
        }
    }

    public boolean isPreserveFixedNodes() {
        if (!this.supportsPreserveFixedNodes()) {
            return false;
        }
        return this.isUseDefaultParameters() ? false : this.ad;
    }

    public synchronized void setFixed(Object object, boolean bl) {
        if (this.bm != null) {
            if (this.bm.isNode(object)) {
                if (!this.supportsPreserveFixedNodes()) {
                    throw new RuntimeException("this layout class does not support the fixed nodes preservation");
                }
            } else if ((this.bm.isLink(object) || this.bm.isInterGraphLink(object)) && !this.supportsPreserveFixedLinks()) {
                throw new RuntimeException("this layout class does not support the fixed links preservation");
            }
        }
        LayoutParametersUtil.SetNodeOrLinkParameter(this, object, e, bl, false);
    }

    public boolean isFixed(Object object) {
        return LayoutParametersUtil.GetNodeOrLinkParameter(this, object, e, false);
    }

    public synchronized void unfixAllNodes() {
        if (!this.supportsPreserveFixedNodes()) {
            throw new RuntimeException("this layout class does not support the fixed nodes preservation");
        }
        if (this.bm == null) {
            throw new RuntimeException("no attached graph model or graph model is null");
        }
        Enumeration enumeration = this.bm.getNodes();
        while (enumeration.hasMoreElements()) {
            this.setFixed(enumeration.nextElement(), false);
        }
    }

    public boolean supportsPreserveFixedLinks() {
        return false;
    }

    public synchronized void setPreserveFixedLinks(boolean bl) {
        if (!this.supportsPreserveFixedLinks()) {
            throw new RuntimeException("this layout class does not support the fixed links preservation");
        }
        if (this.ae != bl) {
            this.ae = bl;
            this.onParameterChanged("PreserveFixedLinks");
        }
    }

    public boolean isPreserveFixedLinks() {
        if (!this.supportsPreserveFixedLinks()) {
            return false;
        }
        return this.isUseDefaultParameters() ? false : this.ae;
    }

    public synchronized void unfixAllLinks() {
        if (!this.supportsPreserveFixedLinks()) {
            throw new RuntimeException("this layout class does not support the fixed links preservation");
        }
        if (this.bm == null) {
            throw new RuntimeException("no attached graph model or graph model is null");
        }
        Enumeration enumeration = this.bm.getLinks();
        while (enumeration.hasMoreElements()) {
            this.setFixed(enumeration.nextElement(), false);
        }
        enumeration = this.bm.getInterGraphLinks();
        while (enumeration.hasMoreElements()) {
            this.setFixed(enumeration.nextElement(), false);
        }
    }

    public boolean supportsAnimation() {
        return false;
    }

    public synchronized void setAnimate(boolean bl) {
        if (!this.supportsAnimation() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the animation");
        }
        if (this.ag != bl) {
            this.ag = bl;
            this.onParameterChanged("Animate");
        }
    }

    public boolean isAnimate() {
        if (!this.supportsAnimation()) {
            return false;
        }
        return this.isUseDefaultParameters() ? false : this.ag;
    }

    public boolean useAnimateRedraw() {
        return this.isAnimate();
    }

    public boolean supportsPercentageComplete() {
        return false;
    }

    public void increasePercentageComplete(int n) {
        IlvGraphLayout ilvGraphLayout = this.getParentLayout();
        if (ilvGraphLayout != null) {
            ilvGraphLayout.increasePercentageComplete(n);
        } else if (n >= 0 && n <= 100 && this.bp != null) {
            int n2 = n;
            if (this.bh && this.bw < this.bv) {
                n2 = 100 * (this.bx + n * this.bz[this.bw] / 100) / this.by;
            }
            if (this.bp.getPercentageComplete() < n2) {
                this.bp.a(n2);
            }
        }
    }

    public boolean supportsStopImmediately() {
        return false;
    }

    public boolean stopImmediately() {
        if (!this.supportsStopImmediately()) {
            return false;
        }
        if (this.ba) {
            return true;
        }
        this.ba = true;
        boolean bl = true;
        IlvGraphLayout ilvGraphLayout = this.a6;
        if (ilvGraphLayout != null && ilvGraphLayout.isLayoutRunning() && ilvGraphLayout.supportsStopImmediately()) {
            bl &= ilvGraphLayout.stopImmediately();
        }
        return bl;
    }

    public boolean isStoppedImmediately() {
        return this.ba;
    }

    public void setLayoutOfConnectedComponentsEnabled(boolean bl) {
        if (!this.supportsLayoutOfConnectedComponents() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the connected component layout mechanism");
        }
        if (this.am != bl) {
            this.am = bl;
            this.setStructureUpToDate(false);
            this.onParameterChanged("LayoutOfConnectedComponentsEnabled");
        }
    }

    public boolean isLayoutOfConnectedComponentsEnabled() {
        return this.isUseDefaultParameters() ? this.isLayoutOfConnectedComponentsEnabledByDefault() : this.am;
    }

    protected boolean isLayoutOfConnectedComponentsEnabledByDefault() {
        return false;
    }

    public void setLayoutOfConnectedComponents(IlvGraphLayout ilvGraphLayout) {
        if (!this.supportsLayoutOfConnectedComponents() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the connected component layout mechanism");
        }
        if (this.a6 != null) {
            this.a6.setParentLayout(null);
            this.a6.detach();
        }
        if (ilvGraphLayout != this.a6) {
            if (ilvGraphLayout != null) {
                ilvGraphLayout.setParentLayout(this);
            }
            this.a6 = ilvGraphLayout;
            this.setStructureUpToDate(false);
            this.onParameterChanged("LayoutOfConnectedComponents");
        }
    }

    public IlvGraphLayout getLayoutOfConnectedComponents() {
        if (!this.supportsLayoutOfConnectedComponents()) {
            return null;
        }
        if (this.a6 == null) {
            IlvGridLayout ilvGridLayout = new IlvGridLayout();
            ilvGridLayout.setParentLayout(this);
            ilvGridLayout.setLayoutMode(0);
            ilvGridLayout.setLayoutRegion(new IlvRect(0.0f, 0.0f, 800.0f, 800.0f));
            this.a6 = ilvGridLayout;
        }
        return this.a6;
    }

    private void a(IlvGraphLayout ilvGraphLayout) {
        IlvGraphLayout ilvGraphLayout2 = null;
        if (ilvGraphLayout.supportsLayoutOfConnectedComponents()) {
            ilvGraphLayout2 = ilvGraphLayout.a6;
        }
        if (ilvGraphLayout2 == this.a6) {
            return;
        }
        if (ilvGraphLayout2 == null) {
            this.setLayoutOfConnectedComponents(null);
        } else if (this.a6 != null && this.a6.getClass() == ilvGraphLayout2.getClass()) {
            this.a6.copyParameters(ilvGraphLayout2);
        } else {
            this.setLayoutOfConnectedComponents(ilvGraphLayout2.copy());
        }
    }

    public final IlvGraphLayoutReport getLayoutOfConnectedComponentsReport() {
        IlvGraphLayout ilvGraphLayout = this.a6;
        if (ilvGraphLayout == null) {
            return null;
        }
        return ilvGraphLayout.isLayoutRunning() ? ilvGraphLayout.getLayoutReport() : this.bq;
    }

    public boolean supportsMemorySavings() {
        return false;
    }

    public boolean isMemorySavings() {
        if (!this.supportsMemorySavings() && !Beans.isDesignTime()) {
            return false;
        }
        return this.isUseDefaultParameters() ? false : this.ah;
    }

    public synchronized void setMemorySavings(boolean bl) {
        if (!this.supportsMemorySavings() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the memory savings mechanism");
        }
        if (this.ah != bl) {
            this.ah = bl;
            this.onParameterChanged("MemorySavings");
        }
    }

    public boolean supportsLayoutRegion() {
        return false;
    }

    private void d() {
        if (this.supportsLayoutRegion()) {
            IlvRect ilvRect = this.getCalcLayoutRegion();
            if (ilvRect == null) {
                this.a1 = null;
            } else if (this.a1 == null) {
                this.a1 = new IlvRect(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
            } else {
                this.a1.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
            }
        }
    }

    public synchronized void setLayoutRegion(IlvManagerView ilvManagerView) {
        block6: {
            block5: {
                if (!this.supportsLayoutRegion()) {
                    throw new RuntimeException("this layout class does not support the layout region mechanism");
                }
                if (ilvManagerView == null) {
                    throw new IllegalArgumentException("view argument cannot be null");
                }
                IlvManagerView ilvManagerView2 = this.az;
                IlvRect ilvRect = this.ax;
                boolean bl = this.isFitToView();
                this.az = ilvManagerView;
                this.ax = null;
                this.a(true);
                if (this.az != ilvManagerView2 || this.ax != ilvRect) break block5;
                if (this.isFitToView() == bl) break block6;
            }
            this.onParameterChanged("LayoutRegion");
        }
    }

    public synchronized void setLayoutRegion(IlvManagerView ilvManagerView, IlvRect ilvRect) {
        block9: {
            block8: {
                if (!this.supportsLayoutRegion()) {
                    throw new RuntimeException("this layout class does not support the layout region mechanism");
                }
                if (ilvManagerView == null) {
                    throw new IllegalArgumentException("view argument cannot be null");
                }
                if (ilvRect == null) {
                    throw new IllegalArgumentException("rect argument cannot be null");
                }
                if (ilvRect.width < 1.0E-20f) {
                    throw new IllegalArgumentException("the width of the rect is too small: " + ilvRect.width);
                }
                if (ilvRect.height < 1.0E-20f) {
                    throw new IllegalArgumentException("the height of the rect is too small: " + ilvRect.height);
                }
                IlvRect ilvRect2 = this.ax;
                IlvManagerView ilvManagerView2 = this.az;
                boolean bl = this.isFitToView();
                this.az = ilvManagerView;
                this.ax = new IlvRect(ilvRect);
                this.a(true);
                if (ilvRect2 == null || !this.ax.equals((Object)ilvRect2) || ilvManagerView2 == null || ilvManagerView2 != this.az) break block8;
                if (bl) break block9;
            }
            this.onParameterChanged("LayoutRegion");
        }
    }

    public synchronized void setLayoutRegion(IlvRect ilvRect) {
        block9: {
            block10: {
                block8: {
                    if (!this.supportsLayoutRegion()) {
                        throw new RuntimeException("this layout class does not support the layout region mechanism");
                    }
                    if (ilvRect != null) break block8;
                    boolean bl = !this.a0 || this.az != null || this.ax != null || this.ay != null;
                    this.a0 = true;
                    this.az = null;
                    this.ax = null;
                    this.ay = null;
                    if (bl) {
                        this.onParameterChanged("LayoutRegion");
                    }
                    break block9;
                }
                if (ilvRect.width < 1.0E-20f) {
                    throw new IllegalArgumentException("the width of the rect is too small: " + ilvRect.width);
                }
                if (ilvRect.height < 1.0E-20f) {
                    throw new IllegalArgumentException("the height of the rect is too small: " + ilvRect.height);
                }
                IlvRect ilvRect2 = this.ax;
                IlvManagerView ilvManagerView = this.az;
                boolean bl = this.isFitToView();
                this.ax = new IlvRect(ilvRect);
                this.ay = new IlvRect(ilvRect);
                this.az = null;
                this.a(false);
                if (ilvRect2 == null || !this.ax.equals((Object)ilvRect2) || ilvManagerView != null) break block10;
                if (!bl) break block9;
            }
            this.onParameterChanged("LayoutRegion");
        }
    }

    final IlvRect b() {
        if (this.ax == null) {
            return null;
        }
        if (this.isUseDefaultParameters()) {
            return null;
        }
        IlvRect ilvRect = new IlvRect(this.ax);
        if (this.getCoordinatesMode() != 2) {
            IlvManagerView ilvManagerView = null;
            if (this.a0) {
                IlvManagerView ilvManagerView2 = ilvManagerView = this.az == null ? this.g() : this.az;
                if (ilvManagerView != null) {
                    ilvManagerView.getTransformer().inverse(ilvRect);
                }
            }
        }
        return ilvRect;
    }

    public IlvRect getSpecLayoutRegion() {
        if (!this.supportsLayoutRegion()) {
            return null;
        }
        return this.e();
    }

    private IlvRect e() {
        IlvRect ilvRect;
        block11: {
            block8: {
                IlvManagerView ilvManagerView;
                block9: {
                    block10: {
                        ilvRect = new IlvRect();
                        ilvManagerView = null;
                        if (!this.a0) break block8;
                        IlvManagerView ilvManagerView2 = ilvManagerView = this.az == null ? this.g() : this.az;
                        if (ilvManagerView == null) {
                            return null;
                        }
                        if (this.ax != null) break block9;
                        Dimension dimension = ilvManagerView.getSize();
                        ilvRect.reshape(0.0f, 0.0f, (float)dimension.width, (float)dimension.height);
                        if (this.getCoordinatesMode() != 2) {
                            ilvManagerView.getTransformer().inverse(ilvRect);
                        }
                        if (ilvRect.width < 1.0E-20f) break block10;
                        if (!(ilvRect.height < 1.0E-20f)) break block11;
                    }
                    return null;
                }
                ilvRect.reshape(this.ax.x, this.ax.y, this.ax.width, this.ax.height);
                if (this.getCoordinatesMode() != 2) {
                    ilvManagerView.getTransformer().inverse(ilvRect);
                }
                break block11;
            }
            if (this.ax != null) {
                ilvRect.reshape(this.ax.x, this.ax.y, this.ax.width, this.ax.height);
            } else {
                return null;
            }
        }
        return ilvRect;
    }

    public IlvRect getLayoutRegion() {
        if (this.ay == null) {
            return null;
        }
        if (this.isUseDefaultParameters()) {
            return null;
        }
        return new IlvRect(this.ay);
    }

    public IlvRect getCalcLayoutRegion() {
        return this.f();
    }

    private IlvRect f() {
        IlvRect ilvRect;
        block5: {
            block7: {
                block6: {
                    block4: {
                        ilvRect = this.getSpecLayoutRegion();
                        if (ilvRect == null) break block4;
                        if (ilvRect.width < 1.0E-20f) break block4;
                        if (!(ilvRect.height < 1.0E-20f)) break block5;
                    }
                    if (this.getGraphModel() == null) break block5;
                    if (this.a2 == null) {
                        this.a2 = LayoutUtil.GetEstimatedLayoutRegion(this, this.getGraphModel());
                    }
                    if (this.a2 == null) break block6;
                    if (this.a2.width < 1.0E-20f) break block6;
                    if (!(this.a2.height < 1.0E-20f)) break block7;
                }
                this.bi.reshape(0.0f, 0.0f, 1000.0f, 1000.0f);
                return this.bi;
            }
            ilvRect = new IlvRect(this.a2);
        }
        return ilvRect;
    }

    public boolean isFitToView() {
        return this.a0;
    }

    final void a(boolean bl) {
        this.a0 = bl;
    }

    private final IlvManagerView g() {
        if (Beans.isDesignTime()) {
            return null;
        }
        if (this.bm == null) {
            return null;
        }
        IlvGrapher ilvGrapher = this.getGrapher();
        if (ilvGrapher == null) {
            return null;
        }
        Enumeration enumeration = ilvGrapher.getViews();
        return enumeration == null || !enumeration.hasMoreElements() ? null : (IlvManagerView)enumeration.nextElement();
    }

    public boolean supportsRandomGenerator() {
        return false;
    }

    public void setSeedValueForRandomGenerator(long l) {
        if (!this.supportsRandomGenerator() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the random generator seed value mechanism");
        }
        if (l != this.aj) {
            this.aj = l;
            this.onParameterChanged("SeedValueForRandomGenerator");
        }
    }

    public long getSeedValueForRandomGenerator() {
        return this.isUseDefaultParameters() ? 0L : this.aj;
    }

    public void setUseSeedValueForRandomGenerator(boolean bl) {
        if (!this.supportsRandomGenerator() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the random generator seed value mechanism");
        }
        if (this.ak != bl) {
            this.ak = bl;
            this.onParameterChanged("UseSeedValueForRandomGenerator");
        }
    }

    public boolean isUseSeedValueForRandomGenerator() {
        return this.isUseDefaultParameters() ? false : this.ak;
    }

    public boolean supportsAllowedTime() {
        return false;
    }

    public long getAllowedTime() {
        if (!this.supportsAllowedTime()) {
            return Long.MAX_VALUE;
        }
        return this.isUseDefaultParameters() ? 32000L : this.ab;
    }

    public synchronized void setAllowedTime(long l) {
        if (!this.supportsAllowedTime() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the allowed time mechanism");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Allowed time cannot be negative!");
        }
        if (this.ab != l) {
            this.ab = l;
            this.onParameterChanged("AllowedTime");
        }
    }

    protected boolean isLayoutTimeElapsed() {
        if (this.bp == null || !this.supportsAllowedTime()) {
            return false;
        }
        return System.currentTimeMillis() - this.bp.a() > this.getAllowedTime();
    }

    public final long getRemainingAllowedTime() {
        if (this.bp == null || !this.supportsAllowedTime()) {
            return -1L;
        }
        long l = this.getAllowedTime() - (System.currentTimeMillis() - this.bp.a());
        return l >= 0L ? l : 0L;
    }

    public boolean supportsLayoutOfConnectedComponents() {
        return false;
    }

    public void contentsChanged(GraphModelEvent graphModelEvent) {
        this.a(graphModelEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GraphModelEvent graphModelEvent) {
        if (this.isLayoutRunning()) {
            return;
        }
        this.a2 = null;
        if (!graphModelEvent.isAdjustmentEnd()) {
            Object object;
            if ((graphModelEvent.getType() & 1) != 0) {
                this.setStructureUpToDate(false);
                this.a8 = false;
                if (this.a6 != null) {
                    this.a6.detach();
                }
                if (this.a7 != null) {
                    this.a7.dispose();
                    this.a7 = null;
                }
            } else if ((graphModelEvent.getType() & 2) != 0) {
                this.setGeometryUpToDate(false);
                if (this.a6 != null) {
                    this.a6.setGeometryUpToDate(false);
                }
            }
            if ((object = graphModelEvent.getNodeOrLink()) != null) {
                if ((graphModelEvent.getType() & 8) != 0) {
                    this.cleanNode(graphModelEvent.getGraphModel(), object);
                } else if ((graphModelEvent.getType() & 0x20) != 0) {
                    this.cleanLink(graphModelEvent.getGraphModel(), object);
                }
            }
        }
        boolean bl = false;
        if (!graphModelEvent.isAdjusting() && this.isLayoutNeeded() && !this.isLayoutRunning(true) && ((graphModelEvent.getType() & 0x40) != 0 || (graphModelEvent.getType() & 0x80) != 0 || (graphModelEvent.getType() & 4) != 0 || (graphModelEvent.getType() & 8) != 0 || (graphModelEvent.getType() & 0x10) != 0 || (graphModelEvent.getType() & 0x20) != 0) && this.h()) {
            try {
                this.performAutoLayout();
                bl = this.isParametersUpToDate();
            }
            finally {
                this.setAutoLayout(true);
                this.setParametersUpToDate(bl);
            }
        }
    }

    private synchronized boolean h() {
        boolean bl = this.isAutoLayout();
        if (bl) {
            this.setAutoLayout(false);
        }
        return bl;
    }

    public void setAutoLayoutHandler(IlvAutoLayoutHandler ilvAutoLayoutHandler) {
        if (ilvAutoLayoutHandler != this.ar) {
            this.ar = ilvAutoLayoutHandler;
            this.onParameterChanged("AutoLayoutHandler");
        }
    }

    public IlvAutoLayoutHandler getAutoLayoutHandler() {
        return this.ar;
    }

    protected void performAutoLayout() {
        IlvAutoLayoutHandler ilvAutoLayoutHandler = this.getAutoLayoutHandler();
        if (ilvAutoLayoutHandler != null) {
            ilvAutoLayoutHandler.performAutoLayout(this, null);
        } else {
            try {
                this.performLayout(true, true);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
    }

    public void setAutoLayout(boolean bl) {
        if (bl != this.ai) {
            this.ai = bl;
            this.onParameterChanged("AutoLayout");
        }
    }

    public final boolean isAutoLayout() {
        return this.isUseDefaultParameters() ? false : this.ai;
    }

    public boolean supportsLinkConnectionBox() {
        return false;
    }

    public void setLinkConnectionBoxInterface(IlvLinkConnectionBoxInterface ilvLinkConnectionBoxInterface) {
        if (!this.supportsLinkConnectionBox() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the link connection box mechanism");
        }
        if (ilvLinkConnectionBoxInterface != this.aq) {
            this.aq = ilvLinkConnectionBoxInterface;
            this.onParameterChanged("LinkConnectionBoxInterface");
        }
    }

    public IlvLinkConnectionBoxInterface getLinkConnectionBoxInterface() {
        return this.aq;
    }

    public boolean supportsLinkClipping() {
        return false;
    }

    public void setLinkClipInterface(IlvLinkClipInterface ilvLinkClipInterface) {
        if (!this.supportsLinkClipping() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the link clipping mechanism");
        }
        if (ilvLinkClipInterface != this.ap) {
            this.ap = ilvLinkClipInterface;
            this.onParameterChanged("LinkClipInterface");
        }
    }

    public IlvLinkClipInterface getLinkClipInterface() {
        return this.ap;
    }

    public void clipLink(Object object, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IlvInappropriateLinkException {
        IlvPoint ilvPoint;
        IlvPoint ilvPoint2;
        IlvPoint ilvPoint3;
        IlvPoint ilvPoint4;
        IlvPoint ilvPoint5;
        float f;
        float f2;
        IlvRect ilvRect;
        int n;
        IlvLinkClipInterface ilvLinkClipInterface = this.getLinkClipInterface();
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (!this.supportsLinkClipping() || ilvLinkClipInterface == null || ilvGraphModel == null) {
            return;
        }
        IlvPoint[] ilvPointArray = ilvGraphModel.getLinkPoints(object);
        int n2 = n = ilvPointArray != null ? ilvPointArray.length : 0;
        if (n < 2) {
            return;
        }
        IlvLinkConnectionBoxInterface ilvLinkConnectionBoxInterface = this.getLinkConnectionBoxInterface();
        Object object2 = ilvGraphModel.getFrom(object);
        Object object3 = ilvGraphModel.getTo(object);
        IlvRect ilvRect2 = ilvGraphModel.boundingBox(object2);
        IlvRect ilvRect3 = ilvGraphModel.boundingBox(object3);
        if (bl2 && bl) {
            ilvRect = ilvRect2;
            f2 = 0.0f;
            f = 0.0f;
            if (this.supportsLinkConnectionBox() && ilvLinkConnectionBoxInterface != null) {
                ilvRect = ilvLinkConnectionBoxInterface.getBox(ilvGraphModel, object2);
                f2 = 0.5f * (ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object2, 4) + ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object2, 8));
                f = 0.5f * (ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object2, 1) + ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object2, 2));
            }
            ilvPoint5 = new IlvPoint(ilvRect.x + 0.5f * ilvRect.width + f2, ilvRect.y + 0.5f * ilvRect.height + f);
        } else {
            ilvPoint5 = ilvPointArray[0];
        }
        if (bl3 && bl) {
            ilvRect = ilvRect3;
            f2 = 0.0f;
            f = 0.0f;
            if (this.supportsLinkConnectionBox() && ilvLinkConnectionBoxInterface != null) {
                ilvRect = ilvLinkConnectionBoxInterface.getBox(ilvGraphModel, object3);
                f2 = 0.5f * (ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object3, 4) + ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object3, 8));
                f = 0.5f * (ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object3, 1) + ilvLinkConnectionBoxInterface.getTangentialOffset(ilvGraphModel, object3, 2));
            }
            ilvPoint4 = new IlvPoint(ilvRect.x + 0.5f * ilvRect.width + f2, ilvRect.y + 0.5f * ilvRect.height + f);
        } else {
            ilvPoint4 = ilvPointArray[n - 1];
        }
        if (n == 2) {
            ilvPoint2 = ilvPoint3 = new IlvPoint(0.5f * (ilvPoint5.x + ilvPoint4.x), 0.5f * (ilvPoint5.y + ilvPoint4.y));
        } else {
            ilvPoint2 = ilvPointArray[1];
            ilvPoint3 = ilvPointArray[n - 2];
        }
        ilvRect = null;
        if (bl2 && !ilvPoint5.equals((Object)(ilvPoint = ilvLinkClipInterface.getConnectionPoint(ilvGraphModel, object2, ilvRect2, object, ilvPoint5, ilvPoint2, true)))) {
            ilvRect = ilvPoint;
        }
        IlvPoint ilvPoint6 = null;
        if (bl3 && !ilvPoint4.equals((Object)(ilvPoint = ilvLinkClipInterface.getConnectionPoint(ilvGraphModel, object3, ilvRect3, object, ilvPoint4, ilvPoint3, false)))) {
            ilvPoint6 = ilvPoint;
        }
        if (ilvRect != null || ilvPoint6 != null) {
            ReshapeLinkUtil.reshapeLink(ilvGraphModel, this, object, 1, (IlvPoint)ilvRect, ilvPointArray, 1, n - 2, ilvPoint6, bl4);
        }
    }

    public void clipAllLinks(boolean bl, boolean bl2) throws IlvInappropriateLinkException {
        IlvLinkClipInterface ilvLinkClipInterface = this.getLinkClipInterface();
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (!this.supportsLinkClipping() || ilvLinkClipInterface == null || ilvGraphModel == null) {
            return;
        }
        Enumeration enumeration = ilvGraphModel.getLinks();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.clipLink(e, bl, true, true, bl2);
        }
    }

    public boolean supportsSplineRouting() {
        return false;
    }

    public void setSplineRoutingEnabled(boolean bl) {
        if (!this.supportsSplineRouting() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the generic optimized spline routing mechanism");
        }
        if (bl != this.as) {
            this.as = bl;
            this.onParameterChanged("SplineRoutingEnabled");
        }
    }

    public boolean isSplineRoutingEnabled() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.as;
    }

    public void setMinSplineCurveSize(float f) {
        if (!this.supportsSplineRouting() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the generic optimized spline routing mechanism");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Negative minimal spline curve size: " + f);
        }
        if (f != this.at) {
            this.at = f;
            this.onParameterChanged("MinSplineCurveSize");
        }
    }

    public float getMinSplineCurveSize() {
        if (this.isUseDefaultParameters()) {
            return 5.0f;
        }
        return this.at;
    }

    public void setMaxSplineCurveSize(float f) {
        if (!this.supportsSplineRouting() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the generic optimized spline routing mechanism");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Negative maximum spline curve size: " + f);
        }
        if (f != this.au) {
            this.au = f;
            this.onParameterChanged("MaxSplineCurveSize");
        }
    }

    public float getMaxSplineCurveSize() {
        if (this.isUseDefaultParameters()) {
            return 30.0f;
        }
        return this.au;
    }

    public void setBalanceSplineCurveThreshold(float f) {
        if (!this.supportsSplineRouting() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the generic optimized spline routing mechanism");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative balance spline curve threshold: " + f);
        }
        if (f != this.av) {
            this.av = f;
            this.onParameterChanged("BalanceSplineCurveThreshold");
        }
    }

    public float getBalanceSplineCurveThreshold() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.av;
    }

    public void setSplineLinkFilter(IlvSplineLinkFilter ilvSplineLinkFilter) {
        if (!this.supportsSplineRouting() && !Beans.isDesignTime()) {
            throw new RuntimeException("this layout class does not support the generic optimized spline routing mechanism");
        }
        if (ilvSplineLinkFilter != this.aw) {
            this.aw = ilvSplineLinkFilter;
            this.onParameterChanged("SplineLinkFilter");
        }
    }

    public IlvSplineLinkFilter getSplineLinkFilter() {
        return this.aw;
    }

    public boolean supportsSaveParametersToNamedProperties() {
        return false;
    }

    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvGraphLayoutGrapherProperty(string, this, bl);
    }

    protected IlvGraphLayoutNodeProperty createLayoutNodeProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvGraphLayoutNodeProperty(string, this, ilvGraphic, bl);
    }

    protected IlvGraphLayoutLinkProperty createLayoutLinkProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvGraphLayoutLinkProperty(string, this, ilvGraphic, bl);
    }

    public final Object setProperty(String string, Object object) {
        if (this.br == null) {
            this.br = new IlvDefaultPropertyContainer();
        }
        return this.br.setProperty(string, object);
    }

    public final Object getProperty(String string) {
        return this.br != null ? this.br.getProperty(string) : null;
    }

    public final Object setProperty(IlvGraphModel ilvGraphModel, Object object, String string, Object object2) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        IlvPropertyContainerInterface ilvPropertyContainerInterface = (IlvPropertyContainerInterface)ilvGraphModel.getProperty(object, this.d);
        if (ilvPropertyContainerInterface == null && object2 != null) {
            ilvPropertyContainerInterface = new IlvDefaultPropertyContainer();
            ilvGraphModel.setProperty(object, this.d, ilvPropertyContainerInterface);
        }
        return ilvPropertyContainerInterface != null ? ilvPropertyContainerInterface.setProperty(string, object2) : null;
    }

    public final Object getProperty(IlvGraphModel ilvGraphModel, Object object, String string) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        IlvPropertyContainerInterface ilvPropertyContainerInterface = (IlvPropertyContainerInterface)ilvGraphModel.getProperty(object, this.d);
        return ilvPropertyContainerInterface != null ? ilvPropertyContainerInterface.getProperty(string) : null;
    }

    static {
        bl = new Runnable(){

            public void run() {
                bk = false;
            }
        };
    }
}

