/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.xml;

import java.net.URL;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.xml.XmlModelDependency;
import oracle.jdeveloper.audit.xml.XmlModelDependencyListener;

class XmlModelDependencyMediator
extends NodeListener {
    private static final Log LOG = new Log("xml-dependency", "dependency");
    private final MultiMap<URL, XmlModelDependencyListener> listenersByFile = new MultiMap(CopyOnWriteArrayList.class);

    XmlModelDependencyMediator() {
        Node.addNodeListenerForTypeHierarchy(XMLSourceNode.class, (NodeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDependency(XmlModelDependency dependency) {
        XmlModelDependencyListener attachingListener;
        String message;
        XMLSourceNode node = dependency.getNode();
        if (node == null) {
            String message2 = "addDependency: node " + dependency.getFile() + " collected since dependency created";
            LOG.trace(message2);
            return;
        }
        Node cachedNode = NodeFactory.find((URL)dependency.getFile());
        if (node != cachedNode) {
            message = cachedNode != null ? "addDependency: node " + dependency.getFile() + " (" + ((Object)((Object)node)).getClass() + ") differs from cached node (" + cachedNode.getClass() + ")" : "addDependency: node " + dependency.getFile() + " (" + ((Object)((Object)node)).getClass() + ") uncached";
            LOG.trace(message);
        }
        if (!node.isReadLockHeld()) {
            message = "addDependency: node " + dependency.getFile() + " (" + ((Object)((Object)node)).getClass() + ") not locked by caller";
            LOG.trace(message);
            AuditLogger.error((Throwable)new Throwable(message), (String)message, (Object[])new Object[0]);
            return;
        }
        if (!node.isOpen()) {
            message = "addDependency: node " + dependency.getFile() + " (" + ((Object)((Object)node)).getClass() + ") not opened by caller";
            LOG.trace(message);
            AuditLogger.error((Throwable)new Throwable(message), (String)message, (Object[])new Object[0]);
            return;
        }
        Context ideContext = new Context(null, dependency.getWorkspace(), dependency.getProject(), (Node)node);
        if (!JDevXmlContext.hasXmlContextBeenCreated(ideContext)) {
            String message3 = "addDependency: node " + dependency.getFile() + " (" + ((Object)((Object)node)).getClass() + ") XMLContext not created";
            LOG.trace(message3);
            AuditLogger.error((Throwable)new Throwable(message3), (String)message3, (Object[])new Object[0]);
            return;
        }
        if (JDevXmlContext.getXmlContext(ideContext).getModel().getDomModel().needsReparse()) {
            String message4 = "addDependency: node " + dependency.getFile() + " (" + ((Object)((Object)node)).getClass() + ") XML model not parsed";
            LOG.trace(message4);
            AuditLogger.error((Throwable)new Throwable(message4), (String)message4, (Object[])new Object[0]);
            return;
        }
        XmlModelDependencyMediator xmlModelDependencyMediator = this;
        synchronized (xmlModelDependencyMediator) {
            URL file = dependency.getFile();
            Collection listeners = this.listenersByFile.get((Object)file);
            if (listeners != null) {
                for (XmlModelDependencyListener listener : listeners) {
                    if (!listener.matches(dependency)) continue;
                    listener.addDependency(dependency);
                    return;
                }
            }
            attachingListener = new XmlModelDependencyListener(dependency);
            LOG.trace("******** created xml model dependency listener: {0}", (Object)attachingListener);
            this.listenersByFile.add((Object)file, (Object)attachingListener);
        }
        attachingListener.addListener(dependency, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDependency(XmlModelDependency dependency) {
        Node cachedNode;
        XMLSourceNode node = dependency.getNode();
        URL file = dependency.getFile();
        if (node == null && (cachedNode = NodeFactory.find((URL)file)) instanceof XMLSourceNode) {
            node = (XMLSourceNode)cachedNode;
        }
        if (node != null && node.isReadLockHeld()) {
            String message = "removeDependency: node " + file + " (" + ((Object)((Object)node)).getClass() + ") read-locked by caller";
            LOG.trace(message);
            AuditLogger.error((Throwable)new Throwable(message), (String)message, (Object[])new Object[0]);
            return;
        }
        XmlModelDependencyListener removingListener = null;
        XmlModelDependencyMediator xmlModelDependencyMediator = this;
        synchronized (xmlModelDependencyMediator) {
            Collection listeners = this.listenersByFile.get((Object)file);
            if (listeners != null) {
                for (XmlModelDependencyListener listener : listeners) {
                    if (!listener.matches(dependency)) continue;
                    listener.removeDependency(dependency);
                    if (!listener.disabled()) break;
                    this.listenersByFile.removeValue((Object)file, (Object)listener);
                    removingListener = listener;
                    break;
                }
            }
        }
        if (removingListener != null && node != null) {
            removingListener.removeListener(dependency, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeOpened(NodeEvent e) {
        Collection listeners;
        XMLSourceNode node = (XMLSourceNode)e.getNode();
        XmlModelDependencyMediator xmlModelDependencyMediator = this;
        synchronized (xmlModelDependencyMediator) {
            listeners = this.listenersByFile.get((Object)node.getURL());
        }
        if (listeners == null) {
            return;
        }
        for (XmlModelDependencyListener listener : listeners) {
            listener.handleNodeOpened(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeClosed(NodeEvent e) {
        Collection listeners;
        XMLSourceNode node = (XMLSourceNode)e.getNode();
        XmlModelDependencyMediator xmlModelDependencyMediator = this;
        synchronized (xmlModelDependencyMediator) {
            listeners = this.listenersByFile.get((Object)node.getURL());
        }
        if (listeners == null) {
            return;
        }
        for (XmlModelDependencyListener listener : listeners) {
            listener.handleNodeClosedOrRenamed(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRenamed(NodeEvent e, URL oldUrl, URL newUrl) {
        Collection listeners;
        XMLSourceNode node = (XMLSourceNode)e.getNode();
        XmlModelDependencyMediator xmlModelDependencyMediator = this;
        synchronized (xmlModelDependencyMediator) {
            listeners = this.listenersByFile.get((Object)oldUrl);
        }
        if (listeners == null) {
            return;
        }
        for (XmlModelDependencyListener listener : listeners) {
            listener.handleNodeClosedOrRenamed(node);
        }
    }
}

