/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.preference.jdev;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.preference.XmlPreferenceManager;
import oracle.bali.xml.preference.jdev.JDevXmlPrefs;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class JDevXmlPreferenceManager
extends XmlPreferenceManager
implements Copyable {
    private ListStructure _preferenceManagerList;

    public JDevXmlPreferenceManager(ListStructure preferenceManagerList) {
        this._preferenceManagerList = preferenceManagerList;
        for (int i = 0; i < this._preferenceManagerList.size(); ++i) {
            ListStructure preferenceItemList = (ListStructure)this._preferenceManagerList.get(i);
            this.getPreferences().put(preferenceItemList.get(0), preferenceItemList.get(1));
        }
    }

    public JDevXmlPreferenceManager(String preferenceManagerName, ListStructure preferenceManagerList) {
        super(preferenceManagerName);
        this._preferenceManagerList = preferenceManagerList;
        for (int i = 0; i < this._preferenceManagerList.size(); ++i) {
            ListStructure preferenceItemList = (ListStructure)this._preferenceManagerList.get(i);
            this.getPreferences().put(preferenceItemList.get(0), preferenceItemList.get(1));
        }
    }

    public void storePreferenceManagerToMemory() {
        JDevXmlPrefs jDevXmlPrefs = JDevXmlPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        ListStructure preferenceManagerList = ListStructure.newInstance();
        HashMap hashMap = this.getPreferences();
        for (Map.Entry entries : hashMap.entrySet()) {
            ListStructure preferenceItemList = ListStructure.newInstance();
            preferenceItemList.add(entries.getKey());
            preferenceItemList.add(entries.getValue());
            preferenceManagerList.add((Object)preferenceItemList);
        }
        if (!preferenceManagerList.isEmpty()) {
            jDevXmlPrefs.getPreferenceManagerHashStructure().putListStructure(this.getPreferenceManagerName(), preferenceManagerList);
        }
    }

    public Object copyTo(Object target) {
        JDevXmlPreferenceManager copy = target != null ? (JDevXmlPreferenceManager)((Object)target) : new JDevXmlPreferenceManager(this._preferenceManagerList);
        copy.setPreferenceManagerName(this.getPreferenceManagerName());
        copy.setPreferences(this.getPreferences());
        copy.setPropertyChangeSupport(this.getPropertyChangeSupport());
        return copy;
    }

    public static JDevXmlPreferenceManager getPreferenceManagerByName(String preferenceManagerName) {
        JDevXmlPrefs jDevXmlPrefs = JDevXmlPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        ListStructure preferenceManagerList = jDevXmlPrefs.getPreferenceManagerHashStructure().getListStructure(preferenceManagerName);
        if (preferenceManagerList != null) {
            return new JDevXmlPreferenceManager(preferenceManagerName, preferenceManagerList);
        }
        JDevXmlPreferenceManager preferenceManager = new JDevXmlPreferenceManager(preferenceManagerName, ListStructure.newInstance());
        preferenceManager.storePreferenceManagerToDisk();
        return preferenceManager;
    }
}

