/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.util;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.operation.AbstractSingleFlavorOperation;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.share.TransactionToken;
import oracle.ide.Context;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;

class OpenInEditorOperation
extends AbstractSingleFlavorOperation {
    OpenInEditorOperation() {
    }

    public boolean apply(AbstractModel model, DomPosition pos, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        TransferableContext transferableContext = (TransferableContext)data.getData(FetchMode.STANDARD, false);
        if (transferableContext != null) {
            for (Element elem : transferableContext) {
                Context copy = Context.newIdeContext();
                copy.setElement(elem);
                if (elem instanceof Node) {
                    copy.setNode((Node)elem);
                }
                OpenEditorOptions opt = new OpenEditorOptions(copy);
                EditorManager.getEditorManager().openEditor(opt);
            }
        }
        return false;
    }

    protected List getApplicableDataAndPositionsImpl(AbstractModel model, List positions, List dataInfos) {
        DomPosition insideDoc = DomPositionFactory.inside((org.w3c.dom.Node)model.getDocument());
        ArrayList<DataAndPositions> ret = new ArrayList<DataAndPositions>(dataInfos.size());
        for (TransferDataInfo data : dataInfos) {
            if (!this.transferableHasAnEditor(data)) continue;
            DataAndPositions dap = new DataAndPositions(data, Collections.singletonList(insideDoc));
            ret.add(dap);
        }
        return ret;
    }

    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        return model.getTranslatedString("OpenFilesInEditor");
    }

    protected DataFlavor getRequiredDataFlavor() {
        return TransferableContext.contextFlavor;
    }

    public float getSuitabilityRank() {
        return 0.1f;
    }

    public int getSupportedActions() {
        return 0x40000001;
    }

    public boolean doesActionMutateModel() {
        return false;
    }

    private boolean transferableHasAnEditor(TransferDataInfo data) {
        try {
            TransferableContext transferableContext = (TransferableContext)data.getData(FetchMode.STANDARD, false);
            if (transferableContext != null) {
                for (Element elem : transferableContext) {
                    if (!(elem instanceof Node) || EditorManager.getEditorManager().getBestEditorAddin((Node)elem) == null) continue;
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

