/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.swing.inspector.SwingInspectorGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.ide.help.HelpInfo;
import oracle.ide.inspector.IdePropertyModel;
import org.w3c.dom.Node;

public class JDevDomPropertyModel
extends XmlDomPropertyModel {
    private static Icon _errorIcon;
    private static Icon _warningIcon;
    private static Icon _dataBoundIcon;
    private static Icon _setIcon;
    private static Icon _customizedAtTipIcon;
    private static Icon _spacerIcon;
    private static final int SET_ICON = 0;
    private static final int DATABOUND_ICON = 1;
    private static final int CUSTOMIZED_ICON = 2;
    private Object[] _columns;
    private int _jdevIconIndex;
    private int _jdevHelpIndex;
    private final transient int _isDataBoundIndex = this.getColumnIndex(COLUMN_IS_DATABOUND);
    private final transient int _isSetIndex = this.getColumnIndex(COLUMN_IS_SET);
    private final transient int _isCustomizedAtTipIndex = this.getColumnIndex(COLUMN_IS_CUSTOMIZED_AT_TIP);
    private final transient int _helpTopicIndex = this.getColumnIndex(COLUMN_HELP_TOPIC);
    private final transient int _xmlKeyIndex = this.getColumnIndex(COLUMN_XMLKEY);
    private final transient int _nodeIndex = this.getColumnIndex(COLUMN_NODE);
    private final transient int _isDatabindingSupportedIndex = this.getColumnIndex(COLUMN_SUPPORTS_DATABINDING);
    private final transient int _iconTooltipIndex = this.getColumnIndex(COLUMN_ICON_TOOLTIP);

    public JDevDomPropertyModel(Node node, BaseInspectorGui gui) {
        super(node, gui);
    }

    public JDevDomPropertyModel(Node node, XmlKey nodeKey, BaseInspectorGui gui) {
        super(node, nodeKey, gui);
    }

    public JDevDomPropertyModel(Node node, List<XmlKey> keys, BaseInspectorGui gui) {
        super(node, keys, gui);
    }

    public Object[] getColumnMapping() {
        if (this._columns == null) {
            Object[] parentColumns = super.getColumnMapping();
            this._columns = new Object[parentColumns.length + 2];
            System.arraycopy(parentColumns, 0, this._columns, 0, parentColumns.length);
            this._jdevIconIndex = parentColumns.length;
            this._jdevHelpIndex = this._jdevIconIndex + 1;
            this._columns[this._jdevIconIndex] = COLUMN_ICON;
            this._columns[this._jdevHelpIndex] = IdePropertyModel.COLUMN_HELP;
        }
        return this._columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getProperty(PropertyRow row, int columnIndex) {
        Object result = null;
        if (columnIndex == this._jdevIconIndex) {
            result = this._isDatabound(row) ? JDevDomPropertyModel._getDataboundIcon(this.getGui()) : (this._getBooleanColumn(row, this._isCustomizedAtTipIndex) ? JDevDomPropertyModel._getCustomizedAtTipIcon(this.getGui()) : (this._getBooleanColumn(row, this._isSetIndex) ? JDevDomPropertyModel._getSetIcon(this.getGui()) : JDevDomPropertyModel._getSpacerIcon(this.getGui())));
        } else if (columnIndex == this._iconTooltipIndex) {
            result = this._isDatabound(row) ? this._getIconTooltip(1) : (this._getBooleanColumn(row, this._isCustomizedAtTipIndex) ? this._getIconTooltip(2) : (this._getBooleanColumn(row, this._isSetIndex) ? this._getIconTooltip(0) : JDevDomPropertyModel._getSpacerIcon(this.getGui())));
        } else if (columnIndex == this._jdevHelpIndex) {
            Object ht = super.getProperty(row, this._helpTopicIndex);
            if (ht != null) {
                result = new HelpInfo(ht.toString());
            } else {
                String topic;
                XmlKey nodeKey = (XmlKey)super.getProperty(row, this._xmlKeyIndex);
                Node node = (Node)super.getProperty(row, this._nodeIndex);
                this.getView().getDomModel().acquireReadLock();
                try {
                    topic = this.getGui().getHelpTopic(node, nodeKey);
                }
                finally {
                    this.getView().getDomModel().releaseReadLock();
                }
                if (topic != null) {
                    result = new HelpInfo(topic);
                }
            }
        } else {
            result = super.getProperty(row, columnIndex);
        }
        return result;
    }

    private String _getIconTooltip(int iconIndex) {
        String tooltip = null;
        BaseInspectorGui gui = this.getGui();
        switch (iconIndex) {
            case 0: {
                tooltip = gui.getTranslatedString("INSPECTOR.SET_ICON_TOOLTIP");
                break;
            }
            case 1: {
                tooltip = gui.getTranslatedString("INSPECTOR.DATABOUND_ICON_TOOLTIP");
                break;
            }
            case 2: {
                tooltip = gui.getTranslatedString("INSPECTOR.CUSTOMIZED_AT_TIP_ICON_TOOLTIP");
            }
        }
        return tooltip;
    }

    private boolean _isDatabound(PropertyRow row) {
        boolean db = this._getBooleanColumn(row, this._isDataBoundIndex);
        boolean s = this._getBooleanColumn(row, this._isDatabindingSupportedIndex);
        return true == db && true == s;
    }

    private boolean _getBooleanColumn(PropertyRow row, int column) {
        Boolean b = (Boolean)super.getProperty(row, column);
        return b;
    }

    private static Icon _getDataboundIcon(BaseInspectorGui gui) {
        if (_dataBoundIcon == null && gui instanceof SwingInspectorGui) {
            _dataBoundIcon = ((SwingInspectorGui)gui).getDataboundIcon();
        }
        return _dataBoundIcon;
    }

    private static Icon _getSetIcon(BaseInspectorGui gui) {
        if (_setIcon == null && gui instanceof SwingInspectorGui) {
            _setIcon = ((SwingInspectorGui)gui).getAttributeSetIcon();
        }
        return _setIcon;
    }

    private static Icon _getCustomizedAtTipIcon(BaseInspectorGui gui) {
        if (_customizedAtTipIcon == null && gui instanceof SwingInspectorGui) {
            _customizedAtTipIcon = ((SwingInspectorGui)gui).getCustomizedAtTipIcon();
        }
        return _customizedAtTipIcon;
    }

    private static Icon _getSpacerIcon(BaseInspectorGui gui) {
        if (_spacerIcon == null && gui instanceof SwingInspectorGui) {
            _spacerIcon = ((SwingInspectorGui)gui).getSpacerIcon();
        }
        return _spacerIcon;
    }

    private static Icon _getErrorIcon(BaseInspectorGui gui) {
        if (_errorIcon == null && gui instanceof SwingInspectorGui) {
            _errorIcon = ((SwingInspectorGui)gui).getErrorIcon();
        }
        return _errorIcon;
    }

    private static Icon _getWarningIcon(BaseInspectorGui gui) {
        if (_warningIcon == null && gui instanceof SwingInspectorGui) {
            _warningIcon = ((SwingInspectorGui)gui).getWarningIcon();
        }
        return _warningIcon;
    }
}

