/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.extension.guifactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.extension.util.HashStructureUtils;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.rules.RuleEngine;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class DeclarativeGuiFactoryHookData
extends HashStructureAdapter {
    private static final String USAGES = "usages";
    private static final String USAGE = "usage";
    private static final String CLASS = "class-name";
    private Collection<XmlUsage> _usages;
    private boolean _bFactoryCreated;
    private XmlGuiFactory _xmlGuiFactory;

    private DeclarativeGuiFactoryHookData(HashStructure hash) {
        super(hash);
    }

    public static DeclarativeGuiFactoryHookData getInstance(HashStructure hash) {
        return new DeclarativeGuiFactoryHookData(hash);
    }

    public boolean evaluateRule(JDevXmlContext xmlContext) {
        String ruleId = this._hash.getString("rule");
        RuleEngine engine = RuleEngine.getInstance();
        if (engine.validateRuleReference(ruleId, null)) {
            return engine.evaluateRule(ruleId, xmlContext.createContext());
        }
        return false;
    }

    public boolean supportsUsage(XmlUsage xmlUsage) {
        return this.getXmlUsages().contains(xmlUsage);
    }

    public XmlGui createGui(XmlView xmlView, XmlUsage xmlUsage) {
        XmlGuiFactory factory = this.getXmlGuiFactory();
        if (factory != null) {
            return factory.createGui(xmlView, xmlUsage);
        }
        return null;
    }

    private synchronized Collection<XmlUsage> getXmlUsages() {
        if (this._usages == null) {
            List usageData;
            this._usages = new ArrayList<XmlUsage>();
            HashStructure usages = this._hash.getHashStructure(USAGES);
            if (usages != null && (usageData = usages.getAsList(USAGE)) != null && !usageData.isEmpty()) {
                for (Object xmlUsage : usageData) {
                    try {
                        HashStructure usage = (HashStructure)xmlUsage;
                        String usageName = usage.getString("#text");
                        if (usageName != null) {
                            usageName = usageName.trim();
                        }
                        if (usageName == null || usageName.length() <= 0) continue;
                        this._usages.add(new XmlUsage(usageName));
                    }
                    catch (Exception e) {
                        HashStructureUtils.logExtensionMessage(Level.SEVERE, e.getLocalizedMessage(), this._hash);
                    }
                }
            }
        }
        return this._usages;
    }

    private synchronized XmlGuiFactory getXmlGuiFactory() {
        if (!this._bFactoryCreated) {
            this._bFactoryCreated = true;
            try {
                HashStructure factoryData = this._hash.getHashStructure(CLASS);
                LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)factoryData);
                this._xmlGuiFactory = (XmlGuiFactory)lazyClassAdapter.createInstance(XmlGuiFactory.class, "#text");
            }
            catch (Exception e) {
                HashStructureUtils.logExtensionMessage(Level.SEVERE, e.getLocalizedMessage(), this._hash);
            }
        }
        return this._xmlGuiFactory;
    }
}

