/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency.url;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.jdev.dependency.ExternalReferenceProvider;
import oracle.bali.xml.gui.jdev.dependency.url.UrlReference;
import oracle.bali.xml.indexing.ContextualIndexingFactory;
import oracle.bali.xml.indexing.IndexingFactory;
import oracle.bali.xml.indexing.XmlIndexingContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.dependency.ReferenceFactory;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.IdDeclaration;
import oracle.ide.dependency.URLDeclarationProvider;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Node;

public class UrlReferenceFactory
extends ReferenceFactory
implements ContextualIndexingFactory,
ExternalReferenceProvider {
    private XmlIndexingContext _context;

    public Collection<Reference> getReferences(XmlContext context, Node node, String value) {
        return Collections.singletonList(new UrlReference(context, node, 0, value.length(), context.getURLForRelativePath(value)));
    }

    public List<IndexingFactory.IndexEntry> getIndexEntries(QualifiedName elementQN, QualifiedName attrQN, String value) {
        ArrayList<IndexingFactory.IndexEntry> entries = new ArrayList<IndexingFactory.IndexEntry>();
        URL fileUrl = URLFactory.newURL((String)value);
        entries.add(new IndexingFactory.IndexEntry(this.getIndexKey(), URLFileSystem.getFileName((URL)fileUrl), 0, value.length()));
        return entries;
    }

    @Override
    public String getIndexKey() {
        return "XDF_URL_REF";
    }

    @Override
    public String getIndexValue(Context ideContext, String id) {
        URL url = URLDeclarationProvider.getURL((String)id);
        if (url != null) {
            return URLFileSystem.getFileName((URL)url);
        }
        return null;
    }

    @Override
    public boolean isReferenceFor(Declaration declaration) {
        if (declaration instanceof IdDeclaration) {
            IdDeclaration idDecl = (IdDeclaration)declaration;
            return URLDeclarationProvider.isURLDeclaration((String)idDecl.getDeclarationId());
        }
        return false;
    }

    public void setIndexingContext(XmlIndexingContext context) {
        this._context = context;
    }

    public XmlIndexingContext getIndexingContext() {
        return this._context;
    }
}

