/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.datatransfer.AbstractTransformingDataTransferPlugin;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.logging.LogUtils;

public class UriListDataTransferPlugin
extends AbstractTransformingDataTransferPlugin {
    public static final DataFlavor uriListFlavor;
    private static final Logger _LOGGER;

    protected DataFlavor getSourceFlavor() {
        return uriListFlavor;
    }

    protected void augmentImpl(AugmentableTransferable trans, Collection sourceDataInfos) {
        Iterator itor = sourceDataInfos.iterator();
        while (itor.hasNext()) {
            trans.augment((TransferDataInfo)new TDI((TransferDataInfo)itor.next()));
        }
    }

    static {
        DataFlavor _uriListFlavor = null;
        try {
            _uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (Exception e) {
            _uriListFlavor = null;
        }
        uriListFlavor = _uriListFlavor;
        _LOGGER = Logger.getLogger(UriListDataTransferPlugin.class.getName());
    }

    private static class TDI
    extends TransferDataInfo {
        private TransferableContext _cached = null;
        private final TransferDataInfo _fileDataInfo;

        public TDI(TransferDataInfo fileDataInfo) {
            this._fileDataInfo = fileDataInfo;
        }

        public TransferDataInfo getFileDataInfo() {
            return this._fileDataInfo;
        }

        public Object getData(FetchMode mode, boolean asReference) throws IOException {
            List<File> fileList;
            if (this._cached == null && mode == FetchMode.STANDARD && !(fileList = this.getFileList(mode, asReference)).isEmpty()) {
                this._cached = new TransferableContext(null);
                Iterator<File> itor = fileList.iterator();
                for (File file : fileList) {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)file.toURL());
                        if (_LOGGER.isLoggable(Level.FINER)) {
                            _LOGGER.log(Level.FINER, "TransferableContext plugin: file={0} node={1}", new Object[]{file, node});
                        }
                        if (node == null) continue;
                        this._cached.add((Object)node);
                    }
                    catch (InstantiationException e) {
                        this._err(e, file);
                    }
                    catch (IllegalAccessException e) {
                        this._err(e, file);
                    }
                }
            }
            return this._cached;
        }

        private List<File> getFileList(FetchMode mode, boolean asReference) throws IOException {
            ArrayList<File> files = new ArrayList<File>();
            Object fileData = this._fileDataInfo.getData(mode, asReference);
            if (fileData instanceof String) {
                StringTokenizer st = new StringTokenizer((String)fileData, "\r\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (token.startsWith("#") || token.isEmpty()) continue;
                    try {
                        File file = new File(new URI(token));
                        files.add(file);
                    }
                    catch (URISyntaxException exc) {
                        throw new IOException(exc);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException(e);
                    }
                }
            }
            return files;
        }

        public DataFlavor getDataFlavor() {
            return TransferableContext.contextFlavor;
        }

        public Object getMetadata(Object key) {
            return this._fileDataInfo.getMetadata(key);
        }

        public float getSuitabilityRank() {
            return TransferUtils.lowerRank((float)this._fileDataInfo.getSuitabilityRank());
        }

        private void _err(Exception e, File f) {
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Exception creating node for file {0}", (Object)f, (Throwable)e);
        }
    }
}

