/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.schema;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bali.xml.addin.schema.MapSchema;
import oracle.ide.net.URLComparator;

public final class SchemaMap
implements Serializable {
    static final String XML_EXT = ".xml";
    private HashMap _extensionToURL = new HashMap();
    private ArrayList _schemas = new ArrayList();
    private static URLComparator _comparator = new URLComparator();

    public static boolean equals(URL url1, URL url2) {
        return _comparator.compare((Object)url1, (Object)url2) == 0;
    }

    public SchemaMap copy() {
        SchemaMap m = new SchemaMap();
        ArrayList list = (ArrayList)this._schemas.clone();
        m.setData(list);
        return m;
    }

    public void put(URL url, String extension, boolean userDefined) {
        ArrayList<URL> v;
        url = this._normalize(url);
        if (extension == null) {
            extension = XML_EXT;
        }
        if ((v = (ArrayList<URL>)this._extensionToURL.get(extension)) == null) {
            v = new ArrayList<URL>();
            this._extensionToURL.put(extension, v);
        }
        for (int i = 0; i < v.size(); ++i) {
            if (!SchemaMap.equals((URL)v.get(i), url)) continue;
            return;
        }
        v.add(url);
        MapSchema ms = new MapSchema(url, extension, userDefined);
        this._schemas.add(ms);
    }

    public void remove(URL url, String ext, boolean userDefined) {
        List v;
        for (int i = 0; i < this._schemas.size(); ++i) {
            MapSchema s = (MapSchema)this._schemas.get(i);
            if (!SchemaMap.equals(s.getURL(), url) || !s.getExtension().equals(ext) || s.isUserDefined() != userDefined) continue;
            this._schemas.remove(i);
            break;
        }
        if ((v = (List)this._extensionToURL.get(ext)) != null) {
            v.remove(url);
            if (v.size() == 0) {
                this._extensionToURL.remove(ext);
            }
        }
    }

    public MapSchema[] getSchemas() {
        return this._schemas.toArray(new MapSchema[0]);
    }

    public List get(String extension) {
        List list;
        if (extension == null) {
            extension = XML_EXT;
        }
        if ((list = (List)this._extensionToURL.get(extension)) == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public ArrayList getData() {
        ArrayList<MapSchema> data = new ArrayList<MapSchema>();
        for (int i = 0; i < this._schemas.size(); ++i) {
            MapSchema ms = (MapSchema)this._schemas.get(i);
            if (!ms.isUserDefined()) continue;
            data.add(ms);
        }
        return data;
    }

    public void setData(ArrayList data) {
        if (data != null) {
            this._extensionToURL = new HashMap();
            this._schemas = new ArrayList();
            int n = data.size();
            for (int i = 0; i < n; ++i) {
                MapSchema s = (MapSchema)data.get(i);
                String extension = s.getExtension();
                this._schemas.add(s);
                ArrayList<URL> v = (ArrayList<URL>)this._extensionToURL.get(extension);
                if (v == null) {
                    v = new ArrayList<URL>();
                    this._extensionToURL.put(extension, v);
                }
                v.add(s.getURL());
            }
        }
    }

    private URL _normalize(URL base) {
        String s = base.toExternalForm();
        s = s.replace('\\', '/');
        try {
            return new URL(s);
        }
        catch (MalformedURLException malformedURLException) {
            return base;
        }
    }
}

