/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.util;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLogger;

public class LogFactory {
    public static String WS_LOGGER = "oracle.mapviewer.ws";
    public static String ACCESS_LOGGER = "oracle.mapviewer.access";
    public static String BUILDER_LOGGER = "oracle.mapviewer.builder";
    public static String SDOVIS_LOGGER = "oracle.mapviewer.sdovis";
    public static String CONSOLE_LOGGER = "oracle.mapviewer.webconsole";
    private static Vector<String> outputLocation = new Vector();
    public static Properties properties = new Properties();

    public static Logger getLogger(LoggerEnum loggerEnum) {
        if (loggerEnum == LoggerEnum.ACCESS) {
            return LogFactory.getLogerUsingName(ACCESS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOVIS) {
            return LogFactory.getLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.INTERNAL) {
            return LogFactory.getLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMS) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMTS) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPVIEWER) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPCACHE_SERVER) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.FOI_SERVER) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPBUILDER) {
            return LogFactory.getLogerUsingName(BUILDER_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SHARE) {
            return LogFactory.getLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WEBCONSOLE) {
            return LogFactory.getLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPEDITOR) {
            return LogFactory.getLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOEDIT) {
            return LogFactory.getLogerUsingName(SDOVIS_LOGGER, null);
        }
        return null;
    }

    public static ODLLogger getODLLogger(LoggerEnum loggerEnum) {
        if (loggerEnum == LoggerEnum.ACCESS) {
            return LogFactory.getODLLogerUsingName(ACCESS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOVIS) {
            return LogFactory.getODLLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.INTERNAL) {
            return LogFactory.getODLLogerUsingName(SDOVIS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMS) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMTS) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPVIEWER) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPCACHE_SERVER) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.FOI_SERVER) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPBUILDER) {
            return LogFactory.getODLLogerUsingName(BUILDER_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SHARE) {
            return LogFactory.getODLLogerUsingName(WS_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WEBCONSOLE) {
            return LogFactory.getODLLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPEDITOR) {
            return LogFactory.getODLLogerUsingName(CONSOLE_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.SDOEDIT) {
            return LogFactory.getODLLogerUsingName(SDOVIS_LOGGER, null);
        }
        return null;
    }

    private static Logger getRealLogger(RealODLLoggersEnum realODLLoggersEnum) {
        if (realODLLoggersEnum == RealODLLoggersEnum.WS) {
            return Logger.getLogger(WS_LOGGER);
        }
        if (realODLLoggersEnum == RealODLLoggersEnum.ACCESS) {
            return Logger.getLogger(ACCESS_LOGGER);
        }
        if (realODLLoggersEnum == RealODLLoggersEnum.BUILDER) {
            return Logger.getLogger(BUILDER_LOGGER);
        }
        if (realODLLoggersEnum == RealODLLoggersEnum.SDOVIS) {
            return Logger.getLogger(SDOVIS_LOGGER);
        }
        if (realODLLoggersEnum == RealODLLoggersEnum.CONSOLE) {
            return Logger.getLogger(CONSOLE_LOGGER);
        }
        return null;
    }

    private static Logger getLogerUsingName(String string, String string2) {
        Logger logger = null;
        logger = string2 == null ? Logger.getLogger(string) : Logger.getLogger(string, string2);
        if (logger != null) {
            return logger;
        }
        return Logger.getLogger(string);
    }

    private static ODLLogger getODLLogerUsingName(String string, String string2) {
        ODLLogger oDLLogger = null;
        oDLLogger = string2 == null ? ODLLogger.getODLLogger((String)string) : ODLLogger.getODLLogger((String)string, (String)string2);
        if (oDLLogger != null) {
            return oDLLogger;
        }
        return ODLLogger.getODLLogger((String)string);
    }

    public static void setMapViewerGlobalConfigs(Properties properties, String[] stringArray, Properties properties2) {
        Object object;
        int n;
        Object object2;
        LogFactory.properties = properties;
        outputLocation = new Vector();
        for (RealODLLoggersEnum realODLLoggersEnum : RealODLLoggersEnum.values()) {
            Logger n3 = LogFactory.getRealLogger(realODLLoggersEnum);
            Object exception = object2 = n3.getHandlers();
            int exception2 = ((Handler[])exception).length;
            for (int vector = 0; vector < exception2; ++vector) {
                Handler n2 = exception[vector];
                n3.removeHandler(n2);
            }
        }
        String string = (String)properties.get("console_log_level");
        Level level = Level.INFO;
        if ("finest".equalsIgnoreCase(string)) {
            level = Level.FINEST;
        } else if ("debug".equalsIgnoreCase(string)) {
            level = Level.FINER;
        }
        if ("fine".equalsIgnoreCase(string)) {
            level = Level.FINE;
        }
        if ("config".equalsIgnoreCase(string)) {
            level = Level.CONFIG;
        } else if ("info".equalsIgnoreCase(string)) {
            level = Level.INFO;
        } else if ("warn".equalsIgnoreCase(string)) {
            level = Level.WARNING;
        } else if ("error".equalsIgnoreCase(string)) {
            level = Level.SEVERE;
        } else if ("fatal".equalsIgnoreCase(string)) {
            level = Level.SEVERE;
        }
        double d = 50.0;
        int n3 = 10;
        object2 = (String)properties.get("file_limit");
        if (object2 != null && ((String)object2).length() > 0) {
            try {
                d = Double.parseDouble((String)object2);
            }
            catch (Exception exception) {
                System.err.println("invalid log file size limit specified: " + (String)object2);
            }
        }
        if ((exception = (String)properties.get("file_count")) != null && ((String)exception).length() > 0) {
            try {
                n3 = Integer.parseInt((String)exception);
            }
            catch (Exception bl) {
                System.err.println("invalid rotating log file count specified: " + (String)exception);
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        boolean bl = false;
        Vector<ConsoleHandler> vector = new Vector<ConsoleHandler>();
        for (n = 0; n < stringArray.length; ++n) {
            Handler l;
            object = stringArray[n];
            if ("System.err".equalsIgnoreCase((String)object) || "System.out".equalsIgnoreCase((String)object)) {
                if (!bl) {
                    ConsoleHandler exception = new ConsoleHandler();
                    exception.setLevel(level);
                    vector.add(exception);
                    bl = true;
                }
            } else {
                try {
                    long l2 = (long)(1048576.0 * d);
                    System.err.println("Log file size limit set to: " + l2 + " bytes.");
                    System.err.println("Log file rotation count set to: " + n3 + ".");
                    for (RealODLLoggersEnum realODLLoggersEnum : RealODLLoggersEnum.values()) {
                        ODLHandler oDLHandler = new ODLHandler((String)object, l2, l2 * (long)n3);
                        oDLHandler.setFormatter((Formatter)new ODLFormatter());
                        vector.add((ConsoleHandler)oDLHandler);
                        Logger logger = LogFactory.getRealLogger(realODLLoggersEnum);
                        if (logger == null) {
                            System.err.println("cannot obtain logger for " + (Object)((Object)realODLLoggersEnum));
                            continue;
                        }
                        String string2 = properties2.getProperty(logger.getName());
                        if (string2 == null) {
                            oDLHandler.setLevel(level);
                            logger.setLevel(level);
                        } else if (string2.equalsIgnoreCase("fatal")) {
                            oDLHandler.setLevel(Level.SEVERE);
                            logger.setLevel(Level.SEVERE);
                        } else if (string2.equalsIgnoreCase("error")) {
                            oDLHandler.setLevel(Level.SEVERE);
                            logger.setLevel(Level.SEVERE);
                        } else if (string2.equalsIgnoreCase("warn")) {
                            oDLHandler.setLevel(Level.WARNING);
                            logger.setLevel(Level.WARNING);
                        } else if (string2.equalsIgnoreCase("info")) {
                            oDLHandler.setLevel(Level.INFO);
                            logger.setLevel(Level.INFO);
                        } else if (string2.equalsIgnoreCase("config")) {
                            oDLHandler.setLevel(Level.CONFIG);
                            logger.setLevel(Level.CONFIG);
                        } else if (string2.equalsIgnoreCase("fine")) {
                            oDLHandler.setLevel(Level.FINE);
                            logger.setLevel(Level.FINE);
                        } else if (string2.equalsIgnoreCase("debug")) {
                            oDLHandler.setLevel(Level.FINER);
                            logger.setLevel(Level.FINER);
                        } else if (string2.equalsIgnoreCase("finest")) {
                            oDLHandler.setLevel(Level.FINEST);
                            logger.setLevel(Level.FINEST);
                        } else {
                            oDLHandler.setLevel(level);
                            logger.setLevel(level);
                        }
                        logger.setUseParentHandlers(false);
                        logger.addHandler((Handler)oDLHandler);
                    }
                }
                catch (Exception exception) {
                    System.err.println("error creating file based log handler:" + (String)object);
                }
            }
            if ((l = (Handler)vector.get(vector.size() - 1)) instanceof ConsoleHandler) continue;
            outputLocation.add(((ODLHandler)l).getPath());
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (Handler)vector.get(n);
            if (!(object instanceof ConsoleHandler)) continue;
            for (RealODLLoggersEnum realODLLoggersEnum : RealODLLoggersEnum.values()) {
                Logger logger = LogFactory.getRealLogger(realODLLoggersEnum);
                logger.addHandler((Handler)object);
            }
        }
    }

    static boolean hasConsoleHandler(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            if (!(handler instanceof ConsoleHandler)) continue;
            return true;
        }
        return false;
    }

    public static String getLogFileContents(String string, int n) {
        Logger logger = null;
        if ("WS_LOGGER".equalsIgnoreCase(string)) {
            logger = LogFactory.getRealLogger(RealODLLoggersEnum.WS);
        } else if ("ACCESS_LOGGER".equalsIgnoreCase(string)) {
            logger = LogFactory.getRealLogger(RealODLLoggersEnum.ACCESS);
        } else if ("BUILDER_LOGGER".equalsIgnoreCase(string)) {
            logger = LogFactory.getRealLogger(RealODLLoggersEnum.BUILDER);
        } else if ("SDOVIS_LOGGER".equalsIgnoreCase(string)) {
            logger = LogFactory.getRealLogger(RealODLLoggersEnum.SDOVIS);
        } else if ("CONSOLE_LOGGER".equalsIgnoreCase(string)) {
            logger = LogFactory.getRealLogger(RealODLLoggersEnum.CONSOLE);
        }
        return "";
    }

    public static void setGlobalLevel(String string) {
        Properties properties = new Properties();
        properties.put("console_log_level", string);
        Level level = Level.INFO;
        if ("finest".equalsIgnoreCase(string)) {
            level = Level.FINEST;
        } else if ("debug".equalsIgnoreCase(string)) {
            level = Level.FINER;
        } else if ("fine".equalsIgnoreCase(string)) {
            level = Level.FINE;
        } else if ("config".equalsIgnoreCase(string)) {
            level = Level.CONFIG;
        } else if ("info".equalsIgnoreCase(string)) {
            level = Level.INFO;
        } else if ("warn".equalsIgnoreCase(string)) {
            level = Level.WARNING;
        } else if ("error".equalsIgnoreCase(string)) {
            level = Level.SEVERE;
        } else if ("fatal".equalsIgnoreCase(string)) {
            level = Level.SEVERE;
        }
        for (RealODLLoggersEnum realODLLoggersEnum : RealODLLoggersEnum.values()) {
            Logger logger = LogFactory.getRealLogger(realODLLoggersEnum);
            logger.setLevel(level);
            for (Handler handler : logger.getHandlers()) {
                handler.setLevel(level);
            }
        }
    }

    public static Properties getGlobalProperties() {
        return properties;
    }

    public static String[] getLogFileLocations() {
        return outputLocation.toArray(new String[outputLocation.size()]);
    }

    private static enum RealODLLoggersEnum {
        WS,
        ACCESS,
        BUILDER,
        SDOVIS,
        CONSOLE;

    }

    public static enum LoggerEnum {
        ACCESS,
        INTERNAL,
        MAPBUILDER,
        SDOVIS,
        WMS,
        WMTS,
        MAPVIEWER,
        MAPCACHE_SERVER,
        FOI_SERVER,
        SHARE,
        WEBCONSOLE,
        MAPEDITOR,
        SDOEDIT;

    }
}

