/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.stylex.Bucket;

public class RangedBucket
extends Bucket {
    static final long serialVersionUID = -5125025974937295048L;
    Field low = null;
    Field high = null;

    public RangedBucket(String string) {
        super(string);
    }

    public RangedBucket(String string, Field field, Field field2) {
        super(string);
        this.setRange(field, field2);
    }

    @Override
    public Object clone() {
        RangedBucket rangedBucket = (RangedBucket)super.clone();
        return rangedBucket;
    }

    public Field getLowerBoundValue() {
        return this.low;
    }

    public void setLowerBoundValue(Field field) {
        this.low = field;
    }

    public Field getUpperBoundValue() {
        return this.high;
    }

    public void setUpperBoundValue(Field field) {
        this.high = field;
    }

    public void setRange(Field field, Field field2) {
        this.low = field;
        this.high = field2;
        this.bucketLabel = "" + field + " - " + field2;
    }

    @Override
    public boolean contains(Field field) {
        block10: {
            if (field == null || this.low == null && this.high == null) {
                return false;
            }
            try {
                if (this.low == null && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.high == null && this.low.compareTo(field) <= 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(field) <= 0 && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(field) <= 0 && this.high.compareTo(field) == 0 && this.isLastBucket()) {
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                field = this.low != null ? Field.createField(field.getString(), this.low.getShortJavaTypeName()) : Field.createField(field.getString(), this.high.getShortJavaTypeName());
                if (this.low == null && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.high == null && this.low.compareTo(field) <= 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(field) <= 0 && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.low == null || this.high == null || this.low.compareTo(field) > 0 || this.high.compareTo(field) != 0 || !this.isLastBucket()) break block10;
                return true;
            }
        }
        return false;
    }

    public double getLowerBound() {
        if (this.low == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.low.getDouble();
    }

    public void setLowerBound(double d) {
        if (this.low == null) {
            this.low = new Field().setDouble(d);
        } else {
            this.low.setDouble(d);
        }
    }

    public double getUpperBound() {
        if (this.high == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.high.getDouble();
    }

    public void setUpperBound(double d) {
        if (this.high == null) {
            this.high = new Field().setDouble(d);
        } else {
            this.high.setDouble(d);
        }
    }
}

