/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.SharedUtils;

public class HeatMapStyleModel
extends AbstractStyleModel {
    private static final long serialVersionUID = 5536355586759208793L;
    public static final int METHOD_KERNEL_ESTIMATE = 1;
    public static final int METHOD_IDW = 2;
    public static final int METHOD_FAST_ALPHAMAP = 3;
    private Color[] colorStops;
    private int numSteps = 256;
    private int alpha = 255;
    private SizeDefinition spotLightRadius = new SizeDefinition(5.0, null);
    private String containerThemeName = null;
    private double gridSampleFactor = 2.5;
    private int method = 1;
    private boolean globalCellValueRangeEnforced = false;
    private double maxPointsInSpotlight = 0.0;
    private Map zoomLevelMaxCellValueMap = null;
    static NumberFormat NF = new DecimalFormat("#.##");

    @Override
    public Object clone() {
        HeatMapStyleModel heatMapStyleModel = (HeatMapStyleModel)super.clone();
        if (this.colorStops != null) {
            heatMapStyleModel.colorStops = new Color[this.colorStops.length];
            for (int i = 0; i < this.colorStops.length; ++i) {
                try {
                    heatMapStyleModel.colorStops[i] = this.colorStops[i];
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return heatMapStyleModel;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    public void setColorStops(Color[] colorArray) {
        this.colorStops = colorArray;
    }

    public Color[] getColorStops() {
        return this.colorStops;
    }

    public void setNumSteps(int n) {
        this.numSteps = n;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setAlpha(int n) {
        this.alpha = n;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setSpotLightRadius(double d) {
        this.spotLightRadius.setValue(d);
    }

    public double getSpotLightRadius() {
        return this.spotLightRadius.getValue();
    }

    public SizeDefinition getSpotLightRadiusSize() {
        return this.spotLightRadius;
    }

    public void setSpotLightRadiusSize(SizeDefinition sizeDefinition) {
        this.spotLightRadius = new SizeDefinition(5.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.spotLightRadius.setValue(sizeDefinition.getValue());
        this.spotLightRadius.setUnit(sizeDefinition.getUnit());
    }

    public String getSpotLightRadiusUnit() {
        return this.spotLightRadius.getUnit();
    }

    public void setSpotLightRadiusUnit(String string) {
        this.spotLightRadius.setUnit(string);
    }

    public void setContainerThemeName(String string) {
        this.containerThemeName = string;
    }

    public String getContainerThemeName() {
        return this.containerThemeName;
    }

    public void setGridSampleFactor(double d) {
        this.gridSampleFactor = d;
    }

    public double getGridSampleFactor() {
        return this.gridSampleFactor;
    }

    public Color[] createGradientColors() {
        return StyleUtils.createMultiStopGradient(this.colorStops, this.numSteps, this.alpha);
    }

    @Override
    public String toXMLString() {
        String string = "";
        if (this.spotLightRadius.getUnit() != null && !this.spotLightRadius.getUnit().equalsIgnoreCase("px")) {
            string = this.spotLightRadius.getUnit();
        }
        String string2 = StyleUtils.getUSLocaleFormat(this.spotLightRadius.getValue());
        string2 = StyleUtils.cleanDecimalZeros(string2, 1);
        if (this.spotLightRadius.isPixelUnit()) {
            string2 = String.valueOf((int)this.spotLightRadius.getValue());
        }
        String string3 = "<?xml version=\"1.0\" ?>\n";
        string3 = string3 + "<AdvancedStyle>\n   <HeatMapStyle>\n";
        string3 = string3 + "      <color_stops num_steps=\"" + this.numSteps + "\" alpha=\"" + this.alpha + "\">\n";
        String string4 = "";
        if (this.colorStops != null) {
            for (int i = 0; i < this.colorStops.length - 1; ++i) {
                String string5 = StyleUtils.getHexidecimalString(this.colorStops[i]);
                string5 = string5.substring(1);
                string4 = string4 + string5 + ",";
            }
            string4 = string4 + StyleUtils.getHexidecimalString(this.colorStops[this.colorStops.length - 1]).substring(1);
        }
        string3 = string3 + "           " + string4 + "\n";
        string3 = string3 + "      </color_stops>\n";
        string3 = string3 + "      <spot_light_radius>" + string2 + string + "</spot_light_radius>\n";
        string3 = string3 + "      <grid_sample_factor>" + this.gridSampleFactor + "</grid_sample_factor>\n";
        string3 = string3 + "      <container_theme>" + this.containerThemeName + "</container_theme>\n";
        if (this.getMethod() == 2 || this.getMethod() == 3) {
            string3 = string3 + "      <method>" + HeatMapStyleModel.getMethodName(this.getMethod()) + "</method>\n";
        }
        if (this.globalCellValueRangeEnforced) {
            string3 = string3 + "      <enforce_global_range>true</enforce_global_range>\n";
            string3 = string3 + "      <max_records_in_raidus>" + NF.format(this.maxPointsInSpotlight) + "</max_records_in_raidus>\n";
        }
        string3 = string3 + "    </HeatMapStyle>\n";
        string3 = string3 + "</AdvancedStyle>\n";
        return string3;
    }

    public static Color[] stringToColorStops(String string) {
        String string2 = string.trim();
        if (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        List list = SharedUtils.splitBy(string2, ",");
        Color[] colorArray = new Color[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (!string3.startsWith("#")) {
                string3 = "#" + string3;
            }
            colorArray[i] = StyleUtils.getColor(string3);
        }
        return colorArray;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }

    public void setMethod(int n) {
        if (2 != n && 1 != n && 3 != n) {
            throw new IllegalArgumentException("Invalid method specified.");
        }
        this.method = n;
    }

    public int getMethod() {
        return this.method;
    }

    public static String getMethodName(int n) {
        switch (n) {
            case 1: {
                return "kernel_estimate";
            }
            case 2: {
                return "idw";
            }
            case 3: {
                return "fast_alphamap";
            }
        }
        return "kernel_estimate";
    }

    public boolean isGlobalCellValueRangeEnforced() {
        return this.globalCellValueRangeEnforced;
    }

    public void setGlobalCellValueRangeEnforced(boolean bl) {
        this.globalCellValueRangeEnforced = bl;
    }

    public double getMaxPointsInSpotlight() {
        return this.maxPointsInSpotlight;
    }

    public void setMaxPointsInSpotlight(double d) {
        this.maxPointsInSpotlight = d;
    }

    public double getGlobalMaxCellValue(double d) {
        if (this.zoomLevelMaxCellValueMap == null) {
            return -1.0;
        }
        Double d2 = new Double(d);
        Object v = this.zoomLevelMaxCellValueMap.get(d2);
        if (v != null) {
            return (Double)v;
        }
        return -1.0;
    }

    public void setGlobalMaxCellValue(double d, double d2) {
        Double d3;
        if (this.zoomLevelMaxCellValueMap == null) {
            this.zoomLevelMaxCellValueMap = new HashMap();
        }
        if (this.zoomLevelMaxCellValueMap.get(d3 = new Double(d2)) == null) {
            Double d4 = new Double(d);
            this.zoomLevelMaxCellValueMap.put(d3, d4);
        }
    }
}

