/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import oracle.sdovis.util.Util;

public class RenderingRule
implements Serializable {
    public static String FILL_COLOR_CHANGE = "FILL_COLOR";
    public static String MARKER_SIZE_SCALE_FACTOR_CHANGE = "MARKER_SIZE_SCALE_FACTOR";
    private String styleName = null;
    private String[] styleColumns = null;
    private String subStyleName = null;
    private String[] subStyleColumns = null;
    private String subStyleChangeProperty = FILL_COLOR_CHANGE;
    private double minScale = Double.NaN;
    private double maxScale = Double.NaN;
    public static String LABEL_ALWAYS_ON_PROPERTY = "label_always_on";
    public static String NO_REPETITIVE_LABEL_PROPERTY = "no_repetitive_label";
    public static String UPSIDE_DOWN_LABELS_PROPERTY = "upside_down_labels";
    public static String ALLOW_NAKED_POINTS_PROPERTY = "allow_naked_points";
    private Properties labelProperties = new Properties();

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String string) {
        this.styleName = string;
    }

    public String[] getStyleColumns() {
        return this.styleColumns;
    }

    public String getStyleColumnsAsString() {
        if (this.styleColumns == null || this.styleColumns.length == 0) {
            return null;
        }
        String string = this.styleColumns[0];
        for (int i = 1; i < this.styleColumns.length; ++i) {
            string = string + "," + this.styleColumns[i];
        }
        return string;
    }

    public void setStyleColumns(String[] stringArray) {
        this.styleColumns = stringArray;
    }

    public void setStyleColumnsAsString(String string) {
        if (string == null) {
            this.styleColumns = null;
        } else {
            ArrayList arrayList = Util.splitBy((String)string, (String)",");
            if (arrayList == null || arrayList.size() == 0) {
                this.styleColumns = null;
            } else {
                this.styleColumns = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.styleColumns[i] = arrayList.get(i).toString();
                }
            }
        }
    }

    public String getSubStyleName() {
        return this.subStyleName;
    }

    public void setSubStyleName(String string) {
        this.subStyleName = string;
    }

    public String[] getSubStyleColumns() {
        return this.subStyleColumns;
    }

    public void setSubStyleColumns(String[] stringArray) {
        this.subStyleColumns = stringArray;
    }

    public String getSubStyleColumnsAsString() {
        if (this.subStyleColumns == null || this.subStyleColumns.length == 0) {
            return null;
        }
        String string = this.subStyleColumns[0];
        for (int i = 1; i < this.subStyleColumns.length; ++i) {
            string = string + "," + this.subStyleColumns[i];
        }
        return string;
    }

    public void setSubStyleColumnsAsString(String string) {
        if (string == null) {
            this.subStyleColumns = null;
        } else {
            ArrayList arrayList = Util.splitBy((String)string, (String)",");
            if (arrayList == null || arrayList.size() == 0) {
                this.subStyleColumns = null;
            } else {
                this.subStyleColumns = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.subStyleColumns[i] = arrayList.get(i).toString();
                }
            }
        }
    }

    public String getSubStyleChangeProperty() {
        return this.subStyleChangeProperty;
    }

    public void setSubStyleChangeProperty(String string) {
        this.subStyleChangeProperty = string;
    }

    public static String[] getChangePropertyNames() {
        String[] stringArray = new String[]{FILL_COLOR_CHANGE, MARKER_SIZE_SCALE_FACTOR_CHANGE};
        return stringArray;
    }

    public void setScaleRange(double d, double d2) {
        this.minScale = d;
        this.maxScale = d2;
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double d) {
        this.minScale = d;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double d) {
        this.maxScale = d;
    }

    public boolean isScaleRangeDefined() {
        return !Double.isNaN(this.minScale) || !Double.isNaN(this.maxScale);
    }

    public boolean isWithinScaleLimits(double d) {
        if (!this.isScaleRangeDefined()) {
            return true;
        }
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || d == 0.0) {
            return true;
        }
        double d2 = this.getMinScale();
        double d3 = this.getMaxScale();
        if (Double.isNaN(d2) && Double.isNaN(d3)) {
            return true;
        }
        if (!Double.isNaN(d2)) {
            if (!Double.isNaN(d3)) {
                return d > d3 && d <= d2;
            }
            return d <= d2;
        }
        return d > d3;
    }

    public String getLabelProperty(String string) {
        if (string == null) {
            return null;
        }
        return this.labelProperties.getProperty(string);
    }

    public void setLabelProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.labelProperties.put(string, string2);
    }

    public RenderingRule getCopy() {
        RenderingRule renderingRule = new RenderingRule();
        renderingRule.setStyleName(this.styleName);
        renderingRule.setStyleColumns(this.styleColumns);
        renderingRule.setSubStyleName(this.subStyleName);
        renderingRule.setSubStyleColumns(this.subStyleColumns);
        renderingRule.setSubStyleChangeProperty(this.subStyleChangeProperty);
        renderingRule.setMinScale(this.minScale);
        renderingRule.setMaxScale(this.maxScale);
        if (this.labelProperties.size() > 0) {
            String[] stringArray = new String[this.labelProperties.size()];
            int n = 0;
            Enumeration<Object> enumeration = this.labelProperties.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = (String)this.labelProperties.get(stringArray[i]);
                renderingRule.setLabelProperty(stringArray[i], string);
            }
        }
        return renderingRule;
    }
}

