/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.worksheet.commands.scriptrunner.task.consumer;

import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.worksheet.AppendQuickTextBuffer;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetTaskResultPanel;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputDockableFactory;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputPane;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ITabListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.olap.OLAPArb;
import oracle.olap.worksheet.commands.scriptrunner.task.OLAPScriptRunnerPanel;

public class OLAPDefaultScriptConsumer
implements IScriptConsumer {
    StringBuffer m_inputBuffer = null;
    OLAPScriptRunnerPanel m_panel = null;
    WorksheetContext m_ctx = null;
    private int m_count = 0;
    private long lastDisplayTime = 0L;
    private int millisecondsToWait = 100;

    public OLAPDefaultScriptConsumer(String string, WorksheetContext worksheetContext, ITabListener iTabListener) {
        this.m_ctx = worksheetContext;
        this.m_inputBuffer = new StringBuffer();
        this.m_panel = new OLAPScriptRunnerPanel(string, worksheetContext);
        this.m_panel.addTabListener(iTabListener);
    }

    public void restart() {
    }

    public void finish() {
        if (this.m_inputBuffer.length() > 0) {
            this.printToUI(this.m_inputBuffer, true);
            this.m_count = 0;
            this.m_inputBuffer.setLength(0);
        }
    }

    public void consumerItermediateResult(String string, boolean bl) {
        if (string.endsWith("force_print") || this.timeToPrint()) {
            if (!(string = this.trimToForcePrint(string)).trim().equals("")) {
                if (string.equalsIgnoreCase(Messages.getString((String)"PLSQL.4"))) {
                    AbstractOutputPane abstractOutputPane;
                    String string2;
                    String string3 = this.m_ctx.getConnectionName();
                    string = DBUtil.getInstance((String)string3).getDBMSOUTPUT();
                    if (string.trim().length() == 0 && (string2 = (abstractOutputPane = DbmsOutputPane.getInstance((View)DbmsOutputDockableFactory.getDbmsDockable())).getOutputText()) != null) {
                        string = string2;
                    }
                    string = string + OLAPArb.get("OLAP_WORKSHEET_COMMAND_COMPLETION_MESSAGE") + "\n";
                }
                this.m_inputBuffer.append(string + "\n");
            }
            this.printToUI(this.m_inputBuffer, bl);
            this.m_count = 0;
            this.m_inputBuffer.setLength(0);
        } else if (!string.endsWith("force_print")) {
            if (string.equalsIgnoreCase(Messages.getString((String)"PLSQL.4"))) {
                AbstractOutputPane abstractOutputPane;
                String string4;
                String string5 = this.m_ctx.getConnectionName();
                string = DBUtil.getInstance((String)string5).getDBMSOUTPUT();
                if (string.trim().length() == 0 && (string4 = (abstractOutputPane = DbmsOutputPane.getInstance((View)DbmsOutputDockableFactory.getDbmsDockable())).getOutputText()) != null) {
                    string = string4;
                }
                string = string + "\n" + OLAPArb.get("OLAP_WORKSHEET_COMMAND_COMPLETION_MESSAGE");
            }
            this.m_inputBuffer.append(string + "\n");
            ++this.m_count;
        }
    }

    private boolean timeToPrint() {
        long l = System.currentTimeMillis();
        if (l > this.lastDisplayTime + (long)this.millisecondsToWait) {
            this.lastDisplayTime = l;
            return true;
        }
        return false;
    }

    private String trimToForcePrint(String string) {
        int n = string.indexOf("force_print");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void printToUI(StringBuffer stringBuffer, Boolean bl) {
        this.printAllToUI(stringBuffer, bl);
    }

    private void printAllToUI(StringBuffer stringBuffer, boolean bl) {
        pushTextToEDT pushTextToEDT2 = new pushTextToEDT(stringBuffer, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            pushTextToEDT2.run();
        } else {
            SwingUtilities.invokeLater(pushTextToEDT2);
        }
    }

    public WorksheetTaskResultPanel getPanel() {
        return this.m_panel;
    }

    private BasicEditorPane getBasicEditorPane() {
        return this.m_panel.getTextPane();
    }

    private BasicDocument getDocument() {
        if (this.getBasicEditorPane() != null) {
            return (BasicDocument)this.getBasicEditorPane().getDocument();
        }
        return null;
    }

    private class pushTextToEDT
    implements Runnable {
        private char[] m_chars = null;
        private int m_stringBufferSize = 0;
        private boolean m_isLast = false;

        public pushTextToEDT(StringBuffer stringBuffer, boolean bl) {
            this.getChars(stringBuffer);
            this.m_isLast = bl;
        }

        private void getChars(StringBuffer stringBuffer) {
            this.m_stringBufferSize = stringBuffer.length();
            this.m_chars = new char[this.m_stringBufferSize];
            stringBuffer.getChars(0, this.m_stringBufferSize, this.m_chars, 0);
        }

        @Override
        public void run() {
            BasicDocument basicDocument = OLAPDefaultScriptConsumer.this.getDocument();
            if (basicDocument != null) {
                if (this.m_isLast) {
                    ((AppendQuickTextBuffer)basicDocument.getTextBuffer()).finish();
                }
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                textBuffer.append(this.m_chars);
                BasicEditorPane basicEditorPane = OLAPDefaultScriptConsumer.this.getBasicEditorPane();
                int n = basicDocument.getLineCount();
                int n2 = basicDocument.getLineStartOffset(n);
                basicEditorPane.setCaretPositionCenter(n2);
            }
        }
    }
}

