/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.worksheet.commands.scriptrunner.task;

import java.io.BufferedOutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.newscriptrunner.IGetHandlePauseProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.GuiScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputDockableFactory;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputPane;
import oracle.dbtools.worksheet.commands.scriptrunner.api.AStatementRunnerTask;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiHandlePauseProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiHandleSetPauseProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedAcceptProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedConnectFieldsProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedPasswordFieldsProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedSubstitutionProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.task.CommandRunnerScope;
import oracle.dbtools.worksheet.scriptparser.api.IScriptParser;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.dbtools.worksheet.utils.CursorUI;
import oracle.dbtools.worksheet.utils.TextBufferReader;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.olap.worksheet.commands.scriptrunner.OLAPConsumerManager;

public abstract class OLAPDBCommandRunnerTask
extends DatabaseQueryTask<Void> {
    private ScriptRunnerContext m_scriptRunnerContext = new GuiScriptRunnerContext();
    private Reader m_reader;
    protected String m_connectionName;
    WorksheetContext m_worksheetContext;
    boolean m_isCanceled;
    Connection m_connection;
    CommandRunnerScope m_commandRunnerScope;
    protected String m_id;
    protected OLAPConsumerManager m_consumerManager;
    IScriptParser m_scriptParser;
    IRaptorTaskRunMode m_runMode;
    Logger m_logger;
    protected boolean isExecutionHandedOver;

    public OLAPDBCommandRunnerTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
        super(string, iRaptorTaskRunMode, bl, bl2);
        this.m_scriptRunnerContext.setPromptedFieldProvider((IGetPromptedFieldProvider)new GuiPromptedAcceptProvider());
        this.m_scriptRunnerContext.setSubstitutionFieldProvider((IGetPromptedFieldProvider)new GuiPromptedSubstitutionProvider());
        this.m_scriptRunnerContext.setPasswordFieldsProvider((IGetPromptedPasswordFieldsProvider)new GuiPromptedPasswordFieldsProvider());
        this.m_scriptRunnerContext.setConnectFieldsProvider((IGetPromptedConnectFieldsProvider)new GuiPromptedConnectFieldsProvider());
        this.m_scriptRunnerContext.setHandlePauseProvider((IGetHandlePauseProvider)new GuiHandlePauseProvider());
        this.m_scriptRunnerContext.setHandleSetPauseProvider((IGetHandlePauseProvider)new GuiHandleSetPauseProvider());
        this.m_reader = null;
        this.m_connectionName = null;
        this.m_worksheetContext = null;
        this.m_isCanceled = false;
        this.m_connection = null;
        this.m_commandRunnerScope = null;
        this.m_id = null;
        this.m_consumerManager = null;
        this.m_scriptParser = null;
        this.m_runMode = null;
        this.m_logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.isExecutionHandedOver = false;
    }

    public OLAPDBCommandRunnerTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3) {
        super(string, iRaptorTaskRunMode, bl, bl2, bl3);
        this.m_scriptRunnerContext.setPromptedFieldProvider((IGetPromptedFieldProvider)new GuiPromptedAcceptProvider());
        this.m_scriptRunnerContext.setSubstitutionFieldProvider((IGetPromptedFieldProvider)new GuiPromptedSubstitutionProvider());
        this.m_scriptRunnerContext.setPasswordFieldsProvider((IGetPromptedPasswordFieldsProvider)new GuiPromptedPasswordFieldsProvider());
        this.m_scriptRunnerContext.setConnectFieldsProvider((IGetPromptedConnectFieldsProvider)new GuiPromptedConnectFieldsProvider());
        this.m_scriptRunnerContext.setHandlePauseProvider((IGetHandlePauseProvider)new GuiHandlePauseProvider());
        this.m_scriptRunnerContext.setHandleSetPauseProvider((IGetHandlePauseProvider)new GuiHandleSetPauseProvider());
        this.m_reader = null;
        this.m_connectionName = null;
        this.m_worksheetContext = null;
        this.m_isCanceled = false;
        this.m_connection = null;
        this.m_commandRunnerScope = null;
        this.m_id = null;
        this.m_consumerManager = null;
        this.m_scriptParser = null;
        this.m_runMode = null;
        this.m_logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.isExecutionHandedOver = false;
    }

    public IRaptorTaskRunMode getRunMode() {
        return this.m_runMode;
    }

    protected abstract void afterLoopProcessing();

    protected abstract void beforeLoopProcessing();

    protected Void doWork() {
        this.m_commandRunnerScope = new CommandRunnerScope(this.m_worksheetContext.getEditor());
        this.startup();
        try {
            Connections.getInstance().getConnection(this.m_worksheetContext.getConnectionName());
            String string = null;
            if (this.m_commandRunnerScope.isSelection()) {
                string = this.m_worksheetContext.getEditor().getSelectedText();
                this.runCommand(string);
            } else {
                this.handleNoSelection(this.m_commandRunnerScope);
            }
        }
        catch (Exception exception) {
            this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (!this.isExecutionHandedOver) {
                this.resetCursor(this.m_commandRunnerScope);
                this.cleanup();
                if (!this.m_isCanceled) {
                    this.setMessage(Messages.getString((String)"ScriptRunnerTask.3"));
                }
                this.m_commandRunnerScope = null;
                this.getScriptRunnerContext().setScriptText(0, 0);
                this.getScriptRunnerContext().getExecutedCommandList().clear();
                System.gc();
            }
        }
        return null;
    }

    protected abstract void cleanup();

    protected void startup() {
    }

    protected abstract void handleNoSelection(CommandRunnerScope var1);

    protected abstract void runCommand(String var1);

    void runTaskInNewThread(Thread thread) {
        try {
            this.checkCanProceed();
            if (!Thread.currentThread().isInterrupted()) {
                thread.start();
            }
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CancellationException) {
                this.m_isCanceled = true;
            }
            this.m_logger.log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
        }
    }

    boolean isInterupted() {
        boolean bl = false;
        try {
            bl = this.getCurrentConnection().isClosed();
        }
        catch (SQLException sQLException) {
            this.m_logger.log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (Exception exception) {
            this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return Thread.currentThread().isInterrupted() || this.m_isCanceled || this.getScriptRunnerContext().getExited() || bl;
    }

    protected void runTaskInThisThread(AStatementRunnerTask aStatementRunnerTask) {
        aStatementRunnerTask.runMe();
    }

    private String getDatabaseProductName() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.m_connectionName);
        return properties.getProperty("subtype");
    }

    void reinitializeTheScriptRunnerContext() {
        if (this.m_scriptRunnerContext.getTopLevel()) {
            if (this.m_scriptRunnerContext.getExited()) {
                this.m_scriptRunnerContext.reInitOnExit();
            } else {
                this.m_scriptRunnerContext.reInitNoExit();
            }
        }
    }

    void closeAnyIntermediateConnection() {
        if (this.getScriptRunnerContext().getCloseConnection()) {
            this.getScriptRunnerContext().closeCurrentConnection();
        }
    }

    void closeThePipeStream(BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    void resetCursor(CommandRunnerScope commandRunnerScope) {
        BasicEditorPane basicEditorPane = ((GuiScriptRunnerContext)this.m_scriptRunnerContext).getEditorComponenet();
        try {
            SwingUtilities.invokeAndWait((Runnable)new CursorUI(commandRunnerScope.getCursorPosition(), commandRunnerScope.isSelection(), commandRunnerScope.getSelectionStart(), commandRunnerScope.getSelectionEnd(), basicEditorPane));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected void runCommand(ISQLCommand iSQLCommand, boolean bl, boolean bl2, int n) {
        String string;
        this.highLightThisStatement(iSQLCommand);
        this.setMessage(Messages.getString((String)"WorksheetTaskFactory.1") + iSQLCommand.getSql());
        this.tailoredRunCommand(iSQLCommand, bl, bl2, n);
        if (this.getScriptRunnerContext().isDbmsEnabled()) {
            this.enableDbmsOutput();
            this.getScriptRunnerContext().clearDbmsFlags();
        }
        if ((string = this.getScriptRunnerContext().popDbmsOutput()) != null) {
            this.setDbmsOutputDockable(string);
        }
    }

    protected void rememberHistory(ISQLCommand iSQLCommand) {
        if (this.m_worksheetContext.isTemporaryFile()) {
            this.getScriptRunnerContext().getExecutedCommandList().add(iSQLCommand);
        }
    }

    protected void saveHistory() {
        try {
            if (this.getScriptRunnerContext().getExecutedCommandList().size() < 1) {
                return;
            }
            if (!this.m_worksheetContext.isTemporaryFile()) {
                return;
            }
            if (this.getScriptRunnerContext().getExecutedCommandList().size() == 1) {
                ISQLCommand iSQLCommand = (ISQLCommand)this.getScriptRunnerContext().getExecutedCommandList().get(0);
                String string = (String)iSQLCommand.getProperty("EXECUTEFAILED");
                if (string == null && SQLCommand.StmtSubType.G_S_COMMENT_PLUS != iSQLCommand.getStmtSubType()) {
                    if (SQLCommand.StmtSubType.G_S_ATNESTED == iSQLCommand.getStmtSubType() || SQLCommand.StmtSubType.G_S_AT == iSQLCommand.getStmtSubType()) {
                        SqlEditorHistory.getInstance();
                        SqlEditorHistory.saveSql((String)(iSQLCommand.getSQLOrig() + iSQLCommand.getStatementTerminator()), (String)Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.m_connection)), (String)SqlEditorHistory.TYPE_SCRIPT_HISTORY, (float)((float)this.getDescriptor().getElapsedTime() / 1000.0f));
                    } else {
                        SqlEditorHistory.getInstance();
                        SqlEditorHistory.saveSql((String)(iSQLCommand.getSQLOrig() + iSQLCommand.getStatementTerminator()), (String)Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.m_connection)), (String)SqlEditorHistory.TYPE_SQL_HISTORY, (float)((float)this.getDescriptor().getElapsedTime() / 1000.0f));
                    }
                }
            } else if (this.isScriptViable()) {
                SqlEditorHistory.getInstance();
                SqlEditorHistory.saveSql((String)((GuiScriptRunnerContext)this.getScriptRunnerContext()).getScriptText().trim(), (String)Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.m_connection)), (String)SqlEditorHistory.TYPE_SCRIPT_HISTORY, (float)((float)this.getDescriptor().getElapsedTime() / 1000.0f));
            }
        }
        catch (Exception exception) {
            this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private boolean isScriptViable() {
        for (ISQLCommand iSQLCommand : this.getScriptRunnerContext().getExecutedCommandList()) {
            String string = (String)iSQLCommand.getProperty("EXECUTEFAILED");
            if (string != null || SQLCommand.StmtSubType.G_S_COMMENT_PLUS == iSQLCommand.getStmtSubType()) continue;
            return true;
        }
        return false;
    }

    protected abstract void tailoredRunCommand(ISQLCommand var1, boolean var2, boolean var3, int var4);

    public OLAPConsumerManager getConsumerManager() {
        return this.m_consumerManager;
    }

    public OLAPDBCommandRunnerTask(WorksheetContext worksheetContext, OLAPConsumerManager oLAPConsumerManager, String string, IRaptorTaskRunMode iRaptorTaskRunMode, String string2) {
        super(string2, iRaptorTaskRunMode, true, true);
        ScriptRunnerContext scriptRunnerContext;
        this.m_scriptRunnerContext.setPromptedFieldProvider((IGetPromptedFieldProvider)new GuiPromptedAcceptProvider());
        this.m_scriptRunnerContext.setSubstitutionFieldProvider((IGetPromptedFieldProvider)new GuiPromptedSubstitutionProvider());
        this.m_scriptRunnerContext.setPasswordFieldsProvider((IGetPromptedPasswordFieldsProvider)new GuiPromptedPasswordFieldsProvider());
        this.m_scriptRunnerContext.setConnectFieldsProvider((IGetPromptedConnectFieldsProvider)new GuiPromptedConnectFieldsProvider());
        this.m_scriptRunnerContext.setHandlePauseProvider((IGetHandlePauseProvider)new GuiHandlePauseProvider());
        this.m_scriptRunnerContext.setHandleSetPauseProvider((IGetHandlePauseProvider)new GuiHandleSetPauseProvider());
        this.m_reader = null;
        this.m_connectionName = null;
        this.m_worksheetContext = null;
        this.m_isCanceled = false;
        this.m_connection = null;
        this.m_commandRunnerScope = null;
        this.m_id = null;
        this.m_consumerManager = null;
        this.m_scriptParser = null;
        this.m_runMode = null;
        this.m_logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.isExecutionHandedOver = false;
        this.m_id = string;
        this.m_connectionName = worksheetContext.getConnectionName();
        this.m_worksheetContext = worksheetContext;
        this.m_consumerManager = oLAPConsumerManager;
        this.m_runMode = iRaptorTaskRunMode;
        try {
            this.m_connection = Connections.getInstance().getConnection(this.m_connectionName);
        }
        catch (DBException dBException) {
            this.m_logger.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
        }
        ScriptRunnerContext scriptRunnerContext2 = (ScriptRunnerContext)worksheetContext.getEditor().getProperty("ScriptRunnerContext");
        if (scriptRunnerContext2 != null) {
            this.m_scriptRunnerContext = scriptRunnerContext2;
            this.m_scriptRunnerContext.reInitNoExit();
        } else {
            scriptRunnerContext = (ScriptRunnerContext)Connections.getInstance().getConnectionInfo(this.m_connectionName).get("GLOGIN");
            if (scriptRunnerContext != null) {
                this.m_scriptRunnerContext = scriptRunnerContext.clone();
                worksheetContext.setScriptRunnerContext(this.m_scriptRunnerContext);
            } else {
                this.m_scriptRunnerContext = new ScriptRunnerContext();
                worksheetContext.setScriptRunnerContext(this.m_scriptRunnerContext);
            }
        }
        this.m_scriptRunnerContext.putProperty("sqldev.script.runner.connection.properties", (Object)this.getDatabaseProductName());
        scriptRunnerContext = worksheetContext.getEditor();
        BasicDocument basicDocument = (BasicDocument)scriptRunnerContext.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        this.m_reader = new TextBufferReader(textBuffer);
        DBConfig dBConfig = DBConfig.getInstance();
        this.m_scriptRunnerContext.putProperty("DBConfig.DEFAULT_PATH", (Object)dBConfig.getString("DEFAULTPATH"));
        this.m_scriptRunnerContext.putProperty("DBConfig.GLOGIN", (Object)new Boolean(dBConfig.getBoolean("GLOGIN")));
        this.m_scriptRunnerContext.putProperty("DBConfig.GLOGIN_FILE", (Object)dBConfig.getString(""));
        this.m_scriptRunnerContext.putProperty("script.runner.autocommit.checkbox", (Object)dBConfig.getBoolean("AUTOCOMMIT"));
        this.m_scriptRunnerContext.putProperty("script.runner.node.url", (Object)worksheetContext.getFileURL());
        ((GuiScriptRunnerContext)this.m_scriptRunnerContext).setEditorComponenet((BasicEditorPane)scriptRunnerContext);
        this.m_scriptRunnerContext.setIsRunScript("Worksheet.RunScript".equals(this.m_id));
        this.m_scriptRunnerContext.setCurrentConnection(this.m_connection);
        this.m_scriptRunnerContext.setBaseConnection(this.m_connection);
        this.m_scriptRunnerContext.setNLSMap(DBConfig.getInstance().getNLSMap());
        this.m_scriptRunnerContext.putProperty("current_cmd_count", (Object)0);
        Boolean bl = dBConfig.getBoolean("REINIT_ON_EXIT");
        if (bl != null) {
            this.m_scriptRunnerContext.putProperty("script.runner.reinitOnExit", (Object)bl);
        }
    }

    protected abstract IScriptConsumer getInitialConsumer();

    protected void setDbmsOutputDockable(String string) {
        AbstractOutputPane abstractOutputPane = DbmsOutputPane.getInstance((View)DbmsOutputDockableFactory.getDbmsDockable());
        abstractOutputPane.setOutputResult(this.getScriptRunnerContext(), string);
    }

    protected void enableDbmsOutput() {
        AbstractOutputPane abstractOutputPane = DbmsOutputPane.getInstance((View)DbmsOutputDockableFactory.getDbmsDockable());
        if (abstractOutputPane.getCurrentConnection() != null) {
            abstractOutputPane.enableOutput(this.getScriptRunnerContext());
        }
    }

    protected Connection getCurrentConnection() {
        return this.m_scriptRunnerContext.getCurrentConnection();
    }

    protected ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    private void highLightThisStatement(ISQLCommand iSQLCommand) {
        SwingUtilities.invokeLater(new HighlightRunningStatement(iSQLCommand.getStartLine(), iSQLCommand.getEndLine()));
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public String getQuery() {
        return "";
    }

    protected WorksheetContext getWorksheetContext() {
        return this.m_worksheetContext;
    }

    private class HighlightRunningStatement
    implements Runnable {
        final BasicEditorPane bep;
        int m_startLine;
        int m_endLine;

        public HighlightRunningStatement(int n, int n2) {
            this.bep = ((GuiScriptRunnerContext)OLAPDBCommandRunnerTask.this.m_scriptRunnerContext).getEditorComponenet();
            this.m_startLine = 0;
            this.m_endLine = 0;
            this.m_startLine = n;
            this.m_endLine = n2;
        }

        @Override
        public void run() {
            try {
                this.bep.setCaretPosition(this.m_startLine);
                if (this.m_startLine >= 0 && this.m_endLine >= 0) {
                    this.bep.select(this.bep.getLineStartOffset(this.m_startLine), this.bep.getLineEndOffset(this.m_endLine));
                }
                this.bep.ensureCaretVisible();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

