/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.util.SearchTool;

public class SQLViewerDialog
extends JDialog {
    private BasicEditorPane queryEditor;
    private SearchTool searchTool;
    private final Resources resources;
    private FetchIcon fetchIcon;
    private String queryText;
    private JScrollPane queryScrollPane;
    private JButton close;
    private JLabel copyButton;
    private JLabel saveButton;
    private String docType;

    public SQLViewerDialog(Window window, String string, String string2, Resources resources, FetchIcon fetchIcon, String string3) {
        super(window);
        this.setTitle(string2);
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        this.queryText = string;
        this.docType = string3;
        this.close = new JButton(OLAPArb.getString("WIZARD_CLOSE"));
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLViewerDialog.this.close();
            }
        });
        KeyStrokeContext[] keyStrokeContextArray = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/worksheet/editor/accelerators.xml")};
        this.queryEditor = EditorFactory.createIdeEditorPane((KeyStrokeContext[])keyStrokeContextArray);
        BasicDocument basicDocument = new BasicDocument(this.docType);
        this.queryEditor.setDocument((Document)basicDocument);
        this.queryEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.queryEditor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this.queryEditor.setText(string);
        this.queryEditor.setEditable(false);
        this.queryScrollPane = new JScrollPane((Component)this.queryEditor);
        this.searchTool = new SearchTool(this.queryEditor, this.queryScrollPane);
        this.layoutComponents();
        this.setMinimumSize(new Dimension(500, 400));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbarPanel(), "North");
        CodeFoldingMargin codeFoldingMargin = null;
        WorksheetFoldingPlugin worksheetFoldingPlugin = new WorksheetFoldingPlugin();
        this.queryEditor.installPlugin((EditorPlugin)worksheetFoldingPlugin);
        codeFoldingMargin = worksheetFoldingPlugin.getCodeFoldingMargin();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)codeFoldingMargin, "East");
        this.queryScrollPane.setRowHeaderView(jPanel);
        this.add((Component)this.queryScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.close, "East");
        this.add((Component)jPanel2, "South");
    }

    private JPanel createToolbarPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        ImageIcon imageIcon = (ImageIcon)this.fetchIcon.getIcon("COPY_ENABLE");
        this.copyButton = new JLabel(imageIcon);
        this.copyButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.copyButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SQLViewerDialog.this.queryEditor.selectAll();
                SQLViewerDialog.this.copyToClipboard();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("COPY_DOWN");
                SQLViewerDialog.this.copyButton.setIcon(imageIcon);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("COPY_ENABLE");
                SQLViewerDialog.this.copyButton.setIcon(imageIcon);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("COPY_OVER");
                SQLViewerDialog.this.copyButton.setIcon(imageIcon);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("COPY_ENABLE");
                SQLViewerDialog.this.copyButton.setIcon(imageIcon);
            }
        });
        imageIcon = (ImageIcon)this.fetchIcon.getIcon("SAVE_ENABLE");
        this.saveButton = new JLabel(imageIcon);
        this.saveButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.saveButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    SQLViewerDialog.this.saveToFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("SAVE_DOWN");
                SQLViewerDialog.this.saveButton.setIcon(imageIcon);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("SAVE_ENABLE");
                SQLViewerDialog.this.saveButton.setIcon(imageIcon);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("SAVE_OVER");
                SQLViewerDialog.this.saveButton.setIcon(imageIcon);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ImageIcon imageIcon = (ImageIcon)SQLViewerDialog.this.fetchIcon.getIcon("SAVE_ENABLE");
                SQLViewerDialog.this.saveButton.setIcon(imageIcon);
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 1, 1));
        jPanel2.add(this.copyButton);
        jPanel2.add(this.saveButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "West");
        jPanel.add((Component)this.searchTool.getSearchField());
        jPanel.add(jPanel3);
        return jPanel;
    }

    private void copyToClipboard() {
        StringSelection stringSelection = new StringSelection(this.queryEditor.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    private void saveToFile() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            Object object;
            if (jFileChooser.getSelectedFile().exists()) {
                object = new JOptionPane();
                int n2 = JOptionPane.showConfirmDialog(this, this.resources.getString("TEXTVIEWER_DIALOG_OVERWRITE.FILE", jFileChooser.getSelectedFile().getName()), "", 0);
                if (n2 == 1) {
                    return;
                }
            }
            object = new FileWriter(jFileChooser.getSelectedFile());
            ((Writer)object).write(this.queryEditor.getText());
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
            this.showConfirmation(this.resources.getString("TEXTVIEWER_DIALOG_CONFIRM.FILE.SAVED", jFileChooser.getSelectedFile().getName()));
        }
    }

    private void close() {
        this.searchTool.dispose();
        this.dispose();
    }

    private void showConfirmation(String string) {
        JOptionPane jOptionPane = new JOptionPane();
        JOptionPane.showMessageDialog(this, string);
    }
}

