/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;

public class CubeMeasureDependencyCheck {
    private AnalyticWorkspace aw;
    private SyntaxParser parser;

    public CubeMeasureDependencyCheck(Connection connection, String string, String string2) {
        Schema schema = null;
        String string3 = Connections.getInstance().getConnectionName(connection);
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", string);
        try {
            schema = OLAPMetadataCache.getUpdatedSchema(string3, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parser = new OLAPISyntaxParser(schema, properties);
        this.aw = new AnalyticWorkspace(schema.getName(), string2);
        for (Cube cube : schema.getCubes()) {
            if (!cube.getAWName().equals(string2)) continue;
            this.aw.addCube(cube);
        }
    }

    public List<Measure> getMeasureDependencies(String string, String string2) {
        return CalcReferences.getDependencies(this.aw, string, string2, this.parser);
    }
}

