/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.tools.pivot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.util.Logger;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.tools.pivot.ColumnProperty;
import oracle.olap.tools.pivot.MeasureDimension;
import oracle.olap.tools.pivot.PivotUtils;
import oracle.olap.util.ColumnSelectionDialog;
import oracle.olap.util.SourceMetadata;
import oracle.olap.util.UISettings;

public class PivotingDialog
extends JDialog
implements TableModelListener {
    private JTextArea descriptionText;
    private JLabel objectLabel;
    private JTextField objectTextField;
    private JButton searchButton;
    private JLabel pivotTableNameLabel;
    private JTextField pivotTableNameTextField;
    private JLabel measurePivotLabel;
    private JTextArea measurePivotTextArea;
    private JScrollPane measurePivotScrollPane;
    private JCheckBox createMeasureDimTableCheckBox;
    private JLabel tableNameLabel;
    private JTextField tableNameTextField;
    private JLabel measureTableLabel;
    private JLabel measureTableDescriptionLabel;
    private JTextArea measureTableTextArea;
    private JScrollPane measureTableScrollPane;
    private JTable columnsTable;
    private DefaultTableModel columnsTableModel;
    private JScrollPane columnsTableScrollPane;
    private JButton helpButton;
    private JPanel panel;
    static final int COL_INCLUDE = 0;
    static final int COL_NAME = 1;
    static final int COL_DATATYPE = 2;
    private Action cancelAction;
    private Action createAction;
    private Action searchAction;
    private Action helpAction;
    private boolean cancel = true;
    private boolean createMeasureDimTable;
    private SourceMetadata conAccess;
    private List<ColumnProperty> columnList;
    private MeasureDimension measureDimension;
    private String schemaSelected;
    private String objectSelected;
    private List<DatabaseObject> previousSelection = null;
    private final HelpProvider helpProvider;
    Resources resources = new OLAPResources();

    public PivotingDialog(Frame frame, SourceMetadata sourceMetadata, MeasureDimension measureDimension, HelpProvider helpProvider) {
        super(frame);
        this.conAccess = sourceMetadata;
        this.measureDimension = measureDimension;
        this.helpProvider = helpProvider;
        this.setTitle(this.resources.getString("PIVOT_TOOL_DIALOG_TITLE"));
        this.setModal(true);
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            this.setSize(450, 650);
            this.setMinimumSize(new Dimension(420, 650));
        } else {
            this.setSize(470, 600);
            this.setMinimumSize(new Dimension(470, 600));
        }
        this.setLocationRelativeTo(frame);
        this.init();
    }

    private Object displaySourceDialog() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = null;
        Object object = null;
        arrayList.add(ColumnSelectionDialog.TABLES);
        arrayList.add(ColumnSelectionDialog.VIEWS);
        arrayList.add(ColumnSelectionDialog.SYNONYMS);
        try {
            list = this.conAccess.getSchemas();
        }
        catch (SQLException sQLException) {
            Logger.severe(PivotingDialog.class, (Throwable)sQLException);
        }
        if (list != null && list.size() > 0) {
            object = ColumnSelectionDialog.showDialog(this, this.conAccess, this.previousSelection, list.get(0), null, null, true, this.helpProvider);
            this.previousSelection = (List)object;
        }
        return object;
    }

    private void init() {
        this.columnsTableModel = new MyTableModel();
        this.columnsTable = new JTable(this.columnsTableModel);
        this.columnsTable.setAutoResizeMode(4);
        this.columnsTable.setCellSelectionEnabled(true);
        this.createAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PivotingDialog.this.cancel = false;
                PivotingDialog.this.setVisible(false);
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PivotingDialog.this.cancel = true;
                PivotingDialog.this.dispose();
            }
        };
        this.searchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = PivotingDialog.this.displaySourceDialog();
                if (object instanceof List) {
                    List list = (List)object;
                    PivotingDialog.this.populateColumsTable(list);
                }
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PivotingDialog.this.showHelp();
            }
        };
        String string = this.resources.getString("PIVOT_TOOL_DIALOG_DESCRIPTION");
        this.descriptionText = new JTextArea(string);
        this.descriptionText.setEditable(false);
        this.descriptionText.setBackground(null);
        this.descriptionText.setBorder(null);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.objectLabel = new JLabel(this.resources.getString("PIVOT_TOOL_DIALOG_OBJECT") + " ");
        this.objectTextField = new JTextField();
        this.objectTextField.setEditable(false);
        this.searchButton = new JButton();
        this.searchButton.setAction(this.searchAction);
        this.searchButton.setText(this.resources.getString("PIVOT_TOOL_DIALOG_SEARCH_BUTTON"));
        this.searchButton.setText(StringUtils.stripMnemonic((String)this.resources.getString("PIVOT_TOOL_DIALOG_SEARCH_BUTTON")));
        this.searchButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("PIVOT_TOOL_DIALOG_SEARCH_BUTTON")));
        this.searchButton.setToolTipText(this.resources.getString("PIVOT_TOOL_DIALOG_SEARCH_BUTTON_TOOLTIP"));
        this.pivotTableNameLabel = new JLabel(this.resources.getString("PIVOT_TOOL_DIALOG_FACT_VIEW_NAME") + " ");
        this.pivotTableNameTextField = new JTextField();
        this.measureTableDescriptionLabel = new JLabel(this.resources.getString("PIVOT_TOOL_DIALOG_SELECT_COLUMNS"), 2);
        this.measurePivotLabel = new JLabel(this.resources.getString("PIVOT_TOOL_DIALOG_FACT_VIEW_SQL") + " ");
        this.measurePivotTextArea = new JTextArea();
        this.measurePivotTextArea.setEditable(false);
        this.measurePivotTextArea.setVisible(true);
        this.createMeasureDimTableCheckBox = new JCheckBox(this.resources.getString("PIVOT_TOOL_DIALOG_CREATE_DIMENSION_TABLE"));
        this.tableNameLabel = new JLabel(this.resources.getString("PIVOT_TOOL_DIALOG_TABLE") + " ");
        this.tableNameTextField = new JTextField();
        this.measureTableLabel = new JLabel(this.resources.getString("PIVOT_TOOL_DIALOG_MEASURE_DIM_SQL") + " ");
        this.measureTableTextArea = new JTextArea();
        this.measureTableTextArea.setEditable(false);
        this.measureTableTextArea.setVisible(true);
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        jButton2.setAction(this.cancelAction);
        jButton2.setText(this.resources.getString("PIVOT_TOOL_DIALOG_CANCEL_BUTTON"));
        jButton.setAction(this.createAction);
        jButton.setText(this.resources.getString("PIVOT_TOOL_DIALOG_CREATE_BUTTON"));
        this.helpButton = new JButton();
        this.helpButton.setVisible(true);
        this.helpButton.setAction(this.helpAction);
        this.helpButton.setText(StringUtils.stripMnemonic((String)this.resources.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.panel = new JPanel();
        this.getContentPane().add(this.panel);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 6;
        this.panel.add((Component)this.descriptionText, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.objectLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.objectTextField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panel.add((Component)this.searchButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.pivotTableNameLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.pivotTableNameTextField, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.measureTableDescriptionLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipady = 80;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.columnsTableScrollPane = new JScrollPane();
        this.columnsTableScrollPane.getViewport().add(this.columnsTable);
        this.panel.add((Component)this.columnsTableScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.measurePivotLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 40;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.measurePivotScrollPane = new JScrollPane();
        this.measurePivotScrollPane.getViewport().add(this.measurePivotTextArea);
        this.panel.add((Component)this.measurePivotScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.createMeasureDimTableCheckBox, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.tableNameLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panel.add((Component)this.tableNameTextField, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.measureTableLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 80;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.measureTableScrollPane = new JScrollPane();
        this.measureTableScrollPane.getViewport().add(this.measureTableTextArea);
        this.panel.add((Component)this.measureTableScrollPane, gridBagConstraints);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)dialogButtonBar, gridBagConstraints);
        this.setEnableMeasureDimensionTable(this.createMeasureDimTableCheckBox.isSelected());
        this.registerKeyboardActions();
        this.pivotTableNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void changed() {
                PivotingDialog.this.updateMeasureDimDmlSql();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }
        });
        this.createMeasureDimTableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = PivotingDialog.this.createMeasureDimTableCheckBox.isSelected();
                PivotingDialog.this.setEnableMeasureDimensionTable(bl);
                PivotingDialog.this.createMeasureDimTable = bl;
            }
        });
        this.tableNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void changed() {
                PivotingDialog.this.updateMeasureDimensionSQL();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }
        });
    }

    public boolean createMeasureDimTable() {
        return this.createMeasureDimTable;
    }

    private void setEnableMeasureDimensionTable(boolean bl) {
        this.tableNameTextField.setEnabled(bl);
        if (bl && this.tableNameTextField.getText().equals("")) {
            this.tableNameTextField.setText(PivotUtils.getDefaultTableName(this.objectSelected));
        } else if (!bl) {
            this.tableNameTextField.setText("");
            this.measureTableTextArea.setText("");
        }
        this.measureTableTextArea.setEnabled(bl);
    }

    private void updateMeasureDimensionSQL() {
        if (!this.tableNameTextField.getText().equals("") && !this.pivotTableNameTextField.getText().equals("") && this.measureDimension.getSelectedColumns().size() > 0) {
            this.measureDimension.setDimensionTableName(this.tableNameTextField.getText());
            String string = this.measureDimension.getDropDimensionTableSql() + this.measureDimension.getCreateDimensionTableSql() + this.measureDimension.getInsertMeasureColumnSql() + "commit;";
            this.measureTableTextArea.setText(string);
        } else if (this.measureDimension.getSelectedColumns().size() == 0) {
            this.measureTableTextArea.setText("");
        }
    }

    private void populateColumsTable(List<DatabaseObject> list) {
        this.columnsTableModel.removeTableModelListener(this);
        this.columnsTableModel.setRowCount(0);
        this.columnsTableModel.setColumnCount(0);
        this.columnsTableModel.addColumn(this.resources.getString("PIVOT_TOOL_DIALOG_MEASURE_COLUMN"));
        this.columnsTableModel.addColumn(this.resources.getString("PIVOT_TOOL_DIALOG_COLUMN_NAME"));
        this.columnsTableModel.addColumn(this.resources.getString("PIVOT_TOOL_DIALOG_DATA_TYPE"));
        TableColumn tableColumn = this.columnsTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new CheckBoxCellEditor());
        tableColumn.setCellRenderer(new CWCheckBoxRenderer());
        if (list != null) {
            this.columnList = new ArrayList<ColumnProperty>();
            for (DatabaseObject databaseObject : list) {
                this.objectTextField.setText(databaseObject.getSchemaName() + "." + databaseObject.getName());
                this.objectSelected = databaseObject.getName();
                this.schemaSelected = databaseObject.getSchemaName();
                List<Column> list2 = databaseObject.getColumns();
                for (Column column : list2) {
                    Object[] objectArray = new Object[this.columnsTableModel.getColumnCount()];
                    ColumnProperty columnProperty = new ColumnProperty(column.getName(), column.getDataType(), false);
                    objectArray[1] = columnProperty.getName();
                    objectArray[2] = columnProperty.getDataType();
                    objectArray[0] = columnProperty.isIncluded();
                    this.columnsTableModel.addRow(objectArray);
                    this.columnList.add(columnProperty);
                }
            }
            this.measureDimension.setColumns(this.columnList);
        }
        this.columnsTableModel.addTableModelListener(this);
        if (this.objectTextField.getText() != "") {
            this.pivotTableNameTextField.setText(PivotUtils.getDefaultViewName(this.objectSelected));
        }
        this.cleanDimensionTable();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (n == -1) {
            return;
        }
        if (tableModelEvent.getSource() == this.columnsTableModel && tableModelEvent.getType() == 0) {
            this.updateColumnTableModelFromCell(n, n2);
        }
    }

    private void updateColumnTableModelFromCell(int n, int n2) {
        Object object = this.columnsTable.getValueAt(n, n2);
        if (n > this.columnList.size() - 1) {
            return;
        }
        ColumnProperty columnProperty = this.columnList.get(n);
        if (n2 == 0) {
            this.columnsTableModel.removeTableModelListener(this);
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                columnProperty.setIncluded(bl);
            }
            this.columnsTableModel.addTableModelListener(this);
        }
        this.updateMeasureDimDmlSql();
        this.updateMeasureDimensionSQL();
    }

    private void updateMeasureDimDmlSql() {
        if (!this.pivotTableNameTextField.getText().equals("") && this.measureDimension.getSelectedColumns().size() > 0) {
            this.measureDimension.setSchemaName(this.schemaSelected);
            this.measureDimension.setFactViewName(this.pivotTableNameTextField.getText());
            this.measureDimension.setFactTableName(this.objectSelected);
            String string = this.measureDimension.getCreateFactViewSql();
            this.measurePivotTextArea.setText(string);
        } else if (this.measureDimension.getSelectedColumns().size() == 0) {
            this.measurePivotTextArea.setText("");
            this.measureTableTextArea.setText("");
        }
        this.measurePivotTextArea.setCaretPosition(0);
        this.measureTableTextArea.setCaretPosition(0);
    }

    private void cleanDimensionTable() {
        this.createMeasureDimTableCheckBox.setSelected(false);
        this.tableNameTextField.setText("");
        this.measureTableTextArea.setText("");
        this.setEnableMeasureDimensionTable(false);
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public String getViewName() {
        return this.pivotTableNameTextField.getText();
    }

    public String getTableName() {
        return this.tableNameTextField.getText();
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(156, 0), 1);
        jRootPane.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void showHelp() {
        this.helpProvider.showHelp(this.panel, "olap_create_fact_view_with_measure_dimension");
    }

    class CWCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border border = new EmptyBorder(1, 2, 1, 2);

        public CWCheckBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Boolean) {
                this.setSelected((Boolean)object);
                this.setEnabled(jTable.isCellEditable(n, n2));
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                }
            } else {
                return null;
            }
            return this;
        }
    }

    class CheckBoxCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JCheckBox checkBox = new JCheckBox();

        public CheckBoxCellEditor() {
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.setBackground(Color.white);
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CheckBoxCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            boolean bl2 = false;
            if (object != null) {
                bl2 = (Boolean)object;
            }
            this.checkBox.setSelected(bl2);
            return this.checkBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkBox.isSelected();
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1 && n2 != 2;
        }
    }
}

