/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.db.DBUtil;
import oracle.ide.db.util.LiveValidationController;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.Database;
import oracle.olap.app.ui.RestrictedTextField;
import oracle.olap.db.model.SQLKeyword;
import oracle.olap.timegen.ui.wizard.TimeGenWizMain;
import oracle.olap.timegen.ui.wizard.TimeGenWizardPanel;

public class TimeGenGeneralPanel
extends TimeGenWizardPanel {
    RestrictedTextField dimNameField;
    private JLabel hierNameLabel;
    RestrictedTextField hierNameField;
    RestrictedTextField tableNameField;
    private JSpinner numOfYearsSpinner;
    private JSpinner startDateSpinner;
    JCheckBox m_createTimeDimCheckBox;
    private JLabel dimNameLabel;
    JComboBox dimNameComboBox;
    private DefaultComboBoxModel dimNameComboBoxModel = new DefaultComboBoxModel();
    private JLabel awNameLabel;
    JComboBox awNameComboBox;
    private DefaultComboBoxModel awNameComboBoxModel = new DefaultComboBoxModel();
    private ItemListener awNameComboBoxListener;
    private String schemaName;
    private Database database;
    private boolean isCreateTimeDimAndHierarchy;
    private LiveValidationController liveValidationController;

    public TimeGenGeneralPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.m_createTimeDimCheckBox = new JCheckBox(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_CREATE_HIERARCHY"));
        this.m_createTimeDimCheckBox.setName("m_createTimeDimCheckBox");
        this.m_createTimeDimCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeGenGeneralPanel.this.enableCreateDimUI(TimeGenGeneralPanel.this.m_createTimeDimCheckBox.isSelected());
            }
        });
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setName("multiLineTopLabel");
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_INSTRUCTION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)multiLineLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        JPanel jPanel = this.getNamePanel();
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints.gridy += 5;
        JPanel jPanel2 = new JPanel();
        this.add(jPanel2, gridBagConstraints);
    }

    private JPanel getNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("namePanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.awNameLabel = new JLabel(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_AW_NAME"));
        jPanel.add((Component)this.awNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        this.awNameComboBox = new JComboBox(this.awNameComboBoxModel);
        this.awNameComboBox.setName("awNameComboBox");
        this.awNameComboBox.setEditable(false);
        this.awNameComboBoxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (TimeGenGeneralPanel.this.database != null && TimeGenGeneralPanel.this.awNameComboBoxModel.getSize() > 1) {
                    String string = (String)TimeGenGeneralPanel.this.awNameComboBox.getSelectedItem();
                    try {
                        List<String> list = TimeGenWizMain.getTimeDimensions(TimeGenGeneralPanel.this.database, TimeGenGeneralPanel.this.schemaName, string);
                        TimeGenGeneralPanel.this.dimNameComboBoxModel.removeAllElements();
                        for (String string2 : list) {
                            TimeGenGeneralPanel.this.dimNameComboBoxModel.addElement(string2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.awNameComboBox.addItemListener(this.awNameComboBoxListener);
        jPanel.add((Component)this.awNameComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_TABLE_NAME")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        this.tableNameField = new RestrictedTextField("TIME_CALENDAR");
        this.tableNameField.setName("tableNameField");
        this.tableNameField.setColumns(15);
        this.tableNameField.setFilterMode(1);
        this.tableNameField.setMaximumLength(30);
        this.tableNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = TimeGenGeneralPanel.this.tableNameField.getText();
                String string2 = TimeGenGeneralPanel.this.validateName(string);
                TimeGenGeneralPanel.this.showNameError(string2);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                String string = TimeGenGeneralPanel.this.tableNameField.getText();
                String string2 = TimeGenGeneralPanel.this.validateName(string);
                TimeGenGeneralPanel.this.showNameError(string2);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                String string = TimeGenGeneralPanel.this.tableNameField.getText();
                String string2 = TimeGenGeneralPanel.this.validateName(string);
                TimeGenGeneralPanel.this.showNameError(string2);
            }
        });
        this.tableNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = TimeGenGeneralPanel.this.tableNameField.getText();
                String string2 = TimeGenGeneralPanel.this.validateName(string);
                TimeGenGeneralPanel.this.showNameError(string2);
            }
        });
        this.liveValidationController = new LiveValidationController((JComponent)this.tableNameField);
        jPanel.add((Component)this.tableNameField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_START_DATE"));
        jLabel.setName("startDateSpinnerLabel");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(1, -50);
        Date date2 = calendar.getTime();
        calendar.add(1, 100);
        Date date3 = calendar.getTime();
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(date, date2, date3, 1);
        this.startDateSpinner = new JSpinner(spinnerDateModel);
        this.startDateSpinner.setName("startDateSpinner");
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.startDateSpinner, "MM/dd/yyyy");
        dateEditor.setName("dateEditor");
        this.startDateSpinner.setEditor(dateEditor);
        jLabel.setLabelFor(this.startDateSpinner);
        jPanel.add((Component)this.startDateSpinner, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_NUM_YEARS")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 1000, 1);
        this.numOfYearsSpinner = new JSpinner(spinnerNumberModel);
        this.numOfYearsSpinner.setName("numOfYearsSpinner");
        jPanel.add((Component)this.numOfYearsSpinner, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_createTimeDimCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dimNameLabel = new JLabel(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_DIMENSION"));
        jPanel.add((Component)this.dimNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        this.dimNameComboBox = new JComboBox(this.dimNameComboBoxModel);
        this.dimNameComboBox.setName("dimNameComboBox");
        this.dimNameComboBox.setEditable(true);
        this.dimNameComboBox.setEditor(new RestrictedTextFieldComboBoxEditor());
        jPanel.add((Component)this.dimNameComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.hierNameLabel = new JLabel(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_HIERARCHY"));
        jPanel.add((Component)this.hierNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        this.hierNameField = new RestrictedTextField("CALENDAR");
        this.hierNameField.setName("hierNameField");
        this.hierNameField.setColumns(15);
        this.hierNameField.setFilterMode(1);
        this.hierNameField.setMaximumLength(30);
        jPanel.add((Component)this.hierNameField, gridBagConstraints);
        if (!this.isCreateTimeDimAndHierarchy) {
            this.awNameLabel.setVisible(false);
            this.awNameComboBox.setVisible(false);
            this.m_createTimeDimCheckBox.setVisible(false);
            this.dimNameLabel.setVisible(false);
            this.dimNameComboBox.setVisible(false);
            this.hierNameLabel.setVisible(false);
            this.hierNameField.setVisible(false);
        }
        return jPanel;
    }

    private void enableCreateDimUI(boolean bl) {
        this.dimNameField.setEnabled(bl);
        this.hierNameField.setEnabled(bl);
    }

    private void showNameError(String string) {
        if (this.liveValidationController != null) {
            this.liveValidationController.showError(string);
        }
    }

    @Override
    public void initializeData(TraversableContext traversableContext) {
        this.database = (Database)traversableContext.get("DATABASE");
        Connection connection = this.database.getConnection();
        this.schemaName = (String)traversableContext.get("SCHEMA");
        String string = (String)traversableContext.get("TABLE_NAME");
        this.tableNameField.setText(string);
        String string2 = (String)traversableContext.get("DIMENSION_NAME");
        String string3 = (String)traversableContext.get("HIERARCHY_NAME");
        this.hierNameField.setText(string3);
        int n = (Integer)traversableContext.get("NUMBER_OF_YEARS");
        this.numOfYearsSpinner.setValue(n);
        Date date = (Date)traversableContext.get("START_DATE");
        this.startDateSpinner.setValue(date);
        this.isCreateTimeDimAndHierarchy = (Boolean)traversableContext.get("SHOW_CREATE_DIMENSION_UI");
        if (this.isCreateTimeDimAndHierarchy) {
            Object object2;
            Boolean bl = (Boolean)traversableContext.get("CREATE_DIMENSION");
            this.m_createTimeDimCheckBox.setSelected(bl);
            List list = (List)traversableContext.get("TIME_DIMENSIONS");
            this.dimNameComboBoxModel.removeAllElements();
            for (Object object2 : list) {
                this.dimNameComboBoxModel.addElement(object2);
            }
            this.dimNameComboBox.setSelectedItem(string2);
            String string4 = (String)traversableContext.get("ANALYTIC_WORKSPACE");
            object2 = (List)traversableContext.get("ANALYTIC_WORKSPACES");
            this.awNameComboBoxModel.removeAllElements();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                this.awNameComboBoxModel.addElement(string5);
            }
            this.awNameComboBox.setSelectedItem(string4);
            if (object2.size() == 1) {
                this.awNameComboBox.setEnabled(false);
            }
        }
    }

    @Override
    public void setContext(TraversableContext traversableContext) {
        traversableContext.put("TABLE_NAME", (Object)this.tableNameField.getText());
        traversableContext.put("NUMBER_OF_YEARS", this.numOfYearsSpinner.getValue());
        traversableContext.put("START_DATE", this.startDateSpinner.getValue());
        if (this.isCreateTimeDimAndHierarchy) {
            traversableContext.put("DIMENSION_NAME", this.dimNameComboBox.getEditor().getItem());
            traversableContext.put("HIERARCHY_NAME", (Object)this.hierNameField.getText());
            traversableContext.put("CREATE_DIMENSION", (Object)this.m_createTimeDimCheckBox.isSelected());
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initializeData(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.validateFields(traversableContext);
        this.setContext(traversableContext);
    }

    public Object getExitTransition() {
        return "LEVELS";
    }

    @Override
    public void validateFields(TraversableContext traversableContext) throws TraversalException {
        Object object;
        String string = "";
        Connection connection = null;
        connection = this.database.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        boolean bl = this.m_createTimeDimCheckBox.isSelected();
        String string2 = this.tableNameField.getText();
        string = this.validateName(string2);
        if (this.isCreateTimeDimAndHierarchy && bl && string.length() == 0) {
            object = (String)traversableContext.get("ANALYTIC_WORKSPACE");
            String string3 = (String)this.dimNameComboBox.getEditor().getItem();
            string = this.checkNameCollisions(string3);
            if (string.length() == 0) {
                String string4 = "select dimension_type, aw_name from all_cube_dimensions where owner=:OWNER and dimension_name=:DIMNAME";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.schemaName);
                hashMap.put("DIMNAME", string3);
                Map map = null;
                map = dBUtil.executeReturnMap(string4, hashMap);
                if (map != null && map.size() > 0) {
                    String string5 = (String)map.get("0.DIMENSION_TYPE");
                    String string6 = (String)map.get("0.AW_NAME");
                    if (!string6.equalsIgnoreCase((String)object)) {
                        string = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_DIM_ERROR_IN_ANOTHER_AW");
                    } else if (!string5.equalsIgnoreCase("TIME")) {
                        string = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_HIER_ERROR");
                    } else {
                        boolean bl2;
                        String string7 = "SELECT SYS.DBMS_CUBE_ADVISE_SEC.GET_MVNAME(:OWNER, :DIMNAME) DIMHIER_MVNAME from dual";
                        String string8 = dBUtil.executeReturnOneCol(string7, hashMap);
                        boolean bl3 = bl2 = string8 != null && string8.length() > 0;
                        if (bl2) {
                            string = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_HIER_ERROR_MV");
                        } else {
                            String string9 = this.hierNameField.getText();
                            string = this.checkName(string9);
                            if (string.length() == 0) {
                                String string10 = "select hierarchy_name from all_cube_hierarchies where dimension_name=:DIMNAME and hierarchy_name=:HIERNAME and owner=:OWNER";
                                hashMap.put("HIERNAME", string9);
                                String string11 = dBUtil.executeReturnOneCol(string10, hashMap);
                                if (string11 != null && string11.length() > 0) {
                                    string = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_HIER_ERROR_EXIST");
                                }
                            }
                        }
                    }
                }
            }
        }
        if (string.length() > 0) {
            object = new TraversalException(string);
            throw object;
        }
    }

    private String validateName(String string) {
        String string2 = "";
        string2 = this.checkName(string);
        if (string2.length() == 0) {
            string2 = this.checkNameCollisions(string);
        }
        return string2;
    }

    private String checkName(String string) {
        String string2 = "";
        if (!this.isNameValid(string)) {
            string2 = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_NAME_ERROR");
        } else if (SQLKeyword.IsSQlKeyword(string)) {
            string2 = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_NAME_ERROR_SQL");
        }
        return string2;
    }

    private String checkNameCollisions(String string) {
        String string2 = "";
        Connection connection = this.database.getConnection();
        TimeGenWizMain timeGenWizMain = TimeGenWizMain.getInstance();
        string2 = timeGenWizMain.checkNameConflicts(connection, this.schemaName, string);
        return string2;
    }

    private boolean isNameValid(String string) {
        char c;
        int n;
        boolean bl = true;
        if (string == null || string.length() == 0 || string.length() > 32) {
            bl = false;
        }
        if (bl && string.length() == 1) {
            n = string.charAt(0);
            boolean bl2 = bl = n != 46 && n != 95;
        }
        if (bl && string.length() == 2) {
            n = string.charAt(0);
            c = string.charAt(1);
            boolean bl3 = bl = n != 46 || !Character.isDigit(c);
        }
        if (bl && Character.isDigit(string.charAt(0))) {
            bl = false;
        }
        if (bl) {
            for (n = 0; n < string.length() && bl; ++n) {
                c = string.charAt(n);
                bl = Character.isDigit(c) || Character.isLetter(c) || c == '.' || c == '_';
            }
        }
        return bl;
    }

    public class RestrictedTextFieldComboBoxEditor
    extends BasicComboBoxEditor {
        @Override
        protected JTextField createEditorComponent() {
            TimeGenGeneralPanel.this.dimNameField = new RestrictedTextField("TIME");
            TimeGenGeneralPanel.this.dimNameField.setName("dimNameField");
            TimeGenGeneralPanel.this.dimNameField.setColumns(15);
            TimeGenGeneralPanel.this.dimNameField.setFilterMode(1);
            TimeGenGeneralPanel.this.dimNameField.setMaximumLength(30);
            RestrictedTextField restrictedTextField = TimeGenGeneralPanel.this.dimNameField;
            return restrictedTextField;
        }
    }
}

