/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseException;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxTokenListener;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olapi.syntax.AggregateOverClause;
import oracle.olapi.syntax.AggregateOverMembersClause;
import oracle.olapi.syntax.AggregationCase;
import oracle.olapi.syntax.AggregationCommand;
import oracle.olapi.syntax.AggregationFunctionExpression;
import oracle.olapi.syntax.BinaryOperatorCondition;
import oracle.olapi.syntax.BinaryOperatorExpression;
import oracle.olapi.syntax.BuildCommand;
import oracle.olapi.syntax.BuildItem;
import oracle.olapi.syntax.BuildProcess;
import oracle.olapi.syntax.BuildSpecification;
import oracle.olapi.syntax.CaseExpression;
import oracle.olapi.syntax.ClearCommand;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.ConsistentSolveCommand;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.GroupCommand;
import oracle.olapi.syntax.IsCondition;
import oracle.olapi.syntax.KeywordArgument;
import oracle.olapi.syntax.ListComparisonCondition;
import oracle.olapi.syntax.LoadCommand;
import oracle.olapi.syntax.NullExpression;
import oracle.olapi.syntax.NumberExpression;
import oracle.olapi.syntax.OLAPDMLCommand;
import oracle.olapi.syntax.OLAPDMLExpression;
import oracle.olapi.syntax.OLAPFunctionExpression;
import oracle.olapi.syntax.PLSQLCommand;
import oracle.olapi.syntax.QDRExpression;
import oracle.olapi.syntax.Qualifier;
import oracle.olapi.syntax.RowFunctionExpression;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SearchedCase;
import oracle.olapi.syntax.SearchedCaseExpression;
import oracle.olapi.syntax.SimpleCase;
import oracle.olapi.syntax.SimpleCaseExpression;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SolveCommand;
import oracle.olapi.syntax.SolveStepCommand;
import oracle.olapi.syntax.StringExpression;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SymmetricConditionElement;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

public class SyntaxVisitor
extends SyntaxObjectVisitor
implements SyntaxTokenListener {
    private static final Logger LOG = Logger.getLogger(SyntaxVisitor.class.getName());
    private static final String RESERVED_WORD_ELSE = "ELSE";
    private static final String RESERVED_WORD_WHEN = "WHEN";
    private static final String RESERVED_WORD_THEN = "THEN";
    private static final String RESERVED_WORD_CASE = "CASE";
    private static final String RESERVED_WORD_NULL = "NULL";
    private static final String RESERVED_WORD_LEVELS = "LEVELS";
    private static final String RESERVED_WORD_WHERE = "WHERE";
    private static final String RESERVED_WORD_NOT = "NOT";
    private static final String RESERVED_WORD_NOT_IN = "NOT IN";
    private static final String RESERVED_WORD_IN = "IN";
    private static final String RESERVED_WORD_IS = "IS";
    private static final String RESERVED_WORD_IS_NOT = "IS NOT";
    private static final String RESERVED_WORD_BUILD = "BUILD";
    private static final String RESERVED_WORD_CLEAR = "CLEAR";
    private static final String RESERVED_WORD_STALE = "STALE";
    private static final String RESERVED_WORD_AGGREGATES = "AGGREGATES";
    private static final String RESERVED_WORD_LOAD = "LOAD";
    private static final String RESERVED_WORD_SOLVE = "SOLVE";
    private static final String RESERVED_WORD_ALL = "ALL";
    private static final String RESERVED_WORD_DIVISION = "DIVISION";
    private static final String RESERVED_WORD_NULLS = "NULLS";
    private static final String RESERVED_WORD_ALLOW = "ALLOW";
    private static final String RESERVED_WORD_DISALLOW = "DISALLOW";
    private static final String RESERVED_WORD_BY = "BY";
    private static final String RESERVED_WORD_ZERO = "ZERO";
    private static final String RESERVED_WORD_CONSIDER = "CONSIDER";
    private static final String RESERVED_WORD_IGNORE = "IGNORE";
    private static final String RESERVED_WORD_OVERFLOW = "OVERFLOW";
    private static final String RESERVED_WORD_SYNCH = "SYNCH";
    private static final String RESERVED_WORD_FROM = "FROM";
    private static final String RESERVED_WORD_NO = "NO";
    private static final String RESERVED_WORD_EXECUTE = "EXECUTE";
    private static final String RESERVED_WORD_OLAP = "OLAP";
    private static final String RESERVED_WORD_DML = "DML";
    private static final String RESERVED_WORD_PLSQL = "PLSQL";
    private static final String RESERVED_WORD_FOR = "FOR";
    private static final String RESERVED_WORD_MEASURES = "MEASURES";
    private static final String RESERVED_WORD_OVER = "OVER";
    private static final String RESERVED_WORD_COUNT = "COUNT";
    private static final String RESERVED_WORD_MAINTAIN = "MAINTAIN";
    private static final String RESERVED_WORD_AGGREGATE = "AGGREGATE";
    private static final String RESERVED_WORD_HIERARCHIES = "HIERARCHIES";
    private static final String OLAP_DML_EXPRESSION = "OLAP_DML_EXPRESSION";
    private static final String FUNCTION_NAME_AVG = "AVG";
    private static final String FUNCTION_NAME_MIN = "MIN";
    private static final String FUNCTION_NAME_MAX = "MAX";
    private static final String FUNCTION_NAME_SUM = "SUM";
    private static final String FUNCTION_NAME_RANK = "RANK";
    private static final String FUNCTION_NAME_DENSE_RANK = "DENSE_RANK";
    private static final String FUNCTION_NAME_AVERAGE_RANK = "AVERAGE_RANK";
    private String syntax;
    private int offset;
    private final HashSet reserved = new HashSet();
    private Schema schema;
    private List<Throwable> badNames = new LinkedList<Throwable>();
    private List<Token> tokenList = new ArrayList<Token>();
    private String cubeName;

    private int findOffset(List<Token> list, int n) {
        int n2 = Collections.binarySearch(list, new Token(null, n, null));
        return n2;
    }

    private ParseNode fixBounds(ParseNode parseNode, int n, int n2) {
        parseNode.setReplaceBounds(n, n2, this.syntax);
        this.extendOnParenthesis(parseNode);
        return parseNode;
    }

    public void setCube(String string) {
        this.cubeName = string;
    }

    public void setSyntax(String string) {
        this.syntax = string;
        this.offset = 0;
        this.badNames.clear();
        this.tokenList = new LinkedList<Token>();
    }

    public List<Throwable> getBadNames() {
        return this.badNames;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void addReservedWord(String string) {
        this.reserved.add(string);
    }

    Type calculateType(String string) {
        if (string.equalsIgnoreCase(Type.MEASURE.toString())) {
            return Type.MEASURE;
        }
        if (string.equalsIgnoreCase("dimension.hierarchy")) {
            return Type.HIERARCHY;
        }
        if (string.equalsIgnoreCase("dimension.level")) {
            return Type.LEVEL;
        }
        if (this.schema != null) {
            NamedObjectWithDesc namedObjectWithDesc;
            IdentifierElement identifierElement = new IdentifierElement(string);
            string = string.replaceAll("\"", "");
            boolean bl = false;
            int n = string.indexOf(46);
            String string2 = string;
            if (identifierElement.getCount() > 0 && identifierElement.get(0).equalsIgnoreCase(this.schema.getName())) {
                string2 = string.substring(n + 1);
                bl = true;
            }
            if ((namedObjectWithDesc = this.schema.getNamedObject(string2)) == null) {
                Dimension dimension;
                int n2 = 0;
                if (identifierElement.getCount() == 3 && bl) {
                    n2 = 1;
                }
                if ((dimension = this.schema.findDimension(identifierElement.get(n2))) != null && identifierElement.getCount() > n2 + 1) {
                    String string3 = identifierElement.get(n2 + 1);
                    if (string3.equals("DIM_KEY") || string3.equals("LEVEL_NAME")) {
                        return Type.ATTRIBUTE;
                    }
                    namedObjectWithDesc = dimension.findAttribute(identifierElement.get(n2 + 1));
                }
            }
            if (namedObjectWithDesc != null) {
                if (namedObjectWithDesc instanceof Measure) {
                    return Type.MEASURE;
                }
                if (namedObjectWithDesc instanceof Dimension) {
                    return Type.DIMENSION;
                }
                if (namedObjectWithDesc instanceof DimensionLevel) {
                    return Type.LEVEL;
                }
                if (namedObjectWithDesc instanceof DimensionHierarchy) {
                    return Type.HIERARCHY;
                }
                if (namedObjectWithDesc instanceof DimensionAttribute) {
                    return Type.ATTRIBUTE;
                }
                if (namedObjectWithDesc instanceof Cube) {
                    return Type.CUBE;
                }
            }
        }
        if (this.reserved.contains(string)) {
            return Type.RESERVED;
        }
        return Type.BAD_NAME;
    }

    protected ParseNode processLiteral(String string, Object object) {
        return this.processLiteral(string, this.calculateType(string), object, false);
    }

    protected ParseNode processLiteral(String string, Type type, Object object) {
        return this.processLiteral(string, type, object, false);
    }

    protected ParseNode processLiteral(String string, Type type, Object object, boolean bl) {
        return this.processLiteral(string, type, object, bl, true, 0);
    }

    protected ParseNode processLiteral(String string, Type type, Object object, boolean bl, boolean bl2, int n) {
        int n2 = 0;
        Token token = this.insensitiveIndexOf(this.syntax, string, this.offset, 1, n);
        if (token == null) {
            n2 = -1;
        } else {
            n2 = token.offset;
            string = token.token;
        }
        if (n2 == -1) {
            if (bl2) {
                LOG.finest(String.format("Creating BAD ParseNode for %s of type %s on offset %d", string, type.toString(), this.offset));
            }
        } else {
            this.offset = n2 + string.length();
        }
        ParseNode parseNode = new ParseNode(string, type.toString(), bl, n2, this.offset);
        if (type == Type.BAD_NAME) {
            this.badNames.add(new ParseException(OLAPArb.format("EXPRESSION_EDITOR_RESULT_INVALID_NAME", string), parseNode.getOffset(), string));
        }
        if (object != null) {
            ((ParseNode)object).add(parseNode);
        }
        return parseNode;
    }

    private int insensitiveIndexOf(String string, String string2, int n) {
        return this.insensitiveIndexOf(string, string2, n, 1);
    }

    private int insensitiveIndexOf(String string, String string2, int n, int n2) {
        Token token = this.insensitiveIndexOf(string, string2, n, n2, 0);
        if (token != null) {
            return token.offset;
        }
        return -1;
    }

    private Token insensitiveIndexOf(String string, String string2, int n, int n2, int n3) {
        try {
            if (n >= string.length()) {
                return null;
            }
            Token token = null;
            int n4 = this.findOffset(this.tokenList, n);
            n4 = n4 < 0 ? (n4 + 1) * -1 : n4;
            List<Token> list = this.tokenList;
            token = list.get(n4);
            while (n3 == 0 || n2 == 1 && token.offset < n3 || n2 == -1 && token.offset > n3) {
                if (SyntaxVisitor.tokensMatch(string2, token.token)) {
                    return token;
                }
                if ((n4 += n2) < list.size() && n4 > 0) {
                    token = list.get(n4);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, String.format("Issue finding token %s starting at index %d in direction %d", string2, n, n2));
        }
        return null;
    }

    public static boolean tokensMatch(String string, String string2) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < string2.length()) {
            char c = Character.toUpperCase(string.charAt(n));
            if (SyntaxVisitor.shouldSkip(c)) {
                ++n;
                continue;
            }
            char c2 = Character.toUpperCase(string2.charAt(n2));
            if (SyntaxVisitor.shouldSkip(c2)) {
                ++n2;
                continue;
            }
            if (c != c2) {
                bl = false;
                break;
            }
            ++n2;
            ++n;
        }
        while (bl && n < string.length()) {
            bl = SyntaxVisitor.shouldSkip(string.charAt(n++));
        }
        while (bl && n2 < string2.length()) {
            bl = SyntaxVisitor.shouldSkip(string2.charAt(n2++));
        }
        return bl;
    }

    private static boolean shouldSkip(char c) {
        return c == '\'' || c == '\"';
    }

    private ParseNode extendOnParenthesis(ParseNode parseNode) {
        return this.extendOnGroupingChars(parseNode);
    }

    private ParseNode extendOnGroupingChars(ParseNode parseNode) {
        String string;
        String string2;
        int n;
        int n2;
        int n3;
        String[] stringArray = new String[]{"(", ")", "[", "]"};
        int[] nArray = new int[]{0, 0, 0, 0};
        Type type = Type.valueFrom(parseNode.getType());
        int n4 = parseNode.getReplaceOffset();
        int n5 = parseNode.getReplaceEnd();
        List<Token> list = this.tokenList;
        int n6 = this.findOffset(list, n4);
        n6 = n6 < 0 ? n6 * -1 : n6;
        Token token = list.get(n6);
        int n7 = n6;
        while (token.offset >= n4 && token.offset < parseNode.getReplaceEnd()) {
            for (n3 = 0; n3 < nArray.length; n3 += 2) {
                String string3 = stringArray[n3];
                String string4 = stringArray[n3 + 1];
                if (token.token.equals(string3)) {
                    int n8 = n3;
                    nArray[n8] = nArray[n8] + 1;
                    continue;
                }
                if (!token.token.equals(string4)) continue;
                if (nArray[n3] > 0) {
                    int n9 = n3;
                    nArray[n9] = nArray[n9] - 1;
                    continue;
                }
                int n10 = n3 + 1;
                nArray[n10] = nArray[n10] + 1;
            }
            if (++n6 >= list.size()) break;
            token = list.get(n6);
        }
        n3 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < nArray.length; n2 += 2) {
            if (n3 == 0) {
                int n11 = n3 = nArray[n2] > 0 ? 1 : 0;
            }
            if (bl) continue;
            bl = nArray[n2 + 1] > 0;
        }
        for (n6 = n2 = n6; n3 != 0 && n6 < list.size() && n6 >= 0; ++n6) {
            token = list.get(n6);
            n3 = 0;
            for (n = 0; n < nArray.length; n += 2) {
                string2 = stringArray[n + 1];
                string = stringArray[n];
                if (token.token.equals(string2)) {
                    int n12 = n;
                    nArray[n12] = nArray[n12] - 1;
                    n5 = token.offset + 1;
                } else if (token.token.equals(string)) {
                    int n13 = n;
                    nArray[n13] = nArray[n13] + 1;
                }
                if (n3 != 0) continue;
                n3 = nArray[n] > 0 ? 1 : 0;
            }
        }
        for (n6 = n7 - 1; bl && n6 < list.size() && n6 >= 0; --n6) {
            token = list.get(n6);
            bl = false;
            for (n = 0; n < nArray.length; n += 2) {
                string2 = stringArray[n];
                string = stringArray[n + 1];
                if (token.token.equals(string2)) {
                    int n14 = n + 1;
                    nArray[n14] = nArray[n14] - 1;
                    n4 = token.offset;
                } else if (token.token.equals(string)) {
                    int n15 = n;
                    nArray[n15] = nArray[n15] + 1;
                }
                if (bl) continue;
                bl = nArray[n + 1] > 0;
            }
        }
        parseNode.setReplaceBounds(n4, n5, this.syntax);
        return parseNode;
    }

    private void loopArgs(FunctionArgument[] functionArgumentArray, Object object) {
        for (int i = 0; i < functionArgumentArray.length; ++i) {
            ((SyntaxObject)functionArgumentArray[i]).visit((SyntaxObjectVisitor)this, object);
        }
    }

    public Object visitSyntaxObject(SyntaxObject syntaxObject, Object object) {
        if (object != null) {
            return this.processLiteral(syntaxObject.toSyntax(), object);
        }
        return null;
    }

    public Object visitBinaryOperatorCondition(BinaryOperatorCondition binaryOperatorCondition, Object object) {
        ParseNode parseNode = new ParseNode(binaryOperatorCondition.getOperator(), Type.OPERATOR.toString());
        Condition[] conditionArray = binaryOperatorCondition.getArguments();
        conditionArray[0].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(binaryOperatorCondition.getOperator(), Type.OPERATOR, object, true);
        conditionArray[1].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode3 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        parseNode2.add(parseNode3);
        parseNode2.add(parseNode4);
        this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    public Object visitBinaryOperatorExpression(BinaryOperatorExpression binaryOperatorExpression, Object object) {
        ParseNode parseNode = new ParseNode(binaryOperatorExpression.getOperator(), Type.OPERATOR.toString());
        TypedExpression[] typedExpressionArray = binaryOperatorExpression.getArguments();
        typedExpressionArray[0].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(binaryOperatorExpression.getOperator(), Type.OPERATOR, object, true);
        typedExpressionArray[1].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode3 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        parseNode2.add(parseNode3);
        parseNode2.add(parseNode4);
        this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    public Object visitValueComparisonCondition(ValueComparisonCondition valueComparisonCondition, Object object) {
        ParseNode parseNode = new ParseNode(valueComparisonCondition.getOperator(), Type.OPERATOR.toString());
        valueComparisonCondition.getLhsArgument().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(valueComparisonCondition.getOperator(), Type.OPERATOR, object, true);
        valueComparisonCondition.getRhsArgument().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode3 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        parseNode2.add(parseNode3);
        parseNode2.add(parseNode4);
        this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    public Object visitRowFunctionExpression(RowFunctionExpression rowFunctionExpression, Object object) {
        ParseNode parseNode = new ParseNode(rowFunctionExpression.getFunctionName(), Type.FUNCTION.toString());
        ((ParseNode)object).add(parseNode);
        this.loopArgs(rowFunctionExpression.getArguments(), parseNode);
        parseNode.setOffset(((ParseNode)parseNode.getFirstChild()).getOffset());
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        return this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
    }

    public Object visitOLAPFunctionExpression(OLAPFunctionExpression oLAPFunctionExpression, Object object) {
        Type type = Type.FUNCTION;
        ParseNode parseNode = this.processLiteral(oLAPFunctionExpression.getFunctionName(), type, object, true);
        this.loopArgs(oLAPFunctionExpression.getArguments(), parseNode);
        if (oLAPFunctionExpression.hasHierarchyClause()) {
            this.loopArgs(oLAPFunctionExpression.getHierarchyClauseArguments(), parseNode);
        }
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        return parseNode;
    }

    public Object visitKeywordArgument(KeywordArgument keywordArgument, Object object) {
        return this.processLiteral(keywordArgument.getName(), Type.KEYWORD, object, true);
    }

    public Object visitDimensionArgument(DimensionArgument dimensionArgument, Object object) {
        return this.processLiteral(dimensionArgument.getDimensionID(), this.calculateType(dimensionArgument.getDimensionID()), object);
    }

    public Object visitQDRExpression(QDRExpression qDRExpression, Object object) {
        ParseNode parseNode = (ParseNode)object;
        ParseNode parseNode2 = new ParseNode("QDR", Type.QDR.toString());
        parseNode.add(parseNode2);
        qDRExpression.getBaseExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        for (Qualifier qualifier : qDRExpression.getQualifiers()) {
            qualifier.visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        }
        if (parseNode2.getChildCount() > 0) {
            ParseNode parseNode3 = (ParseNode)parseNode2.getFirstChild();
            ParseNode parseNode4 = (ParseNode)parseNode2.getLastChild();
            this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
            parseNode2.setOffset(parseNode3.getOffset());
            parseNode2.setEnd(parseNode3.getReplaceEnd());
        }
        return parseNode;
    }

    public Object visitQualifier(Qualifier qualifier, Object object) {
        String string = qualifier.getDimensionID();
        ParseNode parseNode = this.processLiteral(string, this.calculateType(string), object);
        TypedExpression typedExpression = qualifier.getExpression();
        typedExpression.visit((SyntaxObjectVisitor)this, object);
        return parseNode;
    }

    public Object visitStringExpression(StringExpression stringExpression, Object object) {
        return this.processLiteral(stringExpression.getValue().toString(), Type.STRING, object);
    }

    public Object visitNumberExpression(NumberExpression numberExpression, Object object) {
        boolean bl = false;
        return this.processLiteral(numberExpression.getValue().toString(), Type.NUMBER, object, bl);
    }

    public Object visitCaseExpression(CaseExpression caseExpression, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_ELSE, Type.RESERVED, object);
        caseExpression.getElseExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        return parseNode;
    }

    public Object visitSimpleCase(SimpleCase simpleCase, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_WHEN, Type.RESERVED, object);
        simpleCase.getWhenExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_THEN, Type.RESERVED, object);
        simpleCase.getThenExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        return parseNode;
    }

    public Object visitSimpleCaseExpression(SimpleCaseExpression simpleCaseExpression, Object object) {
        SimpleCase[] simpleCaseArray;
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CASE, Type.RESERVED, object);
        simpleCaseExpression.getSwitchExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        for (SimpleCase simpleCase : simpleCaseArray = simpleCaseExpression.getCases()) {
            simpleCase.visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        super.visitSimpleCaseExpression(simpleCaseExpression, (Object)parseNode);
        return parseNode;
    }

    public Object visitSearchedCase(SearchedCase searchedCase, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_WHEN, Type.RESERVED, object);
        searchedCase.getWhenCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_THEN, Type.RESERVED, parseNode);
        searchedCase.getThenExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        return parseNode;
    }

    public Object visitSearchedCaseExpression(SearchedCaseExpression searchedCaseExpression, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CASE, Type.RESERVED, object);
        SearchedCase[] searchedCaseArray = searchedCaseExpression.getCases();
        for (int i = 0; i < searchedCaseArray.length; ++i) {
            searchedCaseArray[i].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        super.visitSearchedCaseExpression(searchedCaseExpression, (Object)parseNode);
        return parseNode;
    }

    public Object visitColumnExpression(ColumnExpression columnExpression, Object object) {
        return this.processLiteral(columnExpression.toSyntax(), this.calculateType(columnExpression.toSyntax()), object);
    }

    public Object visitSimpleCommand(SimpleCommand simpleCommand, Object object) {
        return this.processLiteral(simpleCommand.toSyntax(), Type.SIMPLE_COMMAND, object, true);
    }

    public Object visitGroupCommand(GroupCommand groupCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_FOR, Type.RESERVED, object, true);
        groupCommand.getWhereCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_MEASURES, Type.RESERVED, parseNode, true);
        for (String string : groupCommand.getMeasureIDs()) {
            this.processLiteral(string, parseNode2);
        }
        ParseNode parseNode3 = this.processLiteral(RESERVED_WORD_BUILD, Type.BUILDPROCESS, parseNode);
        for (SimpleCommand simpleCommand : groupCommand.getCommands()) {
            simpleCommand.visit((SyntaxObjectVisitor)this, (Object)parseNode3);
        }
        ParseNode parseNode4 = (ParseNode)parseNode3.getLastChild();
        this.fixBounds(parseNode3, parseNode3.getOffset(), parseNode4.getReplaceEnd());
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode3.getReplaceEnd());
        return parseNode;
    }

    public Object visitSymmetricCondition(SymmetricCondition symmetricCondition, Object object) {
        for (SymmetricConditionElement symmetricConditionElement : symmetricCondition.getElements()) {
            symmetricConditionElement.visit((SyntaxObjectVisitor)this, object);
        }
        return object;
    }

    public Object visitIsCondition(IsCondition isCondition, Object object) {
        ParseNode parseNode;
        ParseNode parseNode2;
        ParseNode parseNode3;
        int n = this.offset;
        if (isCondition.isNegated()) {
            parseNode3 = (ParseNode)object;
            parseNode2 = this.processLiteral(RESERVED_WORD_IS, Type.OPERATOR, null, true);
            parseNode = this.processLiteral(RESERVED_WORD_NOT, Type.OPERATOR, null, true);
            parseNode2 = new ParseNode(RESERVED_WORD_IS_NOT, Type.OPERATOR.toString(), true, parseNode2.getOffset(), parseNode.getEnd());
            parseNode3.add(parseNode2);
        } else {
            parseNode2 = this.processLiteral(RESERVED_WORD_IS, Type.OPERATOR, object, true);
        }
        this.offset = n;
        isCondition.getBaseExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        parseNode3 = this.processLiteral(isCondition.getComparison(), parseNode2);
        parseNode3.setCheckName(true);
        parseNode = (ParseNode)parseNode2.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode2.getLastChild();
        this.fixBounds(parseNode2, parseNode.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    public Object visitSymmetricConditionElement(SymmetricConditionElement symmetricConditionElement, Object object) {
        ParseNode parseNode = this.processLiteral(symmetricConditionElement.getDimensionID(), object);
        if (symmetricConditionElement.getCondition() != null) {
            ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_WHERE, Type.KEYWORD, parseNode, true);
            symmetricConditionElement.getCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
            ParseNode parseNode3 = (ParseNode)parseNode2.getLastChild();
            this.fixBounds(parseNode2, parseNode2.getOffset(), parseNode3.getReplaceEnd());
        } else if (symmetricConditionElement.getQualifier() != null) {
            this.processLiteral(symmetricConditionElement.getQualifier(), Type.KEYWORD, parseNode, true);
        } else {
            ParseNode parseNode4 = this.processLiteral(RESERVED_WORD_LEVELS, Type.KEYWORD, parseNode, true);
            for (String string : symmetricConditionElement.getLevelIDs()) {
                this.processLiteral(string, Type.LEVEL, parseNode4);
            }
        }
        return parseNode;
    }

    public Object visitListComparisonCondition(ListComparisonCondition listComparisonCondition, Object object) {
        ParseNode parseNode;
        Object object2;
        int n = this.offset;
        ParseNode parseNode2 = (ParseNode)object;
        ParseNode parseNode3 = (ParseNode)listComparisonCondition.getLhsArgument().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        if (listComparisonCondition.getOperator().equals("!=")) {
            object2 = this.processLiteral(RESERVED_WORD_NOT, Type.OPERATOR, null, true);
            parseNode = this.processLiteral(RESERVED_WORD_IN, Type.OPERATOR, null, true);
            parseNode = new ParseNode(RESERVED_WORD_NOT_IN, Type.OPERATOR.toString(), true, ((ParseNode)object2).getOffset(), parseNode.getEnd());
            parseNode2.add(parseNode);
        } else {
            parseNode = this.processLiteral(RESERVED_WORD_IN, Type.OPERATOR, object, true);
        }
        this.offset = n;
        for (TypedExpression typedExpression : listComparisonCondition.getList()) {
            typedExpression.visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        object2 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, ((ParseNode)object2).getOffset(), parseNode4.getReplaceEnd());
        return parseNode;
    }

    public Object visitNullExpression(NullExpression nullExpression, Object object) {
        return this.processLiteral(RESERVED_WORD_NULL, Type.RESERVED, object);
    }

    public Object visitOLAPDMLExpression(OLAPDMLExpression oLAPDMLExpression, Object object) {
        Object object2;
        ParseNode parseNode = this.processLiteral(OLAP_DML_EXPRESSION, Type.FUNCTION, object, true);
        String string = oLAPDMLExpression.getOlapDML().toSyntax();
        Cube cube = this.getSchema().findCube(this.cubeName);
        AnalyticWorkspace analyticWorkspace = this.schema.findAW(cube.getAWName());
        boolean bl = true;
        if (analyticWorkspace != null) {
            int n = string.indexOf(33);
            n = n == -1 ? 1 : ++n;
            object2 = analyticWorkspace.findDMLProgram(string.substring(n, string.length() - 1));
            if (object2 != null) {
                this.processLiteral(string, Type.DMLPROGRAM, parseNode, false);
                bl = false;
            }
        }
        if (bl) {
            oLAPDMLExpression.getOlapDML().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        ParseNode parseNode2 = (ParseNode)parseNode.getFirstChild();
        object2 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), ((ParseNode)object2).getReplaceEnd());
        int n = this.findOffset(this.tokenList, parseNode2.getOffset()) + 1;
        int n2 = this.findOffset(this.tokenList, parseNode.getReplaceEnd());
        if (n2 < 0) {
            n2 = n2 * -1 - 2;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (n < n2) {
            boolean bl2 = true;
            Token token = this.tokenList.get(n++);
            if (token.type == Type.PAREN || token.type == Type.OPERATOR) continue;
            String string2 = token.type == Type.DEFAULT ? Type.RESERVED.toString() : token.type.toString();
            if (string2.equalsIgnoreCase("number")) {
                bl2 = false;
            }
            ParseNode parseNode3 = new ParseNode(token.token, string2, bl2, token.offset, token.offset + token.token.length());
            if (defaultMutableTreeNode == null) {
                parseNode.add(parseNode3);
                defaultMutableTreeNode = parseNode3;
                continue;
            }
            defaultMutableTreeNode.add(parseNode3);
        }
        return parseNode;
    }

    public Object visitSQLDataType(SQLDataType sQLDataType, Object object) {
        DataType dataType = sQLDataType.getDataType();
        ParseNode parseNode = this.processLiteral(dataType.getName(), Type.RESERVED, object);
        return parseNode;
    }

    public Object visitBuildSpecification(BuildSpecification buildSpecification, Object object) {
        BuildCommand[] buildCommandArray = buildSpecification.getCommands();
        ParseNode parseNode = null;
        if (buildSpecification.getName() == null) {
            parseNode = (ParseNode)object;
        } else {
            parseNode = this.processLiteral(buildSpecification.getName(), Type.BUILDSPEC, object, false);
            ((ParseNode)object).add(parseNode);
        }
        for (BuildCommand buildCommand : buildCommandArray) {
            buildCommand.visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        return buildCommandArray;
    }

    public Object visitClearCommand(ClearCommand clearCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CLEAR, Type.SIMPLE_COMMAND, object, true);
        String string = clearCommand.getClearTarget();
        if (string.equalsIgnoreCase("ALL AGGREGATES")) {
            this.processLiteral(RESERVED_WORD_ALL, Type.KEYWORD, parseNode, true);
            this.processLiteral(RESERVED_WORD_AGGREGATES, Type.KEYWORD, parseNode, true);
        } else if (string.equalsIgnoreCase("STALE AGGREGATES")) {
            this.processLiteral(RESERVED_WORD_STALE, Type.KEYWORD, parseNode, true);
            this.processLiteral(RESERVED_WORD_AGGREGATES, Type.KEYWORD, parseNode, true);
        } else if (string != null && string.length() > 0) {
            this.processLiteral(string, Type.KEYWORD, parseNode, true);
        }
        String string2 = clearCommand.getParallelismOption();
        if (string2 != null && string2.length() > 0) {
            this.processLiteral(string2, Type.KEYWORD, parseNode, true);
        }
        if (parseNode.getChildCount() > 0) {
            ParseNode parseNode2 = parseNode.getChildren().get(parseNode.getChildCount() - 1);
            parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        }
        return parseNode;
    }

    public Object visitLoadCommand(LoadCommand loadCommand, Object object) {
        ParseNode parseNode;
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_LOAD, Type.SIMPLE_COMMAND, object, true);
        String string = loadCommand.getLoadOption();
        if (string != null && string.length() > 0) {
            int n = this.insensitiveIndexOf(string, RESERVED_WORD_SYNCH, 0);
            if (n != -1) {
                if (!loadCommand.isSynch()) {
                    this.processLiteral(RESERVED_WORD_NO, Type.KEYWORD, parseNode2, true);
                }
                parseNode = this.processLiteral(RESERVED_WORD_SYNCH, Type.KEYWORD, parseNode2, true);
                parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
            } else {
                parseNode = this.processLiteral(string, Type.KEYWORD, parseNode2, true);
                parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
            }
        }
        if (loadCommand.getCubeMapName() != null) {
            this.processLiteral(RESERVED_WORD_FROM, Type.KEYWORD, parseNode2, true);
            parseNode = this.processLiteral(loadCommand.getCubeMapName(), Type.KEYWORD, parseNode2, true);
            parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
        }
        if (loadCommand.getWhereCondition() != null) {
            loadCommand.getWhereCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
            parseNode = (ParseNode)parseNode2.getLastChild();
            parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
        }
        return parseNode2;
    }

    public Object visitOLAPDMLCommand(OLAPDMLCommand oLAPDMLCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_EXECUTE, Type.SIMPLE_COMMAND, object, true);
        this.processLiteral(RESERVED_WORD_OLAP, Type.SIMPLE_COMMAND, parseNode, true);
        this.processLiteral(RESERVED_WORD_DML, Type.SIMPLE_COMMAND, parseNode, true);
        ParseNode parseNode2 = this.processLiteral(oLAPDMLCommand.getDML(), Type.STRING, parseNode, false);
        if (oLAPDMLCommand.getOption() != null && oLAPDMLCommand.getOption().length() > 0) {
            ParseNode parseNode3 = this.processLiteral(oLAPDMLCommand.getOption(), Type.KEYWORD, parseNode, true);
            parseNode.setReplaceEnd(parseNode3.getReplaceEnd(), this.syntax);
        } else {
            parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        }
        return parseNode;
    }

    public Object visitPLSQLCommand(PLSQLCommand pLSQLCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_EXECUTE, Type.SIMPLE_COMMAND, object, true);
        this.processLiteral(RESERVED_WORD_PLSQL, Type.SIMPLE_COMMAND, parseNode, true);
        ParseNode parseNode2 = this.processLiteral(pLSQLCommand.getPLSQL(), Type.STRING, parseNode, false);
        parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        return parseNode;
    }

    public Object visitSolveCommand(SolveCommand solveCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_SOLVE, Type.SOLVE, object, true);
        if (solveCommand.getParallelismOption() != null && solveCommand.getParallelismOption().length() > 0) {
            ParseNode parseNode2 = this.processLiteral(solveCommand.getParallelismOption(), Type.KEYWORD, parseNode, true);
            parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        }
        return parseNode;
    }

    public Object visitBuildItem(BuildItem buildItem, Object object) {
        ParseNode parseNode = this.processLiteral(buildItem.getBuildObjectID(), object);
        buildItem.getInlineBuildSpecification().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ((ParseNode)object).add(parseNode);
        return parseNode;
    }

    public Object visitBuildProcess(BuildProcess buildProcess, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_BUILD, Type.BUILDPROCESS, object);
        for (BuildItem buildItem : buildProcess.getBuildItems()) {
            buildItem.visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        return parseNode;
    }

    public Object visitConsistentSolveSpecification(ConsistentSolveSpecification consistentSolveSpecification, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_SOLVE, Type.SOLVE, object, true);
        for (ConsistentSolveCommand consistentSolveCommand : consistentSolveSpecification.getCommands()) {
            if (!(consistentSolveCommand instanceof SyntaxObject)) continue;
            ((SyntaxObject)consistentSolveCommand).visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        return parseNode;
    }

    public Object visitAggregationCommand(AggregationCommand aggregationCommand, Object object) {
        ParseNode parseNode;
        Object object2;
        String[] stringArray2;
        ParseNode parseNode2;
        ParseNode parseNode3;
        int n;
        String string = aggregationCommand.getFunctionName();
        if (string.equals("NO AGGREGATE")) {
            int n2 = this.insensitiveIndexOf(this.syntax, RESERVED_WORD_NO, this.offset);
            n = this.insensitiveIndexOf(this.syntax, RESERVED_WORD_AGGREGATE, this.offset);
            parseNode3 = new ParseNode(string, Type.FUNCTION.toString(), true, n2, n);
            ((ParseNode)object).add(parseNode3);
        } else {
            parseNode3 = this.processLiteral(string, Type.FUNCTION, object, true);
        }
        this.loopArgs(aggregationCommand.getArguments(), parseNode3);
        if (parseNode3.getChildCount() > 0) {
            parseNode2 = (ParseNode)parseNode3.getLastChild();
            this.fixBounds(parseNode3, parseNode3.getOffset(), parseNode2.getReplaceEnd());
        }
        String string2 = aggregationCommand.getPrimaryDimensionID();
        n = parseNode3.getReplaceEnd();
        ParseNode parseNode4 = this.processLiteral(RESERVED_WORD_OVER, Type.RESERVED, null, true);
        if (string2 != null) {
            this.processLiteral(string2, Type.DIMENSION, parseNode4);
        } else {
            this.processLiteral(RESERVED_WORD_ALL, Type.RESERVED, parseNode4);
        }
        parseNode2 = (ParseNode)parseNode4.getLastChild();
        this.fixBounds(parseNode4, parseNode4.getOffset(), parseNode2.getReplaceEnd());
        int n3 = this.offset;
        PriorityQueue<ParseNode> priorityQueue = new PriorityQueue<ParseNode>(11, new Comparator<ParseNode>(){

            @Override
            public int compare(ParseNode parseNode, ParseNode parseNode2) {
                if (parseNode.getOffset() < parseNode2.getOffset()) {
                    return -1;
                }
                if (parseNode.getOffset() > parseNode2.getOffset()) {
                    return 1;
                }
                return 0;
            }
        });
        for (String stringArray3 : stringArray2 = new String[]{RESERVED_WORD_DISALLOW, RESERVED_WORD_ALLOW}) {
            this.offset = n;
            if (this.enqueueCommandFragment(priorityQueue, parseNode4.getOffset(), stringArray3) == -1) continue;
            this.enqueueCommandFragment(priorityQueue, parseNode4.getOffset(), stringArray3);
        }
        this.offset = n;
        int n4 = -1;
        if (this.enqueueCommandFragment(priorityQueue, parseNode4.getOffset(), RESERVED_WORD_IGNORE) == -1) {
            this.offset = n;
            n4 = this.enqueueCommandFragment(priorityQueue, parseNode4.getOffset(), RESERVED_WORD_CONSIDER);
            if (n4 != -1) {
                n4 = this.enqueueCommandFragment(priorityQueue, parseNode4.getOffset(), RESERVED_WORD_NULLS);
            }
        }
        this.offset = n;
        int n5 = parseNode4.getOffset();
        int n6 = this.enqueueCommandFragment(priorityQueue, parseNode4.getOffset(), RESERVED_WORD_MAINTAIN);
        if (n6 != -1) {
            this.offset = n;
            n6 = this.enqueueCommandFragment(priorityQueue, parseNode4.getOffset(), RESERVED_WORD_COUNT);
        } else {
            n6 = this.offset;
        }
        String[] stringArray = new String[]{RESERVED_WORD_ALLOW, RESERVED_WORD_OVERFLOW};
        boolean bl = aggregationCommand.getAllowOverflow();
        n6 = this.enqueueCommandAttribute(priorityQueue, bl, stringArray, n, n5, n6);
        String[] stringArray3 = new String[]{RESERVED_WORD_ALLOW, RESERVED_WORD_DIVISION, RESERVED_WORD_BY, RESERVED_WORD_ZERO};
        boolean bl2 = aggregationCommand.getAllowDivisionByZero();
        n6 = this.enqueueCommandAttribute(priorityQueue, bl2, stringArray3, n, n5, n6);
        boolean bl3 = aggregationCommand.getIgnoreNulls();
        if (n4 == -1) {
            object2 = new String[]{RESERVED_WORD_IGNORE, RESERVED_WORD_NULLS};
            n6 = this.enqueueCommandAttribute(priorityQueue, bl3, (String[])object2, n, n5, n6);
        }
        object2 = null;
        ParseNode parseNode5 = null;
        while (!priorityQueue.isEmpty()) {
            parseNode = priorityQueue.poll();
            String[] stringArray4 = parseNode.getFullValue();
            if (n4 != -1) {
                if (stringArray4.equalsIgnoreCase(RESERVED_WORD_CONSIDER)) {
                    object2 = parseNode;
                    continue;
                }
                if (stringArray4.equalsIgnoreCase(RESERVED_WORD_NULLS)) {
                    parseNode5 = parseNode;
                    continue;
                }
            }
            parseNode3.add(parseNode);
        }
        if (n4 != -1) {
            parseNode3.add((MutableTreeNode)object2);
            parseNode3.add(parseNode5);
        }
        this.offset = n3;
        parseNode3.add(parseNode4);
        if (aggregationCommand.getHierarchyIDs() != null) {
            parseNode = this.processLiteral(RESERVED_WORD_HIERARCHIES, Type.RESERVED, parseNode3, true);
            for (String string3 : aggregationCommand.getHierarchyIDs()) {
                IdentifierElement identifierElement = new IdentifierElement(string3);
                this.processLiteral(identifierElement.get(identifierElement.getCount() - 1), Type.HIERARCHY, parseNode);
            }
            parseNode2 = (ParseNode)parseNode.getLastChild();
            this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        }
        if (aggregationCommand.getMembersCondition() != null) {
            parseNode = this.processLiteral(RESERVED_WORD_WHERE, Type.RESERVED, parseNode3, true);
            aggregationCommand.getMembersCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode);
            if (parseNode.getChildCount() > 0) {
                parseNode2 = (ParseNode)parseNode.getLastChild();
                this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
            }
        }
        if (parseNode3.getChildCount() > 0) {
            parseNode2 = (ParseNode)parseNode3.getLastChild();
            this.fixBounds(parseNode3, parseNode3.getOffset(), parseNode2.getReplaceEnd());
        }
        return parseNode3;
    }

    private int enqueueCommandAttribute(PriorityQueue<ParseNode> priorityQueue, boolean bl, String[] stringArray, int n, int n2, int n3) {
        int n4 = this.offset = n;
        if (bl) {
            n4 = this.enqueueCommandFragment(priorityQueue, n2, stringArray[1]);
            if (n4 != -1) {
                for (int i = 2; i < stringArray.length; ++i) {
                    n4 = this.enqueueCommandFragment(priorityQueue, n2, stringArray[i]);
                }
            } else {
                n4 = n3;
                for (String string : stringArray) {
                    priorityQueue.add(new ParseNode(string, Type.RESERVED.toString(), true, ++n4, n4));
                }
            }
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                n4 = this.enqueueCommandFragment(priorityQueue, n2, stringArray[i]);
            }
        }
        return n4;
    }

    private int enqueueCommandFragment(PriorityQueue<ParseNode> priorityQueue, int n, String string) {
        ParseNode parseNode = this.processLiteral(string, Type.RESERVED, null, true, false, n);
        if (parseNode.getOffset() != -1 && parseNode.getOffset() < n) {
            priorityQueue.offer(parseNode);
            return parseNode.getEnd();
        }
        return -1;
    }

    public Object visitSolveStepCommand(SolveStepCommand solveStepCommand, Object object) {
        return super.visitSolveStepCommand(solveStepCommand, object);
    }

    public Object visitAggregateOverClause(AggregateOverClause aggregateOverClause, Object object) {
        return super.visitAggregateOverClause(aggregateOverClause, object);
    }

    public Object visitAggregateOverMembersClause(AggregateOverMembersClause aggregateOverMembersClause, Object object) {
        return super.visitAggregateOverMembersClause(aggregateOverMembersClause, object);
    }

    public Object visitAggregationCase(AggregationCase aggregationCase, Object object) {
        return super.visitAggregationCase(aggregationCase, object);
    }

    public Object visitAggregationFunctionExpression(AggregationFunctionExpression aggregationFunctionExpression, Object object) {
        return super.visitAggregationFunctionExpression(aggregationFunctionExpression, object);
    }

    @Override
    public void processToken(String string, String string2, int n) {
        Type type = Type.valueFrom(string2);
        if (type != Type.BLOCK_COMMENT && type != Type.LINE_COMMENT && type != Type.NEWLINE && type != Type.WHITESPACE) {
            this.tokenList.add(new Token(string, n, type));
        }
    }

    private static class Token
    implements Comparable<Token> {
        final String token;
        final int offset;
        final Type type;

        Token(String string, int n, Type type) {
            this.token = string;
            this.offset = n;
            this.type = type;
        }

        @Override
        public int compareTo(Token token) {
            if (token.offset > this.offset) {
                return -1;
            }
            if (token.offset < this.offset) {
                return 1;
            }
            return 0;
        }
    }
}

